*                                                                                  ;
*    Reading in the 2007 PSID data                                                 ;
*                                                                                  ;
*            John Soroushian 2/16/11                                               ;
*                                                                                  ;
*    We read it all in and then output select variables to a flat                  ;
*    file to be picked up by STATA.                                                ;
*                                                                                  ;
 
libname psid 'F:\PSID' ;
filename rawdat 'F:\PSID\raw\fam07.raw' ;

PROC PRINTTO LOG='F:\PSID\logfiles\readfam07.log' NEW;
RUN;

PROC PRINTTO PRINT='F:\PSID\logfiles\readfam07.lst' NEW;
RUN; 

 
data one;
   ATTRIB 
      ER36001   LABEL="RELEASE NUMBER"                                   format=f1.
      ER36002   LABEL="2007 FAMILY INTERVIEW (ID) NUMBER"                format=f5.
      ER36003   LABEL="PSID STATE OF RESIDENCE CODE"                     format=f2.
      ER36004   LABEL="CURRENT STATE"                                    format=f2.
      ER36005   LABEL="SPLITOFF INDICATOR"                               format=f1.
      ER36006   LABEL="MODE OF INTERVIEW"                                format=f1.
      ER36007   LABEL="FAMILY COMPOSITION CHANGE"                        format=f1.
      ER36008   LABEL="TYPE INSTITUTION"                                 format=f1.
      ER36009   LABEL="1968 FAMILY IDENTIFIER"                           format=f4.
      ER36010   LABEL="WTR REINSTATED DROPPED FAMILY"                    format=f1.
      ER36011   LABEL="INTERVIEWER ID"                                   format=f8.
      ER36012   LABEL="MONTH  CURRENT IW"                                format=f2.
      ER36013   LABEL="DAY CURRENT IW"                                   format=f2.
      ER36014   LABEL="YEAR CURRENT IW"                                  format=f4.
      ER36015   LABEL="LENGTH OF IW IN MINUTES"                          format=f3.
      ER36016   LABEL="# IN FU"                                          format=f2.
      ER36017   LABEL="AGE OF HEAD"                                      format=f3.
      ER36018   LABEL="SEX OF HEAD"                                      format=f1.
      ER36019   LABEL="AGE OF WIFE"                                      format=f3.
      ER36020   LABEL="# CHILDREN IN FU"                                 format=f2.
      ER36021   LABEL="AGE YOUNGEST CHILD"                               format=f3.
      ER36022   LABEL="# NONFU SHARING HU"                               format=f2.
      ER36023   LABEL="HEAD MARITAL STATUS"                              format=f1.
      ER36024   LABEL="A4 TYPE DU"                                       format=f1.
      ER36025   LABEL="A6 LIVE IN ELDERLY HSNG"                          format=f1.
      ER36026   LABEL="A7 TYPE ELDERLY HSNG"                             format=f1.
      ER36027   LABEL="A8 ACTUAL # ROOMS"                                format=f2.
      ER36028   LABEL="A19 OWN/RENT OR WHAT"                             format=f1.
      ER36029   LABEL="A20 HOUSE VALUE"                                  format=f7.
      ER36030   LABEL="ACCURACY OF HOUSE VALUE"                          format=f1.
      ER36031   LABEL="A20A WTR HOUSE WORTH 100,000+"                    format=f1.
      ER36032   LABEL="A20B WTR HOUSE WORTH 200,000+"                    format=f1.
      ER36033   LABEL="A20C WTR HOUSE WORTH 400,000+"                    format=f1.
      ER36034   LABEL="A20D WTR HOUSE WORTH 75,000+"                     format=f1.
      ER36035   LABEL="A20E WTR HOUSE WORTH 25,000+"                     format=f1.
      ER36036   LABEL="A21 ANNUAL PROPERTY TAX"                          format=f5.
      ER36037   LABEL="ACCURACY OF ANNUAL PROPERTY TAX"                  format=f1.
      ER36038   LABEL="A22 ANNUAL OWNR INSURANC"                         format=f4.
      ER36039   LABEL="A23 HAVE MORTGAGE?"                               format=f1.
      ER36040   LABEL="A23A TYPE MORTGAGE MOR 1"                         format=f1.
      ER36041   LABEL="A23C WTR ORIGINAL LOAN/REFINANCED #1"             format=f1.
      ER36042   LABEL="A24 REM PRINCIPAL MOR 1"                          format=f7.
      ER36043   LABEL="ACCURACY OF REMAINING MORTGAGE PRIN #1"           format=f1.
      ER36044   LABEL="A25 MNTHLY PMTS MOR 1"                            format=f5.
      ER36045   LABEL="ACCURACY OF MONTHLY PYMNTS ON MTGE #1"            format=f1.
      ER36046   LABEL="A25A CURR INTEREST RATE WHOLE PERCENT #1"         format=f2.
      ER36047   LABEL="A25A CURR INT RATE DECIMAL FRACTION #1"           format=f3.
      ER36048   LABEL="A25A1 WTR CURR INT RATE FIXED/VARBLE #1"          format=f1.
      ER36049   LABEL="A26 YEAR OBTAINED LOAN #1"                        format=f4.
      ER36050   LABEL="A27 YRS TO PAY MOR    1"                          format=f2.
      ER36051   LABEL="A28 2ND MORTGAGE"                                 format=f1.
      ER36052   LABEL="A23A TYPE MORTGAGE MOR 2"                         format=f1.
      ER36053   LABEL="A23C WTR ORIGINAL LOAN/REFINANCED #2"             format=f1.
      ER36054   LABEL="A24 REM PRINCIPAL MOR 2"                          format=f7.
      ER36055   LABEL="ACCURACY OF REMAINING MORTGAGE PRIN #2"           format=f1.
      ER36056   LABEL="A25 MNTHLY PMTS MOR   2"                          format=f5.
      ER36057   LABEL="ACCURACY OF MONTHLY PYMNTS ON MTGE #2"            format=f1.
      ER36058   LABEL="A25A CURR INTEREST RATE WHOLE PERCENT #2"         format=f2.
      ER36059   LABEL="A25A CURR INT RATE DECIMAL FRACTION #2"           format=f3.
      ER36060   LABEL="A25A1 WTR CURR INT RATE FIXED/VARBLE #2"          format=f1.
      ER36061   LABEL="A26 YEAR OBTAINED LOAN #2"                        format=f4.
      ER36062   LABEL="A27 YRS TO PAY MOR    2"                          format=f2.
      ER36063   LABEL="A29 MTG INCL PROP TAXES"                          format=f1.
      ER36064   LABEL="A30 MTG INCL INS PREM"                            format=f1.
      ER36065   LABEL="A31 DOLLARS RENT"                                 format=f5.
      ER36066   LABEL="A31 DOLLARS PER WHAT"                             format=f1.
      ER36067   LABEL="ACCURACY OF RENT"                                 format=f1.
      ER36068   LABEL="A31A FURNISHED APT/HOUSE"                         format=f1.
      ER36069   LABEL="A31B RENT INCL HEAT"                              format=f1.
      ER36070   LABEL="A32 IN PUBLIC OWND PROJ?"                         format=f1.
      ER36071   LABEL="A33 GOVT PAY PART RENT?"                          format=f1.
      ER36072   LABEL="A35 DOLLARS RENT IF RENT"                         format=f4.
      ER36073   LABEL="A35 DOLLARS PER WHAT"                             format=f1.
      ER36074   LABEL="ACCURACY OF VALUE IF RENTED"                      format=f1.
      ER36075   LABEL="A36 IN PUBLIC OWND PROJ?"                         format=f1.
      ER36076   LABEL="A37 GOVT PAY ALL RENT?"                           format=f1.
      ER36077   LABEL="A38 HAVE AIR CONDITNG"                            format=f1.
      ER36078   LABEL="A39 A/C ALL OR SOME ROOM"                         format=f1.
      ER36079   LABEL="A40 TYPE HEATING 1ST MENTION"                     format=f2.
      ER36080   LABEL="A40 TYPE HEATING 2ND MENTION"                     format=f2.
      ER36081   LABEL="A40 TYPE HEATING 3RD MENTION"                     format=f2.
      ER36082   LABEL="A42 WTR GAS/ELEC COSTS ON ONE BILL"               format=f1.
      ER36083   LABEL="A41 HEATING FUEL EXPENSE"                         format=f4.
      ER36084   LABEL="A41 HEATING FUEL EXPENSE PER"                     format=f1.
      ER36085   LABEL="A42 ELECTRICITY EXPENSE"                          format=f4.
      ER36086   LABEL="A42 ELECTRICITY PER"                              format=f1.
      ER36087   LABEL="A42 COMBINED GAS/ELECT EXPENSE"                   format=f4.
      ER36088   LABEL="A42 COMBINED GAS/ELECT EXPENSE PER"               format=f1.
      ER36089   LABEL="A43 WATER/SEWER EXPENSE"                          format=f4.
      ER36090   LABEL="A43 WATER/SEWER EXPENSE PER"                      format=f1.
      ER36091   LABEL="A44 TELEPHONE EXPENSE"                            format=f4.
      ER36092   LABEL="A44 TELEPHONE EXPENSE PER"                        format=f1.
      ER36093   LABEL="A45 WTR OTR UTILITY EXP"                          format=f1.
      ER36094   LABEL="A45A GARBAGE EXPENSE"                             format=f1.
      ER36095   LABEL="A45B TOTAL OTR UTILITIES"                         format=f3.
      ER36096   LABEL="A45B OTR UTILITIES PER"                           format=f1.
      ER36097   LABEL="A46 RECD GOVT HTG SUBSDY"                         format=f1.
      ER36098   LABEL="A46A AMT GOVT HTG SUBSDY"                         format=f4.
      ER36099   LABEL="A47A WTR COMPUTER IN HOME-HD"                     format=f1.
      ER36100   LABEL="A47B WTR USED INTERNET-HD"                        format=f1.
      ER36101   LABEL="A47A WTR COMPUTER IN HOME-WF"                     format=f1.
      ER36102   LABEL="A47B WTR USED INTERNET-WF"                        format=f1.
      ER36103   LABEL="A49 WTR MOVED SINCE JAN 1 OF PRIOR YEAR"          format=f1.
      ER36104   LABEL="A49 MONTH MOVED"                                  format=f2.
      ER36105   LABEL="A49 YEAR MOVED"                                   format=f4.
      ER36106   LABEL="A50 WHY MOVED 1ST"                                format=f2.
      ER36107   LABEL="A51 WTR MIGHT MOVE"                               format=f1.
      ER36108   LABEL="A52 LIKELIHOOD OF MOVING"                         format=f1.
      ER36109   LABEL="BC1 EMPLOYMENT STATUS-1ST MENTION"                format=f2.
      ER36110   LABEL="BC1 EMPLOYMENT STATUS-2ND MENTION"                format=f2.
      ER36111   LABEL="BC1 EMPLOYMENT STATUS-3RD MENTION"                format=f2.
      ER36112   LABEL="BC2 YEAR RETIRED"                                 format=f4.
      ER36113   LABEL="BC3 WTR WORK FOR MONEY"                           format=f1.
      ER36114   LABEL="BC3A WTR WORKD SINCE JAN 1 OF PRIOR YEAR"         format=f1.
      ER36115   LABEL="BC16-17 MAIN JOB INDICATOR"                       format=f1.
      ER36116   LABEL="BC6 BEGINNING MONTH--JOB 1"                       format=f2.
      ER36117   LABEL="BC6 BEGINNING YEAR--JOB 1"                        format=f4.
      ER36118   LABEL="BC6 ENDING MONTH--JOB 1"                          format=f2.
      ER36119   LABEL="BC6 ENDING YEAR--JOB 1"                           format=f4.
      ER36120   LABEL="BC6 WTR EMPLOYED--JOB 1 JAN"                      format=f1.
      ER36121   LABEL="BC6 WTR EMPLOYED--JOB 1 FEB"                      format=f1.
      ER36122   LABEL="BC6 WTR EMPLOYED--JOB 1 MAR"                      format=f1.
      ER36123   LABEL="BC6 WTR EMPLOYED--JOB 1 APR"                      format=f1.
      ER36124   LABEL="BC6 WTR EMPLOYED--JOB 1 MAY"                      format=f1.
      ER36125   LABEL="BC6 WTR EMPLOYED--JOB 1 JUN"                      format=f1.
      ER36126   LABEL="BC6 WTR EMPLOYED--JOB 1 JUL"                      format=f1.
      ER36127   LABEL="BC6 WTR EMPLOYED--JOB 1 AUG"                      format=f1.
      ER36128   LABEL="BC6 WTR EMPLOYED--JOB 1 SEP"                      format=f1.
      ER36129   LABEL="BC6 WTR EMPLOYED--JOB 1 OCT"                      format=f1.
      ER36130   LABEL="BC6 WTR EMPLOYED--JOB 1 NOV"                      format=f1.
      ER36131   LABEL="BC6 WTR EMPLOYED--JOB 1 DEC"                      format=f1.
      ER36132   LABEL="BC20 MAIN OCC FOR JOB 1: 2000 CODE (HD)"          format=f3.
      ER36133   LABEL="BC21 MAIN IND FOR JOB 1: 2000 CODE (HD)"          format=f3.
      ER36134   LABEL="BC22 WORK SELF/OTR?--JOB 1"                       format=f1.
      ER36135   LABEL="BC23 CORP/UNCORP BUS--JOB 1"                      format=f1.
      ER36136   LABEL="BC24 WORK FOR GOVT?--JOB 1"                       format=f1.
      ER36137   LABEL="BC25A NUMBER EMPLOYED AT WORK LOCATION"           format=f9.
      ER36138   LABEL="BC25B WTR 200 OR MORE"                            format=f1.
      ER36139   LABEL="BC25C WTR 100 OR MORE"                            format=f1.
      ER36140   LABEL="BC25D WTR 50 OR MORE"                             format=f1.
      ER36141   LABEL="BC25E WTR 500 OR MORE"                            format=f1.
      ER36142   LABEL="BC25F WTR 1000 OR MORE"                           format=f1.
      ER36143   LABEL="BC26 JOB NOW UNION? (H-E)"                        format=f1.
      ER36144   LABEL="BC27 BELONG UNION? (HD-E)"                        format=f1.
      ER36145   LABEL="BC28A WTR JOB REQUIRES COMPUTER USE"              format=f1.
      ER36146   LABEL="BC29 SLRY/HRLY/OTR (H-E)"                         format=f1.
      ER36147   LABEL="BC30 SALARY AMOUNT"                               format=f10.2
      ER36148   LABEL="BC30 SALARY PER WHAT"                             format=f1.
      ER36149   LABEL="BC31 WTR SAL PD OT (HD-E)"                        format=f1.
      ER36150   LABEL="BC32 HOW PAID FOR OT"                             format=f1.
      ER36151   LABEL="BC32A EXACT OT PAY IF SALARIED"                   format=f10.2
      ER36152   LABEL="BC32A EXACT OT PAY PER"                           format=f1.
      ER36153   LABEL="BC33 HOURLY REGULAR RATE"                         format=f6.2
      ER36154   LABEL="BC34 OT DIFFERENTIAL 1ST"                         format=f1.
      ER36155   LABEL="BC34 OT DIFFERENTIAL 2ND"                         format=f1.
      ER36156   LABEL="BC34 OT DIFFERENTIAL 3RD"                         format=f1.
      ER36157   LABEL="BC34A EXACT OT PAY IF HOURLY"                     format=f10.2
      ER36158   LABEL="BC34A EXACT OT PAY PER"                           format=f1.
      ER36159   LABEL="BC36 AVG TIPS/COMM"                               format=f8.2
      ER36160   LABEL="BC36 TIPS/COMM PER WHAT"                          format=f1.
      ER36161   LABEL="BC37 AVG TIPS/COMM"                               format=f7.
      ER36162   LABEL="BC37 TIPS/COMM PER WHAT"                          format=f1.
      ER36163   LABEL="BC38 HOW PAID-OTR (HD-E)"                         format=f1.
      ER36164   LABEL="BC39 OT RATE"                                     format=f9.2
      ER36165   LABEL="BC41 YRS PRES EMP (H-E)"                          format=f2.
      ER36166   LABEL="BC41 MOS PRES EMP (H-E)"                          format=f2.
      ER36167   LABEL="BC41 WKS PRES EMP (H-E)"                          format=f2.
      ER36168   LABEL="BC42A WKS WORKED--HD JOB 1"                       format=f4.1
      ER36169   LABEL="ACCURACY OF WKS WORKED--HD JOB 1"                 format=f1.
      ER36170   LABEL="BC43 HOURS/WEEK WORKED--JOB 1"                    format=f3.
      ER36171   LABEL="ACCURACY OF HR/WK WORKED--HD JOB 1"               format=f1.
      ER36172   LABEL="BC44 WTR WORKED OT--JOB 1"                        format=f1.
      ER36173   LABEL="BC45 AMT OF OT WORKED--JOB 1"                     format=f4.
      ER36174   LABEL="BC45 OT TIME UNIT--JOB 1"                         format=f1.
      ER36175   LABEL="ACCURACY OF OT--HD JOB 1"                         format=f1.
      ER36176   LABEL="BC46 AMOUNT EARNED LAST YEAR--JOB 1"              format=f10.2
      ER36177   LABEL="BC46 PER FOR AMT EARNED LAST YR--JOB 1"           format=f1.
      ER36178   LABEL="BC51 WHY LAST JOB END (HD-U)"                     format=f1.
      ER36179   LABEL="BC6 BEGINNING MONTH--JOB 2"                       format=f2.
      ER36180   LABEL="BC6 BEGINNING YEAR--JOB 2"                        format=f4.
      ER36181   LABEL="BC6 ENDING MONTH--JOB 2"                          format=f2.
      ER36182   LABEL="BC6 ENDING YEAR--JOB 2"                           format=f4.
      ER36183   LABEL="BC6 WTR EMPLOYED--JOB 2 JAN"                      format=f1.
      ER36184   LABEL="BC6 WTR EMPLOYED--JOB 2 FEB"                      format=f1.
      ER36185   LABEL="BC6 WTR EMPLOYED--JOB 2 MAR"                      format=f1.
      ER36186   LABEL="BC6 WTR EMPLOYED--JOB 2 APR"                      format=f1.
      ER36187   LABEL="BC6 WTR EMPLOYED--JOB 2 MAY"                      format=f1.
      ER36188   LABEL="BC6 WTR EMPLOYED--JOB 2 JUN"                      format=f1.
      ER36189   LABEL="BC6 WTR EMPLOYED--JOB 2 JUL"                      format=f1.
      ER36190   LABEL="BC6 WTR EMPLOYED--JOB 2 AUG"                      format=f1.
      ER36191   LABEL="BC6 WTR EMPLOYED--JOB 2 SEP"                      format=f1.
      ER36192   LABEL="BC6 WTR EMPLOYED--JOB 2 OCT"                      format=f1.
      ER36193   LABEL="BC6 WTR EMPLOYED--JOB 2 NOV"                      format=f1.
      ER36194   LABEL="BC6 WTR EMPLOYED--JOB 2 DEC"                      format=f1.
      ER36195   LABEL="BC20 MAIN OCC FOR JOB 2: 2000 CODE (HD)"          format=f3.
      ER36196   LABEL="BC21 MAIN IND FOR JOB 2: 2000 CODE (HD)"          format=f3.
      ER36197   LABEL="BC22 WORK SELF/OTR?--JOB 2"                       format=f1.
      ER36198   LABEL="BC23 CORP/UNCORP BUS--JOB 2"                      format=f1.
      ER36199   LABEL="BC24 WORK FOR GOVT?--JOB 2"                       format=f1.
      ER36200   LABEL="BC42A WKS WORKED--HD JOB 2"                       format=f4.1
      ER36201   LABEL="ACCURACY OF WKS WORKED--HD JOB 2"                 format=f1.
      ER36202   LABEL="BC43 HOURS/WEEK WORKED--JOB 2"                    format=f3.
      ER36203   LABEL="ACCURACY OF HR/WK WORKED--HD JOB 2"               format=f1.
      ER36204   LABEL="BC44 WTR WORKED OT--JOB 2"                        format=f1.
      ER36205   LABEL="BC45 AMT OF OT WORKED--JOB 2"                     format=f4.
      ER36206   LABEL="BC45 OT TIME UNIT--JOB 2"                         format=f1.
      ER36207   LABEL="ACCURACY OF OT--HD JOB 2"                         format=f1.
      ER36208   LABEL="BC46 AMOUNT EARNED LAST YEAR--JOB 2"              format=f10.2
      ER36209   LABEL="BC46 PER FOR AMT EARNED LAST YR--JOB 2"           format=f1.
      ER36210   LABEL="BC51 WHY JOB ENDED--JOB 2"                        format=f1.
      ER36211   LABEL="BC6 BEGINNING MONTH--JOB 3"                       format=f2.
      ER36212   LABEL="BC6 BEGINNING YEAR--JOB 3"                        format=f4.
      ER36213   LABEL="BC6 ENDING MONTH--JOB 3"                          format=f2.
      ER36214   LABEL="BC6 ENDING YEAR--JOB 3"                           format=f4.
      ER36215   LABEL="BC6 WTR EMPLOYED--JOB 3 JAN"                      format=f1.
      ER36216   LABEL="BC6 WTR EMPLOYED--JOB 3 FEB"                      format=f1.
      ER36217   LABEL="BC6 WTR EMPLOYED--JOB 3 MAR"                      format=f1.
      ER36218   LABEL="BC6 WTR EMPLOYED--JOB 3 APR"                      format=f1.
      ER36219   LABEL="BC6 WTR EMPLOYED--JOB 3 MAY"                      format=f1.
      ER36220   LABEL="BC6 WTR EMPLOYED--JOB 3 JUN"                      format=f1.
      ER36221   LABEL="BC6 WTR EMPLOYED--JOB 3 JUL"                      format=f1.
      ER36222   LABEL="BC6 WTR EMPLOYED--JOB 3 AUG"                      format=f1.
      ER36223   LABEL="BC6 WTR EMPLOYED--JOB 3 SEP"                      format=f1.
      ER36224   LABEL="BC6 WTR EMPLOYED--JOB 3 OCT"                      format=f1.
      ER36225   LABEL="BC6 WTR EMPLOYED--JOB 3 NOV"                      format=f1.
      ER36226   LABEL="BC6 WTR EMPLOYED--JOB 3 DEC"                      format=f1.
      ER36227   LABEL="BC20 MAIN OCC FOR JOB 3: 2000 CODE (HD)"          format=f3.
      ER36228   LABEL="BC21 MAIN IND FOR JOB 3: 2000 CODE (HD)"          format=f3.
      ER36229   LABEL="BC22 WORK SELF/OTR?--JOB 3"                       format=f1.
      ER36230   LABEL="BC23 CORP/UNCORP BUS--JOB 3"                      format=f1.
      ER36231   LABEL="BC24 WORK FOR GOVT?--JOB 3"                       format=f1.
      ER36232   LABEL="BC42A WKS WORKED--HD JOB 3"                       format=f4.1
      ER36233   LABEL="ACCURACY OF WKS WORKED--HD JOB 3"                 format=f1.
      ER36234   LABEL="BC43 HOURS/WEEK WORKED--JOB 3"                    format=f3.
      ER36235   LABEL="ACCURACY OF HR/WK WORKED--HD JOB 3"               format=f1.
      ER36236   LABEL="BC44 WTR WORKED OT--JOB 3"                        format=f1.
      ER36237   LABEL="BC45 AMT OF OT WORKED--JOB 3"                     format=f4.
      ER36238   LABEL="BC45 OT TIME UNIT--JOB 3"                         format=f1.
      ER36239   LABEL="ACCURACY OF OT--HD JOB 3"                         format=f1.
      ER36240   LABEL="BC46 AMOUNT EARNED LAST YEAR--JOB 3"              format=f10.2
      ER36241   LABEL="BC46 PER FOR AMT EARNED LAST YR--JOB 3"           format=f1.
      ER36242   LABEL="BC51 WHY JOB ENDED--JOB 3"                        format=f1.
      ER36243   LABEL="BC6 BEGINNING MONTH--JOB 4"                       format=f2.
      ER36244   LABEL="BC6 BEGINNING YEAR--JOB 4"                        format=f4.
      ER36245   LABEL="BC6 ENDING MONTH--JOB 4"                          format=f2.
      ER36246   LABEL="BC6 ENDING YEAR--JOB 4"                           format=f4.
      ER36247   LABEL="BC6 WTR EMPLOYED--JOB 4 JAN"                      format=f1.
      ER36248   LABEL="BC6 WTR EMPLOYED--JOB 4 FEB"                      format=f1.
      ER36249   LABEL="BC6 WTR EMPLOYED--JOB 4 MAR"                      format=f1.
      ER36250   LABEL="BC6 WTR EMPLOYED--JOB 4 APR"                      format=f1.
      ER36251   LABEL="BC6 WTR EMPLOYED--JOB 4 MAY"                      format=f1.
      ER36252   LABEL="BC6 WTR EMPLOYED--JOB 4 JUN"                      format=f1.
      ER36253   LABEL="BC6 WTR EMPLOYED--JOB 4 JUL"                      format=f1.
      ER36254   LABEL="BC6 WTR EMPLOYED--JOB 4 AUG"                      format=f1.
      ER36255   LABEL="BC6 WTR EMPLOYED--JOB 4 SEP"                      format=f1.
      ER36256   LABEL="BC6 WTR EMPLOYED--JOB 4 OCT"                      format=f1.
      ER36257   LABEL="BC6 WTR EMPLOYED--JOB 4 NOV"                      format=f1.
      ER36258   LABEL="BC6 WTR EMPLOYED--JOB 4 DEC"                      format=f1.
      ER36259   LABEL="BC20 MAIN OCC FOR JOB 4: 2000 CODE (HD)"          format=f3.
      ER36260   LABEL="BC21 MAIN IND FOR JOB 4: 2000 CODE (HD)"          format=f3.
      ER36261   LABEL="BC22 WORK SELF/OTR?--JOB 4"                       format=f1.
      ER36262   LABEL="BC23 CORP/UNCORP BUS--JOB 4"                      format=f1.
      ER36263   LABEL="BC24 WORK FOR GOVT?--JOB 4"                       format=f1.
      ER36264   LABEL="BC42A WKS WORKED--HD JOB 4"                       format=f4.1
      ER36265   LABEL="ACCURACY OF WKS WORKED--HD JOB 4"                 format=f1.
      ER36266   LABEL="BC43 HOURS/WEEK WORKED--JOB 4"                    format=f3.
      ER36267   LABEL="ACCURACY OF HR/WK WORKED--HD JOB 4"               format=f1.
      ER36268   LABEL="BC44 WTR WORKED OT--JOB 4"                        format=f1.
      ER36269   LABEL="BC45 AMT OF OT WORKED--JOB 4"                     format=f4.
      ER36270   LABEL="BC45 OT TIME UNIT--JOB 4"                         format=f1.
      ER36271   LABEL="ACCURACY OF OT--HD JOB 4"                         format=f1.
      ER36272   LABEL="BC46 AMOUNT EARNED LAST YEAR--JOB 4"              format=f10.2
      ER36273   LABEL="BC46 PER FOR AMT EARNED LAST YR--JOB 4"           format=f1.
      ER36274   LABEL="BC51 WHY JOB ENDED--JOB 4"                        format=f1.
      ER36275   LABEL="NUMBER OF ADDITIONAL JOBS--HD"                    format=f1.
      ER36276   LABEL="BC10 WTR OTRS ILL (HD)"                           format=f1.
      ER36277   LABEL="BC10 DAYS OTHERS SICK"                            format=f3.
      ER36278   LABEL="ACCURACY OF DAYS OTRS SICK (HD)"                  format=f1.
      ER36279   LABEL="BC10 WEEKS OTHERS SICK"                           format=f2.
      ER36280   LABEL="ACCURACY OF WEEKS OTRS SICK (HD)"                 format=f1.
      ER36281   LABEL="BC10 MONTHS OTHERS SICK"                          format=f2.
      ER36282   LABEL="ACCURACY OF MONTHS OTRS SICK (HD)"                format=f1.
      ER36283   LABEL="BC11 WTR SELF ILL (HD)"                           format=f1.
      ER36284   LABEL="BC11 DAYS SELF SICK"                              format=f3.
      ER36285   LABEL="ACCURACY OF DAYS SELF ILL (HD)"                   format=f1.
      ER36286   LABEL="BC11 WEEKS SELF SICK"                             format=f2.
      ER36287   LABEL="ACCURACY OF WEEKS SELF ILL (HD)"                  format=f1.
      ER36288   LABEL="BC11 MONTHS SELF SICK"                            format=f2.
      ER36289   LABEL="ACCURACY OF MONTHS SELF ILL (HD)"                 format=f1.
      ER36290   LABEL="BC12 WTR VACATION (HD)"                           format=f1.
      ER36291   LABEL="BC12 DAYS VACATION"                               format=f3.
      ER36292   LABEL="ACCURACY OF DAYS VACATION (HD)"                   format=f1.
      ER36293   LABEL="BC12 WEEKS VACATION"                              format=f2.
      ER36294   LABEL="ACCURACY OF WEEKS VACATION (HD)"                  format=f1.
      ER36295   LABEL="BC12 MONTHS VACATION"                             format=f2.
      ER36296   LABEL="ACCURACY OF MONTHS VACATION (HD)"                 format=f1.
      ER36297   LABEL="BC13 WTR STRIKE (HD)"                             format=f1.
      ER36298   LABEL="BC13 DAYS STRIKE"                                 format=f3.
      ER36299   LABEL="ACCURACY OF STRIKE DAYS (HD)"                     format=f1.
      ER36300   LABEL="BC13 WEEKS STRIKE"                                format=f2.
      ER36301   LABEL="ACCURACY OF STRIKE WEEKS (HD)"                    format=f1.
      ER36302   LABEL="BC13 MONTHS STRIKE"                               format=f2.
      ER36303   LABEL="ACCURACY OF STRIKE MONTHS (HD)"                   format=f1.
      ER36304   LABEL="BC14 WTR LAID OFF (HD)"                           format=f1.
      ER36305   LABEL="BC14 DAYS LAID OFF"                               format=f3.
      ER36306   LABEL="ACCURACY OF DAYS LAID OFF (HD)"                   format=f1.
      ER36307   LABEL="BC14 WEEKS LAID OFF"                              format=f2.
      ER36308   LABEL="ACCURACY OF WEEKS LAID OFF (HD)"                  format=f1.
      ER36309   LABEL="BC14 MONTHS LAID OFF"                             format=f2.
      ER36310   LABEL="ACCURACY OF MONTHS LAID OFF (HD)"                 format=f1.
      ER36311   LABEL="BC8 WTR UNEMPLOYED(HD)"                           format=f1.
      ER36312   LABEL="BC8 DAYS UNEMPLOYED"                              format=f3.
      ER36313   LABEL="ACCURACY OF DAYS UNEMPLOYED (HD)"                 format=f1.
      ER36314   LABEL="BC8 WEEKS UNEMPLOYED"                             format=f2.
      ER36315   LABEL="ACCURACY OF WEEKS UNEMPLOYED (HD)"                format=f1.
      ER36316   LABEL="BC8 MONTHS UNEMPLOYED"                            format=f2.
      ER36317   LABEL="ACCURACY OF MONTHS UNEMPLOYED (HD)"               format=f1.
      ER36318   LABEL="BC8 WTR UNEMPLOYED JAN"                           format=f1.
      ER36319   LABEL="BC8 WTR UNEMPLOYED FEB"                           format=f1.
      ER36320   LABEL="BC8 WTR UNEMPLOYED MAR"                           format=f1.
      ER36321   LABEL="BC8 WTR UNEMPLOYED APR"                           format=f1.
      ER36322   LABEL="BC8 WTR UNEMPLOYED MAY"                           format=f1.
      ER36323   LABEL="BC8 WTR UNEMPLOYED JUN"                           format=f1.
      ER36324   LABEL="BC8 WTR UNEMPLOYED JUL"                           format=f1.
      ER36325   LABEL="BC8 WTR UNEMPLOYED AUG"                           format=f1.
      ER36326   LABEL="BC8 WTR UNEMPLOYED SEP"                           format=f1.
      ER36327   LABEL="BC8 WTR UNEMPLOYED OCT"                           format=f1.
      ER36328   LABEL="BC8 WTR UNEMPLOYED NOV"                           format=f1.
      ER36329   LABEL="BC8 WTR UNEMPLOYED DEC"                           format=f1.
      ER36330   LABEL="BC7 WTR OUT LAB FRC(H)"                           format=f1.
      ER36331   LABEL="BC7 DAYS OUT OF LAB FORCE"                        format=f3.
      ER36332   LABEL="ACCURACY OF DAYS OUT OF LAB FORCE (HD)"           format=f1.
      ER36333   LABEL="BC7WEEKS OUT LABOR FORCE"                         format=f2.
      ER36334   LABEL="ACCURACY OF WKS OUT OF LAB FORCE (HD)"            format=f1.
      ER36335   LABEL="BC7 MONTHS OUT LABR FORCE"                        format=f2.
      ER36336   LABEL="ACCURACY OF MOS OUT OF LAB FORCE (HD)"            format=f1.
      ER36337   LABEL="BC7 WTR OUT LAB FORC JAN"                         format=f1.
      ER36338   LABEL="BC7 WTR OUT LAB FORC FEB"                         format=f1.
      ER36339   LABEL="BC7 WTR OUT LAB FORC MAR"                         format=f1.
      ER36340   LABEL="BC7 WTR OUT LAB FORC APR"                         format=f1.
      ER36341   LABEL="BC7 WTR OUT LAB FORC MAY"                         format=f1.
      ER36342   LABEL="BC7 WTR OUT LAB FORC JUN"                         format=f1.
      ER36343   LABEL="BC7 WTR OUT LAB FORC JUL"                         format=f1.
      ER36344   LABEL="BC7 WTR OUT LAB FORC AUG"                         format=f1.
      ER36345   LABEL="BC7 WTR OUT LAB FORC SEP"                         format=f1.
      ER36346   LABEL="BC7 WTR OUT LAB FORC OCT"                         format=f1.
      ER36347   LABEL="BC7 WTR OUT LAB FORC NOV"                         format=f1.
      ER36348   LABEL="BC7 WTR OUT LAB FORC DEC"                         format=f1.
      ER36349   LABEL="BC54 TOTAL WEEKS WORKED"                          format=f2.
      ER36350   LABEL="BC56 TOTAL HOURS WORKED"                          format=f3.
      ER36351   LABEL="BC62 WTR EVER WORKED"                             format=f1.
      ER36352   LABEL="BC63 MO LAST WORKED"                              format=f2.
      ER36353   LABEL="BC63 YR LAST WORKED"                              format=f4.
      ER36354   LABEL="BC64 WTR LOOKING FOR JOB"                         format=f1.
      ER36355   LABEL="BC65 WTR PUBLIC EMP AGENCY (HD)"                  format=f1.
      ER36356   LABEL="BC65 WTR PRIVATE EMP AGENCY (HD)"                 format=f1.
      ER36357   LABEL="BC65 WTR CHKD W/CURRENT EMP (HD)"                 format=f1.
      ER36358   LABEL="BC65 WTR CHKD W/OTHER EMP (HD)"                   format=f1.
      ER36359   LABEL="BC65 WTR CHKD W/FRIEND OR REL (HD)"               format=f1.
      ER36360   LABEL="BC65 WTR PLACED OR ANSWERED ADS (HD)"             format=f1.
      ER36361   LABEL="BC65 WTR OTHER ACTIVITY (HD)"                     format=f1.
      ER36362   LABEL="BC65 WTR DONE NOTHING (HD)"                       format=f1.
      ER36363   LABEL="BC67 YRS LOOK WRK (H-U)"                          format=f2.
      ER36364   LABEL="BC67 MOS LOOK WRK (H-U)"                          format=f2.
      ER36365   LABEL="BC67 WKS LOOK WRK (H-U)"                          format=f2.
      ER36366   LABEL="DE1 CKPT: WTR WIFE IN FU"                         format=f1.
      ER36367   LABEL="DE1 EMPLOYMENT STATUS-1ST MENTION"                format=f2.
      ER36368   LABEL="DE1 EMPLOYMENT STATUS-2ND MENTION"                format=f2.
      ER36369   LABEL="DE1 EMPLOYMENT STATUS-3RD MENTION"                format=f2.
      ER36370   LABEL="DE2 YEAR RETIRED (WF-R)"                          format=f4.
      ER36371   LABEL="DE3 WTR WORK FOR MONEY"                           format=f1.
      ER36372   LABEL="DE3A WTR WORKD SINCE JAN 1 OF PRIOR YEAR"         format=f1.
      ER36373   LABEL="DE16-17 MAIN JOB INDICATOR"                       format=f1.
      ER36374   LABEL="DE6 BEGINNING MONTH--JOB 1"                       format=f2.
      ER36375   LABEL="DE6 BEGINNING YEAR--JOB 1"                        format=f4.
      ER36376   LABEL="DE6 ENDING MONTH--JOB 1"                          format=f2.
      ER36377   LABEL="DE6 ENDING YEAR--JOB 1"                           format=f4.
      ER36378   LABEL="DE6 WTR EMPLOYED--JOB 1 JAN"                      format=f1.
      ER36379   LABEL="DE6 WTR EMPLOYED--JOB 1 FEB"                      format=f1.
      ER36380   LABEL="DE6 WTR EMPLOYED--JOB 1 MAR"                      format=f1.
      ER36381   LABEL="DE6 WTR EMPLOYED--JOB 1 APR"                      format=f1.
      ER36382   LABEL="DE6 WTR EMPLOYED--JOB 1 MAY"                      format=f1.
      ER36383   LABEL="DE6 WTR EMPLOYED--JOB 1 JUN"                      format=f1.
      ER36384   LABEL="DE6 WTR EMPLOYED--JOB 1 JUL"                      format=f1.
      ER36385   LABEL="DE6 WTR EMPLOYED--JOB 1 AUG"                      format=f1.
      ER36386   LABEL="DE6 WTR EMPLOYED--JOB 1 SEP"                      format=f1.
      ER36387   LABEL="DE6 WTR EMPLOYED--JOB 1 OCT"                      format=f1.
      ER36388   LABEL="DE6 WTR EMPLOYED--JOB 1 NOV"                      format=f1.
      ER36389   LABEL="DE6 WTR EMPLOYED--JOB 1 DEC"                      format=f1.
      ER36390   LABEL="DE20 MAIN OCC FOR JOB 1: 2000 CODE (WF)"          format=f3.
      ER36391   LABEL="DE21 MAIN IND FOR JOB 1: 2000 CODE (WF)"          format=f3.
      ER36392   LABEL="DE22 WORK SELF/OTR?--JOB 1"                       format=f1.
      ER36393   LABEL="DE23 CORP/UNCORP BUS--JOB 1"                      format=f1.
      ER36394   LABEL="DE24 WORK FOR GOVT?--JOB 1"                       format=f1.
      ER36395   LABEL="DE25A NUMBER EMPLOYED AT WORK LOCATION"           format=f9.
      ER36396   LABEL="DE25B WTR 200 OR MORE"                            format=f1.
      ER36397   LABEL="DE25C WTR 100 OR MORE"                            format=f1.
      ER36398   LABEL="DE25D WTR 50 OR MORE"                             format=f1.
      ER36399   LABEL="DE25E WTR 500 OR MORE"                            format=f1.
      ER36400   LABEL="DE25F WTR 1000 OR MORE"                           format=f1.
      ER36401   LABEL="DE26 JOB NOW UNION? (W-E)"                        format=f1.
      ER36402   LABEL="DE27 BELONG UNION? (WF-E)"                        format=f1.
      ER36403   LABEL="DE28A WTR JOB REQUIRES COMPUTER USE"              format=f1.
      ER36404   LABEL="DE29 SLRY/HRLY/OTR (W-E)"                         format=f1.
      ER36405   LABEL="DE30 SALARY AMOUNT"                               format=f10.2
      ER36406   LABEL="DE30 SALARY PER WHAT"                             format=f1.
      ER36407   LABEL="DE31 WTR SAL PD OT (WF-E)"                        format=f1.
      ER36408   LABEL="DE32 HOW PAID FOR OT"                             format=f1.
      ER36409   LABEL="DE32A EXACT OT PAY IF SALARIED"                   format=f10.2
      ER36410   LABEL="DE32A EXACT OT PAY PER"                           format=f1.
      ER36411   LABEL="DE33 HOURLY REGULAR RATE"                         format=f6.2
      ER36412   LABEL="DE34 OT DIFFERENTIAL 1ST"                         format=f1.
      ER36413   LABEL="DE34 OT DIFFERENTIAL 2ND"                         format=f1.
      ER36414   LABEL="DE34 OT DIFFERENTIAL 3RD"                         format=f1.
      ER36415   LABEL="DE34A EXACT OT PAY IF HOURLY"                     format=f10.2
      ER36416   LABEL="DE34A EXACT OT PAY PER"                           format=f1.
      ER36417   LABEL="DE36 AVG TIPS/COMM"                               format=f8.2
      ER36418   LABEL="DE36 TIPS/COMM PER WHAT"                          format=f1.
      ER36419   LABEL="DE37 AVG TIPS/COMM"                               format=f7.
      ER36420   LABEL="DE37 TIPS/COMM PER WHAT"                          format=f1.
      ER36421   LABEL="DE38 HOW PAID-OTR (WF-E)"                         format=f1.
      ER36422   LABEL="DE39 OT RATE"                                     format=f9.2
      ER36423   LABEL="DE41 YRS PRES EMP (W-E)"                          format=f2.
      ER36424   LABEL="DE41 MOS PRES EMP (W-E)"                          format=f2.
      ER36425   LABEL="DE41 WKS PRES EMP (W-E)"                          format=f2.
      ER36426   LABEL="DE42A WKS WORKED--WF JOB 1"                       format=f4.1
      ER36427   LABEL="ACCURACY OF WKS WORKED--WF JOB 1"                 format=f1.
      ER36428   LABEL="DE43 HOURS/WEEK WORKED--JOB 1"                    format=f3.
      ER36429   LABEL="ACCURACY OF HR/WK WORKED--WF JOB 1"               format=f1.
      ER36430   LABEL="DE44 WTR WORKED OT--JOB 1"                        format=f1.
      ER36431   LABEL="DE45 AMT OF OT WORKED--JOB 1"                     format=f4.
      ER36432   LABEL="DE45 OT TIME UNIT--JOB 1"                         format=f1.
      ER36433   LABEL="ACCURACY OF OT--WF JOB 1"                         format=f1.
      ER36434   LABEL="DE46 AMOUNT EARNED LAST YEAR--JOB 1"              format=f10.2
      ER36435   LABEL="DE46 PER FOR AMT EARNED LAST YR--JOB 1"           format=f1.
      ER36436   LABEL="DE51 WHY LAST JOB END (WF-U)"                     format=f1.
      ER36437   LABEL="DE6 BEGINNING MONTH--JOB 2"                       format=f2.
      ER36438   LABEL="DE6 BEGINNING YEAR--JOB 2"                        format=f4.
      ER36439   LABEL="DE6 ENDING MONTH--JOB 2"                          format=f2.
      ER36440   LABEL="DE6 ENDING YEAR--JOB 2"                           format=f4.
      ER36441   LABEL="DE6 WTR EMPLOYED--JOB 2 JAN"                      format=f1.
      ER36442   LABEL="DE6 WTR EMPLOYED--JOB 2 FEB"                      format=f1.
      ER36443   LABEL="DE6 WTR EMPLOYED--JOB 2 MAR"                      format=f1.
      ER36444   LABEL="DE6 WTR EMPLOYED--JOB 2 APR"                      format=f1.
      ER36445   LABEL="DE6 WTR EMPLOYED--JOB 2 MAY"                      format=f1.
      ER36446   LABEL="DE6 WTR EMPLOYED--JOB 2 JUN"                      format=f1.
      ER36447   LABEL="DE6 WTR EMPLOYED--JOB 2 JUL"                      format=f1.
      ER36448   LABEL="DE6 WTR EMPLOYED--JOB 2 AUG"                      format=f1.
      ER36449   LABEL="DE6 WTR EMPLOYED--JOB 2 SEP"                      format=f1.
      ER36450   LABEL="DE6 WTR EMPLOYED--JOB 2 OCT"                      format=f1.
      ER36451   LABEL="DE6 WTR EMPLOYED--JOB 2 NOV"                      format=f1.
      ER36452   LABEL="DE6 WTR EMPLOYED--JOB 2 DEC"                      format=f1.
      ER36453   LABEL="DE20 MAIN OCC FOR JOB 2: 2000 CODE (WF)"          format=f3.
      ER36454   LABEL="DE21 MAIN IND FOR JOB 2: 2000 CODE (WF)"          format=f3.
      ER36455   LABEL="DE22 WORK SELF/OTR?--JOB 2"                       format=f1.
      ER36456   LABEL="DE23 CORP/UNCORP BUS--JOB 2"                      format=f1.
      ER36457   LABEL="DE24 WORK FOR GOVT?--JOB 2"                       format=f1.
      ER36458   LABEL="DE42A WKS WORKED--WF JOB 2"                       format=f4.1
      ER36459   LABEL="ACCURACY OF WKS WORKED--WF JOB 2"                 format=f1.
      ER36460   LABEL="DE43 HOURS/WEEK WORKED--JOB 2"                    format=f3.
      ER36461   LABEL="ACCURACY OF HR/WK WORKED--WF JOB 2"               format=f1.
      ER36462   LABEL="DE44 WTR WORKED OT--JOB 2"                        format=f1.
      ER36463   LABEL="DE45 AMT OF OT WORKED--JOB 2"                     format=f4.
      ER36464   LABEL="DE45 OT TIME UNIT--JOB 2"                         format=f1.
      ER36465   LABEL="ACCURACY OF OT--WF JOB 2"                         format=f1.
      ER36466   LABEL="DE46 AMOUNT EARNED LAST YEAR--JOB 2"              format=f10.2
      ER36467   LABEL="DE46 PER FOR AMT EARNED LAST YR--JOB 2"           format=f1.
      ER36468   LABEL="DE51 WHY JOB ENDED--JOB 2"                        format=f1.
      ER36469   LABEL="DE6 BEGINNING MONTH--JOB 3"                       format=f2.
      ER36470   LABEL="DE6 BEGINNING YEAR--JOB 3"                        format=f4.
      ER36471   LABEL="DE6 ENDING MONTH--JOB 3"                          format=f2.
      ER36472   LABEL="DE6 ENDING YEAR--JOB 3"                           format=f4.
      ER36473   LABEL="DE6 WTR EMPLOYED--JOB 3 JAN"                      format=f1.
      ER36474   LABEL="DE6 WTR EMPLOYED--JOB 3 FEB"                      format=f1.
      ER36475   LABEL="DE6 WTR EMPLOYED--JOB 3 MAR"                      format=f1.
      ER36476   LABEL="DE6 WTR EMPLOYED--JOB 3 APR"                      format=f1.
      ER36477   LABEL="DE6 WTR EMPLOYED--JOB 3 MAY"                      format=f1.
      ER36478   LABEL="DE6 WTR EMPLOYED--JOB 3 JUN"                      format=f1.
      ER36479   LABEL="DE6 WTR EMPLOYED--JOB 3 JUL"                      format=f1.
      ER36480   LABEL="DE6 WTR EMPLOYED--JOB 3 AUG"                      format=f1.
      ER36481   LABEL="DE6 WTR EMPLOYED--JOB 3 SEP"                      format=f1.
      ER36482   LABEL="DE6 WTR EMPLOYED--JOB 3 OCT"                      format=f1.
      ER36483   LABEL="DE6 WTR EMPLOYED--JOB 3 NOV"                      format=f1.
      ER36484   LABEL="DE6 WTR EMPLOYED--JOB 3 DEC"                      format=f1.
      ER36485   LABEL="DE20 MAIN OCC FOR JOB 3: 2000 CODE (WF)"          format=f3.
      ER36486   LABEL="DE21 MAIN IND FOR JOB 3: 2000 CODE (WF)"          format=f3.
      ER36487   LABEL="DE22 WORK SELF/OTR?--JOB 3"                       format=f1.
      ER36488   LABEL="DE23 CORP/UNCORP BUS--JOB 3"                      format=f1.
      ER36489   LABEL="DE24 WORK FOR GOVT?--JOB 3"                       format=f1.
      ER36490   LABEL="DE42A WKS WORKED--WF JOB 3"                       format=f4.1
      ER36491   LABEL="ACCURACY OF WKS WORKED--WF JOB 3"                 format=f1.
      ER36492   LABEL="DE43 HOURS/WEEK WORKED--JOB 3"                    format=f3.
      ER36493   LABEL="ACCURACY OF HR/WK WORKED--WF JOB 3"               format=f1.
      ER36494   LABEL="DE44 WTR WORKED OT--JOB 3"                        format=f1.
      ER36495   LABEL="DE45 AMT OF OT WORKED--JOB 3"                     format=f4.
      ER36496   LABEL="DE45 OT TIME UNIT--JOB 3"                         format=f1.
      ER36497   LABEL="ACCURACY OF OT--WF JOB 3"                         format=f1.
      ER36498   LABEL="DE46 AMOUNT EARNED LAST YEAR--JOB 3"              format=f10.2
      ER36499   LABEL="DE46 PER FOR AMT EARNED LAST YR--JOB 3"           format=f1.
      ER36500   LABEL="DE51 WHY JOB ENDED--JOB 3"                        format=f1.
      ER36501   LABEL="DE6 BEGINNING MONTH--JOB 4"                       format=f2.
      ER36502   LABEL="DE6 BEGINNING YEAR--JOB 4"                        format=f4.
      ER36503   LABEL="DE6 ENDING MONTH--JOB 4"                          format=f2.
      ER36504   LABEL="DE6 ENDING YEAR--JOB 4"                           format=f4.
      ER36505   LABEL="DE6 WTR EMPLOYED--JOB 4 JAN"                      format=f1.
      ER36506   LABEL="DE6 WTR EMPLOYED--JOB 4 FEB"                      format=f1.
      ER36507   LABEL="DE6 WTR EMPLOYED--JOB 4 MAR"                      format=f1.
      ER36508   LABEL="DE6 WTR EMPLOYED--JOB 4 APR"                      format=f1.
      ER36509   LABEL="DE6 WTR EMPLOYED--JOB 4 MAY"                      format=f1.
      ER36510   LABEL="DE6 WTR EMPLOYED--JOB 4 JUN"                      format=f1.
      ER36511   LABEL="DE6 WTR EMPLOYED--JOB 4 JUL"                      format=f1.
      ER36512   LABEL="DE6 WTR EMPLOYED--JOB 4 AUG"                      format=f1.
      ER36513   LABEL="DE6 WTR EMPLOYED--JOB 4 SEP"                      format=f1.
      ER36514   LABEL="DE6 WTR EMPLOYED--JOB 4 OCT"                      format=f1.
      ER36515   LABEL="DE6 WTR EMPLOYED--JOB 4 NOV"                      format=f1.
      ER36516   LABEL="DE6 WTR EMPLOYED--JOB 4 DEC"                      format=f1.
      ER36517   LABEL="DE20 MAIN OCC FOR JOB 4: 2000 CODE (WF)"          format=f3.
      ER36518   LABEL="DE21 MAIN IND FOR JOB 4: 2000 CODE (WF)"          format=f3.
      ER36519   LABEL="DE22 WORK SELF/OTR?--JOB 4"                       format=f1.
      ER36520   LABEL="DE23 CORP/UNCORP BUS--JOB 4"                      format=f1.
      ER36521   LABEL="DE24 WORK FOR GOVT?--JOB 4"                       format=f1.
      ER36522   LABEL="DE42A WKS WORKED--WF JOB 4"                       format=f4.1
      ER36523   LABEL="ACCURACY OF WKS WORKED--WF JOB 4"                 format=f1.
      ER36524   LABEL="DE43 HOURS/WEEK WORKED--JOB 4"                    format=f3.
      ER36525   LABEL="ACCURACY OF HR/WK WORKED--WF JOB 4"               format=f1.
      ER36526   LABEL="DE44 WTR WORKED OT--JOB 4"                        format=f1.
      ER36527   LABEL="DE45 AMT OF OT WORKED--JOB 4"                     format=f4.
      ER36528   LABEL="DE45 OT TIME UNIT--JOB 4"                         format=f1.
      ER36529   LABEL="ACCURACY OF OT--WF JOB 4"                         format=f1.
      ER36530   LABEL="DE46 AMOUNT EARNED LAST YEAR--JOB 4"              format=f10.2
      ER36531   LABEL="DE46 PER FOR AMT EARNED LAST YR--JOB 4"           format=f1.
      ER36532   LABEL="DE51 WHY JOB ENDED--JOB 4"                        format=f1.
      ER36533   LABEL="NUMBER OF ADDITIONAL JOBS--WF"                    format=f1.
      ER36534   LABEL="DE10 WTR OTRS ILL (WF)"                           format=f1.
      ER36535   LABEL="DE10 DAYS OTHERS SICK"                            format=f3.
      ER36536   LABEL="ACCURACY OF DAYS OTRS SICK (WF)"                  format=f1.
      ER36537   LABEL="DE10 WEEKS OTHERS SICK"                           format=f2.
      ER36538   LABEL="ACCURACY OF WEEKS OTRS SICK (WF)"                 format=f1.
      ER36539   LABEL="DE10 MONTHS OTHERS SICK"                          format=f2.
      ER36540   LABEL="ACCURACY OF MONTHS OTRS SICK (WF)"                format=f1.
      ER36541   LABEL="DE11 WTR SELF ILL (WF)"                           format=f1.
      ER36542   LABEL="DE11 DAYS SELF SICK"                              format=f3.
      ER36543   LABEL="ACCURACY OF DAYS SELF ILL (WF)"                   format=f1.
      ER36544   LABEL="DE11 WEEKS SELF SICK"                             format=f2.
      ER36545   LABEL="ACCURACY OF WEEKS SELF ILL (WF)"                  format=f1.
      ER36546   LABEL="DE11 MONTHS SELF SICK"                            format=f2.
      ER36547   LABEL="ACCURACY OF MONTHS SELF ILL (WF)"                 format=f1.
      ER36548   LABEL="DE12 WTR VACATION (WF)"                           format=f1.
      ER36549   LABEL="DE12 DAYS VACATION"                               format=f3.
      ER36550   LABEL="ACCURACY OF DAYS VACATION (WF)"                   format=f1.
      ER36551   LABEL="DE12 WEEKS VACATION"                              format=f2.
      ER36552   LABEL="ACCURACY OF WEEKS VACATION (WF)"                  format=f1.
      ER36553   LABEL="DE12 MONTHS VACATION"                             format=f2.
      ER36554   LABEL="ACCURACY OF MONTHS VACATION (WF)"                 format=f1.
      ER36555   LABEL="DE13 WTR STRIKE (WF)"                             format=f1.
      ER36556   LABEL="DE13 DAYS STRIKE"                                 format=f3.
      ER36557   LABEL="ACCURACY OF STRIKE DAYS (WF)"                     format=f1.
      ER36558   LABEL="DE13 WEEKS STRIKE"                                format=f2.
      ER36559   LABEL="ACCURACY OF STRIKE WEEKS (WF)"                    format=f1.
      ER36560   LABEL="DE13 MONTHS STRIKE"                               format=f2.
      ER36561   LABEL="ACCURACY OF STRIKE MONTHS (WF)"                   format=f1.
      ER36562   LABEL="DE14 WTR LAID OFF (WF)"                           format=f1.
      ER36563   LABEL="DE14 DAYS LAID OFF"                               format=f3.
      ER36564   LABEL="ACCURACY OF DAYS LAID OFF (WF)"                   format=f1.
      ER36565   LABEL="DE14 WEEKS LAID OFF"                              format=f2.
      ER36566   LABEL="ACCURACY OF WEEKS LAID OFF (WF)"                  format=f1.
      ER36567   LABEL="DE14 MONTHS LAID OFF"                             format=f2.
      ER36568   LABEL="ACCURACY OF MONTHS LAID OFF (WF)"                 format=f1.
      ER36569   LABEL="DE8 WTR UNEMPLOYED(WF)"                           format=f1.
      ER36570   LABEL="DE8 DAYS UNEMPLOYED"                              format=f3.
      ER36571   LABEL="ACCURACY OF DAYS UNEMPLOYED (WF)"                 format=f1.
      ER36572   LABEL="DE8 WEEKS UNEMPLOYED"                             format=f2.
      ER36573   LABEL="ACCURACY OF WEEKS UNEMPLOYED (WF)"                format=f1.
      ER36574   LABEL="DE8 MONTHS UNEMPLOYED"                            format=f2.
      ER36575   LABEL="ACCURACY OF MONTHS UNEMPLOYED (WF)"               format=f1.
      ER36576   LABEL="DE8 WTR UNEMPLOYED JAN"                           format=f1.
      ER36577   LABEL="DE8 WTR UNEMPLOYED FEB"                           format=f1.
      ER36578   LABEL="DE8 WTR UNEMPLOYED MAR"                           format=f1.
      ER36579   LABEL="DE8 WTR UNEMPLOYED APR"                           format=f1.
      ER36580   LABEL="DE8 WTR UNEMPLOYED MAY"                           format=f1.
      ER36581   LABEL="DE8 WTR UNEMPLOYED JUN"                           format=f1.
      ER36582   LABEL="DE8 WTR UNEMPLOYED JUL"                           format=f1.
      ER36583   LABEL="DE8 WTR UNEMPLOYED AUG"                           format=f1.
      ER36584   LABEL="DE8 WTR UNEMPLOYED SEP"                           format=f1.
      ER36585   LABEL="DE8 WTR UNEMPLOYED OCT"                           format=f1.
      ER36586   LABEL="DE8 WTR UNEMPLOYED NOV"                           format=f1.
      ER36587   LABEL="DE8 WTR UNEMPLOYED DEC"                           format=f1.
      ER36588   LABEL="DE7 WTR OUT LAB FRC(W)"                           format=f1.
      ER36589   LABEL="DE7 DAYS OUT OF LAB FORCE"                        format=f3.
      ER36590   LABEL="ACCURACY OF DAYS OUT OF LAB FORCE (WF)"           format=f1.
      ER36591   LABEL="DE7WEEKS OUT LABOR FORCE"                         format=f2.
      ER36592   LABEL="ACCURACY OF WKS OUT OF LAB FORCE (WF)"            format=f1.
      ER36593   LABEL="DE7 MONTHS OUT LABR FORCE"                        format=f2.
      ER36594   LABEL="ACCURACY OF MOS OUT OF LAB FORCE (WF)"            format=f1.
      ER36595   LABEL="DE7 WTR OUT LAB FORC JAN"                         format=f1.
      ER36596   LABEL="DE7 WTR OUT LAB FORC FEB"                         format=f1.
      ER36597   LABEL="DE7 WTR OUT LAB FORC MAR"                         format=f1.
      ER36598   LABEL="DE7 WTR OUT LAB FORC APR"                         format=f1.
      ER36599   LABEL="DE7 WTR OUT LAB FORC MAY"                         format=f1.
      ER36600   LABEL="DE7 WTR OUT LAB FORC JUN"                         format=f1.
      ER36601   LABEL="DE7 WTR OUT LAB FORC JUL"                         format=f1.
      ER36602   LABEL="DE7 WTR OUT LAB FORC AUG"                         format=f1.
      ER36603   LABEL="DE7 WTR OUT LAB FORC SEP"                         format=f1.
      ER36604   LABEL="DE7 WTR OUT LAB FORC OCT"                         format=f1.
      ER36605   LABEL="DE7 WTR OUT LAB FORC NOV"                         format=f1.
      ER36606   LABEL="DE7 WTR OUT LAB FORC DEC"                         format=f1.
      ER36607   LABEL="DE54 TOTAL WEEKS WORKED"                          format=f2.
      ER36608   LABEL="DE56 TOTAL HOURS WORKED"                          format=f3.
      ER36609   LABEL="DE62 WTR EVER WORKED"                             format=f1.
      ER36610   LABEL="DE63 MO LAST WORKED"                              format=f2.
      ER36611   LABEL="DE63 YR LAST WORKED"                              format=f4.
      ER36612   LABEL="DE64 WTR LOOKING FOR JOB"                         format=f1.
      ER36613   LABEL="DE65 WTR PUBLIC EMP AGENCY (WF)"                  format=f1.
      ER36614   LABEL="DE65 WTR PRIVATE EMP AGENCY (WF)"                 format=f1.
      ER36615   LABEL="DE65 WTR CHKD W/CURRENT EMP (WF)"                 format=f1.
      ER36616   LABEL="DE65 WTR CHKD W/OTHER EMP (WF)"                   format=f1.
      ER36617   LABEL="DE65 WTR CHKD W/FRIEND OR REL (WF)"               format=f1.
      ER36618   LABEL="DE65 WTR PLACED OR ANSWERED ADS (WF)"             format=f1.
      ER36619   LABEL="DE65 WTR OTHER ACTIVITY (WF)"                     format=f1.
      ER36620   LABEL="DE65 WTR DONE NOTHING (WF)"                       format=f1.
      ER36621   LABEL="DE67 YRS LOOK WRK (W-U)"                          format=f2.
      ER36622   LABEL="DE67 MOS LOOK WRK (W-U)"                          format=f2.
      ER36623   LABEL="DE67 WKS LOOK WRK (W-U)"                          format=f2.
      ER36624   LABEL="F1 CKPT:TYPE HD+WF"                               format=f1.
      ER36625   LABEL="F2 HOUSEWORK HRS-WIFE"                            format=f3.
      ER36626   LABEL="ACCURACY OF WF HOUSEWORK HRS"                     format=f1.
      ER36627   LABEL="F3 HOUSEWORK HOURS-HEAD"                          format=f3.
      ER36628   LABEL="ACCURACY OF HD HOUSEWORK HRS"                     format=f1.
      ER36629   LABEL="F5 FAM TOGETHR MAIN MEAL"                         format=f1.
      ER36630   LABEL="F6 CKPT: WTR CHILD 5-18 IN FU LAST YEAR"          format=f1.
      ER36631   LABEL="F6A WTR CH REC FREE/LOW LUNCH LAST YR"            format=f1.
      ER36632   LABEL="F6B WTR CH REC FREE/LOW BKFST LAST YR"            format=f1.
      ER36633   LABEL="F6D COST CHILD CARE LAST YEAR"                    format=f6.
      ER36634   LABEL="F6D CHILD CARE COST PER"                          format=f1.
      ER36635   LABEL="F6D2 WTR PAID FOR CHILD CARE JAN LAST YR"         format=f1.
      ER36636   LABEL="F6D2 WTR PAID FOR CHILD CARE FEB LAST YR"         format=f1.
      ER36637   LABEL="F6D2 WTR PAID FOR CHILD CARE MAR LAST YR"         format=f1.
      ER36638   LABEL="F6D2 WTR PAID FOR CHILD CARE APR LAST YR"         format=f1.
      ER36639   LABEL="F6D2 WTR PAID FOR CHILD CARE MAY LAST YR"         format=f1.
      ER36640   LABEL="F6D2 WTR PAID FOR CHILD CARE JUN LAST YR"         format=f1.
      ER36641   LABEL="F6D2 WTR PAID FOR CHILD CARE JUL LAST YR"         format=f1.
      ER36642   LABEL="F6D2 WTR PAID FOR CHILD CARE AUG LAST YR"         format=f1.
      ER36643   LABEL="F6D2 WTR PAID FOR CHILD CARE SEP LAST YR"         format=f1.
      ER36644   LABEL="F6D2 WTR PAID FOR CHILD CARE OCT LAST YR"         format=f1.
      ER36645   LABEL="F6D2 WTR PAID FOR CHILD CARE NOV LAST YR"         format=f1.
      ER36646   LABEL="F6D2 WTR PAID FOR CHILD CARE DEC LAST YR"         format=f1.
      ER36647   LABEL="F6E WTR CHILD IN DAY CARE CNTR LAST YR"           format=f1.
      ER36648   LABEL="F6F WTR MEALS/SNACKS PROVIDED TO CHILD"           format=f1.
      ER36649   LABEL="F6G WTR DAY CARE IN CHILD/ADULT FOOD PGM"         format=f1.
      ER36650   LABEL="F6H FU FEMALE 15-45/CHILD <5 LAST YR"             format=f1.
      ER36651   LABEL="F6I WTR RECD FOOD THROUGH WIC PROGRAM"            format=f1.
      ER36652   LABEL="F7 WTR ADULT IN ADULT DAY CARE PREV YR"           format=f1.
      ER36653   LABEL="F7A AMT PAID FOR ADULT DAY CARE"                  format=f6.
      ER36654   LABEL="F7B WTR FU MEMBER 60+ LAST YR"                    format=f1.
      ER36655   LABEL="F7C WTR RECD FREE/REDUCD MEALS LAST YR"           format=f1.
      ER36656   LABEL="F8 WTR USED FOOD STAMPS 2 YRS AGO"                format=f1.
      ER36657   LABEL="F9 VALUE OF FOOD STAMPS 2 YRS AGO"                format=f6.
      ER36658   LABEL="F9 TIME UNIT-VALUE FOOD STAMPS 2 YRS AGO"         format=f1.
      ER36659   LABEL="ACCURACY OF FOOD STAMPS 2 YEARS AGO"              format=f1.
      ER36660   LABEL="F10 WTR RECVD FOOD STAMPS JAN 2 YRS AGO"          format=f1.
      ER36661   LABEL="F10 WTR RECVD FOOD STAMPS FEB 2 YRS AGO"          format=f1.
      ER36662   LABEL="F10 WTR RECVD FOOD STAMPS MAR 2 YRS AGO"          format=f1.
      ER36663   LABEL="F10 WTR RECVD FOOD STAMPS APR 2 YRS AGO"          format=f1.
      ER36664   LABEL="F10 WTR RECVD FOOD STAMPS MAY 2 YRS AGO"          format=f1.
      ER36665   LABEL="F10 WTR RECVD FOOD STAMPS JUN 2 YRS AGO"          format=f1.
      ER36666   LABEL="F10 WTR RECVD FOOD STAMPS JUL 2 YRS AGO"          format=f1.
      ER36667   LABEL="F10 WTR RECVD FOOD STAMPS AUG 2 YRS AGO"          format=f1.
      ER36668   LABEL="F10 WTR RECVD FOOD STAMPS SEP 2 YRS AGO"          format=f1.
      ER36669   LABEL="F10 WTR RECVD FOOD STAMPS OCT 2 YRS AGO"          format=f1.
      ER36670   LABEL="F10 WTR RECVD FOOD STAMPS NOV 2 YRS AGO"          format=f1.
      ER36671   LABEL="F10 WTR RECVD FOOD STAMPS DEC 2 YRS AGO"          format=f1.
      ER36672   LABEL="F11 WTR RECEIVED FOOD STAMPS LAST YEAR"           format=f1.
      ER36673   LABEL="F12 VALUE OF FOOD STAMPS LAST YEAR"               format=f6.
      ER36674   LABEL="F12 TIME UNIT-VALUE FOOD STAMPS LAST YR"          format=f1.
      ER36675   LABEL="ACCURACY OF FOOD STAMPS LAST YEAR"                format=f1.
      ER36676   LABEL="F13 WTR RECVD FOOD STAMPS JAN LAST YEAR"          format=f1.
      ER36677   LABEL="F13 WTR RECVD FOOD STAMPS FEB LAST YEAR"          format=f1.
      ER36678   LABEL="F13 WTR RECVD FOOD STAMPS MAR LAST YEAR"          format=f1.
      ER36679   LABEL="F13 WTR RECVD FOOD STAMPS APR LAST YEAR"          format=f1.
      ER36680   LABEL="F13 WTR RECVD FOOD STAMPS MAY LAST YEAR"          format=f1.
      ER36681   LABEL="F13 WTR RECVD FOOD STAMPS JUN LAST YEAR"          format=f1.
      ER36682   LABEL="F13 WTR RECVD FOOD STAMPS JUL LAST YEAR"          format=f1.
      ER36683   LABEL="F13 WTR RECVD FOOD STAMPS AUG LAST YEAR"          format=f1.
      ER36684   LABEL="F13 WTR RECVD FOOD STAMPS SEP LAST YEAR"          format=f1.
      ER36685   LABEL="F13 WTR RECVD FOOD STAMPS OCT LAST YEAR"          format=f1.
      ER36686   LABEL="F13 WTR RECVD FOOD STAMPS NOV LAST YEAR"          format=f1.
      ER36687   LABEL="F13 WTR RECVD FOOD STAMPS DEC LAST YEAR"          format=f1.
      ER36688   LABEL="F14 WTR RECEIVED FOOD STAMPS THIS YEAR"           format=f1.
      ER36689   LABEL="F14A WTR RECVD FOOD STAMPS JAN THIS YEAR"         format=f1.
      ER36690   LABEL="F14A WTR RECVD FOOD STAMPS FEB THIS YEAR"         format=f1.
      ER36691   LABEL="F14A WTR RECVD FOOD STAMPS MAR THIS YEAR"         format=f1.
      ER36692   LABEL="F14A WTR RECVD FOOD STAMPS APR THIS YEAR"         format=f1.
      ER36693   LABEL="F14A WTR RECVD FOOD STAMPS MAY THIS YEAR"         format=f1.
      ER36694   LABEL="F14A WTR RECVD FOOD STAMPS JUN THIS YEAR"         format=f1.
      ER36695   LABEL="F14A WTR RECVD FOOD STAMPS JUL THIS YEAR"         format=f1.
      ER36696   LABEL="F14A WTR RECVD FOOD STAMPS AUG THIS YEAR"         format=f1.
      ER36697   LABEL="F14A WTR RECVD FOOD STAMPS SEP THIS YEAR"         format=f1.
      ER36698   LABEL="F14A WTR RECVD FOOD STAMPS OCT THIS YEAR"         format=f1.
      ER36699   LABEL="F14A WTR RECVD FOOD STAMPS NOV THIS YEAR"         format=f1.
      ER36700   LABEL="F14A WTR RECVD FOOD STAMPS DEC THIS YEAR"         format=f1.
      ER36701   LABEL="F15 # FU MEMBERS RECEIVED FOOD STAMPS"            format=f1.
      ER36702   LABEL="F16 VALUE OF FOOD STAMPS RECD THIS YR"            format=f6.
      ER36703   LABEL="F16 VALUE OF FOOD STAMPS PER"                     format=f1.
      ER36704   LABEL="ACCURACY OF FOOD STAMPS THIS YEAR"                format=f1.
      ER36705   LABEL="F17 WTR BUY FOOD TO USE AT HOME"                  format=f1.
      ER36706   LABEL="F18 REPORTED COST OF FOOD AT HOME"                format=f8.2
      ER36707   LABEL="F18 COST OF FOOD AT HOME PER"                     format=f1.
      ER36708   LABEL="ACCURACY OF FOOD AT HOME-RECD FD STAMPS"          format=f1.
      ER36709   LABEL="F19 WTR FOOD DELIVERED TO HOME"                   format=f1.
      ER36710   LABEL="F20 COST OF DELIVERED FOOD"                       format=f8.2
      ER36711   LABEL="F20 COST OF DELIVERED FOOD PER"                   format=f1.
      ER36712   LABEL="ACCURACY OF DELIVERD FOOD-RECD FD STAMPS"         format=f1.
      ER36713   LABEL="F21 COST OF FOOD EATEN OUT"                       format=f8.2
      ER36714   LABEL="F21 COST OF FOOD EATEN OUT PER"                   format=f1.
      ER36715   LABEL="ACCURACY OF FOOD EATN OUT-RECD FD STAMPS"         format=f1.
      ER36716   LABEL="F22 REPORTED COST OF FOOD AT HOME"                format=f8.2
      ER36717   LABEL="F22 COST OF FOOD AT HOME PER"                     format=f1.
      ER36718   LABEL="ACCURACY OF FOOD AT HOME-NO FD STAMPS"            format=f1.
      ER36719   LABEL="F23 WTR FOOD DELIVERED TO HOME"                   format=f1.
      ER36720   LABEL="F24 COST OF DELIVERED FOOD"                       format=f8.2
      ER36721   LABEL="F24 COST OF DELIVERED FOOD PER"                   format=f1.
      ER36722   LABEL="ACCURACY OF DELIVERED FOOD-NO FD STAMPS"          format=f1.
      ER36723   LABEL="F25 COST OF FOOD EATEN OUT"                       format=f8.2
      ER36724   LABEL="F25 COST OF FOOD EATEN OUT PER"                   format=f1.
      ER36725   LABEL="ACCURACY OF FOOD EATEN OUT-NO FD STAMPS"          format=f1.
      ER36726   LABEL="F47 WTR HAVE VEHICLE"                             format=f1.
      ER36727   LABEL="F48 NUMBER OF VEHICLES"                           format=f2.
      ER36728   LABEL="F49 MANUFACTURER CODE #1"                         format=f2.
      ER36729   LABEL="F49 VEHICLE MAKE CODE #1"                         format=f2.
      ER36730   LABEL="F49 VEHICLE MODEL YEAR #1"                        format=f4.
      ER36731   LABEL="F49 VEHICLE TYPE CODE #1"                         format=f1.
      ER36732   LABEL="F51 VEHICLE SIZE #1"                              format=f1.
      ER36733   LABEL="F52 CYPSN OF USUAL DRIVER #1"                     format=f2.
      ER36734   LABEL="F53 HOW ACQUIRED #1"                              format=f1.
      ER36735   LABEL="F54 WTR NEW OR USED #1"                           format=f1.
      ER36736   LABEL="F55 YR ACQUIRED #1"                               format=f4.
      ER36737   LABEL="F56 MO ACQUIRED #1"                               format=f2.
      ER36738   LABEL="F57 WTR USED FOR BUSINESS #1"                     format=f1.
      ER36739   LABEL="F58 WTR USED MOSTLY FOR BUSINESS #1"              format=f1.
      ER36740   LABEL="F60 WTR OWN/LEASE >3 YR OLD VEHICLE #1"           format=f1.
      ER36741   LABEL="F61 TOTAL PRICE #1"                               format=f6.
      ER36742   LABEL="F62 WTR TRADE-IN #1"                              format=f1.
      ER36743   LABEL="F63 TRADE-IN AMOUNT #1"                           format=f6.
      ER36744   LABEL="F64 CASH DOWNPMT AMT #1"                          format=f6.
      ER36745   LABEL="F65 WTR GOT LOAN #1"                              format=f1.
      ER36746   LABEL="F66 LOAN AMOUNT #1"                               format=f6.
      ER36747   LABEL="F67 LOAN PAYMENT AMT #1"                          format=f6.
      ER36748   LABEL="F67 LOAN PMT AMT PER #1"                          format=f1.
      ER36749   LABEL="F69 LOAN TOTAL # PMTS #1"                         format=f3.
      ER36750   LABEL="F70 LOAN # PMTS MADE #1"                          format=f3.
      ER36751   LABEL="F71 LEASE INITIAL OUTLAY #1"                      format=f6.
      ER36752   LABEL="F72 LEASE PMT AMOUNT #1"                          format=f6.
      ER36753   LABEL="F72 LEASE AMOUNT PER #1"                          format=f1.
      ER36754   LABEL="F73 LEASE TOTAL # PMTS #1"                        format=f3.
      ER36755   LABEL="F74 LEASE # PMTS MADE #1"                         format=f3.
      ER36756   LABEL="F49 MANUFACTURER CODE #2"                         format=f2.
      ER36757   LABEL="F49 VEHICLE MAKE CODE #2"                         format=f2.
      ER36758   LABEL="F49 VEHICLE MODEL YEAR #2"                        format=f4.
      ER36759   LABEL="F49 VEHICLE TYPE CODE #2"                         format=f1.
      ER36760   LABEL="F51 VEHICLE SIZE #2"                              format=f1.
      ER36761   LABEL="F52 CYPSN OF USUAL DRIVER #2"                     format=f2.
      ER36762   LABEL="F53 HOW ACQUIRED #2"                              format=f1.
      ER36763   LABEL="F54 WTR NEW OR USED #2"                           format=f1.
      ER36764   LABEL="F55 YR ACQUIRED #2"                               format=f4.
      ER36765   LABEL="F55 MO ACQUIRED #2"                               format=f2.
      ER36766   LABEL="F57 WTR USED FOR BUSINESS #2"                     format=f1.
      ER36767   LABEL="F58 WTR MOSTLY FOR BUSINESS #2"                   format=f1.
      ER36768   LABEL="F60 CKPT: WTR OWN >3 YR OLD VEHICLE #2"           format=f1.
      ER36769   LABEL="F61 TOTAL PRICE #2"                               format=f6.
      ER36770   LABEL="F62 WTR TRADE-IN #2"                              format=f1.
      ER36771   LABEL="F63 TRADE-IN AMOUNT #2"                           format=f6.
      ER36772   LABEL="F64 CASH DOWNPMT AMT #2"                          format=f6.
      ER36773   LABEL="F65 WTR GOT LOAN #2"                              format=f1.
      ER36774   LABEL="F66 LOAN AMOUNT #2"                               format=f6.
      ER36775   LABEL="F67 LOAN PAYMENT AMT #2"                          format=f6.
      ER36776   LABEL="F67 LOAN PMT AMT PER #2"                          format=f1.
      ER36777   LABEL="F69 LOAN TOT # PMTS #2"                           format=f3.
      ER36778   LABEL="F70 LOAN # PMTS MADE #2"                          format=f3.
      ER36779   LABEL="F71 LEASE INITIAL OUTLAY #2"                      format=f6.
      ER36780   LABEL="F72 LEASE PMT AMOUNT #2"                          format=f6.
      ER36781   LABEL="F72 LEASE AMOUNT PER #2"                          format=f1.
      ER36782   LABEL="F73 LEASE TOTAL # PMTS #2"                        format=f3.
      ER36783   LABEL="F74 LEASE # PMTS MADE #2"                         format=f3.
      ER36784   LABEL="F49 MANUFACTURER CODE #3"                         format=f2.
      ER36785   LABEL="F49 VEHICLE MAKE CODE #3"                         format=f2.
      ER36786   LABEL="F49 VEHICLE MODEL YEAR #3"                        format=f4.
      ER36787   LABEL="F49 VEHICLE TYPE CODE #3"                         format=f1.
      ER36788   LABEL="F51 VEHICLE SIZE #3"                              format=f1.
      ER36789   LABEL="F52 CYPSN OF USUAL DRIVER #3"                     format=f2.
      ER36790   LABEL="F53 HOW ACQUIRED #3"                              format=f1.
      ER36791   LABEL="F54 WTR NEW OR USED #3"                           format=f1.
      ER36792   LABEL="F55 YR ACQUIRED #3"                               format=f4.
      ER36793   LABEL="F56 MO ACQUIRED #3"                               format=f2.
      ER36794   LABEL="F57 WTR USED FOR BUSINESS #3"                     format=f1.
      ER36795   LABEL="F58 WTR MOSTLY FOR BUSINESS #3"                   format=f1.
      ER36796   LABEL="F60 CKPT: WTR OWN >3 YR OLD VEHICLE #3"           format=f1.
      ER36797   LABEL="F61 TOTAL PRICE #3"                               format=f6.
      ER36798   LABEL="F62 WTR TRADE-IN #3"                              format=f1.
      ER36799   LABEL="F63 TRADE-IN AMOUNT #3"                           format=f6.
      ER36800   LABEL="F64 CASH DOWNPMT AMT #3"                          format=f6.
      ER36801   LABEL="F65 WTR GOT LOAN #3"                              format=f1.
      ER36802   LABEL="F66 LOAN AMOUNT #3"                               format=f6.
      ER36803   LABEL="F67 LOAN PAYMENT AMT #3"                          format=f6.
      ER36804   LABEL="F67 LOAN PMT AMT PER #3"                          format=f1.
      ER36805   LABEL="F69 LOAN TOTAL # PMTS #3"                         format=f3.
      ER36806   LABEL="F70 LOAN # PMTS MADE #3"                          format=f3.
      ER36807   LABEL="F71 LEASE INITIAL OUTLAY #3"                      format=f6.
      ER36808   LABEL="F72 LEASE PMT AMOUNT #3"                          format=f6.
      ER36809   LABEL="F72 LEASE AMOUNT PER #3"                          format=f1.
      ER36810   LABEL="F73 LEASE TOTAL # PMTS #3"                        format=f3.
      ER36811   LABEL="F74 LEASE # PMTS MADE #3"                         format=f3.
      ER36812   LABEL="F77 CAR INSURANCE EXPENSE"                        format=f6.
      ER36813   LABEL="F77 CAR INSURANCE PER"                            format=f1.
      ER36814   LABEL="F78CKPT WTR OTR VEHICLES"                         format=f1.
      ER36815   LABEL="F79 ADDL CAR/LEASE PMTS"                          format=f6.
      ER36816   LABEL="F80A CAR REPAIR EXPENSES"                         format=f5.
      ER36817   LABEL="F80B GASOLINE EXPENSES"                           format=f5.
      ER36818   LABEL="F80C PARKING EXPENSES"                            format=f5.
      ER36819   LABEL="F81A BUS/TRAIN FARES"                             format=f5.
      ER36820   LABEL="F81B CAB FARE EXPENSES"                           format=f5.
      ER36821   LABEL="F81C OTR TRANSP EXPENSES"                         format=f5.
      ER36822   LABEL="F82 WTR SCHOOL EXPENSES"                          format=f1.
      ER36823   LABEL="F83 TOTAL SCHOOL EXPENSES"                        format=f6.
      ER36824   LABEL="F84 WTR OTR SCHOOL EXPENSES"                      format=f1.
      ER36825   LABEL="F86 TOTAL OTR SCHOOL EXPENSES"                    format=f6.
      ER36826   LABEL="F87 COST OF HOME REPAIRS LAST YEAR"               format=f6.
      ER36827   LABEL="F87 TIME UNIT FOR HOME REPAIRS"                   format=f1.
      ER36828   LABEL="F87A WTR $400 OR MORE"                            format=f1.
      ER36829   LABEL="F87B WTR $1000 OR MORE"                           format=f1.
      ER36830   LABEL="F87C WTR $100 OR MORE"                            format=f1.
      ER36831   LABEL="F88 COST OF HHOLD FURNISHINGS LAST YEAR"          format=f6.
      ER36832   LABEL="F88 TIME UNIT FOR HHOLD FURNISHINGS"              format=f1.
      ER36833   LABEL="F88A WTR $500 OR MORE"                            format=f1.
      ER36834   LABEL="F88B WTR $1500 OR MORE"                           format=f1.
      ER36835   LABEL="F88C WTR $100 OR MORE"                            format=f1.
      ER36836   LABEL="F89 COST OF CLOTHING LAST YEAR"                   format=f6.
      ER36837   LABEL="F89 TIME UNIT FOR CLOTHING"                       format=f1.
      ER36838   LABEL="F89A WTR $700 OR MORE"                            format=f1.
      ER36839   LABEL="F89B WTR$1500 OR MORE"                            format=f1.
      ER36840   LABEL="F89C WTR $200 OR MORE"                            format=f1.
      ER36841   LABEL="F90 COST OF TRIPS, VACATIONS LAST YEAR"           format=f6.
      ER36842   LABEL="F90 TIME UNIT FOR TRIPS, VACATIONS"               format=f1.
      ER36843   LABEL="F90A WTR $500 OR MORE"                            format=f1.
      ER36844   LABEL="F90B WTR $1500 OR MORE"                           format=f1.
      ER36845   LABEL="F90C WTR $200 OR MORE"                            format=f1.
      ER36846   LABEL="F91 COST OF OTR RECREATION LAST YEAR"             format=f6.
      ER36847   LABEL="F91 TIME UNIT FOR OTR RECREATON"                  format=f1.
      ER36848   LABEL="F91A WTR $500 OR MORE"                            format=f1.
      ER36849   LABEL="F91B WTR $1500 OR MORE"                           format=f1.
      ER36850   LABEL="F91C WTR $200 OR MORE"                            format=f1.
      ER36851   LABEL="G1A WHETHER HEAD FARMER"                          format=f1.
      ER36852   LABEL="G2 TOTAL FARM RECEIPTS"                           format=f7.
      ER36853   LABEL="G3 PYR FARM EXPENSES"                             format=f7.
      ER36854   LABEL="G4 PYR NET FARM INCOME"                           format=f7.
      ER36855   LABEL="ACCURACY OF FARM INCOME"                          format=f1.
      ER36856   LABEL="G5 WHETHER BUSINESS"                              format=f1.
      ER36857   LABEL="G7A 2-DIGIT INDUSTRY-BUS 1"                       format=f2.
      ER36858   LABEL="G8 HEAD OWN BUSINESS 1?"                          format=f1.
      ER36859   LABEL="G8 WIFE OWN BUSINESS 1?"                          format=f1.
      ER36860   LABEL="G8OTR RELATIVE OWN BUS1?"                         format=f1.
      ER36861   LABEL="G8OTHER PERSON OWN BUS1?"                         format=f1.
      ER36862   LABEL="HEAD WORK IN BUSINESS 1"                          format=f2.
      ER36863   LABEL="HEAD REPORT HRS BUSNS 1"                          format=f2.
      ER36864   LABEL="WIFE WORK IN BUSINESS 1"                          format=f2.
      ER36865   LABEL="WIFE REPORT HRS BUSNS 1"                          format=f2.
      ER36866   LABEL="G10 CORP/UNINCORP BUS1"                           format=f1.
      ER36867   LABEL="G11 GROSS RECEIPTS BUS1"                          format=f7.
      ER36868   LABEL="G11A EXPENSES BUS 1"                              format=f7.
      ER36869   LABEL="G11B PROFIT/LOSS BUS 1"                           format=f7.
      ER36870   LABEL="ACCURACY OF BUSINESS1 PROFIT/LOSS"                format=f1.
      ER36871   LABEL="G7A 2-DIGIT INDUSTRY-BUS 2"                       format=f2.
      ER36872   LABEL="G8 HEAD OWN BUSINESS 2?"                          format=f1.
      ER36873   LABEL="G8 WIFE OWN BUSINESS 2?"                          format=f1.
      ER36874   LABEL="G8OTR RELATIVE OWN BUS2?"                         format=f1.
      ER36875   LABEL="G8OTHER PERSON OWN BUS2?"                         format=f1.
      ER36876   LABEL="HEAD WORK IN BUSINESS 2"                          format=f2.
      ER36877   LABEL="HEAD REPORT HRS BUSNS 2"                          format=f2.
      ER36878   LABEL="WIFE WORK IN BUSINESS 2"                          format=f2.
      ER36879   LABEL="WIFE REPORT HRS BUSNS 2"                          format=f2.
      ER36880   LABEL="G10 CORP/UNINCORP BUS2"                           format=f1.
      ER36881   LABEL="G11 GROSS RECEIPTS BUS 2"                         format=f7.
      ER36882   LABEL="G11A EXPENSES BUS 2"                              format=f7.
      ER36883   LABEL="G11B PROFIT/LOSS BUS 2"                           format=f7.
      ER36884   LABEL="ACCURACY OF BUSINESS2 PROFIT/LOSS"                format=f1.
      ER36885   LABEL="G7A 2-DIGIT INDUSTRY-BUS 3"                       format=f2.
      ER36886   LABEL="G8 HEAD OWN BUSINESS 3?"                          format=f1.
      ER36887   LABEL="G8 WIFE OWN BUSINESS 3?"                          format=f1.
      ER36888   LABEL="G8OTR RELATIVE OWN BUS3?"                         format=f1.
      ER36889   LABEL="G8OTHER PERSON OWN BUS3?"                         format=f1.
      ER36890   LABEL="HEAD WORK IN BUSINESS 3"                          format=f2.
      ER36891   LABEL="HEAD REPORT HRS BUSNS 3"                          format=f2.
      ER36892   LABEL="WIFE WORK IN BUSINESS 3"                          format=f2.
      ER36893   LABEL="WIFE REPORT HRS BUSNS 3"                          format=f2.
      ER36894   LABEL="G10 CORP/UNINCORP BUS3"                           format=f1.
      ER36895   LABEL="G11 GROSS RECEIPTS BUS 3"                         format=f7.
      ER36896   LABEL="G11A EXPENSES BUS 3"                              format=f7.
      ER36897   LABEL="G11B PROFIT/LOSS BUS 3"                           format=f7.
      ER36898   LABEL="ACCURACY OF BUSINESS3 PROFIT/LOSS"                format=f1.
      ER36899   LABEL="G7A 2-DIGIT INDUSTRY-BUS 4"                       format=f2.
      ER36900   LABEL="G8 HEAD OWN BUSINESS 4?"                          format=f1.
      ER36901   LABEL="G8 WIFE OWN BUSINESS 4?"                          format=f1.
      ER36902   LABEL="G8OTR RELATIVE OWN BUS4?"                         format=f1.
      ER36903   LABEL="G8OTHER PERSON OWN BUS4?"                         format=f1.
      ER36904   LABEL="HEAD WORK IN BUSINESS 4"                          format=f2.
      ER36905   LABEL="HEAD REPORT HRS BUSNS 4"                          format=f2.
      ER36906   LABEL="WIFE WORK IN BUSINESS 4"                          format=f2.
      ER36907   LABEL="WIFE REPORT HRS BUSNS 4"                          format=f2.
      ER36908   LABEL="G10 CORP/UNINCORP BUS4"                           format=f1.
      ER36909   LABEL="G11 GROSS RECEIPTS BUS 4"                         format=f7.
      ER36910   LABEL="G11A EXPENSES BUS 4"                              format=f7.
      ER36911   LABEL="G11B PROFIT/LOSS BUS 4"                           format=f7.
      ER36912   LABEL="ACCURACY OF BUSINESS4 PROFIT/LOSS"                format=f1.
      ER36913   LABEL="G7A 2-DIGIT INDUSTRY-BUS 5"                       format=f2.
      ER36914   LABEL="G8 HEAD OWN BUSINESS 5?"                          format=f1.
      ER36915   LABEL="G8 WIFE OWN BUSINESS 5?"                          format=f1.
      ER36916   LABEL="G8OTR RELATIVE OWN BUS5?"                         format=f1.
      ER36917   LABEL="G8OTHER PERSON OWN BUS5?"                         format=f1.
      ER36918   LABEL="HEAD WORK IN BUSINESS 5"                          format=f2.
      ER36919   LABEL="HEAD REPORT HRS BUSNS 5"                          format=f2.
      ER36920   LABEL="WIFE WORK IN BUSINESS 5"                          format=f2.
      ER36921   LABEL="WIFE REPORT HRS BUSNS 5"                          format=f2.
      ER36922   LABEL="G10 CORP/UNINCORP BUS5"                           format=f1.
      ER36923   LABEL="G11 GROSS RECEIPTS BUS 5"                         format=f7.
      ER36924   LABEL="G11A EXPENSES BUS 5"                              format=f7.
      ER36925   LABEL="G11B PROFIT/LOSS BUS 5"                           format=f7.
      ER36926   LABEL="ACCURACY OF BUSINESS5 PROFIT/LOSS"                format=f1.
      ER36927   LABEL="G12 HEAD HAVE WAGES"                              format=f1.
      ER36928   LABEL="G13 WAGES/SALARY OF HEAD"                         format=f7.
      ER36929   LABEL="ACCURACY OF WAGES/SALARY-HEAD"                    format=f1.
      ER36930   LABEL="G14/16 HD BONUS/OT/COMM"                          format=f1.
      ER36931   LABEL="HEAD HAVE BONUS"                                  format=f1.
      ER36932   LABEL="AMT HEAD BONUS"                                   format=f6.
      ER36933   LABEL="ACCURACY OF BONUS-HEAD"                           format=f1.
      ER36934   LABEL="HEAD HAVE OVERTIME"                               format=f1.
      ER36935   LABEL="AMT HEAD OVERTIME"                                format=f6.
      ER36936   LABEL="ACCURACY OF OVERTIME-HEAD"                        format=f1.
      ER36937   LABEL="HEAD HAVE TIPS"                                   format=f1.
      ER36938   LABEL="AMT HEAD TIPS"                                    format=f6.
      ER36939   LABEL="ACCURACY OF TIPS-HEAD"                            format=f1.
      ER36940   LABEL="HEAD HAVE COMMISSION"                             format=f1.
      ER36941   LABEL="AMT HEAD COMMISSION"                              format=f6.
      ER36942   LABEL="ACCURACY OF COMMISSION-HEAD"                      format=f1.
      ER36943   LABEL="WTR OTHER LABOR Y-HEAD"                           format=f1.
      ER36944   LABEL="AMT OTHER LABOR Y-HEAD"                           format=f6.
      ER36945   LABEL="ACCURACY OF OTHER LABOR Y-HEAD"                   format=f1.
      ER36946   LABEL="WTR WORK HRS FOR WAGES ETC"                       format=f1.
      ER36947   LABEL="G18A WTR HEAD PROF PRACT"                         format=f1.
      ER36948   LABEL="AMT PROF PRACTICE OF HD"                          format=f7.
      ER36949   LABEL="AMT PROF PRACTICE PER"                            format=f1.
      ER36950   LABEL="ACCURACY OF PROF PRACTICE-HEAD"                   format=f1.
      ER36951   LABEL="PROF/TRADE INCOME H JAN"                          format=f1.
      ER36952   LABEL="PROF/TRADE INCOME H FEB"                          format=f1.
      ER36953   LABEL="PROF/TRADE INCOME H MAR"                          format=f1.
      ER36954   LABEL="PROF/TRADE INCOME H APR"                          format=f1.
      ER36955   LABEL="PROF/TRADE INCOME H MAY"                          format=f1.
      ER36956   LABEL="PROF/TRADE INCOME H JUN"                          format=f1.
      ER36957   LABEL="PROF/TRADE INCOME H JUL"                          format=f1.
      ER36958   LABEL="PROF/TRADE INCOME H AUG"                          format=f1.
      ER36959   LABEL="PROF/TRADE INCOME H SEP"                          format=f1.
      ER36960   LABEL="PROF/TRADE INCOME H OCT"                          format=f1.
      ER36961   LABEL="PROF/TRADE INCOME H NOV"                          format=f1.
      ER36962   LABEL="PROF/TRADE INCOME H DEC"                          format=f1.
      ER36963   LABEL="G21A WTR WORK HRS FOR PROF PRAC"                  format=f1.
      ER36964   LABEL="G18B WTR HEAD MKT GDNING"                         format=f1.
      ER36965   LABEL="AMT MKT GARDENING OF HD"                          format=f7.
      ER36966   LABEL="AMT MKT GARDENING PER"                            format=f1.
      ER36967   LABEL="ACCURACY OF MKT GARDENING-HEAD"                   format=f1.
      ER36968   LABEL="GARDEN/FARM INCOME H JAN"                         format=f1.
      ER36969   LABEL="GARDEN/FARM INCOME H FEB"                         format=f1.
      ER36970   LABEL="GARDEN/FARM INCOME H MAR"                         format=f1.
      ER36971   LABEL="GARDEN/FARM INCOME H APR"                         format=f1.
      ER36972   LABEL="GARDEN/FARM INCOME H MAY"                         format=f1.
      ER36973   LABEL="GARDEN/FARM INCOME H JUN"                         format=f1.
      ER36974   LABEL="GARDEN/FARM INCOME H JUL"                         format=f1.
      ER36975   LABEL="GARDEN/FARM INCOME H AUG"                         format=f1.
      ER36976   LABEL="GARDEN/FARM INCOME H SEP"                         format=f1.
      ER36977   LABEL="GARDEN/FARM INCOME H OCT"                         format=f1.
      ER36978   LABEL="GARDEN/FARM INCOME H NOV"                         format=f1.
      ER36979   LABEL="GARDEN/FARM INCOME H DEC"                         format=f1.
      ER36980   LABEL="G21B WTR WORK HRS FOR MKT GRDNG"                  format=f1.
      ER36981   LABEL="G18C WTR HEAD ROOMERS"                            format=f1.
      ER36982   LABEL="AMT ROOMERS/BOARDERS HD"                          format=f7.
      ER36983   LABEL="AMT ROOMERS/BOARDERS PER"                         format=f1.
      ER36984   LABEL="ACCURACY OF ROOMERS/BOARDERS-HEAD"                format=f1.
      ER36985   LABEL="ROOM/BORD INCOME H JAN"                           format=f1.
      ER36986   LABEL="ROOM/BORD INCOME H FEB"                           format=f1.
      ER36987   LABEL="ROOM/BORD INCOME H MAR"                           format=f1.
      ER36988   LABEL="ROOM/BORD INCOME H APR"                           format=f1.
      ER36989   LABEL="ROOM/BORD INCOME H MAY"                           format=f1.
      ER36990   LABEL="ROOM/BORD INCOME H JUN"                           format=f1.
      ER36991   LABEL="ROOM/BORD INCOME H JUL"                           format=f1.
      ER36992   LABEL="ROOM/BORD INCOME H AUG"                           format=f1.
      ER36993   LABEL="ROOM/BORD INCOME H SEP"                           format=f1.
      ER36994   LABEL="ROOM/BORD INCOME H OCT"                           format=f1.
      ER36995   LABEL="ROOM/BORD INCOME H NOV"                           format=f1.
      ER36996   LABEL="ROOM/BORD INCOME H DEC"                           format=f1.
      ER36997   LABEL="G21C WTR WORK HRS FOR ROOMERS"                    format=f1.
      ER36998   LABEL="G23 WTR INCL EARNINGS XTRA JOB"                   format=f1.
      ER36999   LABEL="AMT FROM XTRA JOBS"                               format=f7.
      ER37000   LABEL="ACCURACY OF XTRA JOB INCOME-HEAD"                 format=f1.
      ER37001   LABEL="G25A WHETHER RENT HEAD"                           format=f1.
      ER37002   LABEL="RENT OF HEAD"                                     format=f6.
      ER37003   LABEL="RENT OF HEAD PER"                                 format=f1.
      ER37004   LABEL="ACCURACY OF RENT-HEAD"                            format=f1.
      ER37005   LABEL="G26A2 WTR RENT JOINT WITH WIFE"                   format=f1.
      ER37006   LABEL="RENT INCOME HEAD JAN"                             format=f1.
      ER37007   LABEL="RENT INCOME HEAD FEB"                             format=f1.
      ER37008   LABEL="RENT INCOME HEAD MAR"                             format=f1.
      ER37009   LABEL="RENT INCOME HEAD APR"                             format=f1.
      ER37010   LABEL="RENT INCOME HEAD MAY"                             format=f1.
      ER37011   LABEL="RENT INCOME HEAD JUN"                             format=f1.
      ER37012   LABEL="RENT INCOME HEAD JUL"                             format=f1.
      ER37013   LABEL="RENT INCOME HEAD AUG"                             format=f1.
      ER37014   LABEL="RENT INCOME HEAD SEP"                             format=f1.
      ER37015   LABEL="RENT INCOME HEAD OCT"                             format=f1.
      ER37016   LABEL="RENT INCOME HEAD NOV"                             format=f1.
      ER37017   LABEL="RENT INCOME HEAD DEC"                             format=f1.
      ER37018   LABEL="G25B WHETHER DIVIDENDS HEAD"                      format=f1.
      ER37019   LABEL="DIVIDENDS OF HEAD"                                format=f6.
      ER37020   LABEL="DIVIDENDS OF HEAD PER"                            format=f1.
      ER37021   LABEL="ACCURACY OF DIVIDENDS-HEAD"                       format=f1.
      ER37022   LABEL="G26B2 WTR DIVIDENDS JOINT WITH WIFE"              format=f1.
      ER37023   LABEL="DIVIDEND INCOME HEAD JAN"                         format=f1.
      ER37024   LABEL="DIVIDEND INCOME HEAD FEB"                         format=f1.
      ER37025   LABEL="DIVIDEND INCOME HEAD MAR"                         format=f1.
      ER37026   LABEL="DIVIDEND INCOME HEAD APR"                         format=f1.
      ER37027   LABEL="DIVIDEND INCOME HEAD MAY"                         format=f1.
      ER37028   LABEL="DIVIDEND INCOME HEAD JUN"                         format=f1.
      ER37029   LABEL="DIVIDEND INCOME HEAD JUL"                         format=f1.
      ER37030   LABEL="DIVIDEND INCOME HEAD AUG"                         format=f1.
      ER37031   LABEL="DIVIDEND INCOME HEAD SEP"                         format=f1.
      ER37032   LABEL="DIVIDEND INCOME HEAD OCT"                         format=f1.
      ER37033   LABEL="DIVIDEND INCOME HEAD NOV"                         format=f1.
      ER37034   LABEL="DIVIDEND INCOME HEAD DEC"                         format=f1.
      ER37035   LABEL="G25C WHETHER INTEREST HEAD"                       format=f1.
      ER37036   LABEL="INTEREST OF HEAD"                                 format=f6.
      ER37037   LABEL="INTEREST OF HEAD PER"                             format=f1.
      ER37038   LABEL="ACCURACY OF INTEREST-HEAD"                        format=f1.
      ER37039   LABEL="G26C2 WTR INTEREST JOINT WITH WIFE"               format=f1.
      ER37040   LABEL="INTEREST INCOME HEAD JAN"                         format=f1.
      ER37041   LABEL="INTEREST INCOME HEAD FEB"                         format=f1.
      ER37042   LABEL="INTEREST INCOME HEAD MAR"                         format=f1.
      ER37043   LABEL="INTEREST INCOME HEAD APR"                         format=f1.
      ER37044   LABEL="INTEREST INCOME HEAD MAY"                         format=f1.
      ER37045   LABEL="INTEREST INCOME HEAD JUN"                         format=f1.
      ER37046   LABEL="INTEREST INCOME HEAD JUL"                         format=f1.
      ER37047   LABEL="INTEREST INCOME HEAD AUG"                         format=f1.
      ER37048   LABEL="INTEREST INCOME HEAD SEP"                         format=f1.
      ER37049   LABEL="INTEREST INCOME HEAD OCT"                         format=f1.
      ER37050   LABEL="INTEREST INCOME HEAD NOV"                         format=f1.
      ER37051   LABEL="INTEREST INCOME HEAD DEC"                         format=f1.
      ER37052   LABEL="WHETHER TRUST FUND HEAD"                          format=f1.
      ER37053   LABEL="G25D TRUST FUND OF HEAD"                          format=f6.
      ER37054   LABEL="TRUST FUND OF HEAD PER"                           format=f1.
      ER37055   LABEL="ACCURACY OF TRUST FUND-HEAD"                      format=f1.
      ER37056   LABEL="TRUST/ROYAL INCOME H JAN"                         format=f1.
      ER37057   LABEL="TRUST/ROYAL INCOME H FEB"                         format=f1.
      ER37058   LABEL="TRUST/ROYAL INCOME H MAR"                         format=f1.
      ER37059   LABEL="TRUST/ROYAL INCOME H APR"                         format=f1.
      ER37060   LABEL="TRUST/ROYAL INCOME H MAY"                         format=f1.
      ER37061   LABEL="TRUST/ROYAL INCOME H JUN"                         format=f1.
      ER37062   LABEL="TRUST/ROYAL INCOME H JUL"                         format=f1.
      ER37063   LABEL="TRUST/ROYAL INCOME H AUG"                         format=f1.
      ER37064   LABEL="TRUST/ROYAL INCOME H SEP"                         format=f1.
      ER37065   LABEL="TRUST/ROYAL INCOME H OCT"                         format=f1.
      ER37066   LABEL="TRUST/ROYAL INCOME H NOV"                         format=f1.
      ER37067   LABEL="TRUST/ROYAL INCOME H DEC"                         format=f1.
      ER37068   LABEL="G25E WHETHER ADC/TANF HEAD"                       format=f1.
      ER37069   LABEL="ADC/TANF OF HEAD"                                 format=f6.
      ER37070   LABEL="ADC/TANF OF HEAD PER"                             format=f1.
      ER37071   LABEL="ACCURACY OF ADC/TANF-HEAD"                        format=f1.
      ER37072   LABEL="ADC/TANF INCOME HEAD JAN"                         format=f1.
      ER37073   LABEL="ADC/TANF INCOME HEAD FEB"                         format=f1.
      ER37074   LABEL="ADC/TANF INCOME HEAD MAR"                         format=f1.
      ER37075   LABEL="ADC/TANF INCOME HEAD APR"                         format=f1.
      ER37076   LABEL="ADC/TANF INCOME HEAD MAY"                         format=f1.
      ER37077   LABEL="ADC/TANF INCOME HEAD JUN"                         format=f1.
      ER37078   LABEL="ADC/TANF INCOME HEAD JUL"                         format=f1.
      ER37079   LABEL="ADC/TANF INCOME HEAD AUG"                         format=f1.
      ER37080   LABEL="ADC/TANF INCOME HEAD SEP"                         format=f1.
      ER37081   LABEL="ADC/TANF INCOME HEAD OCT"                         format=f1.
      ER37082   LABEL="ADC/TANF INCOME HEAD NOV"                         format=f1.
      ER37083   LABEL="ADC/TANF INCOME HEAD DEC"                         format=f1.
      ER37084   LABEL="G25F WHETHER SSI HEAD"                            format=f1.
      ER37085   LABEL="HEAD SSI SELF/ELSE/BOTH"                          format=f1.
      ER37086   LABEL="SSI OF HEAD"                                      format=f6.
      ER37087   LABEL="SSI OF HEAD PER"                                  format=f1.
      ER37088   LABEL="ACCURACY OF SSI-HEAD"                             format=f1.
      ER37089   LABEL="SSI INCOME HEAD JAN"                              format=f1.
      ER37090   LABEL="SSI INCOME HEAD FEB"                              format=f1.
      ER37091   LABEL="SSI INCOME HEAD MAR"                              format=f1.
      ER37092   LABEL="SSI INCOME HEAD APR"                              format=f1.
      ER37093   LABEL="SSI INCOME HEAD MAY"                              format=f1.
      ER37094   LABEL="SSI INCOME HEAD JUN"                              format=f1.
      ER37095   LABEL="SSI INCOME HEAD JUL"                              format=f1.
      ER37096   LABEL="SSI INCOME HEAD AUG"                              format=f1.
      ER37097   LABEL="SSI INCOME HEAD SEP"                              format=f1.
      ER37098   LABEL="SSI INCOME HEAD OCT"                              format=f1.
      ER37099   LABEL="SSI INCOME HEAD NOV"                              format=f1.
      ER37100   LABEL="SSI INCOME HEAD DEC"                              format=f1.
      ER37101   LABEL="G25G WHETHER OTHER WELFARE HD"                    format=f1.
      ER37102   LABEL="OTHER WELFARE OF HEAD"                            format=f6.
      ER37103   LABEL="OTHER WELFARE OF HD PER"                          format=f1.
      ER37104   LABEL="ACCURACY OF OTR WELFARE-HEAD"                     format=f1.
      ER37105   LABEL="OTR WELFARE INCOME H JAN"                         format=f1.
      ER37106   LABEL="OTR WELFARE INCOME H FEB"                         format=f1.
      ER37107   LABEL="OTR WELFARE INCOME H MAR"                         format=f1.
      ER37108   LABEL="OTR WELFARE INCOME H APR"                         format=f1.
      ER37109   LABEL="OTR WELFARE INCOME H MAY"                         format=f1.
      ER37110   LABEL="OTR WELFARE INCOME H JUN"                         format=f1.
      ER37111   LABEL="OTR WELFARE INCOME H JUL"                         format=f1.
      ER37112   LABEL="OTR WELFARE INCOME H AUG"                         format=f1.
      ER37113   LABEL="OTR WELFARE INCOME H SEP"                         format=f1.
      ER37114   LABEL="OTR WELFARE INCOME H OCT"                         format=f1.
      ER37115   LABEL="OTR WELFARE INCOME H NOV"                         format=f1.
      ER37116   LABEL="OTR WELFARE INCOME H DEC"                         format=f1.
      ER37117   LABEL="G31 ANY FU MEMB GET SOCSEC"                       format=f1.
      ER37118   LABEL="G37 WHETHER HEAD VA PENSION"                      format=f1.
      ER37119   LABEL="VA PENSION OF HEAD AMT"                           format=f6.
      ER37120   LABEL="VA PENSION OF HEAD PER"                           format=f1.
      ER37121   LABEL="ACCURACY OF VA PENSION-HEAD"                      format=f1.
      ER37122   LABEL="VA INCOME HEAD JAN"                               format=f1.
      ER37123   LABEL="VA INCOME HEAD FEB"                               format=f1.
      ER37124   LABEL="VA INCOME HEAD MAR"                               format=f1.
      ER37125   LABEL="VA INCOME HEAD APR"                               format=f1.
      ER37126   LABEL="VA INCOME HEAD MAY"                               format=f1.
      ER37127   LABEL="VA INCOME HEAD JUN"                               format=f1.
      ER37128   LABEL="VA INCOME HEAD JUL"                               format=f1.
      ER37129   LABEL="VA INCOME HEAD AUG"                               format=f1.
      ER37130   LABEL="VA INCOME HEAD SEP"                               format=f1.
      ER37131   LABEL="VA INCOME HEAD OCT"                               format=f1.
      ER37132   LABEL="VA INCOME HEAD NOV"                               format=f1.
      ER37133   LABEL="VA INCOME HEAD DEC"                               format=f1.
      ER37134   LABEL="G40A WTR NONVA RETIREMT-HEAD"                     format=f1.
      ER37135   LABEL="NONVA RETIREMENT-HEAD"                            format=f6.
      ER37136   LABEL="NONVA RETIREMENT PER-HD"                          format=f1.
      ER37137   LABEL="ACCURACY OF NONVA RETIREMENT-HEAD"                format=f1.
      ER37138   LABEL="RETIREMENT INCOME H JAN"                          format=f1.
      ER37139   LABEL="RETIREMENT INCOME H FEB"                          format=f1.
      ER37140   LABEL="RETIREMENT INCOME H MAR"                          format=f1.
      ER37141   LABEL="RETIREMENT INCOME H APR"                          format=f1.
      ER37142   LABEL="RETIREMENT INCOME H MAY"                          format=f1.
      ER37143   LABEL="RETIREMENT INCOME H JUN"                          format=f1.
      ER37144   LABEL="RETIREMENT INCOME H JUL"                          format=f1.
      ER37145   LABEL="RETIREMENT INCOME H AUG"                          format=f1.
      ER37146   LABEL="RETIREMENT INCOME H SEP"                          format=f1.
      ER37147   LABEL="RETIREMENT INCOME H OCT"                          format=f1.
      ER37148   LABEL="RETIREMENT INCOME H NOV"                          format=f1.
      ER37149   LABEL="RETIREMENT INCOME H DEC"                          format=f1.
      ER37150   LABEL="G40B WHETHER HEAD ANNUITIES"                      format=f1.
      ER37151   LABEL="ANNUITIES OF HEAD"                                format=f6.
      ER37152   LABEL="ANNUITIES OF HEAD PER"                            format=f1.
      ER37153   LABEL="ACCURACY OF ANNUITIES-HEAD"                       format=f1.
      ER37154   LABEL="ANNUITIES INCOME JAN"                             format=f1.
      ER37155   LABEL="ANNUITIES INCOME FEB"                             format=f1.
      ER37156   LABEL="ANNUITIES INCOME MAR"                             format=f1.
      ER37157   LABEL="ANNUITIES INCOME APR"                             format=f1.
      ER37158   LABEL="ANNUITIES INCOME MAY"                             format=f1.
      ER37159   LABEL="ANNUITIES INCOME JUN"                             format=f1.
      ER37160   LABEL="ANNUITIES INCOME JUL"                             format=f1.
      ER37161   LABEL="ANNUITIES INCOME AUG"                             format=f1.
      ER37162   LABEL="ANNUITIES INCOME SEP"                             format=f1.
      ER37163   LABEL="ANNUITIES INCOME OCT"                             format=f1.
      ER37164   LABEL="ANNUITIES INCOME NOV"                             format=f1.
      ER37165   LABEL="ANNUITIES INCOME DEC"                             format=f1.
      ER37166   LABEL="G40C WHETHER HEAD OTR PENSION"                    format=f1.
      ER37167   LABEL="OTHER PENSION OF HEAD"                            format=f6.
      ER37168   LABEL="OTHER PENSION OF HD PER"                          format=f1.
      ER37169   LABEL="ACCURACY OF OTR PENSION-HEAD"                     format=f1.
      ER37170   LABEL="OTR PENSION HEAD JAN"                             format=f1.
      ER37171   LABEL="OTR PENSION HEAD FEB"                             format=f1.
      ER37172   LABEL="OTR PENSION HEAD MAR"                             format=f1.
      ER37173   LABEL="OTR PENSION HEAD APR"                             format=f1.
      ER37174   LABEL="OTR PENSION HEAD MAY"                             format=f1.
      ER37175   LABEL="OTR PENSION HEAD JUN"                             format=f1.
      ER37176   LABEL="OTR PENSION HEAD JUL"                             format=f1.
      ER37177   LABEL="OTR PENSION HEAD AUG"                             format=f1.
      ER37178   LABEL="OTR PENSION HEAD SEP"                             format=f1.
      ER37179   LABEL="OTR PENSION HEAD OCT"                             format=f1.
      ER37180   LABEL="OTR PENSION HEAD NOV"                             format=f1.
      ER37181   LABEL="OTR PENSION HEAD DEC"                             format=f1.
      ER37182   LABEL="G43 NUM OF HEAD NON VA PENSN"                     format=f1.
      ER37183   LABEL="G44A WTR UNEMPL COMP OF HEAD"                     format=f1.
      ER37184   LABEL="AMT UNEMPL COMP OF HEAD"                          format=f6.
      ER37185   LABEL="AMT UNEMPL COMP HD PER"                           format=f1.
      ER37186   LABEL="ACCURACY OF UNEMPL COMP-HEAD"                     format=f1.
      ER37187   LABEL="UNEMPLOY INCOME HEAD JAN"                         format=f1.
      ER37188   LABEL="UNEMPLOY INCOME HEAD FEB"                         format=f1.
      ER37189   LABEL="UNEMPLOY INCOME HEAD MAR"                         format=f1.
      ER37190   LABEL="UNEMPLOY INCOME HEAD APR"                         format=f1.
      ER37191   LABEL="UNEMPLOY INCOME HEAD MAY"                         format=f1.
      ER37192   LABEL="UNEMPLOY INCOME HEAD JUN"                         format=f1.
      ER37193   LABEL="UNEMPLOY INCOME HEAD JUL"                         format=f1.
      ER37194   LABEL="UNEMPLOY INCOME HEAD AUG"                         format=f1.
      ER37195   LABEL="UNEMPLOY INCOME HEAD SEP"                         format=f1.
      ER37196   LABEL="UNEMPLOY INCOME HEAD OCT"                         format=f1.
      ER37197   LABEL="UNEMPLOY INCOME HEAD NOV"                         format=f1.
      ER37198   LABEL="UNEMPLOY INCOME HEAD DEC"                         format=f1.
      ER37199   LABEL="G44B WTR WORKMEN COMP OF HEAD"                    format=f1.
      ER37200   LABEL="AMT WORKMEN COMP OF HEAD"                         format=f6.
      ER37201   LABEL="AMT WORKMEN COMP HD PER"                          format=f1.
      ER37202   LABEL="ACCURACY OF WORKMEN COMP-HEAD"                    format=f1.
      ER37203   LABEL="WORKER COMP INCOME H JAN"                         format=f1.
      ER37204   LABEL="WORKER COMP INCOME H FEB"                         format=f1.
      ER37205   LABEL="WORKER COMP INCOME H MAR"                         format=f1.
      ER37206   LABEL="WORKER COMP INCOME H APR"                         format=f1.
      ER37207   LABEL="WORKER COMP INCOME H MAY"                         format=f1.
      ER37208   LABEL="WORKER COMP INCOME H JUN"                         format=f1.
      ER37209   LABEL="WORKER COMP INCOME H JUL"                         format=f1.
      ER37210   LABEL="WORKER COMP INCOME H AUG"                         format=f1.
      ER37211   LABEL="WORKER COMP INCOME H SEP"                         format=f1.
      ER37212   LABEL="WORKER COMP INCOME H OCT"                         format=f1.
      ER37213   LABEL="WORKER COMP INCOME H NOV"                         format=f1.
      ER37214   LABEL="WORKER COMP INCOME H DEC"                         format=f1.
      ER37215   LABEL="G44C WTR CHILD SUPPORT OF HD"                     format=f1.
      ER37216   LABEL="AMT CHILD SUPPORT OF HD"                          format=f6.
      ER37217   LABEL="AMT CHILD SUPPORT HD PER"                         format=f1.
      ER37218   LABEL="ACCURACY OF CHILD SUPPORT-HEAD"                   format=f1.
      ER37219   LABEL="CHILD SUPPORT INC H JAN"                          format=f1.
      ER37220   LABEL="CHILD SUPPORT INC H FEB"                          format=f1.
      ER37221   LABEL="CHILD SUPPORT INC H MAR"                          format=f1.
      ER37222   LABEL="CHILD SUPPORT INC H APR"                          format=f1.
      ER37223   LABEL="CHILD SUPPORT INC H MAY"                          format=f1.
      ER37224   LABEL="CHILD SUPPORT INC H JUN"                          format=f1.
      ER37225   LABEL="CHILD SUPPORT INC H JUL"                          format=f1.
      ER37226   LABEL="CHILD SUPPORT INC H AUG"                          format=f1.
      ER37227   LABEL="CHILD SUPPORT INC H SEP"                          format=f1.
      ER37228   LABEL="CHILD SUPPORT INC H OCT"                          format=f1.
      ER37229   LABEL="CHILD SUPPORT INC H NOV"                          format=f1.
      ER37230   LABEL="CHILD SUPPORT INC H DEC"                          format=f1.
      ER37231   LABEL="G44D WTR ALIMONY OF HEAD"                         format=f1.
      ER37232   LABEL="AMT ALIMONY OF HEAD"                              format=f6.
      ER37233   LABEL="AMT ALIMONY OF HEAD PER"                          format=f1.
      ER37234   LABEL="ACCURACY OF ALIMONY-HEAD"                         format=f1.
      ER37235   LABEL="ALIMONY INCOME HEAD JAN"                          format=f1.
      ER37236   LABEL="ALIMONY INCOME HEAD FEB"                          format=f1.
      ER37237   LABEL="ALIMONY INCOME HEAD MAR"                          format=f1.
      ER37238   LABEL="ALIMONY INCOME HEAD APR"                          format=f1.
      ER37239   LABEL="ALIMONY INCOME HEAD MAY"                          format=f1.
      ER37240   LABEL="ALIMONY INCOME HEAD JUN"                          format=f1.
      ER37241   LABEL="ALIMONY INCOME HEAD JUL"                          format=f1.
      ER37242   LABEL="ALIMONY INCOME HEAD AUG"                          format=f1.
      ER37243   LABEL="ALIMONY INCOME HEAD SEP"                          format=f1.
      ER37244   LABEL="ALIMONY INCOME HEAD OCT"                          format=f1.
      ER37245   LABEL="ALIMONY INCOME HEAD NOV"                          format=f1.
      ER37246   LABEL="ALIMONY INCOME HEAD DEC"                          format=f1.
      ER37247   LABEL="G44E WTR HELP FRM RELATIV HEAD"                   format=f1.
      ER37248   LABEL="AMT HELP FRM RELATIV HD"                          format=f6.
      ER37249   LABEL="AMT HELP FRM RELATIV PER"                         format=f1.
      ER37250   LABEL="ACCURACY OF HELP FRM RELATIV-HEAD"                format=f1.
      ER37251   LABEL="HELP FROM RELATIVE H JAN"                         format=f1.
      ER37252   LABEL="HELP FROM RELATIVE H FEB"                         format=f1.
      ER37253   LABEL="HELP FROM RELATIVE H MAR"                         format=f1.
      ER37254   LABEL="HELP FROM RELATIVE H APR"                         format=f1.
      ER37255   LABEL="HELP FROM RELATIVE H MAY"                         format=f1.
      ER37256   LABEL="HELP FROM RELATIVE H JUN"                         format=f1.
      ER37257   LABEL="HELP FROM RELATIVE H JUL"                         format=f1.
      ER37258   LABEL="HELP FROM RELATIVE H AUG"                         format=f1.
      ER37259   LABEL="HELP FROM RELATIVE H SEP"                         format=f1.
      ER37260   LABEL="HELP FROM RELATIVE H OCT"                         format=f1.
      ER37261   LABEL="HELP FROM RELATIVE H NOV"                         format=f1.
      ER37262   LABEL="HELP FROM RELATIVE H DEC"                         format=f1.
      ER37263   LABEL="G44F WTR HELP FRM OTHERS HEAD"                    format=f1.
      ER37264   LABEL="AMT HELP FRM OTHERS HD"                           format=f6.
      ER37265   LABEL="AMT HELP FRM OTHERS PER"                          format=f1.
      ER37266   LABEL="ACCURACY OF HELP FRM OTHERS-HEAD"                 format=f1.
      ER37267   LABEL="HELP FROM OTHERS H JAN"                           format=f1.
      ER37268   LABEL="HELP FROM OTHERS H FEB"                           format=f1.
      ER37269   LABEL="HELP FROM OTHERS H MAR"                           format=f1.
      ER37270   LABEL="HELP FROM OTHERS H APR"                           format=f1.
      ER37271   LABEL="HELP FROM OTHERS H MAY"                           format=f1.
      ER37272   LABEL="HELP FROM OTHERS H JUN"                           format=f1.
      ER37273   LABEL="HELP FROM OTHERS H JUL"                           format=f1.
      ER37274   LABEL="HELP FROM OTHERS H AUG"                           format=f1.
      ER37275   LABEL="HELP FROM OTHERS H SEP"                           format=f1.
      ER37276   LABEL="HELP FROM OTHERS H OCT"                           format=f1.
      ER37277   LABEL="HELP FROM OTHERS H NOV"                           format=f1.
      ER37278   LABEL="HELP FROM OTHERS H DEC"                           format=f1.
      ER37279   LABEL="G44G WTR ANYTHING ELSE OF HD"                     format=f1.
      ER37280   LABEL="AMT ANYTHING ELSE OF HD"                          format=f6.
      ER37281   LABEL="AMT ANYTHING ELSE PER"                            format=f1.
      ER37282   LABEL="ACCURACY OF ANYTHING ELSE-HEAD"                   format=f1.
      ER37283   LABEL="ANY OTHER INCOME H JAN"                           format=f1.
      ER37284   LABEL="ANY OTHER INCOME H FEB"                           format=f1.
      ER37285   LABEL="ANY OTHER INCOME H MAR"                           format=f1.
      ER37286   LABEL="ANY OTHER INCOME H APR"                           format=f1.
      ER37287   LABEL="ANY OTHER INCOME H MAY"                           format=f1.
      ER37288   LABEL="ANY OTHER INCOME H JUN"                           format=f1.
      ER37289   LABEL="ANY OTHER INCOME H JUL"                           format=f1.
      ER37290   LABEL="ANY OTHER INCOME H AUG"                           format=f1.
      ER37291   LABEL="ANY OTHER INCOME H SEP"                           format=f1.
      ER37292   LABEL="ANY OTHER INCOME H OCT"                           format=f1.
      ER37293   LABEL="ANY OTHER INCOME H NOV"                           format=f1.
      ER37294   LABEL="ANY OTHER INCOME H DEC"                           format=f1.
      ER37295   LABEL="G49 WTR WIFE IN FU NOW"                           format=f1.
      ER37296   LABEL="G50 WHETHER WIFE HAD INCOME"                      format=f1.
      ER37297   LABEL="G51A WHETHER WIFE LABOR INC"                      format=f1.
      ER37298   LABEL="G51B WHETHER WFE INC FRM WORK"                    format=f1.
      ER37299   LABEL="WAGES/SALARY OF WIFE"                             format=f7.
      ER37300   LABEL="ACCURACY OF WAGES/SALARY-WIFE"                    format=f1.
      ER37301   LABEL="G52B WTR WORK HOURS FOR WIFE"                     format=f1.
      ER37302   LABEL="G53 WHETHER UNEMPLOYMENT WFE"                     format=f1.
      ER37303   LABEL="UNEMPLOYMNT COMP OF WIFE"                         format=f6.
      ER37304   LABEL="UNEMPLOYMNT COMP WFE PER"                         format=f1.
      ER37305   LABEL="ACCURACY OF UNEMPLOYMENT COMP-WIFE"               format=f1.
      ER37306   LABEL="UNEMPLOY INCOME WIFE JAN"                         format=f1.
      ER37307   LABEL="UNEMPLOY INCOME WIFE FEB"                         format=f1.
      ER37308   LABEL="UNEMPLOY INCOME WIFE MAR"                         format=f1.
      ER37309   LABEL="UNEMPLOY INCOME WIFE APR"                         format=f1.
      ER37310   LABEL="UNEMPLOY INCOME WIFE MAY"                         format=f1.
      ER37311   LABEL="UNEMPLOY INCOME WIFE JUN"                         format=f1.
      ER37312   LABEL="UNEMPLOY INCOME WIFE JUL"                         format=f1.
      ER37313   LABEL="UNEMPLOY INCOME WIFE AUG"                         format=f1.
      ER37314   LABEL="UNEMPLOY INCOME WIFE SEP"                         format=f1.
      ER37315   LABEL="UNEMPLOY INCOME WIFE OCT"                         format=f1.
      ER37316   LABEL="UNEMPLOY INCOME WIFE NOV"                         format=f1.
      ER37317   LABEL="UNEMPLOY INCOME WIFE DEC"                         format=f1.
      ER37318   LABEL="G56 WHETHER WORKERS COMP WFE"                     format=f1.
      ER37319   LABEL="WORKERS COMP OF WIFE"                             format=f6.
      ER37320   LABEL="WORKERS COMP OF WIFE PER"                         format=f1.
      ER37321   LABEL="ACCURACY OF WORKERS COMP-WIFE"                    format=f1.
      ER37322   LABEL="WORKER COMP INCOME W JAN"                         format=f1.
      ER37323   LABEL="WORKER COMP INCOME W FEB"                         format=f1.
      ER37324   LABEL="WORKER COMP INCOME W MAR"                         format=f1.
      ER37325   LABEL="WORKER COMP INCOME W APR"                         format=f1.
      ER37326   LABEL="WORKER COMP INCOME W MAY"                         format=f1.
      ER37327   LABEL="WORKER COMP INCOME W JUN"                         format=f1.
      ER37328   LABEL="WORKER COMP INCOME W JUL"                         format=f1.
      ER37329   LABEL="WORKER COMP INCOME W AUG"                         format=f1.
      ER37330   LABEL="WORKER COMP INCOME W SEP"                         format=f1.
      ER37331   LABEL="WORKER COMP INCOME W OCT"                         format=f1.
      ER37332   LABEL="WORKER COMP INCOME W NOV"                         format=f1.
      ER37333   LABEL="WORKER COMP INCOME W DEC"                         format=f1.
      ER37334   LABEL="G59A WHETHER WIFE RENT"                           format=f1.
      ER37335   LABEL="RENT OF WIFE AMT"                                 format=f6.
      ER37336   LABEL="RENT OF WIFE PER"                                 format=f1.
      ER37337   LABEL="ACCURACY OF RENT-WIFE"                            format=f1.
      ER37338   LABEL="G59A3 WTR RENT ADDITIONAL TO HEAD AMT"            format=f1.
      ER37339   LABEL="RENT INCOME WIFE JAN"                             format=f1.
      ER37340   LABEL="RENT INCOME WIFE FEB"                             format=f1.
      ER37341   LABEL="RENT INCOME WIFE MAR"                             format=f1.
      ER37342   LABEL="RENT INCOME WIFE APR"                             format=f1.
      ER37343   LABEL="RENT INCOME WIFE MAY"                             format=f1.
      ER37344   LABEL="RENT INCOME WIFE JUN"                             format=f1.
      ER37345   LABEL="RENT INCOME WIFE JUL"                             format=f1.
      ER37346   LABEL="RENT INCOME WIFE AUG"                             format=f1.
      ER37347   LABEL="RENT INCOME WIFE SEP"                             format=f1.
      ER37348   LABEL="RENT INCOME WIFE OCT"                             format=f1.
      ER37349   LABEL="RENT INCOME WIFE NOV"                             format=f1.
      ER37350   LABEL="RENT INCOME WIFE DEC"                             format=f1.
      ER37351   LABEL="G59B WHETHER WIFE DIVIDENDS"                      format=f1.
      ER37352   LABEL="DIVIDENDS OF WIFE AMT"                            format=f6.
      ER37353   LABEL="DIVIDENDS OF WIFE PER"                            format=f1.
      ER37354   LABEL="ACCURACY OF DIVIDENDS-WIFE"                       format=f1.
      ER37355   LABEL="G59B3 WTR DIVS ADDITIONAL TO HEAD AMT"            format=f1.
      ER37356   LABEL="DIVIDEND INCOME WIFE JAN"                         format=f1.
      ER37357   LABEL="DIVIDEND INCOME WIFE FEB"                         format=f1.
      ER37358   LABEL="DIVIDEND INCOME WIFE MAR"                         format=f1.
      ER37359   LABEL="DIVIDEND INCOME WIFE APR"                         format=f1.
      ER37360   LABEL="DIVIDEND INCOME WIFE MAY"                         format=f1.
      ER37361   LABEL="DIVIDEND INCOME WIFE JUN"                         format=f1.
      ER37362   LABEL="DIVIDEND INCOME WIFE JUL"                         format=f1.
      ER37363   LABEL="DIVIDEND INCOME WIFE AUG"                         format=f1.
      ER37364   LABEL="DIVIDEND INCOME WIFE SEP"                         format=f1.
      ER37365   LABEL="DIVIDEND INCOME WIFE OCT"                         format=f1.
      ER37366   LABEL="DIVIDEND INCOME WIFE NOV"                         format=f1.
      ER37367   LABEL="DIVIDEND INCOME WIFE DEC"                         format=f1.
      ER37368   LABEL="G59C WHETHER WIFE INTEREST"                       format=f1.
      ER37369   LABEL="INTEREST OF WIFE AMT"                             format=f6.
      ER37370   LABEL="INTEREST OF WIFE AMT PER"                         format=f1.
      ER37371   LABEL="ACCURACY OF INTEREST-WIFE"                        format=f1.
      ER37372   LABEL="G59C3 WTR INTEREST ADDITNL TO HEAD AMT"           format=f1.
      ER37373   LABEL="INTEREST INCOME WIFE JAN"                         format=f1.
      ER37374   LABEL="INTEREST INCOME WIFE FEB"                         format=f1.
      ER37375   LABEL="INTEREST INCOME WIFE MAR"                         format=f1.
      ER37376   LABEL="INTEREST INCOME WIFE APR"                         format=f1.
      ER37377   LABEL="INTEREST INCOME WIFE MAY"                         format=f1.
      ER37378   LABEL="INTEREST INCOME WIFE JUN"                         format=f1.
      ER37379   LABEL="INTEREST INCOME WIFE JUL"                         format=f1.
      ER37380   LABEL="INTEREST INCOME WIFE AUG"                         format=f1.
      ER37381   LABEL="INTEREST INCOME WIFE SEP"                         format=f1.
      ER37382   LABEL="INTEREST INCOME WIFE OCT"                         format=f1.
      ER37383   LABEL="INTEREST INCOME WIFE NOV"                         format=f1.
      ER37384   LABEL="INTEREST INCOME WIFE DEC"                         format=f1.
      ER37385   LABEL="G59D WHETHER WIFE TRUST FUND"                     format=f1.
      ER37386   LABEL="TRUST FUND OF WIFE AMT"                           format=f6.
      ER37387   LABEL="TRUST FUND OF WIFE PER"                           format=f1.
      ER37388   LABEL="ACCURACY OF TRUST FUND-WIFE"                      format=f1.
      ER37389   LABEL="TRUST INCOME WIFE JAN"                            format=f1.
      ER37390   LABEL="TRUST INCOME WIFE FEB"                            format=f1.
      ER37391   LABEL="TRUST INCOME WIFE MAR"                            format=f1.
      ER37392   LABEL="TRUST INCOME WIFE APR"                            format=f1.
      ER37393   LABEL="TRUST INCOME WIFE MAY"                            format=f1.
      ER37394   LABEL="TRUST INCOME WIFE JUN"                            format=f1.
      ER37395   LABEL="TRUST INCOME WIFE JUL"                            format=f1.
      ER37396   LABEL="TRUST INCOME WIFE AUG"                            format=f1.
      ER37397   LABEL="TRUST INCOME WIFE SEP"                            format=f1.
      ER37398   LABEL="TRUST INCOME WIFE OCT"                            format=f1.
      ER37399   LABEL="TRUST INCOME WIFE NOV"                            format=f1.
      ER37400   LABEL="TRUST INCOME WIFE DEC"                            format=f1.
      ER37401   LABEL="G60A WHETHER WIFE RECD SSI"                       format=f1.
      ER37402   LABEL="G60A1 WIFE SSI SELF/ELSE/BOTH"                    format=f1.
      ER37403   LABEL="SSI OF WIFE AMT"                                  format=f6.
      ER37404   LABEL="SSI OF WIFE AMT PER"                              format=f1.
      ER37405   LABEL="ACCURACY OF SSI-WIFE"                             format=f1.
      ER37406   LABEL="SSI INCOME WIFE JAN"                              format=f1.
      ER37407   LABEL="SSI INCOME WIFE FEB"                              format=f1.
      ER37408   LABEL="SSI INCOME WIFE MAR"                              format=f1.
      ER37409   LABEL="SSI INCOME WIFE APR"                              format=f1.
      ER37410   LABEL="SSI INCOME WIFE MAY"                              format=f1.
      ER37411   LABEL="SSI INCOME WIFE JUN"                              format=f1.
      ER37412   LABEL="SSI INCOME WIFE JUL"                              format=f1.
      ER37413   LABEL="SSI INCOME WIFE AUG"                              format=f1.
      ER37414   LABEL="SSI INCOME WIFE SEP"                              format=f1.
      ER37415   LABEL="SSI INCOME WIFE OCT"                              format=f1.
      ER37416   LABEL="SSI INCOME WIFE NOV"                              format=f1.
      ER37417   LABEL="SSI INCOME WIFE DEC"                              format=f1.
      ER37418   LABEL="G60B WTR WIFE RECD ADC/TANF"                      format=f1.
      ER37419   LABEL="ADC/TANF OF WIFE AMT"                             format=f6.
      ER37420   LABEL="ADC/TANF OF WIFE AMT PER"                         format=f1.
      ER37421   LABEL="ACCURACY OF ADC/TANF-WIFE"                        format=f1.
      ER37422   LABEL="ADC/TANF INCOME WIFE JAN"                         format=f1.
      ER37423   LABEL="ADC/TANF INCOME WIFE FEB"                         format=f1.
      ER37424   LABEL="ADC/TANF INCOME WIFE MAR"                         format=f1.
      ER37425   LABEL="ADC/TANF INCOME WIFE APR"                         format=f1.
      ER37426   LABEL="ADC/TANF INCOME WIFE MAY"                         format=f1.
      ER37427   LABEL="ADC/TANF INCOME WIFE JUN"                         format=f1.
      ER37428   LABEL="ADC/TANF INCOME WIFE JUL"                         format=f1.
      ER37429   LABEL="ADC/TANF INCOME WIFE AUG"                         format=f1.
      ER37430   LABEL="ADC/TANF INCOME WIFE SEP"                         format=f1.
      ER37431   LABEL="ADC/TANF INCOME WIFE OCT"                         format=f1.
      ER37432   LABEL="ADC/TANF INCOME WIFE NOV"                         format=f1.
      ER37433   LABEL="ADC/TANF INCOME WIFE DEC"                         format=f1.
      ER37434   LABEL="G60C WTR WF RECD CHILD SUPPRT"                    format=f1.
      ER37435   LABEL="CHILD SUPPORT OF WF AMT"                          format=f6.
      ER37436   LABEL="CHILD SUPPORT OF WF PER"                          format=f1.
      ER37437   LABEL="ACCURACY OF CHILD SUPPORT-WIFE"                   format=f1.
      ER37438   LABEL="CHILD SUPPORT INC W JAN"                          format=f1.
      ER37439   LABEL="CHILD SUPPORT INC W FEB"                          format=f1.
      ER37440   LABEL="CHILD SUPPORT INC W MAR"                          format=f1.
      ER37441   LABEL="CHILD SUPPORT INC W APR"                          format=f1.
      ER37442   LABEL="CHILD SUPPORT INC W MAY"                          format=f1.
      ER37443   LABEL="CHILD SUPPORT INC W JUN"                          format=f1.
      ER37444   LABEL="CHILD SUPPORT INC W JUL"                          format=f1.
      ER37445   LABEL="CHILD SUPPORT INC W AUG"                          format=f1.
      ER37446   LABEL="CHILD SUPPORT INC W SEP"                          format=f1.
      ER37447   LABEL="CHILD SUPPORT INC W OCT"                          format=f1.
      ER37448   LABEL="CHILD SUPPORT INC W NOV"                          format=f1.
      ER37449   LABEL="CHILD SUPPORT INC W DEC"                          format=f1.
      ER37450   LABEL="G60D WTR WF RECD OTR WELFARE"                     format=f1.
      ER37451   LABEL="OTHER WELFARE OF WF AMT"                          format=f6.
      ER37452   LABEL="OTHER WELFARE OF WF PER"                          format=f1.
      ER37453   LABEL="ACCURACY OF OTHER WELFARE-WIFE"                   format=f1.
      ER37454   LABEL="OTHER WELFARE INC W JAN"                          format=f1.
      ER37455   LABEL="OTHER WELFARE INC W FEB"                          format=f1.
      ER37456   LABEL="OTHER WELFARE INC W MAR"                          format=f1.
      ER37457   LABEL="OTHER WELFARE INC W APR"                          format=f1.
      ER37458   LABEL="OTHER WELFARE INC W MAY"                          format=f1.
      ER37459   LABEL="OTHER WELFARE INC W JUN"                          format=f1.
      ER37460   LABEL="OTHER WELFARE INC W JUL"                          format=f1.
      ER37461   LABEL="OTHER WELFARE INC W AUG"                          format=f1.
      ER37462   LABEL="OTHER WELFARE INC W SEP"                          format=f1.
      ER37463   LABEL="OTHER WELFARE INC W OCT"                          format=f1.
      ER37464   LABEL="OTHER WELFARE INC W NOV"                          format=f1.
      ER37465   LABEL="OTHER WELFARE INC W DEC"                          format=f1.
      ER37466   LABEL="G61 WTR WF RECD PENS/ANNUITY"                     format=f1.
      ER37467   LABEL="PENSION/ANNUITY WF AMT"                           format=f6.
      ER37468   LABEL="PENSION/ANNUITY WF PER"                           format=f1.
      ER37469   LABEL="ACCURACY OF PENSION/ANNUITY-WIFE"                 format=f1.
      ER37470   LABEL="PENSION/ANNUITY W JAN"                            format=f1.
      ER37471   LABEL="PENSION/ANNUITY W FEB"                            format=f1.
      ER37472   LABEL="PENSION/ANNUITY W MAR"                            format=f1.
      ER37473   LABEL="PENSION/ANNUITY W APR"                            format=f1.
      ER37474   LABEL="PENSION/ANNUITY W MAY"                            format=f1.
      ER37475   LABEL="PENSION/ANNUITY W JUN"                            format=f1.
      ER37476   LABEL="PENSION/ANNUITY W JUL"                            format=f1.
      ER37477   LABEL="PENSION/ANNUITY W AUG"                            format=f1.
      ER37478   LABEL="PENSION/ANNUITY W SEP"                            format=f1.
      ER37479   LABEL="PENSION/ANNUITY W OCT"                            format=f1.
      ER37480   LABEL="PENSION/ANNUITY W NOV"                            format=f1.
      ER37481   LABEL="PENSION/ANNUITY W DEC"                            format=f1.
      ER37482   LABEL="G62A WTR WF HELP FR RELATIVES"                    format=f1.
      ER37483   LABEL="HELP FR RELATIVES WF AMT"                         format=f6.
      ER37484   LABEL="HELP FR RELS WF PER"                              format=f1.
      ER37485   LABEL="ACCURACY OF HELP FRM RELATIVES-WIFE"              format=f1.
      ER37486   LABEL="HELP FR RELATIVES WF JAN"                         format=f1.
      ER37487   LABEL="HELP FR RELATIVES WF FEB"                         format=f1.
      ER37488   LABEL="HELP FR RELATIVES WF MAR"                         format=f1.
      ER37489   LABEL="HELP FR RELATIVES WF APR"                         format=f1.
      ER37490   LABEL="HELP FR RELATIVES WF MAY"                         format=f1.
      ER37491   LABEL="HELP FR RELATIVES WF JUN"                         format=f1.
      ER37492   LABEL="HELP FR RELATIVES WF JUL"                         format=f1.
      ER37493   LABEL="HELP FR RELATIVES WF AUG"                         format=f1.
      ER37494   LABEL="HELP FR RELATIVES WF SEP"                         format=f1.
      ER37495   LABEL="HELP FR RELATIVES WF OCT"                         format=f1.
      ER37496   LABEL="HELP FR RELATIVES WF NOV"                         format=f1.
      ER37497   LABEL="HELP FR RELATIVES WF DEC"                         format=f1.
      ER37498   LABEL="G62B WTR WF HELP FROM FRIENDS"                    format=f1.
      ER37499   LABEL="HELP FR FRIENDS WF AMT"                           format=f6.
      ER37500   LABEL="HELP FR FRIENDS WF PER"                           format=f1.
      ER37501   LABEL="ACCURACY OF HELP FRM FRIENDS-WIFE"                format=f1.
      ER37502   LABEL="HELP FROM FRIENDS W JAN"                          format=f1.
      ER37503   LABEL="HELP FROM FRIENDS W FEB"                          format=f1.
      ER37504   LABEL="HELP FROM FRIENDS W MAR"                          format=f1.
      ER37505   LABEL="HELP FROM FRIENDS W APR"                          format=f1.
      ER37506   LABEL="HELP FROM FRIENDS W MAY"                          format=f1.
      ER37507   LABEL="HELP FROM FRIENDS W JUN"                          format=f1.
      ER37508   LABEL="HELP FROM FRIENDS W JUL"                          format=f1.
      ER37509   LABEL="HELP FROM FRIENDS W AUG"                          format=f1.
      ER37510   LABEL="HELP FROM FRIENDS W SEP"                          format=f1.
      ER37511   LABEL="HELP FROM FRIENDS W OCT"                          format=f1.
      ER37512   LABEL="HELP FROM FRIENDS W NOV"                          format=f1.
      ER37513   LABEL="HELP FROM FRIENDS W DEC"                          format=f1.
      ER37514   LABEL="G63 WTR WFE RECD OTR INCOME"                      format=f1.
      ER37515   LABEL="WIFE OTHER INCOME AMT"                            format=f6.
      ER37516   LABEL="WIFE OTHER INCOME PER"                            format=f1.
      ER37517   LABEL="ACCURACY OF OTHER INCOME-WIFE"                    format=f1.
      ER37518   LABEL="ANY OTHER INCOME W JAN"                           format=f1.
      ER37519   LABEL="ANY OTHER INCOME W FEB"                           format=f1.
      ER37520   LABEL="ANY OTHER INCOME W MAR"                           format=f1.
      ER37521   LABEL="ANY OTHER INCOME W APR"                           format=f1.
      ER37522   LABEL="ANY OTHER INCOME W MAY"                           format=f1.
      ER37523   LABEL="ANY OTHER INCOME W JUN"                           format=f1.
      ER37524   LABEL="ANY OTHER INCOME W JUL"                           format=f1.
      ER37525   LABEL="ANY OTHER INCOME W AUG"                           format=f1.
      ER37526   LABEL="ANY OTHER INCOME W SEP"                           format=f1.
      ER37527   LABEL="ANY OTHER INCOME W OCT"                           format=f1.
      ER37528   LABEL="ANY OTHER INCOME W NOV"                           format=f1.
      ER37529   LABEL="ANY OTHER INCOME W DEC"                           format=f1.
      ER37530   LABEL="G99 WTR LUMP SUM PAYMNTS"                         format=f1.
      ER37531   LABEL="G100 LUMP SUM PAYMENTS"                           format=f7.
      ER37532   LABEL="G101 INHERITANCE"                                 format=f7.
      ER37533   LABEL="G102 WTR ITEMIZE FOR TAX"                         format=f1.
      ER37534   LABEL="G102A ITEMIZED CHARITABLE CONTRIB AMT"            format=f6.
      ER37535   LABEL="G102B ITEMIZED MEDICAL EXPENSES AMT"              format=f6.
      ER37536   LABEL="G103 WTR HELP OTRS"                               format=f1.
      ER37537   LABEL="G104 # OTRS SUPPORTED"                            format=f2.
      ER37538   LABEL="G105 WHO SUPPORT      1"                          format=f2.
      ER37539   LABEL="G105 WHO SUPPORT      2"                          format=f2.
      ER37540   LABEL="G105 WHO SUPPORT      3"                          format=f2.
      ER37541   LABEL="G105 WHO SUPPORT      4"                          format=f2.
      ER37542   LABEL="G105 WHO SUPPORT      5"                          format=f2.
      ER37543   LABEL="G106 TOTAL SUPP OF OTRS"                          format=f7.
      ER37544   LABEL="G107 ANY CHILD SUPPORT"                           format=f1.
      ER37545   LABEL="AMT OF CHLD SUPPRT GIVEN"                         format=f7.
      ER37546   LABEL="G109 ANY ALIMONY"                                 format=f1.
      ER37547   LABEL="AMT OF ALIMONY GIVEN"                             format=f7.
      ER37548   LABEL="G112 WTR DEPNDT OTRS"                             format=f1.
      ER37549   LABEL="G113 NUMBER DEPNDT OTR"                           format=f2.
      ER37550   LABEL="G114 WTR DEPNDT OTHS"                             format=f1.
      ER37551   LABEL="W1 WTR OTR REAL ESTATE"                           format=f1.
      ER37552   LABEL="W1A WTR SECOND HOME"                              format=f1.
      ER37553   LABEL="W2 PROFIT IF SOLD OTR REAL ESTATE"                format=f9.
      ER37554   LABEL="W3 WTR PROFIT GE 50,000"                          format=f1.
      ER37555   LABEL="W4 WTR PROFIT GE 150,000"                         format=f1.
      ER37556   LABEL="W5 WTR PROFIT GE 5,000"                           format=f1.
      ER37557   LABEL="W6 PROFIT IF SOLD VEHICLES"                       format=f9.
      ER37558   LABEL="W7 WTR PROFIT GE 10,000"                          format=f1.
      ER37559   LABEL="W8 WTR PROFIT GE 25,000"                          format=f1.
      ER37560   LABEL="W9 WTR PROFIT GE 2,000"                           format=f1.
      ER37561   LABEL="W10 WTR OWN BUSINESS/FARM"                        format=f1.
      ER37562   LABEL="W11 PROFIT IF SOLD BUSINESS/FARM"                 format=f9.
      ER37563   LABEL="W12 WTR PROFIT GE 50,000"                         format=f1.
      ER37564   LABEL="W13 WTR PROFIT GE 200,000"                        format=f1.
      ER37565   LABEL="W14 WTR PROFIT GE 10,000"                         format=f1.
      ER37566   LABEL="W15 WTR OWN NON-IRA STOCK"                        format=f1.
      ER37567   LABEL="W16 PROFIT IF SOLD NON-IRA STOCK"                 format=f9.
      ER37568   LABEL="W17 WTR PROFIT GE 25,000"                         format=f1.
      ER37569   LABEL="W18 WTR PROFIT GE 50,000"                         format=f1.
      ER37570   LABEL="W19 WTR PROFIT GE 5,000"                          format=f1.
      ER37571   LABEL="W20 WTR PROFIT GE 100,000"                        format=f1.
      ER37572   LABEL="W20D WTR DIVIDEND AMT CORRECT"                    format=f1.
      ER37573   LABEL="W20E REVISED DIVIDENDS"                           format=f6.
      ER37574   LABEL="W20E REVISED DIVIDENDS PER"                       format=f1.
      ER37575   LABEL="W20F WTR REC REV DIVIDENDS IN JAN"                format=f1.
      ER37576   LABEL="W20F WTR REC REV DIVIDENDS IN FEB"                format=f1.
      ER37577   LABEL="W20F WTR REC REV DIVIDENDS IN MAR"                format=f1.
      ER37578   LABEL="W20F WTR REC REV DIVIDENDS IN APR"                format=f1.
      ER37579   LABEL="W20F WTR REC REV DIVIDENDS IN MAY"                format=f1.
      ER37580   LABEL="W20F WTR REC REV DIVIDENDS IN JUN"                format=f1.
      ER37581   LABEL="W20F WTR REC REV DIVIDENDS IN JUL"                format=f1.
      ER37582   LABEL="W20F WTR REC REV DIVIDENDS IN AUG"                format=f1.
      ER37583   LABEL="W20F WTR REC REV DIVIDENDS IN SEP"                format=f1.
      ER37584   LABEL="W20F WTR REC REV DIVIDENDS IN OCT"                format=f1.
      ER37585   LABEL="W20F WTR REC REV DIVIDENDS IN NOV"                format=f1.
      ER37586   LABEL="W20F WTR REC REV DIVIDENDS IN DEC"                format=f1.
      ER37587   LABEL="W21 WTR IRA/PRIVATE ANNUITY"                      format=f1.
      ER37588   LABEL="W21A HOW FUNDS INVESTED"                          format=f1.
      ER37589   LABEL="W22 VALUE OF IRA/ANNUITY"                         format=f9.
      ER37590   LABEL="W23 WTR VALUE GE 25,000"                          format=f1.
      ER37591   LABEL="W24 WTR VALUE GE 50,000"                          format=f1.
      ER37592   LABEL="W25 WTR VALUE GE 5,000"                           format=f1.
      ER37593   LABEL="W26 WTR VALUE GE 100,000"                         format=f1.
      ER37594   LABEL="W27 WTR CK/SAVINGS/CD, ETC"                       format=f1.
      ER37595   LABEL="W28 AMT ALL ACCOUNTS"                             format=f9.
      ER37596   LABEL="W29 WTR VALUE GE 5,000"                           format=f1.
      ER37597   LABEL="W30 WTR VALUE GE 10,000"                          format=f1.
      ER37598   LABEL="W31 WTR VALUE GE 50,000"                          format=f1.
      ER37599   LABEL="W31D WTR INTEREST AMT CORRECT"                    format=f1.
      ER37600   LABEL="W31E REVISED INTEREST"                            format=f6.
      ER37601   LABEL="W31E REVISED INTEREST PER"                        format=f1.
      ER37602   LABEL="W31F WTR REC REV INTEREST IN JAN"                 format=f1.
      ER37603   LABEL="W31F WTR REC REV INTEREST IN FEB"                 format=f1.
      ER37604   LABEL="W31F WTR REC REV INTEREST IN MAR"                 format=f1.
      ER37605   LABEL="W31F WTR REC REV INTEREST IN APR"                 format=f1.
      ER37606   LABEL="W31F WTR REC REV INTEREST IN MAY"                 format=f1.
      ER37607   LABEL="W31F WTR REC REV INTEREST IN JUN"                 format=f1.
      ER37608   LABEL="W31F WTR REC REV INTEREST IN JUL"                 format=f1.
      ER37609   LABEL="W31F WTR REC REV INTEREST IN AUG"                 format=f1.
      ER37610   LABEL="W31F WTR REC REV INTEREST IN SEP"                 format=f1.
      ER37611   LABEL="W31F WTR REC REV INTEREST IN OCT"                 format=f1.
      ER37612   LABEL="W31F WTR REC REV INTEREST IN NOV"                 format=f1.
      ER37613   LABEL="W31F WTR REC REV INTEREST IN DEC"                 format=f1.
      ER37614   LABEL="W32 WTR VALUE GE 1,000"                           format=f1.
      ER37615   LABEL="W33 WTR BONDS/INSURANCE, ETC."                    format=f1.
      ER37616   LABEL="W34 PROFIT IF SOLD BONDS/INSURANCE"               format=f9.
      ER37617   LABEL="W35 WTR PROFIT GE 10,000"                         format=f1.
      ER37618   LABEL="W36 WTR PROFIT GE 25,000"                         format=f1.
      ER37619   LABEL="W37 WTR PROFIT GE 2,000"                          format=f1.
      ER37620   LABEL="W38 WTR OTHER DEBTS"                              format=f1.
      ER37621   LABEL="W39 VALUE ALL DEBTS"                              format=f9.
      ER37622   LABEL="W40 WTR DEBTS GE 2,000"                           format=f1.
      ER37623   LABEL="W41 WTR DEBTS GE 5,000"                           format=f1.
      ER37624   LABEL="W42 WTR DEBTS GE 1,000"                           format=f1.
      ER37625   LABEL="W43 WTR CHANGED IRA/PRIVATE ANNUITY"              format=f1.
      ER37626   LABEL="W44 AMT INVESTED IN IRA/ANNUITY"                  format=f9.
      ER37627   LABEL="W45 WTR INVEST GE 10,000"                         format=f1.
      ER37628   LABEL="W46 WTR INVEST GE 50,000"                         format=f1.
      ER37629   LABEL="W47 WTR INVEST GE 5,000"                          format=f1.
      ER37630   LABEL="W48 WTR CASHED PNSN/ANNTY/IRA"                    format=f1.
      ER37631   LABEL="W49 VALUE PENSION/ANNUITY/IRA"                    format=f9.
      ER37632   LABEL="W50 WTR VALUE GE 10,000"                          format=f1.
      ER37633   LABEL="W51 WTR VALUE GE 50,000"                          format=f1.
      ER37634   LABEL="W52 WTR VALUE GE 100,000"                         format=f1.
      ER37635   LABEL="W53 WTR VALUE GE 5,000"                           format=f1.
      ER37636   LABEL="W54 WTR SOLD HOME"                                format=f1.
      ER37637   LABEL="W55 HOME SELLING PRICE"                           format=f9.
      ER37638   LABEL="W56 WTR PRICE GE 60,000"                          format=f1.
      ER37639   LABEL="W57 WTR PRICE GE 120,000"                         format=f1.
      ER37640   LABEL="W58 WTR PRICE GE 30,000"                          format=f1.
      ER37641   LABEL="W59 WTR BOUGHT OTR REAL ESTATE"                   format=f1.
      ER37642   LABEL="W60 AMT IN REAL ESTATE"                           format=f9.
      ER37643   LABEL="W61 WTR AMT GE 60,000"                            format=f1.
      ER37644   LABEL="W62 WTR AMT GE 120,000"                           format=f1.
      ER37645   LABEL="W63 WTR AMT GE 30,000"                            format=f1.
      ER37646   LABEL="W64 WTR SOLD OTR REAL ESTATE"                     format=f1.
      ER37647   LABEL="W65 AMT FROM OTR REAL ESTATE"                     format=f9.
      ER37648   LABEL="W66 WTR AMT GE 60,000"                            format=f1.
      ER37649   LABEL="W67 WTR AMT GE 120,000"                           format=f1.
      ER37650   LABEL="W68 WTR AMT GE 30,000"                            format=f1.
      ER37651   LABEL="W69 WTR MADE ADDITION/REPAIRS"                    format=f1.
      ER37652   LABEL="W70 COST OF ADDITION/REPAIRS"                     format=f9.
      ER37653   LABEL="W71 WTR COST GE 25,000"                           format=f1.
      ER37654   LABEL="W72 WTR COST GE 75,000"                           format=f1.
      ER37655   LABEL="W73 WTR INVESTED IN BUSNES/FARM"                  format=f1.
      ER37656   LABEL="W74 AMT INVESTED IN BUSINESS/FARM"                format=f9.
      ER37657   LABEL="W75 WTR AMT GE 25,000"                            format=f1.
      ER37658   LABEL="W76 WTR AMT GE 100,000"                           format=f1.
      ER37659   LABEL="W77 WTR AMT GE 10,000"                            format=f1.
      ER37660   LABEL="W78 WTR SOLD BUSINESS/FARM"                       format=f1.
      ER37661   LABEL="W79 AMT FROM BUSINESS/FARM"                       format=f9.
      ER37662   LABEL="W80 WTR AMT GE 25,000"                            format=f1.
      ER37663   LABEL="W81 WTR AMT GE 100,000"                           format=f1.
      ER37664   LABEL="W82 WTR AMT GE 10,000"                            format=f1.
      ER37665   LABEL="W83 WTR BOUGHT NON-IRA STOCK"                     format=f1.
      ER37666   LABEL="W84 WTR ALSO SOLD STOCK"                          format=f1.
      ER37667   LABEL="W85 WTR BOUGHT MORE/SOLD MORE"                    format=f1.
      ER37668   LABEL="W86 BALANCE IN/OUT STOCKS"                        format=f9.
      ER37669   LABEL="W87 WTR STOCKS GE 20,000"                         format=f1.
      ER37670   LABEL="W88 WTR STOCKS GE 50,000"                         format=f1.
      ER37671   LABEL="W90 WTR STOCKS GE 100,000"                        format=f1.
      ER37672   LABEL="W89 WTR STOCKS GE 5,000"                          format=f1.
      ER37673   LABEL="W91 AMT INVESTED IN STOCKS"                       format=f9.
      ER37674   LABEL="W92 WTR AMT GE 20,000"                            format=f1.
      ER37675   LABEL="W93 WTR AMT GE 50,000"                            format=f1.
      ER37676   LABEL="W94 WTR AMT GE 100,000"                           format=f1.
      ER37677   LABEL="W95 WTR AMT GE 5,000"                             format=f1.
      ER37678   LABEL="W96 WTR SOLD NON-IRA STOCK"                       format=f1.
      ER37679   LABEL="W97 AMT NON-IRA STOCK"                            format=f9.
      ER37680   LABEL="W98 WTR AMT GE 20,000"                            format=f1.
      ER37681   LABEL="W99 WTR AMT GE 50,000"                            format=f1.
      ER37682   LABEL="W100 WTR AMT GE 100,000"                          format=f1.
      ER37683   LABEL="W101 WTR AMT GE 5,000"                            format=f1.
      ER37684   LABEL="W102 WTR MOVER OUT W/ASSETS"                      format=f1.
      ER37685   LABEL="W103 VALUE ASSETS MOVED OUT"                      format=f9.
      ER37686   LABEL="W104 WTR VALUE GE 10,000"                         format=f1.
      ER37687   LABEL="W105 WTR VALUE GE 25,000"                         format=f1.
      ER37688   LABEL="W106 WTR VALUE GE 100,000"                        format=f1.
      ER37689   LABEL="W107 WTR VALUE GE 5,000"                          format=f1.
      ER37690   LABEL="W108 VALUE DEBTS MOVED OUT"                       format=f9.
      ER37691   LABEL="W109 WTR VALUE GE 10,000"                         format=f1.
      ER37692   LABEL="W110 WTR VALUE GE 25,000"                         format=f1.
      ER37693   LABEL="W111 WTR VALUE GE 5,000"                          format=f1.
      ER37694   LABEL="W112 CKPT: FU COMPOSITION"                        format=f1.
      ER37695   LABEL="W113 WTR MOVER IN ASSETS"                         format=f1.
      ER37696   LABEL="W114 VALUE ASSETS MOVED IN"                       format=f9.
      ER37697   LABEL="W115 WTR VALUE GE 10,000"                         format=f1.
      ER37698   LABEL="W116 WTR VALUE GE 25,000"                         format=f1.
      ER37699   LABEL="W117 WTR VALUE GE 100,000"                        format=f1.
      ER37700   LABEL="W118 WTR VALUE GE 5,000"                          format=f1.
      ER37701   LABEL="W119 VALUE DEBTS MOVE IN"                         format=f9.
      ER37702   LABEL="W120 WTR VALUE GE 10,000"                         format=f1.
      ER37703   LABEL="W121 WTR VALUE GE 25,000"                         format=f1.
      ER37704   LABEL="W122 WTR VALUE GE 5,000"                          format=f1.
      ER37705   LABEL="W123 WTR RECD GIFT/INHERITANCE"                   format=f1.
      ER37706   LABEL="W124 YR RECD GIFT/INHERIT-#1"                     format=f4.
      ER37707   LABEL="W125 VALUE GIFT/INHERIT-#1"                       format=f9.
      ER37708   LABEL="W126 WTR VALUE GE 25,000-#1"                      format=f1.
      ER37709   LABEL="W127 WTR VALUE GE 75,000-#1"                      format=f1.
      ER37710   LABEL="W123 WTR GIFT/INHERITANCE-#2"                     format=f1.
      ER37711   LABEL="W124 YR RECD GIFT/INHERIT-#2"                     format=f4.
      ER37712   LABEL="W125 VALUE GIFT/INHERIT-#2"                       format=f9.
      ER37713   LABEL="W126 WTR VALUE GE 25,000-#2"                      format=f1.
      ER37714   LABEL="W127 WTR VALUE GE 75,000-#2"                      format=f1.
      ER37715   LABEL="W123 WTR GIFT/INHERITANCE-#3"                     format=f1.
      ER37716   LABEL="W124 YR REC GIFT/INHERIT-#3"                      format=f4.
      ER37717   LABEL="W125 VALUE GIFT/INHERIT-#3"                       format=f9.
      ER37718   LABEL="W126 WTR VALUE GE 25,000-#3"                      format=f1.
      ER37719   LABEL="W127 WTR VALUE GE 75,000-#3"                      format=f1.
      ER37720   LABEL="W129 HOW IMPORTANT LV ESTATE TO RELS"             format=f1.
      ER37721   LABEL="W130 HOW IMPORTANT LV ESTATE TO REL ORG"          format=f1.
      ER37722   LABEL="W131 HOW IMPORTANT LV ESTATE TO CHARITY"          format=f1.
      ER37723   LABEL="W132 HOW IMPORTANT PAY 4 CHILD EDUC"              format=f1.
      ER37724   LABEL="W133 NUMBER LIVING CHILDREN UNDER 30"             format=f2.
      ER37725   LABEL="W134 EARNINGS EXPECTATIONS FOR CHILD--1"          format=f1.
      ER37726   LABEL="W134 EARNINGS EXPECTATIONS FOR CHILD--2"          format=f1.
      ER37727   LABEL="W134 EARNINGS EXPECTATIONS FOR CHILD--3"          format=f1.
      ER37728   LABEL="W135 PARENTS POOR OR?--HD"                        format=f1.
      ER37729   LABEL="W136 PARENTS POOR OR?--WF"                        format=f1.
      ER37730   LABEL="W137 PARENTS STILL LIVING?--HD"                   format=f1.
      ER37731   LABEL="W138 PARENTS STILL LIVING?--WF"                   format=f1.
      ER37732   LABEL="W139 WTR GAVE SUPPORT TO PARENTS"                 format=f1.
      ER37733   LABEL="W140 WTR WILL GIVE SUPPORT TO PARENTS"            format=f1.
      ER37734   LABEL="W141 WTR CARED FOR PARENTS"                       format=f1.
      ER37735   LABEL="W142 WTR WILL CARE FOR PARENTS"                   format=f1.
      ER37736   LABEL="W143 WTR PARENTS EVER LIVED WITH H/W"             format=f1.
      ER37737   LABEL="W144 WTR PARENTS WILL LIVE WITH H/W"              format=f1.
      ER37738   LABEL="P0 WTR WORKING NOW"                               format=f1.
      ER37739   LABEL="P1 WTR PNSN AT CURR JOB"                          format=f1.
      ER37740   LABEL="P6 # YRS IN PENSION PLAN"                         format=f2.
      ER37741   LABEL="P6 YR JOINED PENSION PLAN"                        format=f4.
      ER37742   LABEL="P7 WTR EVER ELIG FOR PLAN"                        format=f1.
      ER37743   LABEL="P8 # YRS TILL ELIGIBLE"                           format=f3.
      ER37744   LABEL="P9 WTR VESTED"                                    format=f1.
      ER37745   LABEL="P10 # YRS TILL VESTED"                            format=f3.
      ER37746   LABEL="P11 WTR CONTRIB TO PENSION"                       format=f1.
      ER37747   LABEL="P12 WTR CONTRIB REQUIRED"                         format=f1.
      ER37748   LABEL="P13 REQUIRED AMT"                                 format=f7.
      ER37749   LABEL="P13 REQUIRED AMT PER"                             format=f1.
      ER37750   LABEL="P13 REQUIRED PCT"                                 format=f3.
      ER37751   LABEL="P14 WTR VOLUNTARY CONTRIB"                        format=f1.
      ER37752   LABEL="P15 VOLUNTARY AMT"                                format=f7.
      ER37753   LABEL="P15 VOLUNTARY AMT PER"                            format=f1.
      ER37754   LABEL="P15 VOLUNTARY PCT"                                format=f3.
      ER37755   LABEL="P16 HOW BENEFIT FIGURED"                          format=f1.
      ER37756   LABEL="P17 WTR EMPLYR CONTRIB"                           format=f1.
      ER37757   LABEL="P18 AMT EMPLYR CONTRIB"                           format=f7.
      ER37758   LABEL="P18 EMPLYR AMT PER"                               format=f1.
      ER37759   LABEL="P18 PCT EMPLYR CONTRIB"                           format=f3.
      ER37760   LABEL="P19 AGE PENSION INCL EMPLYR CONTRIB"              format=f3.
      ER37761   LABEL="P20 AMT IN PENSION ACCT NOW"                      format=f9.
      ER37762   LABEL="P20B WTR AMT GE 10,000"                           format=f1.
      ER37763   LABEL="P20C WTR AMT GE 20,000"                           format=f1.
      ER37764   LABEL="P20D WTR AMT GE 50,000"                           format=f1.
      ER37765   LABEL="P20E WTR AMT GE 150,000"                          format=f1.
      ER37766   LABEL="P20A HOW FUNDS INVESTED"                          format=f1.
      ER37767   LABEL="P21 AMT COULD TAKE IF LEAVE EMPLYR"               format=f9.
      ER37768   LABEL="P21 AMT PER IF LEAVE EMPLYR"                      format=f1.
      ER37769   LABEL="P21 PCT COULD TAKE IF LEAVE EMPLYR"               format=f3.
      ER37770   LABEL="P22 CKPT: TYPE PENSION"                           format=f1.
      ER37771   LABEL="P23 BENEFIT FORMULA"                              format=f1.
      ER37772   LABEL="P24 AGE FULL BENEFITS"                            format=f3.
      ER37773   LABEL="P25 # YRS NEC FOR FULL BENEFITS"                  format=f3.
      ER37774   LABEL="P26 AGE IF AGE+YRS"                               format=f3.
      ER37775   LABEL="P26 # YRS IF AGE+YRS"                             format=f3.
      ER37776   LABEL="P27 WTR REC PART PNSN IF RETIRE EARLY"            format=f1.
      ER37777   LABEL="P28 EARLY RETRMT FORMULA"                         format=f1.
      ER37778   LABEL="P29 AGE ELIG PART BENEFITS"                       format=f3.
      ER37779   LABEL="P30 # YRS ELIG PART BENEFITS"                     format=f3.
      ER37780   LABEL="P31 AGE IF AGE+YRS"                               format=f3.
      ER37781   LABEL="P31 # YRS IF AGE+YRS"                             format=f3.
      ER37782   LABEL="P32 AGE EXPECT RECEIVE BENEFITS"                  format=f3.
      ER37783   LABEL="P33 WTR CAN ESTIMATE BENEFIT"                     format=f1.
      ER37784   LABEL="P34 ESTIMATED BENEFIT AMT"                        format=f7.
      ER37785   LABEL="P34 ESTIMATED BENEFIT PER"                        format=f1.
      ER37786   LABEL="P34 ESTIMATED BENEFIT PCT"                        format=f3.
      ER37787   LABEL="P34 ESTIMATED LUMP SUM BENEFIT"                   format=f9.
      ER37788   LABEL="P34B WTR AMT GE 1,000 PER MONTH"                  format=f1.
      ER37789   LABEL="P34C WTR AMT GE 2,000 PER MONTH"                  format=f1.
      ER37790   LABEL="P34D WTR AMT GE 3,000 PER MONTH"                  format=f1.
      ER37791   LABEL="P34E WTR AMT GE 500 PER MONTH"                    format=f1.
      ER37792   LABEL="P35 WTR BENEFICIARY"                              format=f1.
      ER37793   LABEL="P36 AMT BENEFICIARY RECEIVES"                     format=f1.
      ER37794   LABEL="P37 WTR PNSN LESSENED BY SOC SEC"                 format=f1.
      ER37795   LABEL="P38 WHEN SOC SEC CHG PNSN AMT"                    format=f1.
      ER37796   LABEL="P39 USUAL RETIREMNT AGE OF OTRS"                  format=f2.
      ER37797   LABEL="P39 USUAL # YRS OTRS RETIRE"                      format=f2.
      ER37798   LABEL="P40 AGE PLAN STOP WORK"                           format=f3.
      ER37799   LABEL="P40 YR PLAN STOP WORK"                            format=f4.
      ER37800   LABEL="P41 AGE WILL STOP WORK"                           format=f3.
      ER37801   LABEL="P41 YR WILL STOP WORK"                            format=f4.
      ER37802   LABEL="P42 WTR TAX-DEFER PLAN"                           format=f1.
      ER37803   LABEL="P43 WTR EMPLYR CONTRIB"                           format=f1.
      ER37804   LABEL="P44 AMT EMPLYR CONTRIB"                           format=f7.
      ER37805   LABEL="P44 EMPLYR CONTRIB PER"                           format=f1.
      ER37806   LABEL="P44 PCT EMPLYR CONTRIB"                           format=f3.
      ER37807   LABEL="P45 WTR PNSN W/PREV EMPLYR"                       format=f1.
      ER37808   LABEL="P46 TYPE PREV PENSION-#1"                         format=f1.
      ER37809   LABEL="P47 ACCT AMT WHEN LEFT PREV EMPLYR-#1"            format=f8.
      ER37810   LABEL="P47B WTR AMT GE 20,000-#1"                        format=f1.
      ER37811   LABEL="P47C WTR AMT GE 50,000-#1"                        format=f1.
      ER37812   LABEL="P47D WTR AMT GE 150,000-#1"                       format=f1.
      ER37813   LABEL="P47E WTR AMT GE 5,000-#1"                         format=f1.
      ER37814   LABEL="P48 WHAT DID W/PREV PNSN-#1"                      format=f1.
      ER37815   LABEL="P49 AMT NOW PREV PNSN ACCT-#1"                    format=f8.
      ER37816   LABEL="P49B WTR AMT GE 10,000-#1"                        format=f1.
      ER37817   LABEL="P49C WTR AMT GE 20,000-#1"                        format=f1.
      ER37818   LABEL="P49D WTR AMT GE 50,000-#1"                        format=f1.
      ER37819   LABEL="P49E WTR AMT GE 150,000-#1"                       format=f1.
      ER37820   LABEL="P50 AGE REC IF ANNUITY-#1"                        format=f2.
      ER37821   LABEL="P51 AMT PREV ANNUITY-#1"                          format=f7.
      ER37822   LABEL="P51 PREV ANNUITY PER-#1"                          format=f1.
      ER37823   LABEL="P51B WTR AMT GE 400 PER MONTH-#1"                 format=f1.
      ER37824   LABEL="P51C WTR AMT GE 1,200 PER MONTH-#1"               format=f1.
      ER37825   LABEL="P51D WTR AMT GE 1,600 PER MONTH-#1"               format=f1.
      ER37826   LABEL="P51E WTR AMT GE 200 PER MONTH-#1"                 format=f1.
      ER37827   LABEL="P52 STATUS PREV PNSN MEN1-#1"                     format=f1.
      ER37828   LABEL="P52 STATUS PREV PNSN MEN2-#1"                     format=f1.
      ER37829   LABEL="P52 STATUS PREV PNSN MEN3-#1"                     format=f1.
      ER37830   LABEL="P52 STATUS PREV PNSN MEN4-#1"                     format=f1.
      ER37831   LABEL="P52 STATUS PREV PNSN MEN5-#1"                     format=f1.
      ER37832   LABEL="P52 STATUS PREV PNSN MEN6-#1"                     format=f1.
      ER37833   LABEL="P53 MO REC PREV PNSN-#1"                          format=f2.
      ER37834   LABEL="P53 YR REC PREV PNSN-#1"                          format=f4.
      ER37835   LABEL="P54 PREV PNSN BENEFIT AMT-#1"                     format=f7.
      ER37836   LABEL="P54 BENEFIT PER-#1"                               format=f1.
      ER37837   LABEL="P54B WTR AMT GE 400 PER MONTH-#1"                 format=f1.
      ER37838   LABEL="P54C WTR AMT GE 1,200 PER MONTH-#1"               format=f1.
      ER37839   LABEL="P54D WTR AMT GE 1,600 PER MONTH-#1"               format=f1.
      ER37840   LABEL="P54E WTR AMT GE 200 PER MONTH-#1"                 format=f1.
      ER37841   LABEL="P55 WTR BENEFITS COLA-#1"                         format=f1.
      ER37842   LABEL="P56 WTR BENEFITS EVER COLA-#1"                    format=f1.
      ER37843   LABEL="P57 PREV PNSN CASH SETTLEMNT AMT-#1"              format=f7.
      ER37844   LABEL="P57B WTR AMT GE 6,000-#1"                         format=f1.
      ER37845   LABEL="P57C WTR AMT GE 60,000-#1"                        format=f1.
      ER37846   LABEL="P57D WTR AMT GE 250,000-#1"                       format=f1.
      ER37847   LABEL="P57E WTR AMT GE 2,000-#1"                         format=f1.
      ER37848   LABEL="P58 WHAT DID W/CASH MEN1-#1"                      format=f1.
      ER37849   LABEL="P58 WHAT DID W/CASH MEN2-#1"                      format=f1.
      ER37850   LABEL="P58 WHAT DID W/CASH MEN3-#1"                      format=f1.
      ER37851   LABEL="P58 WHAT DID W/CASH MEN4-#1"                      format=f1.
      ER37852   LABEL="P58 WHAT DID W/CASH MEN5-#1"                      format=f1.
      ER37853   LABEL="P58 WHAT DID W/CASH MEN6-#1"                      format=f1.
      ER37854   LABEL="P59 PREV PNSN IRA AMT-#1"                         format=f7.
      ER37855   LABEL="P59B WTR AMT GE 6,000-#1"                         format=f1.
      ER37856   LABEL="P59C WTR AMT GE 60,000-#1"                        format=f1.
      ER37857   LABEL="P59D WTR AMT GE 250,000-#1"                       format=f1.
      ER37858   LABEL="P59E WTR AMT GE 2,000-#1"                         format=f1.
      ER37859   LABEL="P60 # YRS IN PREV PLAN-#1"                        format=f2.
      ER37860   LABEL="P61 AGE EXPECT REC PREV PNSN-#1"                  format=f2.
      ER37861   LABEL="P62 AMT EXPECT REC PREV PNSN-#1"                  format=f6.
      ER37862   LABEL="P62 PREV PNSN PER-#1"                             format=f1.
      ER37863   LABEL="P62 PCT EXPECT REC PREV PNSN-#1"                  format=f3.
      ER37864   LABEL="P62 LUMP SUM EXPECT PREV PNSN-#1"                 format=f8.
      ER37865   LABEL="P62B WTR AMT GE 1,000-#1"                         format=f1.
      ER37866   LABEL="P62C WTR AMT GE 2,000-#1"                         format=f1.
      ER37867   LABEL="P62D WTR AMT GE 3,000-#1"                         format=f1.
      ER37868   LABEL="P62E WTR AMT GE 500-#1"                           format=f1.
      ER37869   LABEL="P63 ACCT AMT WHEN LEFT PREV EMPLYR-#1"            format=f7.
      ER37870   LABEL="P63B WTR AMT GE 20,000-#1"                        format=f1.
      ER37871   LABEL="P63C WTR AMT GE 50,000-#1"                        format=f1.
      ER37872   LABEL="P63D WTR AMT GE 150,000-#1"                       format=f1.
      ER37873   LABEL="P63E WTR AMT GE 5,000-#1"                         format=f1.
      ER37874   LABEL="P64 WHAT DID W/PREV PNSN-#1"                      format=f1.
      ER37875   LABEL="P65 ACCT AMT PREV PNSN NOW-#1"                    format=f8.
      ER37876   LABEL="P65B WTR AMT GE 10,000-#1"                        format=f1.
      ER37877   LABEL="P65C WTR AMT GE 20,000-#1"                        format=f1.
      ER37878   LABEL="P65D WTR AMT GE 50,000-#1"                        format=f1.
      ER37879   LABEL="P65E WTR AMT GE 150,000-#1"                       format=f1.
      ER37880   LABEL="P66 AGE BEGAN REC ANNUITY-#1"                     format=f2.
      ER37881   LABEL="P67 AMT PREV ANNUITY-#1"                          format=f7.
      ER37882   LABEL="P67 PREV ANNUITY PER-#1"                          format=f1.
      ER37883   LABEL="P67B WTR AMT GE 400 PER MONTH-#1"                 format=f1.
      ER37884   LABEL="P67C WTR AMT GE 1,200 PER MONTH-#1"               format=f1.
      ER37885   LABEL="P67D WTR AMT GE 1,600 PER MONTH-#1"               format=f1.
      ER37886   LABEL="P67E WTR AMT GE 200 PER MONTH-#1"                 format=f1.
      ER37887   LABEL="P68 AGE ELIG PREV PNSN-#1"                        format=f2.
      ER37888   LABEL="P69 WTR SECOND PREV PENSION"                      format=f1.
      ER37889   LABEL="P46 TYPE PREV PENSION-#2"                         format=f1.
      ER37890   LABEL="P47 ACCT AMT WHEN LEFT PREV EMPLYR-#2"            format=f8.
      ER37891   LABEL="P47B WTR AMT GE 20,000-#2"                        format=f1.
      ER37892   LABEL="P47C WTR AMT GE 50,000-#2"                        format=f1.
      ER37893   LABEL="P47D WTR AMT GE 150,000-#2"                       format=f1.
      ER37894   LABEL="P47E WTR AMT GE 5,000-#2"                         format=f1.
      ER37895   LABEL="P48 WHAT DID W/PREV PNSN-#2"                      format=f1.
      ER37896   LABEL="P49 AMT NOW PREV PNSN ACCT-#2"                    format=f8.
      ER37897   LABEL="P49B WTR AMT GE 10,000-#2"                        format=f1.
      ER37898   LABEL="P49C WTR AMT GE 20,000-#2"                        format=f1.
      ER37899   LABEL="P49D WTR AMT GE 50,000-#2"                        format=f1.
      ER37900   LABEL="P49E WTR AMT GE 150,000-#2"                       format=f1.
      ER37901   LABEL="P50 AGE REC IF ANNUITY-#2"                        format=f2.
      ER37902   LABEL="P51 AMT PREV ANNUITY-#2"                          format=f7.
      ER37903   LABEL="P51 PREV ANNUITY PER-#2"                          format=f1.
      ER37904   LABEL="P51B WTR AMT GE 400 PER MONTH-#2"                 format=f1.
      ER37905   LABEL="P51C WTR AMT GE 1,200 PER MONTH-#2"               format=f1.
      ER37906   LABEL="P51D WTR AMT GE 1,600 PER MONTH-#2"               format=f1.
      ER37907   LABEL="P51E WTR AMT GE 200 PER MONTH-#2"                 format=f1.
      ER37908   LABEL="P52 STATUS PREV PNSN MEN1-#2"                     format=f1.
      ER37909   LABEL="P52 STATUS PREV PNSN MEN2-#2"                     format=f1.
      ER37910   LABEL="P52 STATUS PREV PNSN MEN3-#2"                     format=f1.
      ER37911   LABEL="P52 STATUS PREV PNSN MEN4-#2"                     format=f1.
      ER37912   LABEL="P52 STATUS PREV PNSN MEN5-#2"                     format=f1.
      ER37913   LABEL="P52 STATUS PREV PNSN MEN6-#2"                     format=f1.
      ER37914   LABEL="P53 MO REC PREV PNSN-#2"                          format=f2.
      ER37915   LABEL="P53 YR REC PREV PNSN-#2"                          format=f4.
      ER37916   LABEL="P54 PREV PNSN BENEFIT AMT-#2"                     format=f7.
      ER37917   LABEL="P54 BENEFIT PER-#2"                               format=f1.
      ER37918   LABEL="P54B WTR AMT GE 400 PER MONTH-#2"                 format=f1.
      ER37919   LABEL="P54C WTR AMT GE 1,200 PER MONTH-#2"               format=f1.
      ER37920   LABEL="P54D WTR AMT GE 1,600 PER MONTH-#2"               format=f1.
      ER37921   LABEL="P54E WTR AMT GE 200 PER MONTH-#2"                 format=f1.
      ER37922   LABEL="P55 WTR BENEFITS COLA-#2"                         format=f1.
      ER37923   LABEL="P56 WTR BENEFITS EVER COLA-#2"                    format=f1.
      ER37924   LABEL="P57 PREV PNSN CASH SETTLEMNT AMT-#2"              format=f7.
      ER37925   LABEL="P57B WTR AMT GE 6,000-#2"                         format=f1.
      ER37926   LABEL="P57C WTR AMT GE 60,000-#2"                        format=f1.
      ER37927   LABEL="P57D WTR AMT GE 250,000-#2"                       format=f1.
      ER37928   LABEL="P57E WTR AMT GE 2,000-#2"                         format=f1.
      ER37929   LABEL="P58 WHAT DID W/CASH MEN1-#2"                      format=f1.
      ER37930   LABEL="P58 WHAT DID W/CASH MEN2-#2"                      format=f1.
      ER37931   LABEL="P58 WHAT DID W/CASH MEN3-#2"                      format=f1.
      ER37932   LABEL="P58 WHAT DID W/CASH MEN4-#2"                      format=f1.
      ER37933   LABEL="P58 WHAT DID W/CASH MEN5-#2"                      format=f1.
      ER37934   LABEL="P58 WHAT DID W/CASH MEN6-#2"                      format=f1.
      ER37935   LABEL="P59 PREV PNSN IRA AMT-#2"                         format=f7.
      ER37936   LABEL="P59B WTR AMT GE 6,000-#2"                         format=f1.
      ER37937   LABEL="P59C WTR AMT GE 60,000-#2"                        format=f1.
      ER37938   LABEL="P59D WTR AMT GE 250,000-#2"                       format=f1.
      ER37939   LABEL="P59E WTR AMT GE 2,000-#2"                         format=f1.
      ER37940   LABEL="P60 # YRS IN PREV PLAN-#2"                        format=f2.
      ER37941   LABEL="P61 AGE EXPECT REC PREV PNSN-#2"                  format=f2.
      ER37942   LABEL="P62 AMT EXPECT REC PREV PNSN-#2"                  format=f6.
      ER37943   LABEL="P62 PREV PNSN PER-#2"                             format=f1.
      ER37944   LABEL="P62 PCT EXPECT REC PREV PNSN-#2"                  format=f3.
      ER37945   LABEL="P62 LUMP SUM EXPECT PREV PNSN-#2"                 format=f8.
      ER37946   LABEL="P62B WTR AMT GE 1,000-#2"                         format=f1.
      ER37947   LABEL="P62C WTR AMT GE 2,000-#2"                         format=f1.
      ER37948   LABEL="P62D WTR AMT GE 3,000-#2"                         format=f1.
      ER37949   LABEL="P62E WTR AMT GE 500-#2"                           format=f1.
      ER37950   LABEL="P63 ACCT AMT WHEN LEFT PREV EMPLYR-#2"            format=f7.
      ER37951   LABEL="P63B WTR AMT GE 20,000-#2"                        format=f1.
      ER37952   LABEL="P63C WTR AMT GE 50,000-#2"                        format=f1.
      ER37953   LABEL="P63D WTR AMT GE 150,000-#2"                       format=f1.
      ER37954   LABEL="P63E WTR AMT GE 5,000-#2"                         format=f1.
      ER37955   LABEL="P64 WHAT DID W/PREV PNSN-#2"                      format=f1.
      ER37956   LABEL="P65 ACCT AMT PREV PNSN NOW-#2"                    format=f8.
      ER37957   LABEL="P65B WTR AMT GE 10,000-#2"                        format=f1.
      ER37958   LABEL="P65C WTR AMT GE 20,000-#2"                        format=f1.
      ER37959   LABEL="P65D WTR AMT GE 50,000-#2"                        format=f1.
      ER37960   LABEL="P65E WTR AMT GE 150,000-#2"                       format=f1.
      ER37961   LABEL="P66 AGE BEGAN REC ANNUITY-#2"                     format=f2.
      ER37962   LABEL="P67 AMT PREV ANNUITY-#2"                          format=f7.
      ER37963   LABEL="P67 PREV ANNUITY PER-#2"                          format=f1.
      ER37964   LABEL="P67B WTR AMT GE 400 PER MONTH-#2"                 format=f1.
      ER37965   LABEL="P67C WTR AMT GE 1,200 PER MONTH-#2"               format=f1.
      ER37966   LABEL="P67D WTR AMT GE 1,600 PER MONTH-#2"               format=f1.
      ER37967   LABEL="P67E WTR AMT GE 200 PER MONTH-#2"                 format=f1.
      ER37968   LABEL="P68 AGE ELIG PREV PNSN-#2"                        format=f2.
      ER37969   LABEL="P69 WTR 3RD PREV PENSION"                         format=f1.
      ER37970   LABEL="P70 WTR WORKING NOW"                              format=f1.
      ER37971   LABEL="P71 WTR PNSN AT CURR JOB"                         format=f1.
      ER37972   LABEL="P76 # YRS IN PENSION PLAN"                        format=f2.
      ER37973   LABEL="P76 YR JOINED PENSION PLAN"                       format=f4.
      ER37974   LABEL="P77 WTR EVER ELIG FOR PLAN"                       format=f1.
      ER37975   LABEL="P78 # YRS TILL ELIGIBLE"                          format=f3.
      ER37976   LABEL="P79 WTR VESTED"                                   format=f1.
      ER37977   LABEL="P80 # YRS TILL VESTED"                            format=f3.
      ER37978   LABEL="P81 WTR CONTRIB TO PENSION"                       format=f1.
      ER37979   LABEL="P82 WTR CONTRIB REQUIRED"                         format=f1.
      ER37980   LABEL="P83 REQUIRED AMT"                                 format=f7.
      ER37981   LABEL="P83 REQUIRED AMT PER"                             format=f1.
      ER37982   LABEL="P83 REQUIRED PCT"                                 format=f3.
      ER37983   LABEL="P84 WTR VOLUNTARY CONTRIB"                        format=f1.
      ER37984   LABEL="P85 VOLUNTARY AMT"                                format=f7.
      ER37985   LABEL="P85 VOLUNTARY AMT PER"                            format=f1.
      ER37986   LABEL="P85 VOLUNTARY PCT"                                format=f3.
      ER37987   LABEL="P86 HOW BENEFIT FIGURED"                          format=f1.
      ER37988   LABEL="P87 WTR EMPLYR CONTRIB"                           format=f1.
      ER37989   LABEL="P88 AMT EMPLYR CONTRIB"                           format=f7.
      ER37990   LABEL="P88 EMPLYR AMT PER"                               format=f1.
      ER37991   LABEL="P88 PCT EMPLYR CONTRIB"                           format=f3.
      ER37992   LABEL="P89 AGE PENSION INCL EMPLYR CONTRIB"              format=f3.
      ER37993   LABEL="P90 AMT IN PENSION ACCT NOW"                      format=f9.
      ER37994   LABEL="P90B WTR AMT GE 10,000"                           format=f1.
      ER37995   LABEL="P90C WTR AMT GE 20,000"                           format=f1.
      ER37996   LABEL="P90D WTR AMT GE 50,000"                           format=f1.
      ER37997   LABEL="P90E WTR AMT GE 150,000"                          format=f1.
      ER37998   LABEL="P90A HOW FUNDS INVESTED"                          format=f1.
      ER37999   LABEL="P91 AMT COULD TAKE IF LEAVE EMPLYR"               format=f9.
      ER38000   LABEL="P91 AMT PER IF LEAVE EMPLYR"                      format=f1.
      ER38001   LABEL="P91 PCT COULD TAKE IF LEAVE EMPLYR"               format=f3.
      ER38002   LABEL="P92 CKPT: TYPE PENSION"                           format=f1.
      ER38003   LABEL="P93 BENEFIT FORMULA"                              format=f1.
      ER38004   LABEL="P94 AGE FULL BENEFITS"                            format=f3.
      ER38005   LABEL="P95 # YRS NEC FOR FULL BENEFITS"                  format=f3.
      ER38006   LABEL="P96 AGE IF AGE+YRS"                               format=f3.
      ER38007   LABEL="P96 # YRS IF AGE+YRS"                             format=f3.
      ER38008   LABEL="P97 WTR REC PART PNSN IF RETIRE EARLY"            format=f1.
      ER38009   LABEL="P98 EARLY RETRMT FORMULA"                         format=f1.
      ER38010   LABEL="P99 AGE ELIG PART BENEFITS"                       format=f3.
      ER38011   LABEL="P100 # YRS ELIG PART BENEFITS"                    format=f3.
      ER38012   LABEL="P101 AGE IF AGE+YRS"                              format=f3.
      ER38013   LABEL="P101 # YRS IF AGE+YRS"                            format=f3.
      ER38014   LABEL="P102 AGE EXPECT RECEIVE BENEFITS"                 format=f3.
      ER38015   LABEL="P103 WTR CAN ESTIMATE BENEFIT"                    format=f1.
      ER38016   LABEL="P104 ESTIMATED BENEFIT AMT"                       format=f7.
      ER38017   LABEL="P104 ESTIMATED BENEFIT PER"                       format=f1.
      ER38018   LABEL="P104 ESTIMATED BENEFIT PCT"                       format=f3.
      ER38019   LABEL="P104 ESTIMATED LUMP SUM BENEFIT"                  format=f9.
      ER38020   LABEL="P104B WTR AMT GE 1,000 PER MONTH"                 format=f1.
      ER38021   LABEL="P104C WTR AMT GE 2,000 PER MONTH"                 format=f1.
      ER38022   LABEL="P104D WTR AMT GE 3,000 PER MONTH"                 format=f1.
      ER38023   LABEL="P104E WTR AMT GE 500 PER MONTH"                   format=f1.
      ER38024   LABEL="P105 WTR BENEFICIARY"                             format=f1.
      ER38025   LABEL="P106 AMT BENEFICIARY RECEIVES"                    format=f1.
      ER38026   LABEL="P107 WTR PNSN LESSENED BY SOC SEC"                format=f1.
      ER38027   LABEL="P108 WHEN SOC SEC CHG PNSN AMT"                   format=f1.
      ER38028   LABEL="P109 USUAL RETIRMNT AGE OF OTRS"                  format=f2.
      ER38029   LABEL="P109 USUAL # YRS OTRS RETIRE"                     format=f2.
      ER38030   LABEL="P110 AGE PLAN STOP WORK"                          format=f3.
      ER38031   LABEL="P110 YR PLAN STOP WORK"                           format=f4.
      ER38032   LABEL="P111 AGE WILL STOP WORK"                          format=f3.
      ER38033   LABEL="P111 YR WILL STOP WORK"                           format=f4.
      ER38034   LABEL="P112 WTR TAX-DEFER PLAN"                          format=f1.
      ER38035   LABEL="P113 WTR EMPLYR CONTRIB"                          format=f1.
      ER38036   LABEL="P114 AMT EMPLYR CONTRIB"                          format=f7.
      ER38037   LABEL="P114 EMPLYR CONTRIB PER"                          format=f1.
      ER38038   LABEL="P114 PCT EMPLYR CONTRIB"                          format=f3.
      ER38039   LABEL="P115 WTR PNSN W/PREV EMPLYR"                      format=f1.
      ER38040   LABEL="P116 TYPE PREV PENSION-#1"                        format=f1.
      ER38041   LABEL="P117 ACCT AMT WHEN LEFT PREV EMPLYR-#1"           format=f8.
      ER38042   LABEL="P117B WTR AMT GE 20,000-#1"                       format=f1.
      ER38043   LABEL="P117C WTR AMT GE 50,000-#1"                       format=f1.
      ER38044   LABEL="P117D WTR AMT GE 150,000-#1"                      format=f1.
      ER38045   LABEL="P117E WTR AMT GE 5,000-#1"                        format=f1.
      ER38046   LABEL="P118 WHAT DID W/PREV PNSN-#1"                     format=f1.
      ER38047   LABEL="P119 AMT NOW PREV PNSN ACCT-#1"                   format=f8.
      ER38048   LABEL="P119B WTR AMT GE 10,000-#1"                       format=f1.
      ER38049   LABEL="P119C WTR AMT GE 20,000-#1"                       format=f1.
      ER38050   LABEL="P119D WTR AMT GE 50,000-#1"                       format=f1.
      ER38051   LABEL="P119E WTR AMT GE 150,000-#1"                      format=f1.
      ER38052   LABEL="P120 AGE REC IF ANNUITY-#1"                       format=f2.
      ER38053   LABEL="P121 AMT PREV ANNUITY-#1"                         format=f7.
      ER38054   LABEL="P121 PREV ANNUITY PER-#1"                         format=f1.
      ER38055   LABEL="P121B WTR AMT GE 400 PER MONTH-#1"                format=f1.
      ER38056   LABEL="P121C WTR AMT GE 1,200 PER MONTH-#1"              format=f1.
      ER38057   LABEL="P121D WTR AMT GE 1,600 PER MONTH-#1"              format=f1.
      ER38058   LABEL="P121E WTR AMT GE 200 PER MONTH-#1"                format=f1.
      ER38059   LABEL="P122 STATUS PREV PNSN MEN1-#1"                    format=f1.
      ER38060   LABEL="P122 STATUS PREV PNSN MEN2-#1"                    format=f1.
      ER38061   LABEL="P122 STATUS PREV PNSN MEN3-#1"                    format=f1.
      ER38062   LABEL="P122 STATUS PREV PNSN MEN4-#1"                    format=f1.
      ER38063   LABEL="P122 STATUS PREV PNSN MEN5-#1"                    format=f1.
      ER38064   LABEL="P122 STATUS PREV PNSN MEN6-#1"                    format=f1.
      ER38065   LABEL="P123 MO REC PREV PNSN-#1"                         format=f2.
      ER38066   LABEL="P123 YR REC PREV PNSN-#1"                         format=f4.
      ER38067   LABEL="P124 PREV PNSN BENEFIT AMT-#1"                    format=f7.
      ER38068   LABEL="P124 BENEFIT PER-#1"                              format=f1.
      ER38069   LABEL="P124B WTR AMT GE 400 PER MONTH-#1"                format=f1.
      ER38070   LABEL="P124C WTR AMT GE 1,200 PER MONTH-#1"              format=f1.
      ER38071   LABEL="P124D WTR AMT GE 1,600 PER MONTH-#1"              format=f1.
      ER38072   LABEL="P124E WTR AMT GE 200 PER MONTH-#1"                format=f1.
      ER38073   LABEL="P125 WTR BENEFITS COLA-#1"                        format=f1.
      ER38074   LABEL="P126 WTR BENEFITS EVER COLA-#1"                   format=f1.
      ER38075   LABEL="P127 PREV PNSN CASH SETTLEMNT AMT-#1"             format=f7.
      ER38076   LABEL="P127B WTR AMT GE 6,000-#1"                        format=f1.
      ER38077   LABEL="P127C WTR AMT GE 60,000-#1"                       format=f1.
      ER38078   LABEL="P127D WTR AMT GE 250,000-#1"                      format=f1.
      ER38079   LABEL="P127E WTR AMT GE 2,000-#1"                        format=f1.
      ER38080   LABEL="P128 WHAT DID W/CASH MEN1-#1"                     format=f1.
      ER38081   LABEL="P128 WHAT DID W/CASH MEN2-#1"                     format=f1.
      ER38082   LABEL="P128 WHAT DID W/CASH MEN3-#1"                     format=f1.
      ER38083   LABEL="P128 WHAT DID W/CASH MEN4-#1"                     format=f1.
      ER38084   LABEL="P128 WHAT DID W/CASH MEN5-#1"                     format=f1.
      ER38085   LABEL="P128 WHAT DID W/CASH MEN6-#1"                     format=f1.
      ER38086   LABEL="P129 PREV PNSN IRA AMT-#1"                        format=f7.
      ER38087   LABEL="P129B WTR AMT GE 6,000-#1"                        format=f1.
      ER38088   LABEL="P129C WTR AMT GE 60,000-#1"                       format=f1.
      ER38089   LABEL="P129D WTR AMT GE 250,000-#1"                      format=f1.
      ER38090   LABEL="P129E WTR AMT GE 2,000-#1"                        format=f1.
      ER38091   LABEL="P130 # YRS IN PREV PLAN-#1"                       format=f2.
      ER38092   LABEL="P131 AGE EXPECT REC PREV PNSN-#1"                 format=f2.
      ER38093   LABEL="P132 AMT EXPECT REC PREV PNSN-#1"                 format=f6.
      ER38094   LABEL="P132 PREV PNSN PER-#1"                            format=f1.
      ER38095   LABEL="P132 PCT EXPECT REC PREV PNSN-#1"                 format=f3.
      ER38096   LABEL="P132 LUMP SUM EXPECT PREV PNSN-#1"                format=f8.
      ER38097   LABEL="P132B WTR AMT GE 1,000-#1"                        format=f1.
      ER38098   LABEL="P132C WTR AMT GE 2,000-#1"                        format=f1.
      ER38099   LABEL="P132D WTR AMT GE 3,000-#1"                        format=f1.
      ER38100   LABEL="P132E WTR AMT GE 500-#1"                          format=f1.
      ER38101   LABEL="P133 ACCT AMT WHEN LEFT PREV EMPLYR-#1"           format=f7.
      ER38102   LABEL="P133B WTR AMT GE 20,000-#1"                       format=f1.
      ER38103   LABEL="P133C WTR AMT GE 50,000-#1"                       format=f1.
      ER38104   LABEL="P133D WTR AMT GE 150,000-#1"                      format=f1.
      ER38105   LABEL="P133E WTR AMT GE 5,000-#1"                        format=f1.
      ER38106   LABEL="P134 WHAT DID W/PREV PNSN-#1"                     format=f1.
      ER38107   LABEL="P135 ACCT AMT PREV PNSN NOW-#1"                   format=f8.
      ER38108   LABEL="P135B WTR AMT GE 10,000-#1"                       format=f1.
      ER38109   LABEL="P135C WTR AMT GE 20,000-#1"                       format=f1.
      ER38110   LABEL="P135D WTR AMT GE 50,000-#1"                       format=f1.
      ER38111   LABEL="P135E WTR AMT GE 150,000-#1"                      format=f1.
      ER38112   LABEL="P136 AGE BEGAN REC ANNUITY-#1"                    format=f2.
      ER38113   LABEL="P137 AMT PREV ANNUITY-#1"                         format=f7.
      ER38114   LABEL="P137 PREV ANNUITY PER-#1"                         format=f1.
      ER38115   LABEL="P137B WTR AMT GE 400 PER MONTH-#1"                format=f1.
      ER38116   LABEL="P137C WTR AMT GE 1,200 PER MONTH-#1"              format=f1.
      ER38117   LABEL="P137D WTR AMT GE 1,600 PER MONTH-#1"              format=f1.
      ER38118   LABEL="P137E WTR AMT GE 200 PER MONTH-#1"                format=f1.
      ER38119   LABEL="P138 AGE ELIG PREV PNSN-#1"                       format=f2.
      ER38120   LABEL="P139 WTR SECOND PREV PENSION"                     format=f1.
      ER38121   LABEL="P116 TYPE PREV PENSION-#2"                        format=f1.
      ER38122   LABEL="P117 ACCT AMT WHEN LEFT PREV EMPLYR-#2"           format=f8.
      ER38123   LABEL="P117B WTR AMT GE 20,000-#2"                       format=f1.
      ER38124   LABEL="P117C WTR AMT GE 50,000-#2"                       format=f1.
      ER38125   LABEL="P117D WTR AMT GE 150,000-#2"                      format=f1.
      ER38126   LABEL="P117E WTR AMT GE 5,000-#2"                        format=f1.
      ER38127   LABEL="P118 WHAT DID W/PREV PNSN-#2"                     format=f1.
      ER38128   LABEL="P119 AMT NOW PREV PNSN ACCT-#2"                   format=f8.
      ER38129   LABEL="P119B WTR AMT GE 10,000-#2"                       format=f1.
      ER38130   LABEL="P119C WTR AMT GE 20,000-#2"                       format=f1.
      ER38131   LABEL="P119D WTR AMT GE 50,000-#2"                       format=f1.
      ER38132   LABEL="P119E WTR AMT GE 150,000-#2"                      format=f1.
      ER38133   LABEL="P120 AGE REC IF ANNUITY-#2"                       format=f2.
      ER38134   LABEL="P121 AMT PREV ANNUITY-#2"                         format=f7.
      ER38135   LABEL="P121 PREV ANNUITY PER-#2"                         format=f1.
      ER38136   LABEL="P121B WTR AMT GE 400 PER MONTH-#2"                format=f1.
      ER38137   LABEL="P121C WTR AMT GE 1,200 PER MONTH-#2"              format=f1.
      ER38138   LABEL="P121D WTR AMT GE 1,600 PER MONTH-#2"              format=f1.
      ER38139   LABEL="P121E WTR AMT GE 200 PER MONTH-#2"                format=f1.
      ER38140   LABEL="P122 STATUS PREV PNSN MEN1-#2"                    format=f1.
      ER38141   LABEL="P122 STATUS PREV PNSN MEN2-#2"                    format=f1.
      ER38142   LABEL="P122 STATUS PREV PNSN MEN3-#2"                    format=f1.
      ER38143   LABEL="P122 STATUS PREV PNSN MEN4-#2"                    format=f1.
      ER38144   LABEL="P122 STATUS PREV PNSN MEN5-#2"                    format=f1.
      ER38145   LABEL="P122 STATUS PREV PNSN MEN6-#2"                    format=f1.
      ER38146   LABEL="P123 MO REC PREV PNSN-#2"                         format=f2.
      ER38147   LABEL="P123 YR REC PREV PNSN-#2"                         format=f4.
      ER38148   LABEL="P124 PREV PNSN BENEFIT AMT-#2"                    format=f7.
      ER38149   LABEL="P124 BENEFIT PER-#2"                              format=f1.
      ER38150   LABEL="P124B WTR AMT GE 400 PER MONTH-#2"                format=f1.
      ER38151   LABEL="P124C WTR AMT GE 1,200 PER MONTH-#2"              format=f1.
      ER38152   LABEL="P124D WTR AMT GE 1,600 PER MONTH-#2"              format=f1.
      ER38153   LABEL="P124E WTR AMT GE 200 PER MONTH-#2"                format=f1.
      ER38154   LABEL="P125 WTR BENEFITS COLA-#2"                        format=f1.
      ER38155   LABEL="P126 WTR BENEFITS EVER COLA-#2"                   format=f1.
      ER38156   LABEL="P127 PREV PNSN CASH SETTLEMNT AMT-#2"             format=f7.
      ER38157   LABEL="P127B WTR AMT GE 6,000-#2"                        format=f1.
      ER38158   LABEL="P127C WTR AMT GE 60,000-#2"                       format=f1.
      ER38159   LABEL="P127D WTR AMT GE 250,000-#2"                      format=f1.
      ER38160   LABEL="P127E WTR AMT GE 2,000-#2"                        format=f1.
      ER38161   LABEL="P128 WHAT DID W/CASH MEN1-#2"                     format=f1.
      ER38162   LABEL="P128 WHAT DID W/CASH MEN2-#2"                     format=f1.
      ER38163   LABEL="P128 WHAT DID W/CASH MEN3-#2"                     format=f1.
      ER38164   LABEL="P128 WHAT DID W/CASH MEN4-#2"                     format=f1.
      ER38165   LABEL="P128 WHAT DID W/CASH MEN5-#2"                     format=f1.
      ER38166   LABEL="P128 WHAT DID W/CASH MEN6-#2"                     format=f1.
      ER38167   LABEL="P129 PREV PNSN IRA AMT-#2"                        format=f7.
      ER38168   LABEL="P129B WTR AMT GE 6,000-#2"                        format=f1.
      ER38169   LABEL="P129C WTR AMT GE 60,000-#2"                       format=f1.
      ER38170   LABEL="P129D WTR AMT GE 250,000-#2"                      format=f1.
      ER38171   LABEL="P129E WTR AMT GE 2,000-#2"                        format=f1.
      ER38172   LABEL="P130 # YRS IN PREV PLAN-#2"                       format=f2.
      ER38173   LABEL="P131 AGE EXPECT REC PREV PNSN-#2"                 format=f2.
      ER38174   LABEL="P132 AMT EXPECT REC PREV PNSN-#2"                 format=f6.
      ER38175   LABEL="P132 PREV PNSN PER-#2"                            format=f1.
      ER38176   LABEL="P132 PCT EXPECT REC PREV PNSN-#2"                 format=f3.
      ER38177   LABEL="P132 LUMP SUM EXPECT PREV PNSN-#2"                format=f8.
      ER38178   LABEL="P132B WTR AMT GE 1,000-#2"                        format=f1.
      ER38179   LABEL="P132C WTR AMT GE 2,000-#2"                        format=f1.
      ER38180   LABEL="P132D WTR AMT GE 3,000-#2"                        format=f1.
      ER38181   LABEL="P132E WTR AMT GE 500-#2"                          format=f1.
      ER38182   LABEL="P133 ACCT AMT WHEN LEFT PREV EMPLYR-#2"           format=f7.
      ER38183   LABEL="P133B WTR AMT GE 20,000-#2"                       format=f1.
      ER38184   LABEL="P133C WTR AMT GE 50,000-#2"                       format=f1.
      ER38185   LABEL="P133D WTR AMT GE 150,000-#2"                      format=f1.
      ER38186   LABEL="P133E WTR AMT GE 5,000-#2"                        format=f1.
      ER38187   LABEL="P134 WHAT DID W/PREV PNSN-#2"                     format=f1.
      ER38188   LABEL="P135 ACCT AMT PREV PNSN NOW-#2"                   format=f8.
      ER38189   LABEL="P135B WTR AMT GE 10,000-#2"                       format=f1.
      ER38190   LABEL="P135C WTR AMT GE 20,000-#2"                       format=f1.
      ER38191   LABEL="P135D WTR AMT GE 50,000-#2"                       format=f1.
      ER38192   LABEL="P135E WTR AMT GE 150,000-#2"                      format=f1.
      ER38193   LABEL="P136 AGE BEGAN REC ANNUITY-#2"                    format=f2.
      ER38194   LABEL="P137 AMT PREV ANNUITY-#2"                         format=f7.
      ER38195   LABEL="P137 PREV ANNUITY PER-#2"                         format=f1.
      ER38196   LABEL="P137B WTR AMT GE 400 PER MONTH-#2"                format=f1.
      ER38197   LABEL="P137C WTR AMT GE 1,200 PER MONTH-#2"              format=f1.
      ER38198   LABEL="P137D WTR AMT GE 1,600 PER MONTH-#2"              format=f1.
      ER38199   LABEL="P137E WTR AMT GE 200 PER MONTH-#2"                format=f1.
      ER38200   LABEL="P138 AGE ELIG PREV PNSN-#2"                       format=f2.
      ER38201   LABEL="P139 WTR 3RD PREV PENSION"                        format=f1.
      ER38202   LABEL="H1 HEALTH STATUS-HEAD"                            format=f1.
      ER38203   LABEL="H1A WTR HLTH BETTER/WORSE-HEAD"                   format=f1.
      ER38204   LABEL="H1B WTR HEALTH BETTER-HEAD"                       format=f1.
      ER38205   LABEL="H1C WTR HEALTH WORSE-HEAD"                        format=f1.
      ER38206   LABEL="H2 WTR LIMIT TYPE/AMT WRK- HEAD"                  format=f1.
      ER38207   LABEL="H3 WTR UNABLE TO DO SOME TYPES WORK-HD"           format=f1.
      ER38208   LABEL="H4 WTR LIMIT AMT WRK CAN DO-HEAD"                 format=f1.
      ER38209   LABEL="H5A WTR HAD STROKE-HEAD"                          format=f1.
      ER38210   LABEL="H6A1 AGE AT FIRST STROKE-HEAD"                    format=f3.
      ER38211   LABEL="H6A2 WTR SECOND STROKE-HEAD"                      format=f1.
      ER38212   LABEL="H7A WTR STROKE LIMIT DAILY ACTIVITY-HD"           format=f1.
      ER38213   LABEL="H5B WTR HEART ATTACK-HEAD"                        format=f1.
      ER38214   LABEL="H6B1 AGE AT FIRST HEART ATTACK-HD"                format=f3.
      ER38215   LABEL="H6B2 WTR SECOND HEART ATTACK-HD"                  format=f1.
      ER38216   LABEL="H7B WTR HEART ATTACK LIMIT ACTIVITY-HD"           format=f1.
      ER38217   LABEL="H5C WTR HEART DISEASE-HEAD"                       format=f1.
      ER38218   LABEL="H6C1 AGE FIRST HAD HEART DISEASE-HD"              format=f3.
      ER38219   LABEL="H6C2 WTR HRT DISEASE GOT WORSE-HD"                format=f1.
      ER38220   LABEL="H7C WTR HRT DISEASE LIMIT ACTIVITY-HD"            format=f1.
      ER38221   LABEL="H5D WTR HYPERTENSION-HEAD"                        format=f1.
      ER38222   LABEL="H6D1 AGE FIRST HAD HYPERTENSION-HD"               format=f3.
      ER38223   LABEL="H6D2 WTR HYPERTENSION GOT WORSE-HD"               format=f1.
      ER38224   LABEL="H7D WTR HYPERTENSION LIMIT ACTIVITY-HD"           format=f1.
      ER38225   LABEL="H5E WTR ASTHMA-HEAD"                              format=f1.
      ER38226   LABEL="H6E1 AGE FIRST HAD ASTHMA-HEAD"                   format=f3.
      ER38227   LABEL="H6E2 WTR ASTHMA GOT WORSE-HEAD"                   format=f1.
      ER38228   LABEL="H7E WTR ASTHMA LIMIT DAILY ACTIVITY-HD"           format=f1.
      ER38229   LABEL="H5F WTR LUNG DISEASE-HEAD"                        format=f1.
      ER38230   LABEL="H6F1 AGE FIRST HAD LUNG DISEASE-HD"               format=f3.
      ER38231   LABEL="H6F2 WTR LUNG DISEASE GOT WORSE-HD"               format=f1.
      ER38232   LABEL="H7F WTR LUNG DISEASE LIMIT ACTIVITY-HD"           format=f1.
      ER38233   LABEL="H5G WTR DIABETES-HEAD"                            format=f1.
      ER38234   LABEL="H6G1 AGE FIRST HAD DIABETES-HEAD"                 format=f3.
      ER38235   LABEL="H6G2 WTR DIABETES GOT WORSE-HEAD"                 format=f1.
      ER38236   LABEL="H7G WTR DIABETES LIMIT ACTIVITY-HD"               format=f1.
      ER38237   LABEL="H5H WTR ARTHRITIS-HEAD"                           format=f1.
      ER38238   LABEL="H6H1 AGE FIRST HAD ARTHRITIS-HEAD"                format=f3.
      ER38239   LABEL="H6H2 WTR ARTHRITIS GOT WORSE-HEAD"                format=f1.
      ER38240   LABEL="H7H WTR ARTHRITIS LIMIT ACTIVITY-HD"              format=f1.
      ER38241   LABEL="H5I WTR MEMORY LOSS-HEAD"                         format=f1.
      ER38242   LABEL="H6I1 AGE FIRST HAD MEMORY LOSS-HD"                format=f3.
      ER38243   LABEL="H6I2 WTR MEMORY LOSS GOT WORSE-HD"                format=f1.
      ER38244   LABEL="H7I WTR MEMORY LOSS LIMIT ACTIVITY-HD"            format=f1.
      ER38245   LABEL="H5J WTR LEARNING DISORDER-HEAD"                   format=f1.
      ER38246   LABEL="H6J1 AGE FIRST HAD LRNG DISORDER-HD"              format=f3.
      ER38247   LABEL="H6J2 WTR LRNG DISORDER GOT WORSE-HD"              format=f1.
      ER38248   LABEL="H7J WTR LRNG DISORDR LIMIT ACTIVITY-HD"           format=f1.
      ER38249   LABEL="H5K WTR CANCER-HEAD"                              format=f1.
      ER38250   LABEL="H6K1 AGE FIRST HAD CANCER-HEAD"                   format=f3.
      ER38251   LABEL="H6K2 WTR CANCER GOT WORSE-HEAD"                   format=f1.
      ER38252   LABEL="H6K3 WTR TREATING, RMSSN, OR CURED-HD"            format=f1.
      ER38253   LABEL="H6K4 TYPE OF CANCER MENTION 1-HEAD"               format=f2.
      ER38254   LABEL="H6K4 TYPE OF CANCER MENTION 2-HEAD"               format=f2.
      ER38255   LABEL="H7K WTR CANCER LIMIT ACTIVITY-HEAD"               format=f1.
      ER38256   LABEL="H5L WTR PSYCH PROBLEM-HEAD"                       format=f1.
      ER38257   LABEL="H6L1 AGE FIRST HAD PSYCH PROB-HEAD"               format=f3.
      ER38258   LABEL="H6L2 TYPE OF PSYCH PROB MENTION 1-HD"             format=f2.
      ER38259   LABEL="H6L2 TYPE OF PSYCH PROB MENTION 2-HD"             format=f2.
      ER38260   LABEL="H6L2 TYPE OF PSYCH PROB MENTION 3-HD"             format=f2.
      ER38261   LABEL="H6L3 WTR PSYCH PROB GOT WORSE-HD"                 format=f1.
      ER38262   LABEL="H7L WTR PSYCH PROB LIMIT ACTIVITY-HD"             format=f1.
      ER38263   LABEL="H5M WTR OTR CHRONIC CONDITION-HD"                 format=f1.
      ER38264   LABEL="H6M2 AGE FIRST HAD CHRON COND-HEAD"               format=f3.
      ER38265   LABEL="H6M3 WTR CHRON COND GOT WORSE-HD"                 format=f1.
      ER38266   LABEL="H7M WTR CHRON COND LIMIT ACTIVITY-HD"             format=f1.
      ER38267   LABEL="H8 WTR HOSPITALIZED IN 2004-HEAD"                 format=f1.
      ER38268   LABEL="H8A # NIGHTS IN HOSPITAL-HEAD"                    format=f3.
      ER38269   LABEL="H8A # WEEKS IN HOSPITAL-HEAD"                     format=f2.
      ER38270   LABEL="H9A WTR PROBLEM BATHING-HEAD"                     format=f1.
      ER38271   LABEL="H10A1 WTR SOMEONE HELPS BATHE-HD"                 format=f1.
      ER38272   LABEL="H10A2 WTR NEED EQUIP TO BATHE-HD"                 format=f1.
      ER38273   LABEL="H9B WTR PROBLEM DRESSING-HEAD"                    format=f1.
      ER38274   LABEL="H10B1 WTR SOMEONE HELPS DRESS-HD"                 format=f1.
      ER38275   LABEL="H10B2 WTR NEED EQUIP TO DRESS-HD"                 format=f1.
      ER38276   LABEL="H9C WTR PROBLEM EATING-HEAD"                      format=f1.
      ER38277   LABEL="H10C1 WTR SOMEONE HELPS EATNG-HD"                 format=f1.
      ER38278   LABEL="H10C2 WTR NEED EQUIP TO EAT-HD"                   format=f1.
      ER38279   LABEL="H9D WTR PROB GET IN/OUT BED/CHAIR-HD"             format=f1.
      ER38280   LABEL="H10D1 WTR SOMEONE HELPS BED/CHAIR-HD"             format=f1.
      ER38281   LABEL="H10D2 WTR NEED EQUIP FOR BED/CHAIR-HD"            format=f1.
      ER38282   LABEL="H9E WTR PROBLEM WALKING-HEAD"                     format=f1.
      ER38283   LABEL="H10E1 WTR SOMEONE HELPS WALK-HD"                  format=f1.
      ER38284   LABEL="H10E2 WTR NEED EQUIP TO WALK-HD"                  format=f1.
      ER38285   LABEL="H9F WTR PROBLEM GETTING OUTSIDE-HD"               format=f1.
      ER38286   LABEL="H10F1 WTR SOMEONE HELPS GET OUT-HD"               format=f1.
      ER38287   LABEL="H10F2 WTR NEED EQUIP TO GO OUTSIDE-HD"            format=f1.
      ER38288   LABEL="H9G WTR PROBLEM USE TOILET-HD"                    format=f1.
      ER38289   LABEL="H10G1 WTR SOMEONE HELPS TOILET-HD"                format=f1.
      ER38290   LABEL="H10G2 WTR NEED EQUIP TO USE TOILET-HD"            format=f1.
      ER38291   LABEL="H11A WTR DIFFICULT PREPARE MEALS-HD"              format=f1.
      ER38292   LABEL="H11B HEALTH/PHYSICAL PROBLEM?-HD"                 format=f1.
      ER38293   LABEL="H11C WTR DIFFICULT SHOPPING-HD"                   format=f1.
      ER38294   LABEL="H11D HEALTH/PHYSICAL PROBLEM?-HD"                 format=f1.
      ER38295   LABEL="H11E WTR DIFFICULT MANAGE MONEY-HD"               format=f1.
      ER38296   LABEL="H11F HEALTH/PHYSICAL PROBLEM?-HD"                 format=f1.
      ER38297   LABEL="H11G WTR TELEPHONE DIFFICULT-HD"                  format=f1.
      ER38298   LABEL="H11H HEALTH/PHYSICAL PROBLEM?-HD"                 format=f1.
      ER38299   LABEL="H11J WTR HEAVY HSWRK DIFFICULT-HD"                format=f1.
      ER38300   LABEL="H11K HEALTH/PHYSICAL PROBLEM?-HD"                 format=f1.
      ER38301   LABEL="H11L WTR LIGHT HSWRK DIFFICULT-HD"                format=f1.
      ER38302   LABEL="H11M HEALTH/PHYSICAL PROBLEM?-HD"                 format=f1.
      ER38303   LABEL="H12A FREQ OF HVY PHYSICAL ACTIVITY-HD"            format=f3.
      ER38304   LABEL="H12A TIME UNIT FOR HVY PHYS ACTIVITY-HD"          format=f1.
      ER38305   LABEL="H12B FREQ OF LITE PHYSICAL ACTIVITY-HD"           format=f3.
      ER38306   LABEL="H12B TIME UNIT FOR LITE PHYS ACTIVITY-HD"         format=f1.
      ER38307   LABEL="H12C FREQ OF STRENGTH PHYS ACTIVITY-HD"           format=f3.
      ER38308   LABEL="H12C TIME UNIT STRNGTH PHYS ACTVTY-HD"            format=f1.
      ER38309   LABEL="H13 WTR SMOKE CIGARETTES-HD"                      format=f1.
      ER38310   LABEL="H14 # CIGARETTES PER DAY-HD"                      format=f3.
      ER38311   LABEL="H15 AGE WHEN FIRST SMOKED-HD"                     format=f2.
      ER38312   LABEL="H16 WTR EVER SMOKED CIGARETTES-HD"                format=f1.
      ER38313   LABEL="H17 # CIGARETTES PER DAY-HD"                      format=f3.
      ER38314   LABEL="H18 AGE LAST SMOKED REGULARLY-HD"                 format=f2.
      ER38315   LABEL="H19 AGE FIRST SMOKED REGULARLY-HD"                format=f2.
      ER38316   LABEL="H20 WTR DRINK ALCOHOL-HEAD"                       format=f1.
      ER38317   LABEL="H21A HOW OFTEN HAVE DRINKS-HD"                    format=f1.
      ER38318   LABEL="H21B # ALCOHOLIC DRINKS PER DAY-HD"               format=f2.
      ER38319   LABEL="H21C # DAYS HAD 4-5 DRINKS-HEAD"                  format=f3.
      ER38320   LABEL="H22 WEIGHT-HEAD"                                  format=f3.
      ER38321   LABEL="H23 HEIGHT-FEET-HEAD"                             format=f1.
      ER38322   LABEL="H23 HEIGHT-INCHES-HEAD"                           format=f2.
      ER38323   LABEL="H25H HEALTH STATUS B4 AGE 17--HD"                 format=f1.
      ER38324   LABEL="H26H WTR MISSED MO OR MORE SCHOOL--HD"            format=f1.
      ER38325   LABEL="H27H WTR MEASLES B4 AGE 17--HD"                   format=f1.
      ER38326   LABEL="H28H WTR MUMPS B4 AGE 17--HD"                     format=f1.
      ER38327   LABEL="H29H WTR CHICKEN POX B4 AGE 17--HD"               format=f1.
      ER38328   LABEL="H30H WTR DIFF SEEING B4 AGE 17--HD"               format=f1.
      ER38329   LABEL="H31H PARENTS SMOKED B4 HD AGE 17?--HD"            format=f1.
      ER38330   LABEL="H32H WTR ASTHMA B4 AGE 17--HD"                    format=f1.
      ER38331   LABEL="H33H WTR DIABETES B4 AGE 17--HD"                  format=f1.
      ER38332   LABEL="H34H WTR RESP DIS B4 AGE 17--HD"                  format=f1.
      ER38333   LABEL="H35H WTR SPCH IMPAIR B4 AGE 17--HD"               format=f1.
      ER38334   LABEL="H36H WTR ALLERGY B4 AGE 17--HD"                   format=f1.
      ER38335   LABEL="H37H WTR HEART TRBL B4 AGE 17--HD"                format=f1.
      ER38336   LABEL="H38H WTR EAR PROB B4 AGE 17--HD"                  format=f1.
      ER38337   LABEL="H39H WTR EPILEPSY B4 AGE 17--HD"                  format=f1.
      ER38338   LABEL="H40H WTR HEADACHE B4 AGE 17--HD"                  format=f1.
      ER38339   LABEL="H41H WTR STOM PROB B4 AGE 17--HD"                 format=f1.
      ER38340   LABEL="H42H WTR HGH BLOOD PR B4 AGE 17--HD"              format=f1.
      ER38341   LABEL="H43H WTR DEPRESSION B4 AGE 17--HD"                format=f1.
      ER38342   LABEL="H44H WTR DRUG/AL PROB B4 AGE 17--HD"              format=f1.
      ER38343   LABEL="H45H WTR OTR PSYCH PROB B4 AGE 17--HD"            format=f1.
      ER38344   LABEL="HEHC SLF RPT: YEAR 1ST REPORT--HD"                format=f4.
      ER38345   LABEL="HEHC SLF RPT: PAR SEP B4 AGE 1--HD"               format=f1.
      ER38346   LABEL="HEHC SLF RPT: PAR SEP AGE 1--HD"                  format=f1.
      ER38347   LABEL="HEHC SLF RPT: PAR SEP AGE 2--HD"                  format=f1.
      ER38348   LABEL="HEHC SLF RPT: PAR SEP AGE 3--HD"                  format=f1.
      ER38349   LABEL="HEHC SLF RPT: PAR SEP AGE 4--HD"                  format=f1.
      ER38350   LABEL="HEHC SLF RPT: PAR SEP AGE 5--HD"                  format=f1.
      ER38351   LABEL="HEHC SLF RPT: PAR SEP AGE 6--HD"                  format=f1.
      ER38352   LABEL="HEHC SLF RPT: PAR SEP AGE 7--HD"                  format=f1.
      ER38353   LABEL="HEHC SLF RPT: PAR SEP AGE 8--HD"                  format=f1.
      ER38354   LABEL="HEHC SLF RPT: PAR SEP AGE 9--HD"                  format=f1.
      ER38355   LABEL="HEHC SLF RPT: PAR SEP AGE 10--HD"                 format=f1.
      ER38356   LABEL="HEHC SLF RPT: PAR SEP AGE 11--HD"                 format=f1.
      ER38357   LABEL="HEHC SLF RPT: PAR SEP AGE 12--HD"                 format=f1.
      ER38358   LABEL="HEHC SLF RPT: PAR SEP AGE 13--HD"                 format=f1.
      ER38359   LABEL="HEHC SLF RPT: PAR SEP AGE 14--HD"                 format=f1.
      ER38360   LABEL="HEHC SLF RPT: PAR SEP AGE 15--HD"                 format=f1.
      ER38361   LABEL="HEHC SLF RPT: PAR SEP AGE 16--HD"                 format=f1.
      ER38362   LABEL="HEHC SLF RPT: MOVE B4 AGE 1--HD"                  format=f1.
      ER38363   LABEL="HEHC SLF RPT: MOVE AGE 1--HD"                     format=f1.
      ER38364   LABEL="HEHC SLF RPT: MOVE AGE 2--HD"                     format=f1.
      ER38365   LABEL="HEHC SLF RPT: MOVE AGE 3--HD"                     format=f1.
      ER38366   LABEL="HEHC SLF RPT: MOVE AGE 4--HD"                     format=f1.
      ER38367   LABEL="HEHC SLF RPT: MOVE AGE 5--HD"                     format=f1.
      ER38368   LABEL="HEHC SLF RPT: MOVE AGE 6--HD"                     format=f1.
      ER38369   LABEL="HEHC SLF RPT: MOVE AGE 7--HD"                     format=f1.
      ER38370   LABEL="HEHC SLF RPT: MOVE AGE 8--HD"                     format=f1.
      ER38371   LABEL="HEHC SLF RPT: MOVE AGE 9--HD"                     format=f1.
      ER38372   LABEL="HEHC SLF RPT: MOVE AGE 10--HD"                    format=f1.
      ER38373   LABEL="HEHC SLF RPT: MOVE AGE 11--HD"                    format=f1.
      ER38374   LABEL="HEHC SLF RPT: MOVE AGE 12--HD"                    format=f1.
      ER38375   LABEL="HEHC SLF RPT: MOVE AGE 13--HD"                    format=f1.
      ER38376   LABEL="HEHC SLF RPT: MOVE AGE 14--HD"                    format=f1.
      ER38377   LABEL="HEHC SLF RPT: MOVE AGE 15--HD"                    format=f1.
      ER38378   LABEL="HEHC SLF RPT: MOVE AGE 16--HD"                    format=f1.
      ER38379   LABEL="HEHC SLF RPT: SCHOOL B4 AGE 1--HD"                format=f1.
      ER38380   LABEL="HEHC SLF RPT: SCHOOL AGE 1--HD"                   format=f1.
      ER38381   LABEL="HEHC SLF RPT: SCHOOL AGE 2--HD"                   format=f1.
      ER38382   LABEL="HEHC SLF RPT: SCHOOL AGE 3--HD"                   format=f1.
      ER38383   LABEL="HEHC SLF RPT: SCHOOL AGE 4--HD"                   format=f1.
      ER38384   LABEL="HEHC SLF RPT: SCHOOL AGE 5--HD"                   format=f1.
      ER38385   LABEL="HEHC SLF RPT: SCHOOL AGE 6--HD"                   format=f1.
      ER38386   LABEL="HEHC SLF RPT: SCHOOL AGE 7--HD"                   format=f1.
      ER38387   LABEL="HEHC SLF RPT: SCHOOL AGE 8--HD"                   format=f1.
      ER38388   LABEL="HEHC SLF RPT: SCHOOL AGE 9--HD"                   format=f1.
      ER38389   LABEL="HEHC SLF RPT: SCHOOL AGE 10--HD"                  format=f1.
      ER38390   LABEL="HEHC SLF RPT: SCHOOL AGE 11--HD"                  format=f1.
      ER38391   LABEL="HEHC SLF RPT: SCHOOL AGE 12--HD"                  format=f1.
      ER38392   LABEL="HEHC SLF RPT: SCHOOL AGE 13--HD"                  format=f1.
      ER38393   LABEL="HEHC SLF RPT: SCHOOL AGE 14--HD"                  format=f1.
      ER38394   LABEL="HEHC SLF RPT: SCHOOL AGE 15--HD"                  format=f1.
      ER38395   LABEL="HEHC SLF RPT: SCHOOL AGE 16--HD"                  format=f1.
      ER38396   LABEL="HEHC SLF RPT: ASTHMA B4 AGE 1--HD"                format=f1.
      ER38397   LABEL="HEHC SLF RPT: ASTHMA AGE 1--HD"                   format=f1.
      ER38398   LABEL="HEHC SLF RPT: ASTHMA AGE 2--HD"                   format=f1.
      ER38399   LABEL="HEHC SLF RPT: ASTHMA AGE 3--HD"                   format=f1.
      ER38400   LABEL="HEHC SLF RPT: ASTHMA AGE 4--HD"                   format=f1.
      ER38401   LABEL="HEHC SLF RPT: ASTHMA AGE 5--HD"                   format=f1.
      ER38402   LABEL="HEHC SLF RPT: ASTHMA AGE 6--HD"                   format=f1.
      ER38403   LABEL="HEHC SLF RPT: ASTHMA AGE 7--HD"                   format=f1.
      ER38404   LABEL="HEHC SLF RPT: ASTHMA AGE 8--HD"                   format=f1.
      ER38405   LABEL="HEHC SLF RPT: ASTHMA AGE 9--HD"                   format=f1.
      ER38406   LABEL="HEHC SLF RPT: ASTHMA AGE 10--HD"                  format=f1.
      ER38407   LABEL="HEHC SLF RPT: ASTHMA AGE 11--HD"                  format=f1.
      ER38408   LABEL="HEHC SLF RPT: ASTHMA AGE 12--HD"                  format=f1.
      ER38409   LABEL="HEHC SLF RPT: ASTHMA AGE 13--HD"                  format=f1.
      ER38410   LABEL="HEHC SLF RPT: ASTHMA AGE 14--HD"                  format=f1.
      ER38411   LABEL="HEHC SLF RPT: ASTHMA AGE 15--HD"                  format=f1.
      ER38412   LABEL="HEHC SLF RPT: ASTHMA AGE 16--HD"                  format=f1.
      ER38413   LABEL="HEHC SLF RPT: ASTHMA AGE 17+--HD"                 format=f1.
      ER38414   LABEL="HEHC SLF RPT: AGE END ASTHMA--HD"                 format=f3.
      ER38415   LABEL="HEHC SLF RPT: DIABETES B4 AGE 1--HD"              format=f1.
      ER38416   LABEL="HEHC SLF RPT: DIABETES AGE 1--HD"                 format=f1.
      ER38417   LABEL="HEHC SLF RPT: DIABETES AGE 2--HD"                 format=f1.
      ER38418   LABEL="HEHC SLF RPT: DIABETES AGE 3--HD"                 format=f1.
      ER38419   LABEL="HEHC SLF RPT: DIABETES AGE 4--HD"                 format=f1.
      ER38420   LABEL="HEHC SLF RPT: DIABETES AGE 5--HD"                 format=f1.
      ER38421   LABEL="HEHC SLF RPT: DIABETES AGE 6--HD"                 format=f1.
      ER38422   LABEL="HEHC SLF RPT: DIABETES AGE 7--HD"                 format=f1.
      ER38423   LABEL="HEHC SLF RPT: DIABETES AGE 8--HD"                 format=f1.
      ER38424   LABEL="HEHC SLF RPT: DIABETES AGE 9--HD"                 format=f1.
      ER38425   LABEL="HEHC SLF RPT: DIABETES AGE 10--HD"                format=f1.
      ER38426   LABEL="HEHC SLF RPT: DIABETES AGE 11--HD"                format=f1.
      ER38427   LABEL="HEHC SLF RPT: DIABETES AGE 12--HD"                format=f1.
      ER38428   LABEL="HEHC SLF RPT: DIABETES AGE 13--HD"                format=f1.
      ER38429   LABEL="HEHC SLF RPT: DIABETES AGE 14--HD"                format=f1.
      ER38430   LABEL="HEHC SLF RPT: DIABETES AGE 15--HD"                format=f1.
      ER38431   LABEL="HEHC SLF RPT: DIABETES AGE 16--HD"                format=f1.
      ER38432   LABEL="HEHC SLF RPT: DIABETES AGE 17+--HD"               format=f1.
      ER38433   LABEL="HEHC SLF RPT: AGE END DIABETES--HD"               format=f3.
      ER38434   LABEL="HEHC SLF RPT: RESP DIS B4 AGE 1--HD"              format=f1.
      ER38435   LABEL="HEHC SLF RPT: RESP DIS AGE 1--HD"                 format=f1.
      ER38436   LABEL="HEHC SLF RPT: RESP DIS AGE 2--HD"                 format=f1.
      ER38437   LABEL="HEHC SLF RPT: RESP DIS AGE 3--HD"                 format=f1.
      ER38438   LABEL="HEHC SLF RPT: RESP DIS AGE 4--HD"                 format=f1.
      ER38439   LABEL="HEHC SLF RPT: RESP DIS AGE 5--HD"                 format=f1.
      ER38440   LABEL="HEHC SLF RPT: RESP DIS AGE 6--HD"                 format=f1.
      ER38441   LABEL="HEHC SLF RPT: RESP DIS AGE 7--HD"                 format=f1.
      ER38442   LABEL="HEHC SLF RPT: RESP DIS AGE 8--HD"                 format=f1.
      ER38443   LABEL="HEHC SLF RPT: RESP DIS AGE 9--HD"                 format=f1.
      ER38444   LABEL="HEHC SLF RPT: RESP DIS AGE 10--HD"                format=f1.
      ER38445   LABEL="HEHC SLF RPT: RESP DIS AGE 11--HD"                format=f1.
      ER38446   LABEL="HEHC SLF RPT: RESP DIS AGE 12--HD"                format=f1.
      ER38447   LABEL="HEHC SLF RPT: RESP DIS AGE 13--HD"                format=f1.
      ER38448   LABEL="HEHC SLF RPT: RESP DIS AGE 14--HD"                format=f1.
      ER38449   LABEL="HEHC SLF RPT: RESP DIS AGE 15--HD"                format=f1.
      ER38450   LABEL="HEHC SLF RPT: RESP DIS AGE 16--HD"                format=f1.
      ER38451   LABEL="HEHC SLF RPT: RESP DIS AGE 17+--HD"               format=f1.
      ER38452   LABEL="HEHC SLF RPT: AGE END RESP DIS--HD"               format=f3.
      ER38453   LABEL="HEHC SLF RPT: SPCH IMPAIR B4 AGE 1--HD"           format=f1.
      ER38454   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 1--HD"              format=f1.
      ER38455   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 2--HD"              format=f1.
      ER38456   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 3--HD"              format=f1.
      ER38457   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 4--HD"              format=f1.
      ER38458   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 5--HD"              format=f1.
      ER38459   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 6--HD"              format=f1.
      ER38460   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 7--HD"              format=f1.
      ER38461   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 8--HD"              format=f1.
      ER38462   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 9--HD"              format=f1.
      ER38463   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 10--HD"             format=f1.
      ER38464   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 11--HD"             format=f1.
      ER38465   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 12--HD"             format=f1.
      ER38466   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 13--HD"             format=f1.
      ER38467   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 14--HD"             format=f1.
      ER38468   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 15--HD"             format=f1.
      ER38469   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 16--HD"             format=f1.
      ER38470   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 17+--HD"            format=f1.
      ER38471   LABEL="HEHC SLF RPT: AGE END SPCH IMPAIR--HD"            format=f3.
      ER38472   LABEL="HEHC SLF RPT: ALLERGY B4 AGE 1--HD"               format=f1.
      ER38473   LABEL="HEHC SLF RPT: ALLERGY AGE 1--HD"                  format=f1.
      ER38474   LABEL="HEHC SLF RPT: ALLERGY AGE 2--HD"                  format=f1.
      ER38475   LABEL="HEHC SLF RPT: ALLERGY AGE 3--HD"                  format=f1.
      ER38476   LABEL="HEHC SLF RPT: ALLERGY AGE 4--HD"                  format=f1.
      ER38477   LABEL="HEHC SLF RPT: ALLERGY AGE 5--HD"                  format=f1.
      ER38478   LABEL="HEHC SLF RPT: ALLERGY AGE 6--HD"                  format=f1.
      ER38479   LABEL="HEHC SLF RPT: ALLERGY AGE 7--HD"                  format=f1.
      ER38480   LABEL="HEHC SLF RPT: ALLERGY AGE 8--HD"                  format=f1.
      ER38481   LABEL="HEHC SLF RPT: ALLERGY AGE 9--HD"                  format=f1.
      ER38482   LABEL="HEHC SLF RPT: ALLERGY AGE 10--HD"                 format=f1.
      ER38483   LABEL="HEHC SLF RPT: ALLERGY AGE 11--HD"                 format=f1.
      ER38484   LABEL="HEHC SLF RPT: ALLERGY AGE 12--HD"                 format=f1.
      ER38485   LABEL="HEHC SLF RPT: ALLERGY AGE 13--HD"                 format=f1.
      ER38486   LABEL="HEHC SLF RPT: ALLERGY AGE 14--HD"                 format=f1.
      ER38487   LABEL="HEHC SLF RPT: ALLERGY AGE 15--HD"                 format=f1.
      ER38488   LABEL="HEHC SLF RPT: ALLERGY AGE 16--HD"                 format=f1.
      ER38489   LABEL="HEHC SLF RPT: ALLERGY AGE 17+--HD"                format=f1.
      ER38490   LABEL="HEHC SLF RPT: AGE END ALLERGY--HD"                format=f3.
      ER38491   LABEL="HEHC SLF RPT: HEART TRBL B4 AGE 1--HD"            format=f1.
      ER38492   LABEL="HEHC SLF RPT: HEART TRBL AGE 1--HD"               format=f1.
      ER38493   LABEL="HEHC SLF RPT: HEART TRBL AGE 2--HD"               format=f1.
      ER38494   LABEL="HEHC SLF RPT: HEART TRBL AGE 3--HD"               format=f1.
      ER38495   LABEL="HEHC SLF RPT: HEART TRBL AGE 4--HD"               format=f1.
      ER38496   LABEL="HEHC SLF RPT: HEART TRBL AGE 5--HD"               format=f1.
      ER38497   LABEL="HEHC SLF RPT: HEART TRBL AGE 6--HD"               format=f1.
      ER38498   LABEL="HEHC SLF RPT: HEART TRBL AGE 7--HD"               format=f1.
      ER38499   LABEL="HEHC SLF RPT: HEART TRBL AGE 8--HD"               format=f1.
      ER38500   LABEL="HEHC SLF RPT: HEART TRBL AGE 9--HD"               format=f1.
      ER38501   LABEL="HEHC SLF RPT: HEART TRBL AGE 10--HD"              format=f1.
      ER38502   LABEL="HEHC SLF RPT: HEART TRBL AGE 11--HD"              format=f1.
      ER38503   LABEL="HEHC SLF RPT: HEART TRBL AGE 12--HD"              format=f1.
      ER38504   LABEL="HEHC SLF RPT: HEART TRBL AGE 13--HD"              format=f1.
      ER38505   LABEL="HEHC SLF RPT: HEART TRBL AGE 14--HD"              format=f1.
      ER38506   LABEL="HEHC SLF RPT: HEART TRBL AGE 15--HD"              format=f1.
      ER38507   LABEL="HEHC SLF RPT: HEART TRBL AGE 16--HD"              format=f1.
      ER38508   LABEL="HEHC SLF RPT: HEART TRBL AGE 17+--HD"             format=f1.
      ER38509   LABEL="HEHC SLF RPT: AGE END HEART TRBL--HD"             format=f3.
      ER38510   LABEL="HEHC SLF RPT: EAR PROBS B4 AGE 1--HD"             format=f1.
      ER38511   LABEL="HEHC SLF RPT: EAR PROBS AGE 1--HD"                format=f1.
      ER38512   LABEL="HEHC SLF RPT: EAR PROBS AGE 2--HD"                format=f1.
      ER38513   LABEL="HEHC SLF RPT: EAR PROBS AGE 3--HD"                format=f1.
      ER38514   LABEL="HEHC SLF RPT: EAR PROBS AGE 4--HD"                format=f1.
      ER38515   LABEL="HEHC SLF RPT: EAR PROBS AGE 5--HD"                format=f1.
      ER38516   LABEL="HEHC SLF RPT: EAR PROBS AGE 6--HD"                format=f1.
      ER38517   LABEL="HEHC SLF RPT: EAR PROBS AGE 7--HD"                format=f1.
      ER38518   LABEL="HEHC SLF RPT: EAR PROBS AGE 8--HD"                format=f1.
      ER38519   LABEL="HEHC SLF RPT: EAR PROBS AGE 9--HD"                format=f1.
      ER38520   LABEL="HEHC SLF RPT: EAR PROBS AGE 10--HD"               format=f1.
      ER38521   LABEL="HEHC SLF RPT: EAR PROBS AGE 11--HD"               format=f1.
      ER38522   LABEL="HEHC SLF RPT: EAR PROBS AGE 12--HD"               format=f1.
      ER38523   LABEL="HEHC SLF RPT: EAR PROBS AGE 13--HD"               format=f1.
      ER38524   LABEL="HEHC SLF RPT: EAR PROBS AGE 14--HD"               format=f1.
      ER38525   LABEL="HEHC SLF RPT: EAR PROBS AGE 15--HD"               format=f1.
      ER38526   LABEL="HEHC SLF RPT: EAR PROBS AGE 16--HD"               format=f1.
      ER38527   LABEL="HEHC SLF RPT: EAR PROBS AGE 17+--HD"              format=f1.
      ER38528   LABEL="HEHC SLF RPT: AGE END EAR PROBS--HD"              format=f3.
      ER38529   LABEL="HEHC SLF RPT: EPILEPSY B4 AGE 1--HD"              format=f1.
      ER38530   LABEL="HEHC SLF RPT: EPILEPSY AGE 1--HD"                 format=f1.
      ER38531   LABEL="HEHC SLF RPT: EPILEPSY AGE 2--HD"                 format=f1.
      ER38532   LABEL="HEHC SLF RPT: EPILEPSY AGE 3--HD"                 format=f1.
      ER38533   LABEL="HEHC SLF RPT: EPILEPSY AGE 4--HD"                 format=f1.
      ER38534   LABEL="HEHC SLF RPT: EPILEPSY AGE 5--HD"                 format=f1.
      ER38535   LABEL="HEHC SLF RPT: EPILEPSY AGE 6--HD"                 format=f1.
      ER38536   LABEL="HEHC SLF RPT: EPILEPSY AGE 7--HD"                 format=f1.
      ER38537   LABEL="HEHC SLF RPT: EPILEPSY AGE 8--HD"                 format=f1.
      ER38538   LABEL="HEHC SLF RPT: EPILEPSY AGE 9--HD"                 format=f1.
      ER38539   LABEL="HEHC SLF RPT: EPILEPSY AGE 10--HD"                format=f1.
      ER38540   LABEL="HEHC SLF RPT: EPILEPSY AGE 11--HD"                format=f1.
      ER38541   LABEL="HEHC SLF RPT: EPILEPSY AGE 12--HD"                format=f1.
      ER38542   LABEL="HEHC SLF RPT: EPILEPSY AGE 13--HD"                format=f1.
      ER38543   LABEL="HEHC SLF RPT: EPILEPSY AGE 14--HD"                format=f1.
      ER38544   LABEL="HEHC SLF RPT: EPILEPSY AGE 15--HD"                format=f1.
      ER38545   LABEL="HEHC SLF RPT: EPILEPSY AGE 16--HD"                format=f1.
      ER38546   LABEL="HEHC SLF RPT: EPILEPSY AGE 17+--HD"               format=f1.
      ER38547   LABEL="HEHC SLF RPT: AGE END EPILEPSY--HD"               format=f3.
      ER38548   LABEL="HEHC SLF RPT: HEADACHE B4 AGE 1--HD"              format=f1.
      ER38549   LABEL="HEHC SLF RPT: HEADACHE AGE 1--HD"                 format=f1.
      ER38550   LABEL="HEHC SLF RPT: HEADACHE AGE 2--HD"                 format=f1.
      ER38551   LABEL="HEHC SLF RPT: HEADACHE AGE 3--HD"                 format=f1.
      ER38552   LABEL="HEHC SLF RPT: HEADACHE AGE 4--HD"                 format=f1.
      ER38553   LABEL="HEHC SLF RPT: HEADACHE AGE 5--HD"                 format=f1.
      ER38554   LABEL="HEHC SLF RPT: HEADACHE AGE 6--HD"                 format=f1.
      ER38555   LABEL="HEHC SLF RPT: HEADACHE AGE 7--HD"                 format=f1.
      ER38556   LABEL="HEHC SLF RPT: HEADACHE AGE 8--HD"                 format=f1.
      ER38557   LABEL="HEHC SLF RPT: HEADACHE AGE 9--HD"                 format=f1.
      ER38558   LABEL="HEHC SLF RPT: HEADACHE AGE 10--HD"                format=f1.
      ER38559   LABEL="HEHC SLF RPT: HEADACHE AGE 11--HD"                format=f1.
      ER38560   LABEL="HEHC SLF RPT: HEADACHE AGE 12--HD"                format=f1.
      ER38561   LABEL="HEHC SLF RPT: HEADACHE AGE 13--HD"                format=f1.
      ER38562   LABEL="HEHC SLF RPT: HEADACHE AGE 14--HD"                format=f1.
      ER38563   LABEL="HEHC SLF RPT: HEADACHE AGE 15--HD"                format=f1.
      ER38564   LABEL="HEHC SLF RPT: HEADACHE AGE 16--HD"                format=f1.
      ER38565   LABEL="HEHC SLF RPT: HEADACHE AGE 17+--HD"               format=f1.
      ER38566   LABEL="HEHC SLF RPT: AGE END HEADACHE--HD"               format=f3.
      ER38567   LABEL="HEHC SLF RPT: STOM PROB B4 AGE 1--HD"             format=f1.
      ER38568   LABEL="HEHC SLF RPT: STOM PROB AGE 1--HD"                format=f1.
      ER38569   LABEL="HEHC SLF RPT: STOM PROB AGE 2--HD"                format=f1.
      ER38570   LABEL="HEHC SLF RPT: STOM PROB AGE 3--HD"                format=f1.
      ER38571   LABEL="HEHC SLF RPT: STOM PROB AGE 4--HD"                format=f1.
      ER38572   LABEL="HEHC SLF RPT: STOM PROB AGE 5--HD"                format=f1.
      ER38573   LABEL="HEHC SLF RPT: STOM PROB AGE 6--HD"                format=f1.
      ER38574   LABEL="HEHC SLF RPT: STOM PROB AGE 7--HD"                format=f1.
      ER38575   LABEL="HEHC SLF RPT: STOM PROB AGE 8--HD"                format=f1.
      ER38576   LABEL="HEHC SLF RPT: STOM PROB AGE 9--HD"                format=f1.
      ER38577   LABEL="HEHC SLF RPT: STOM PROB AGE 10--HD"               format=f1.
      ER38578   LABEL="HEHC SLF RPT: STOM PROB AGE 11--HD"               format=f1.
      ER38579   LABEL="HEHC SLF RPT: STOM PROB AGE 12--HD"               format=f1.
      ER38580   LABEL="HEHC SLF RPT: STOM PROB AGE 13--HD"               format=f1.
      ER38581   LABEL="HEHC SLF RPT: STOM PROB AGE 14--HD"               format=f1.
      ER38582   LABEL="HEHC SLF RPT: STOM PROB AGE 15--HD"               format=f1.
      ER38583   LABEL="HEHC SLF RPT: STOM PROB AGE 16--HD"               format=f1.
      ER38584   LABEL="HEHC SLF RPT: STOM PROB AGE 17+--HD"              format=f1.
      ER38585   LABEL="HEHC SLF RPT: AGE END STOM PROB--HD"              format=f3.
      ER38586   LABEL="HEHC SLF RPT: HGH BLOOD PR B4 AGE 1--HD"          format=f1.
      ER38587   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 1--HD"             format=f1.
      ER38588   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 2--HD"             format=f1.
      ER38589   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 3--HD"             format=f1.
      ER38590   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 4--HD"             format=f1.
      ER38591   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 5--HD"             format=f1.
      ER38592   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 6--HD"             format=f1.
      ER38593   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 7--HD"             format=f1.
      ER38594   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 8--HD"             format=f1.
      ER38595   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 9--HD"             format=f1.
      ER38596   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 10--HD"            format=f1.
      ER38597   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 11--HD"            format=f1.
      ER38598   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 12--HD"            format=f1.
      ER38599   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 13--HD"            format=f1.
      ER38600   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 14--HD"            format=f1.
      ER38601   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 15--HD"            format=f1.
      ER38602   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 16--HD"            format=f1.
      ER38603   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 17+--HD"           format=f1.
      ER38604   LABEL="HEHC SLF RPT: AGE END HGH BLD PR--HD"             format=f3.
      ER38605   LABEL="HEHC SLF RPT: DEPRESSION B4 AGE 1--HD"            format=f1.
      ER38606   LABEL="HEHC SLF RPT: DEPRESSION AGE 1--HD"               format=f1.
      ER38607   LABEL="HEHC SLF RPT: DEPRESSION AGE 2--HD"               format=f1.
      ER38608   LABEL="HEHC SLF RPT: DEPRESSION AGE 3--HD"               format=f1.
      ER38609   LABEL="HEHC SLF RPT: DEPRESSION AGE 4--HD"               format=f1.
      ER38610   LABEL="HEHC SLF RPT: DEPRESSION AGE 5--HD"               format=f1.
      ER38611   LABEL="HEHC SLF RPT: DEPRESSION AGE 6--HD"               format=f1.
      ER38612   LABEL="HEHC SLF RPT: DEPRESSION AGE 7--HD"               format=f1.
      ER38613   LABEL="HEHC SLF RPT: DEPRESSION AGE 8--HD"               format=f1.
      ER38614   LABEL="HEHC SLF RPT: DEPRESSION AGE 9--HD"               format=f1.
      ER38615   LABEL="HEHC SLF RPT: DEPRESSION AGE 10--HD"              format=f1.
      ER38616   LABEL="HEHC SLF RPT: DEPRESSION AGE 11--HD"              format=f1.
      ER38617   LABEL="HEHC SLF RPT: DEPRESSION AGE 12--HD"              format=f1.
      ER38618   LABEL="HEHC SLF RPT: DEPRESSION AGE 13--HD"              format=f1.
      ER38619   LABEL="HEHC SLF RPT: DEPRESSION AGE 14--HD"              format=f1.
      ER38620   LABEL="HEHC SLF RPT: DEPRESSION AGE 15--HD"              format=f1.
      ER38621   LABEL="HEHC SLF RPT: DEPRESSION AGE 16--HD"              format=f1.
      ER38622   LABEL="HEHC SLF RPT: DEPRESSION AGE 17+--HD"             format=f1.
      ER38623   LABEL="HEHC SLF RPT: AGE END DEPRESSION--HD"             format=f3.
      ER38624   LABEL="HEHC SLF RPT: DRUG/AL PROB B4 AGE 1--HD"          format=f1.
      ER38625   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 1--HD"             format=f1.
      ER38626   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 2--HD"             format=f1.
      ER38627   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 3--HD"             format=f1.
      ER38628   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 4--HD"             format=f1.
      ER38629   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 5--HD"             format=f1.
      ER38630   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 6--HD"             format=f1.
      ER38631   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 7--HD"             format=f1.
      ER38632   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 8--HD"             format=f1.
      ER38633   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 9--HD"             format=f1.
      ER38634   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 10--HD"            format=f1.
      ER38635   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 11--HD"            format=f1.
      ER38636   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 12--HD"            format=f1.
      ER38637   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 13--HD"            format=f1.
      ER38638   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 14--HD"            format=f1.
      ER38639   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 15--HD"            format=f1.
      ER38640   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 16--HD"            format=f1.
      ER38641   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 17+--HD"           format=f1.
      ER38642   LABEL="HEHC SLF RPT: AGE END DRUG/AL PROB--HD"           format=f3.
      ER38643   LABEL="HEHC SLF RPT: OTR PSYCH PROB B4 AGE 1--H"         format=f1.
      ER38644   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 1--HD"           format=f1.
      ER38645   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 2--HD"           format=f1.
      ER38646   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 3--HD"           format=f1.
      ER38647   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 4--HD"           format=f1.
      ER38648   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 5--HD"           format=f1.
      ER38649   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 6--HD"           format=f1.
      ER38650   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 7--HD"           format=f1.
      ER38651   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 8--HD"           format=f1.
      ER38652   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 9--HD"           format=f1.
      ER38653   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 10--HD"          format=f1.
      ER38654   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 11--HD"          format=f1.
      ER38655   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 12--HD"          format=f1.
      ER38656   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 13--HD"          format=f1.
      ER38657   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 14--HD"          format=f1.
      ER38658   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 15--HD"          format=f1.
      ER38659   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 16--HD"          format=f1.
      ER38660   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 17+--HD"         format=f1.
      ER38661   LABEL="HEHC SLF RPT: AGE END OTR PSYCH PROB--HD"         format=f3.
      ER38662   LABEL="HEHC SP REPORT: YEAR 1ST REPORT--HD"              format=f4.
      ER38663   LABEL="HEHC SP RPT: PAR SEP B4 AGE 1--HD"                format=f1.
      ER38664   LABEL="HEHC SP RPT: PAR SEP AGE 1--HD"                   format=f1.
      ER38665   LABEL="HEHC SP RPT: PAR SEP AGE 2--HD"                   format=f1.
      ER38666   LABEL="HEHC SP RPT: PAR SEP AGE 3--HD"                   format=f1.
      ER38667   LABEL="HEHC SP RPT: PAR SEP AGE 4--HD"                   format=f1.
      ER38668   LABEL="HEHC SP RPT: PAR SEP AGE 5--HD"                   format=f1.
      ER38669   LABEL="HEHC SP RPT: PAR SEP AGE 6--HD"                   format=f1.
      ER38670   LABEL="HEHC SP RPT: PAR SEP AGE 7--HD"                   format=f1.
      ER38671   LABEL="HEHC SP RPT: PAR SEP AGE 8--HD"                   format=f1.
      ER38672   LABEL="HEHC SP RPT: PAR SEP AGE 9--HD"                   format=f1.
      ER38673   LABEL="HEHC SP RPT: PAR SEP AGE 10--HD"                  format=f1.
      ER38674   LABEL="HEHC SP RPT: PAR SEP AGE 11--HD"                  format=f1.
      ER38675   LABEL="HEHC SP RPT: PAR SEP AGE 12--HD"                  format=f1.
      ER38676   LABEL="HEHC SP RPT: PAR SEP AGE 13--HD"                  format=f1.
      ER38677   LABEL="HEHC SP RPT: PAR SEP AGE 14--HD"                  format=f1.
      ER38678   LABEL="HEHC SP RPT: PAR SEP AGE 15--HD"                  format=f1.
      ER38679   LABEL="HEHC SP RPT: PAR SEP AGE 16--HD"                  format=f1.
      ER38680   LABEL="HEHC SP RPT: MOVE B4 AGE 1--HD"                   format=f1.
      ER38681   LABEL="HEHC SP RPT: MOVE AGE 1--HD"                      format=f1.
      ER38682   LABEL="HEHC SP RPT: MOVE AGE 2--HD"                      format=f1.
      ER38683   LABEL="HEHC SP RPT: MOVE AGE 3--HD"                      format=f1.
      ER38684   LABEL="HEHC SP RPT: MOVE AGE 4--HD"                      format=f1.
      ER38685   LABEL="HEHC SP RPT: MOVE AGE 5--HD"                      format=f1.
      ER38686   LABEL="HEHC SP RPT: MOVE AGE 6--HD"                      format=f1.
      ER38687   LABEL="HEHC SP RPT: MOVE AGE 7--HD"                      format=f1.
      ER38688   LABEL="HEHC SP RPT: MOVE AGE 8--HD"                      format=f1.
      ER38689   LABEL="HEHC SP RPT: MOVE AGE 9--HD"                      format=f1.
      ER38690   LABEL="HEHC SP RPT: MOVE AGE 10--HD"                     format=f1.
      ER38691   LABEL="HEHC SP RPT: MOVE AGE 11--HD"                     format=f1.
      ER38692   LABEL="HEHC SP RPT: MOVE AGE 12--HD"                     format=f1.
      ER38693   LABEL="HEHC SP RPT: MOVE AGE 13--HD"                     format=f1.
      ER38694   LABEL="HEHC SP RPT: MOVE AGE 14--HD"                     format=f1.
      ER38695   LABEL="HEHC SP RPT: MOVE AGE 15--HD"                     format=f1.
      ER38696   LABEL="HEHC SP RPT: MOVE AGE 16--HD"                     format=f1.
      ER38697   LABEL="HEHC SP RPT: SCHOOL B4 AGE 1--HD"                 format=f1.
      ER38698   LABEL="HEHC SP RPT: SCHOOL AGE 1--HD"                    format=f1.
      ER38699   LABEL="HEHC SP RPT: SCHOOL AGE 2--HD"                    format=f1.
      ER38700   LABEL="HEHC SP RPT: SCHOOL AGE 3--HD"                    format=f1.
      ER38701   LABEL="HEHC SP RPT: SCHOOL AGE 4--HD"                    format=f1.
      ER38702   LABEL="HEHC SP RPT: SCHOOL AGE 5--HD"                    format=f1.
      ER38703   LABEL="HEHC SP RPT: SCHOOL AGE 6--HD"                    format=f1.
      ER38704   LABEL="HEHC SP RPT: SCHOOL AGE 7--HD"                    format=f1.
      ER38705   LABEL="HEHC SP RPT: SCHOOL AGE 8--HD"                    format=f1.
      ER38706   LABEL="HEHC SP RPT: SCHOOL AGE 9--HD"                    format=f1.
      ER38707   LABEL="HEHC SP RPT: SCHOOL AGE 10--HD"                   format=f1.
      ER38708   LABEL="HEHC SP RPT: SCHOOL AGE 11--HD"                   format=f1.
      ER38709   LABEL="HEHC SP RPT: SCHOOL AGE 12--HD"                   format=f1.
      ER38710   LABEL="HEHC SP RPT: SCHOOL AGE 13--HD"                   format=f1.
      ER38711   LABEL="HEHC SP RPT: SCHOOL AGE 14--HD"                   format=f1.
      ER38712   LABEL="HEHC SP RPT: SCHOOL AGE 15--HD"                   format=f1.
      ER38713   LABEL="HEHC SP RPT: SCHOOL AGE 16--HD"                   format=f1.
      ER38714   LABEL="HEHC SP RPT: ASTHMA B4 AGE 1--HD"                 format=f1.
      ER38715   LABEL="HEHC SP RPT: ASTHMA AGE 1--HD"                    format=f1.
      ER38716   LABEL="HEHC SP RPT: ASTHMA AGE 2--HD"                    format=f1.
      ER38717   LABEL="HEHC SP RPT: ASTHMA AGE 3--HD"                    format=f1.
      ER38718   LABEL="HEHC SP RPT: ASTHMA AGE 4--HD"                    format=f1.
      ER38719   LABEL="HEHC SP RPT: ASTHMA AGE 5--HD"                    format=f1.
      ER38720   LABEL="HEHC SP RPT: ASTHMA AGE 6--HD"                    format=f1.
      ER38721   LABEL="HEHC SP RPT: ASTHMA AGE 7--HD"                    format=f1.
      ER38722   LABEL="HEHC SP RPT: ASTHMA AGE 8--HD"                    format=f1.
      ER38723   LABEL="HEHC SP RPT: ASTHMA AGE 9--HD"                    format=f1.
      ER38724   LABEL="HEHC SP RPT: ASTHMA AGE 10--HD"                   format=f1.
      ER38725   LABEL="HEHC SP RPT: ASTHMA AGE 11--HD"                   format=f1.
      ER38726   LABEL="HEHC SP RPT: ASTHMA AGE 12--HD"                   format=f1.
      ER38727   LABEL="HEHC SP RPT: ASTHMA AGE 13--HD"                   format=f1.
      ER38728   LABEL="HEHC SP RPT: ASTHMA AGE 14--HD"                   format=f1.
      ER38729   LABEL="HEHC SP RPT: ASTHMA AGE 15--HD"                   format=f1.
      ER38730   LABEL="HEHC SP RPT: ASTHMA AGE 16--HD"                   format=f1.
      ER38731   LABEL="HEHC SP RPT: ASTHMA AGE 17+--HD"                  format=f1.
      ER38732   LABEL="HEHC SP RPT: AGE END ASTHMA--HD"                  format=f3.
      ER38733   LABEL="HEHC SP RPT: DIABETES B4 AGE 1--HD"               format=f1.
      ER38734   LABEL="HEHC SP RPT: DIABETES AGE 1--HD"                  format=f1.
      ER38735   LABEL="HEHC SP RPT: DIABETES AGE 2--HD"                  format=f1.
      ER38736   LABEL="HEHC SP RPT: DIABETES AGE 3--HD"                  format=f1.
      ER38737   LABEL="HEHC SP RPT: DIABETES AGE 4--HD"                  format=f1.
      ER38738   LABEL="HEHC SP RPT: DIABETES AGE 5--HD"                  format=f1.
      ER38739   LABEL="HEHC SP RPT: DIABETES AGE 6--HD"                  format=f1.
      ER38740   LABEL="HEHC SP RPT: DIABETES AGE 7--HD"                  format=f1.
      ER38741   LABEL="HEHC SP RPT: DIABETES AGE 8--HD"                  format=f1.
      ER38742   LABEL="HEHC SP RPT: DIABETES AGE 9--HD"                  format=f1.
      ER38743   LABEL="HEHC SP RPT: DIABETES AGE 10--HD"                 format=f1.
      ER38744   LABEL="HEHC SP RPT: DIABETES AGE 11--HD"                 format=f1.
      ER38745   LABEL="HEHC SP RPT: DIABETES AGE 12--HD"                 format=f1.
      ER38746   LABEL="HEHC SP RPT: DIABETES AGE 13--HD"                 format=f1.
      ER38747   LABEL="HEHC SP RPT: DIABETES AGE 14--HD"                 format=f1.
      ER38748   LABEL="HEHC SP RPT: DIABETES AGE 15--HD"                 format=f1.
      ER38749   LABEL="HEHC SP RPT: DIABETES AGE 16--HD"                 format=f1.
      ER38750   LABEL="HEHC SP RPT: DIABETES AGE 17+--HD"                format=f1.
      ER38751   LABEL="HEHC SP RPT: AGE END DIABETES--HD"                format=f3.
      ER38752   LABEL="HEHC SP RPT: RESP DIS B4 AGE 1--HD"               format=f1.
      ER38753   LABEL="HEHC SP RPT: RESP DIS AGE 1--HD"                  format=f1.
      ER38754   LABEL="HEHC SP RPT: RESP DIS AGE 2--HD"                  format=f1.
      ER38755   LABEL="HEHC SP RPT: RESP DIS AGE 3--HD"                  format=f1.
      ER38756   LABEL="HEHC SP RPT: RESP DIS AGE 4--HD"                  format=f1.
      ER38757   LABEL="HEHC SP RPT: RESP DIS AGE 5--HD"                  format=f1.
      ER38758   LABEL="HEHC SP RPT: RESP DIS AGE 6--HD"                  format=f1.
      ER38759   LABEL="HEHC SP RPT: RESP DIS AGE 7--HD"                  format=f1.
      ER38760   LABEL="HEHC SP RPT: RESP DIS AGE 8--HD"                  format=f1.
      ER38761   LABEL="HEHC SP RPT: RESP DIS AGE 9--HD"                  format=f1.
      ER38762   LABEL="HEHC SP RPT: RESP DIS AGE 10--HD"                 format=f1.
      ER38763   LABEL="HEHC SP RPT: RESP DIS AGE 11--HD"                 format=f1.
      ER38764   LABEL="HEHC SP RPT: RESP DIS AGE 12--HD"                 format=f1.
      ER38765   LABEL="HEHC SP RPT: RESP DIS AGE 13--HD"                 format=f1.
      ER38766   LABEL="HEHC SP RPT: RESP DIS AGE 14--HD"                 format=f1.
      ER38767   LABEL="HEHC SP RPT: RESP DIS AGE 15--HD"                 format=f1.
      ER38768   LABEL="HEHC SP RPT: RESP DIS AGE 16--HD"                 format=f1.
      ER38769   LABEL="HEHC SP RPT: RESP DIS AGE 17+--HD"                format=f1.
      ER38770   LABEL="HEHC SP RPT: AGE END RESP DIS--HD"                format=f3.
      ER38771   LABEL="HEHC SP RPT: SPCH IMPAIR B4 AGE 1--HD"            format=f1.
      ER38772   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 1--HD"               format=f1.
      ER38773   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 2--HD"               format=f1.
      ER38774   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 3--HD"               format=f1.
      ER38775   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 4--HD"               format=f1.
      ER38776   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 5--HD"               format=f1.
      ER38777   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 6--HD"               format=f1.
      ER38778   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 7--HD"               format=f1.
      ER38779   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 8--HD"               format=f1.
      ER38780   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 9--HD"               format=f1.
      ER38781   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 10--HD"              format=f1.
      ER38782   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 11--HD"              format=f1.
      ER38783   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 12--HD"              format=f1.
      ER38784   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 13--HD"              format=f1.
      ER38785   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 14--HD"              format=f1.
      ER38786   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 15--HD"              format=f1.
      ER38787   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 16--HD"              format=f1.
      ER38788   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 17+--HD"             format=f1.
      ER38789   LABEL="HEHC SP RPT: AGE END SPCH IMPAIR--HD"             format=f3.
      ER38790   LABEL="HEHC SP RPT: ALLERGY B4 AGE 1--HD"                format=f1.
      ER38791   LABEL="HEHC SP RPT: ALLERGY AGE 1--HD"                   format=f1.
      ER38792   LABEL="HEHC SP RPT: ALLERGY AGE 2--HD"                   format=f1.
      ER38793   LABEL="HEHC SP RPT: ALLERGY AGE 3--HD"                   format=f1.
      ER38794   LABEL="HEHC SP RPT: ALLERGY AGE 4--HD"                   format=f1.
      ER38795   LABEL="HEHC SP RPT: ALLERGY AGE 5--HD"                   format=f1.
      ER38796   LABEL="HEHC SP RPT: ALLERGY AGE 6--HD"                   format=f1.
      ER38797   LABEL="HEHC SP RPT: ALLERGY AGE 7--HD"                   format=f1.
      ER38798   LABEL="HEHC SP RPT: ALLERGY AGE 8--HD"                   format=f1.
      ER38799   LABEL="HEHC SP RPT: ALLERGY AGE 9--HD"                   format=f1.
      ER38800   LABEL="HEHC SP RPT: ALLERGY AGE 10--HD"                  format=f1.
      ER38801   LABEL="HEHC SP RPT: ALLERGY AGE 11--HD"                  format=f1.
      ER38802   LABEL="HEHC SP RPT: ALLERGY AGE 12--HD"                  format=f1.
      ER38803   LABEL="HEHC SP RPT: ALLERGY AGE 13--HD"                  format=f1.
      ER38804   LABEL="HEHC SP RPT: ALLERGY AGE 14--HD"                  format=f1.
      ER38805   LABEL="HEHC SP RPT: ALLERGY AGE 15--HD"                  format=f1.
      ER38806   LABEL="HEHC SP RPT: ALLERGY AGE 16--HD"                  format=f1.
      ER38807   LABEL="HEHC SP RPT: ALLERGY AGE 17+--HD"                 format=f1.
      ER38808   LABEL="HEHC SP RPT: AGE END ALLERGY--HD"                 format=f3.
      ER38809   LABEL="HEHC SP RPT: HEART TRBL B4 AGE 1--HD"             format=f1.
      ER38810   LABEL="HEHC SP RPT: HEART TRBL AGE 1--HD"                format=f1.
      ER38811   LABEL="HEHC SP RPT: HEART TRBL AGE 2--HD"                format=f1.
      ER38812   LABEL="HEHC SP RPT: HEART TRBL AGE 3--HD"                format=f1.
      ER38813   LABEL="HEHC SP RPT: HEART TRBL AGE 4--HD"                format=f1.
      ER38814   LABEL="HEHC SP RPT: HEART TRBL AGE 5--HD"                format=f1.
      ER38815   LABEL="HEHC SP RPT: HEART TRBL AGE 6--HD"                format=f1.
      ER38816   LABEL="HEHC SP RPT: HEART TRBL AGE 7--HD"                format=f1.
      ER38817   LABEL="HEHC SP RPT: HEART TRBL AGE 8--HD"                format=f1.
      ER38818   LABEL="HEHC SP RPT: HEART TRBL AGE 9--HD"                format=f1.
      ER38819   LABEL="HEHC SP RPT: HEART TRBL AGE 10--HD"               format=f1.
      ER38820   LABEL="HEHC SP RPT: HEART TRBL AGE 11--HD"               format=f1.
      ER38821   LABEL="HEHC SP RPT: HEART TRBL AGE 12--HD"               format=f1.
      ER38822   LABEL="HEHC SP RPT: HEART TRBL AGE 13--HD"               format=f1.
      ER38823   LABEL="HEHC SP RPT: HEART TRBL AGE 14--HD"               format=f1.
      ER38824   LABEL="HEHC SP RPT: HEART TRBL AGE 15--HD"               format=f1.
      ER38825   LABEL="HEHC SP RPT: HEART TRBL AGE 16--HD"               format=f1.
      ER38826   LABEL="HEHC SP RPT: HEART TRBL AGE 17+--HD"              format=f1.
      ER38827   LABEL="HEHC SP RPT: AGE END HEART TRBL--HD"              format=f3.
      ER38828   LABEL="HEHC SP RPT: EAR PROBS B4 AGE 1--HD"              format=f1.
      ER38829   LABEL="HEHC SP RPT: EAR PROBS AGE 1--HD"                 format=f1.
      ER38830   LABEL="HEHC SP RPT: EAR PROBS AGE 2--HD"                 format=f1.
      ER38831   LABEL="HEHC SP RPT: EAR PROBS AGE 3--HD"                 format=f1.
      ER38832   LABEL="HEHC SP RPT: EAR PROBS AGE 4--HD"                 format=f1.
      ER38833   LABEL="HEHC SP RPT: EAR PROBS AGE 5--HD"                 format=f1.
      ER38834   LABEL="HEHC SP RPT: EAR PROBS AGE 6--HD"                 format=f1.
      ER38835   LABEL="HEHC SP RPT: EAR PROBS AGE 7--HD"                 format=f1.
      ER38836   LABEL="HEHC SP RPT: EAR PROBS AGE 8--HD"                 format=f1.
      ER38837   LABEL="HEHC SP RPT: EAR PROBS AGE 9--HD"                 format=f1.
      ER38838   LABEL="HEHC SP RPT: EAR PROBS AGE 10--HD"                format=f1.
      ER38839   LABEL="HEHC SP RPT: EAR PROBS AGE 11--HD"                format=f1.
      ER38840   LABEL="HEHC SP RPT: EAR PROBS AGE 12--HD"                format=f1.
      ER38841   LABEL="HEHC SP RPT: EAR PROBS AGE 13--HD"                format=f1.
      ER38842   LABEL="HEHC SP RPT: EAR PROBS AGE 14--HD"                format=f1.
      ER38843   LABEL="HEHC SP RPT: EAR PROBS AGE 15--HD"                format=f1.
      ER38844   LABEL="HEHC SP RPT: EAR PROBS AGE 16--HD"                format=f1.
      ER38845   LABEL="HEHC SP RPT: EAR PROBS AGE 17+--HD"               format=f1.
      ER38846   LABEL="HEHC SP RPT: AGE END EAR PROBS--HD"               format=f3.
      ER38847   LABEL="HEHC SP RPT: EPILEPSY B4 AGE 1--HD"               format=f1.
      ER38848   LABEL="HEHC SP RPT: EPILEPSY AGE 1--HD"                  format=f1.
      ER38849   LABEL="HEHC SP RPT: EPILEPSY AGE 2--HD"                  format=f1.
      ER38850   LABEL="HEHC SP RPT: EPILEPSY AGE 3--HD"                  format=f1.
      ER38851   LABEL="HEHC SP RPT: EPILEPSY AGE 4--HD"                  format=f1.
      ER38852   LABEL="HEHC SP RPT: EPILEPSY AGE 5--HD"                  format=f1.
      ER38853   LABEL="HEHC SP RPT: EPILEPSY AGE 6--HD"                  format=f1.
      ER38854   LABEL="HEHC SP RPT: EPILEPSY AGE 7--HD"                  format=f1.
      ER38855   LABEL="HEHC SP RPT: EPILEPSY AGE 8--HD"                  format=f1.
      ER38856   LABEL="HEHC SP RPT: EPILEPSY AGE 9--HD"                  format=f1.
      ER38857   LABEL="HEHC SP RPT: EPILEPSY AGE 10--HD"                 format=f1.
      ER38858   LABEL="HEHC SP RPT: EPILEPSY AGE 11--HD"                 format=f1.
      ER38859   LABEL="HEHC SP RPT: EPILEPSY AGE 12--HD"                 format=f1.
      ER38860   LABEL="HEHC SP RPT: EPILEPSY AGE 13--HD"                 format=f1.
      ER38861   LABEL="HEHC SP RPT: EPILEPSY AGE 14--HD"                 format=f1.
      ER38862   LABEL="HEHC SP RPT: EPILEPSY AGE 15--HD"                 format=f1.
      ER38863   LABEL="HEHC SP RPT: EPILEPSY AGE 16--HD"                 format=f1.
      ER38864   LABEL="HEHC SP RPT: EPILEPSY AGE 17+--HD"                format=f1.
      ER38865   LABEL="HEHC SP RPT: AGE END EPILEPSY--HD"                format=f3.
      ER38866   LABEL="HEHC SP RPT: HEADACHE B4 AGE 1--HD"               format=f1.
      ER38867   LABEL="HEHC SP RPT: HEADACHE AGE 1--HD"                  format=f1.
      ER38868   LABEL="HEHC SP RPT: HEADACHE AGE 2--HD"                  format=f1.
      ER38869   LABEL="HEHC SP RPT: HEADACHE AGE 3--HD"                  format=f1.
      ER38870   LABEL="HEHC SP RPT: HEADACHE AGE 4--HD"                  format=f1.
      ER38871   LABEL="HEHC SP RPT: HEADACHE AGE 5--HD"                  format=f1.
      ER38872   LABEL="HEHC SP RPT: HEADACHE AGE 6--HD"                  format=f1.
      ER38873   LABEL="HEHC SP RPT: HEADACHE AGE 7--HD"                  format=f1.
      ER38874   LABEL="HEHC SP RPT: HEADACHE AGE 8--HD"                  format=f1.
      ER38875   LABEL="HEHC SP RPT: HEADACHE AGE 9--HD"                  format=f1.
      ER38876   LABEL="HEHC SP RPT: HEADACHE AGE 10--HD"                 format=f1.
      ER38877   LABEL="HEHC SP RPT: HEADACHE AGE 11--HD"                 format=f1.
      ER38878   LABEL="HEHC SP RPT: HEADACHE AGE 12--HD"                 format=f1.
      ER38879   LABEL="HEHC SP RPT: HEADACHE AGE 13--HD"                 format=f1.
      ER38880   LABEL="HEHC SP RPT: HEADACHE AGE 14--HD"                 format=f1.
      ER38881   LABEL="HEHC SP RPT: HEADACHE AGE 15--HD"                 format=f1.
      ER38882   LABEL="HEHC SP RPT: HEADACHE AGE 16--HD"                 format=f1.
      ER38883   LABEL="HEHC SP RPT: HEADACHE AGE 17+--HD"                format=f1.
      ER38884   LABEL="HEHC SP RPT: AGE END HEADACHE--HD"                format=f3.
      ER38885   LABEL="HEHC SP RPT: STOM PROB B4 AGE 1--HD"              format=f1.
      ER38886   LABEL="HEHC SP RPT: STOM PROB AGE 1--HD"                 format=f1.
      ER38887   LABEL="HEHC SP RPT: STOM PROB AGE 2--HD"                 format=f1.
      ER38888   LABEL="HEHC SP RPT: STOM PROB AGE 3--HD"                 format=f1.
      ER38889   LABEL="HEHC SP RPT: STOM PROB AGE 4--HD"                 format=f1.
      ER38890   LABEL="HEHC SP RPT: STOM PROB AGE 5--HD"                 format=f1.
      ER38891   LABEL="HEHC SP RPT: STOM PROB AGE 6--HD"                 format=f1.
      ER38892   LABEL="HEHC SP RPT: STOM PROB AGE 7--HD"                 format=f1.
      ER38893   LABEL="HEHC SP RPT: STOM PROB AGE 8--HD"                 format=f1.
      ER38894   LABEL="HEHC SP RPT: STOM PROB AGE 9--HD"                 format=f1.
      ER38895   LABEL="HEHC SP RPT: STOM PROB AGE 10--HD"                format=f1.
      ER38896   LABEL="HEHC SP RPT: STOM PROB AGE 11--HD"                format=f1.
      ER38897   LABEL="HEHC SP RPT: STOM PROB AGE 12--HD"                format=f1.
      ER38898   LABEL="HEHC SP RPT: STOM PROB AGE 13--HD"                format=f1.
      ER38899   LABEL="HEHC SP RPT: STOM PROB AGE 14--HD"                format=f1.
      ER38900   LABEL="HEHC SP RPT: STOM PROB AGE 15--HD"                format=f1.
      ER38901   LABEL="HEHC SP RPT: STOM PROB AGE 16--HD"                format=f1.
      ER38902   LABEL="HEHC SP RPT: STOM PROB AGE 17+--HD"               format=f1.
      ER38903   LABEL="HEHC SP RPT: AGE END STOM PROB--HD"               format=f3.
      ER38904   LABEL="HEHC SP RPT: HGH BLOOD PR B4 AGE 1--HD"           format=f1.
      ER38905   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 1--HD"              format=f1.
      ER38906   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 2--HD"              format=f1.
      ER38907   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 3--HD"              format=f1.
      ER38908   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 4--HD"              format=f1.
      ER38909   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 5--HD"              format=f1.
      ER38910   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 6--HD"              format=f1.
      ER38911   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 7--HD"              format=f1.
      ER38912   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 8--HD"              format=f1.
      ER38913   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 9--HD"              format=f1.
      ER38914   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 10--HD"             format=f1.
      ER38915   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 11--HD"             format=f1.
      ER38916   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 12--HD"             format=f1.
      ER38917   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 13--HD"             format=f1.
      ER38918   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 14--HD"             format=f1.
      ER38919   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 15--HD"             format=f1.
      ER38920   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 16--HD"             format=f1.
      ER38921   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 17+--HD"            format=f1.
      ER38922   LABEL="HEHC SP RPT: AGE END HGH BLD PR--HD"              format=f3.
      ER38923   LABEL="HEHC SP RPT: DEPRESSION B4 AGE 1--HD"             format=f1.
      ER38924   LABEL="HEHC SP RPT: DEPRESSION AGE 1--HD"                format=f1.
      ER38925   LABEL="HEHC SP RPT: DEPRESSION AGE 2--HD"                format=f1.
      ER38926   LABEL="HEHC SP RPT: DEPRESSION AGE 3--HD"                format=f1.
      ER38927   LABEL="HEHC SP RPT: DEPRESSION AGE 4--HD"                format=f1.
      ER38928   LABEL="HEHC SP RPT: DEPRESSION AGE 5--HD"                format=f1.
      ER38929   LABEL="HEHC SP RPT: DEPRESSION AGE 6--HD"                format=f1.
      ER38930   LABEL="HEHC SP RPT: DEPRESSION AGE 7--HD"                format=f1.
      ER38931   LABEL="HEHC SP RPT: DEPRESSION AGE 8--HD"                format=f1.
      ER38932   LABEL="HEHC SP RPT: DEPRESSION AGE 9--HD"                format=f1.
      ER38933   LABEL="HEHC SP RPT: DEPRESSION AGE 10--HD"               format=f1.
      ER38934   LABEL="HEHC SP RPT: DEPRESSION AGE 11--HD"               format=f1.
      ER38935   LABEL="HEHC SP RPT: DEPRESSION AGE 12--HD"               format=f1.
      ER38936   LABEL="HEHC SP RPT: DEPRESSION AGE 13--HD"               format=f1.
      ER38937   LABEL="HEHC SP RPT: DEPRESSION AGE 14--HD"               format=f1.
      ER38938   LABEL="HEHC SP RPT: DEPRESSION AGE 15--HD"               format=f1.
      ER38939   LABEL="HEHC SP RPT: DEPRESSION AGE 16--HD"               format=f1.
      ER38940   LABEL="HEHC SP RPT: DEPRESSION AGE 17+--HD"              format=f1.
      ER38941   LABEL="HEHC SP RPT: AGE END DEPRESSION--HD"              format=f3.
      ER38942   LABEL="HEHC SP RPT: DRUG/AL PROB B4 AGE 1--HD"           format=f1.
      ER38943   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 1--HD"              format=f1.
      ER38944   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 2--HD"              format=f1.
      ER38945   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 3--HD"              format=f1.
      ER38946   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 4--HD"              format=f1.
      ER38947   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 5--HD"              format=f1.
      ER38948   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 6--HD"              format=f1.
      ER38949   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 7--HD"              format=f1.
      ER38950   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 8--HD"              format=f1.
      ER38951   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 9--HD"              format=f1.
      ER38952   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 10--HD"             format=f1.
      ER38953   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 11--HD"             format=f1.
      ER38954   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 12--HD"             format=f1.
      ER38955   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 13--HD"             format=f1.
      ER38956   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 14--HD"             format=f1.
      ER38957   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 15--HD"             format=f1.
      ER38958   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 16--HD"             format=f1.
      ER38959   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 17+--HD"            format=f1.
      ER38960   LABEL="HEHC SP RPT: AGE END DRUG/AL PROB--HD"            format=f3.
      ER38961   LABEL="HEHC SP RPT: OTR PSYCH PROB B4 AGE 1--HD"         format=f1.
      ER38962   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 1--HD"            format=f1.
      ER38963   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 2--HD"            format=f1.
      ER38964   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 3--HD"            format=f1.
      ER38965   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 4--HD"            format=f1.
      ER38966   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 5--HD"            format=f1.
      ER38967   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 6--HD"            format=f1.
      ER38968   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 7--HD"            format=f1.
      ER38969   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 8--HD"            format=f1.
      ER38970   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 9--HD"            format=f1.
      ER38971   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 10--HD"           format=f1.
      ER38972   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 11--HD"           format=f1.
      ER38973   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 12--HD"           format=f1.
      ER38974   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 13--HD"           format=f1.
      ER38975   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 14--HD"           format=f1.
      ER38976   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 15--HD"           format=f1.
      ER38977   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 16--HD"           format=f1.
      ER38978   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 17+--HD"          format=f1.
      ER38979   LABEL="HEHC SP RPT: AGE END OTR PSYCH PROB--HD"          format=f3.
      ER38980   LABEL="HEHC OTR RPT: YEAR 1ST REPORT--HD"                format=f4.
      ER38981   LABEL="HEHC OTR RPT: PAR SEP B4 AGE 1--HD"               format=f1.
      ER38982   LABEL="HEHC OTR RPT: PAR SEP AGE 1--HD"                  format=f1.
      ER38983   LABEL="HEHC OTR RPT: PAR SEP AGE 2--HD"                  format=f1.
      ER38984   LABEL="HEHC OTR RPT: PAR SEP AGE 3--HD"                  format=f1.
      ER38985   LABEL="HEHC OTR RPT: PAR SEP AGE 4--HD"                  format=f1.
      ER38986   LABEL="HEHC OTR RPT: PAR SEP AGE 5--HD"                  format=f1.
      ER38987   LABEL="HEHC OTR RPT: PAR SEP AGE 6--HD"                  format=f1.
      ER38988   LABEL="HEHC OTR RPT: PAR SEP AGE 7--HD"                  format=f1.
      ER38989   LABEL="HEHC OTR RPT: PAR SEP AGE 8--HD"                  format=f1.
      ER38990   LABEL="HEHC OTR RPT: PAR SEP AGE 9--HD"                  format=f1.
      ER38991   LABEL="HEHC OTR RPT: PAR SEP AGE 10--HD"                 format=f1.
      ER38992   LABEL="HEHC OTR RPT: PAR SEP AGE 11--HD"                 format=f1.
      ER38993   LABEL="HEHC OTR RPT: PAR SEP AGE 12--HD"                 format=f1.
      ER38994   LABEL="HEHC OTR RPT: PAR SEP AGE 13--HD"                 format=f1.
      ER38995   LABEL="HEHC OTR RPT: PAR SEP AGE 14--HD"                 format=f1.
      ER38996   LABEL="HEHC OTR RPT: PAR SEP AGE 15--HD"                 format=f1.
      ER38997   LABEL="HEHC OTR RPT: PAR SEP AGE 16--HD"                 format=f1.
      ER38998   LABEL="HEHC OTR RPT: MOVE B4 AGE 1--HD"                  format=f1.
      ER38999   LABEL="HEHC OTR RPT: MOVE AGE 1--HD"                     format=f1.
      ER39000   LABEL="HEHC OTR RPT: MOVE AGE 2--HD"                     format=f1.
      ER39001   LABEL="HEHC OTR RPT: MOVE AGE 3--HD"                     format=f1.
      ER39002   LABEL="HEHC OTR RPT: MOVE AGE 4--HD"                     format=f1.
      ER39003   LABEL="HEHC OTR RPT: MOVE AGE 5--HD"                     format=f1.
      ER39004   LABEL="HEHC OTR RPT: MOVE AGE 6--HD"                     format=f1.
      ER39005   LABEL="HEHC OTR RPT: MOVE AGE 7--HD"                     format=f1.
      ER39006   LABEL="HEHC OTR RPT: MOVE AGE 8--HD"                     format=f1.
      ER39007   LABEL="HEHC OTR RPT: MOVE AGE 9--HD"                     format=f1.
      ER39008   LABEL="HEHC OTR RPT: MOVE AGE 10--HD"                    format=f1.
      ER39009   LABEL="HEHC OTR RPT: MOVE AGE 11--HD"                    format=f1.
      ER39010   LABEL="HEHC OTR RPT: MOVE AGE 12--HD"                    format=f1.
      ER39011   LABEL="HEHC OTR RPT: MOVE AGE 13--HD"                    format=f1.
      ER39012   LABEL="HEHC OTR RPT: MOVE AGE 14--HD"                    format=f1.
      ER39013   LABEL="HEHC OTR RPT: MOVE AGE 15--HD"                    format=f1.
      ER39014   LABEL="HEHC OTR RPT: MOVE AGE 16--HD"                    format=f1.
      ER39015   LABEL="HEHC OTR RPT: SCHOOL B4 AGE 1--HD"                format=f1.
      ER39016   LABEL="HEHC OTR RPT: SCHOOL AGE 1--HD"                   format=f1.
      ER39017   LABEL="HEHC OTR RPT: SCHOOL AGE 2--HD"                   format=f1.
      ER39018   LABEL="HEHC OTR RPT: SCHOOL AGE 3--HD"                   format=f1.
      ER39019   LABEL="HEHC OTR RPT: SCHOOL AGE 4--HD"                   format=f1.
      ER39020   LABEL="HEHC OTR RPT: SCHOOL AGE 5--HD"                   format=f1.
      ER39021   LABEL="HEHC OTR RPT: SCHOOL AGE 6--HD"                   format=f1.
      ER39022   LABEL="HEHC OTR RPT: SCHOOL AGE 7--HD"                   format=f1.
      ER39023   LABEL="HEHC OTR RPT: SCHOOL AGE 8--HD"                   format=f1.
      ER39024   LABEL="HEHC OTR RPT: SCHOOL AGE 9--HD"                   format=f1.
      ER39025   LABEL="HEHC OTR RPT: SCHOOL AGE 10--HD"                  format=f1.
      ER39026   LABEL="HEHC OTR RPT: SCHOOL AGE 11--HD"                  format=f1.
      ER39027   LABEL="HEHC OTR RPT: SCHOOL AGE 12--HD"                  format=f1.
      ER39028   LABEL="HEHC OTR RPT: SCHOOL AGE 13--HD"                  format=f1.
      ER39029   LABEL="HEHC OTR RPT: SCHOOL AGE 14--HD"                  format=f1.
      ER39030   LABEL="HEHC OTR RPT: SCHOOL AGE 15--HD"                  format=f1.
      ER39031   LABEL="HEHC OTR RPT: SCHOOL AGE 16--HD"                  format=f1.
      ER39032   LABEL="HEHC OTR RPT: ASTHMA B4 AGE 1--HD"                format=f1.
      ER39033   LABEL="HEHC OTR RPT: ASTHMA AGE 1--HD"                   format=f1.
      ER39034   LABEL="HEHC OTR RPT: ASTHMA AGE 2--HD"                   format=f1.
      ER39035   LABEL="HEHC OTR RPT: ASTHMA AGE 3--HD"                   format=f1.
      ER39036   LABEL="HEHC OTR RPT: ASTHMA AGE 4--HD"                   format=f1.
      ER39037   LABEL="HEHC OTR RPT: ASTHMA AGE 5--HD"                   format=f1.
      ER39038   LABEL="HEHC OTR RPT: ASTHMA AGE 6--HD"                   format=f1.
      ER39039   LABEL="HEHC OTR RPT: ASTHMA AGE 7--HD"                   format=f1.
      ER39040   LABEL="HEHC OTR RPT: ASTHMA AGE 8--HD"                   format=f1.
      ER39041   LABEL="HEHC OTR RPT: ASTHMA AGE 9--HD"                   format=f1.
      ER39042   LABEL="HEHC OTR RPT: ASTHMA AGE 10--HD"                  format=f1.
      ER39043   LABEL="HEHC OTR RPT: ASTHMA AGE 11--HD"                  format=f1.
      ER39044   LABEL="HEHC OTR RPT: ASTHMA AGE 12--HD"                  format=f1.
      ER39045   LABEL="HEHC OTR RPT: ASTHMA AGE 13--HD"                  format=f1.
      ER39046   LABEL="HEHC OTR RPT: ASTHMA AGE 14--HD"                  format=f1.
      ER39047   LABEL="HEHC OTR RPT: ASTHMA AGE 15--HD"                  format=f1.
      ER39048   LABEL="HEHC OTR RPT: ASTHMA AGE 16--HD"                  format=f1.
      ER39049   LABEL="HEHC OTR RPT: ASTHMA AGE 17+--HD"                 format=f1.
      ER39050   LABEL="HEHC OTR RPT: AGE END ASTHMA--HD"                 format=f3.
      ER39051   LABEL="HEHC OTR RPT: DIABETES B4 AGE 1--HD"              format=f1.
      ER39052   LABEL="HEHC OTR RPT: DIABETES AGE 1--HD"                 format=f1.
      ER39053   LABEL="HEHC OTR RPT: DIABETES AGE 2--HD"                 format=f1.
      ER39054   LABEL="HEHC OTR RPT: DIABETES AGE 3--HD"                 format=f1.
      ER39055   LABEL="HEHC OTR RPT: DIABETES AGE 4--HD"                 format=f1.
      ER39056   LABEL="HEHC OTR RPT: DIABETES AGE 5--HD"                 format=f1.
      ER39057   LABEL="HEHC OTR RPT: DIABETES AGE 6--HD"                 format=f1.
      ER39058   LABEL="HEHC OTR RPT: DIABETES AGE 7--HD"                 format=f1.
      ER39059   LABEL="HEHC OTR RPT: DIABETES AGE 8--HD"                 format=f1.
      ER39060   LABEL="HEHC OTR RPT: DIABETES AGE 9--HD"                 format=f1.
      ER39061   LABEL="HEHC OTR RPT: DIABETES AGE 10--HD"                format=f1.
      ER39062   LABEL="HEHC OTR RPT: DIABETES AGE 11--HD"                format=f1.
      ER39063   LABEL="HEHC OTR RPT: DIABETES AGE 12--HD"                format=f1.
      ER39064   LABEL="HEHC OTR RPT: DIABETES AGE 13--HD"                format=f1.
      ER39065   LABEL="HEHC OTR RPT: DIABETES AGE 14--HD"                format=f1.
      ER39066   LABEL="HEHC OTR RPT: DIABETES AGE 15--HD"                format=f1.
      ER39067   LABEL="HEHC OTR RPT: DIABETES AGE 16--HD"                format=f1.
      ER39068   LABEL="HEHC OTR RPT: DIABETES AGE 17+--HD"               format=f1.
      ER39069   LABEL="HEHC OTR RPT: AGE END DIABETES--HD"               format=f3.
      ER39070   LABEL="HEHC OTR RPT: RESP DIS B4 AGE 1--HD"              format=f1.
      ER39071   LABEL="HEHC OTR RPT: RESP DIS AGE 1--HD"                 format=f1.
      ER39072   LABEL="HEHC OTR RPT: RESP DIS AGE 2--HD"                 format=f1.
      ER39073   LABEL="HEHC OTR RPT: RESP DIS AGE 3--HD"                 format=f1.
      ER39074   LABEL="HEHC OTR RPT: RESP DIS AGE 4--HD"                 format=f1.
      ER39075   LABEL="HEHC OTR RPT: RESP DIS AGE 5--HD"                 format=f1.
      ER39076   LABEL="HEHC OTR RPT: RESP DIS AGE 6--HD"                 format=f1.
      ER39077   LABEL="HEHC OTR RPT: RESP DIS AGE 7--HD"                 format=f1.
      ER39078   LABEL="HEHC OTR RPT: RESP DIS AGE 8--HD"                 format=f1.
      ER39079   LABEL="HEHC OTR RPT: RESP DIS AGE 9--HD"                 format=f1.
      ER39080   LABEL="HEHC OTR RPT: RESP DIS AGE 10--HD"                format=f1.
      ER39081   LABEL="HEHC OTR RPT: RESP DIS AGE 11--HD"                format=f1.
      ER39082   LABEL="HEHC OTR RPT: RESP DIS AGE 12--HD"                format=f1.
      ER39083   LABEL="HEHC OTR RPT: RESP DIS AGE 13--HD"                format=f1.
      ER39084   LABEL="HEHC OTR RPT: RESP DIS AGE 14--HD"                format=f1.
      ER39085   LABEL="HEHC OTR RPT: RESP DIS AGE 15--HD"                format=f1.
      ER39086   LABEL="HEHC OTR RPT: RESP DIS AGE 16--HD"                format=f1.
      ER39087   LABEL="HEHC OTR RPT: RESP DIS AGE 17+--HD"               format=f1.
      ER39088   LABEL="HEHC OTR RPT: AGE END RESP DIS--HD"               format=f3.
      ER39089   LABEL="HEHC OTR RPT: SPCH IMPAIR B4 AGE 1--HD"           format=f1.
      ER39090   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 1--HD"              format=f1.
      ER39091   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 2--HD"              format=f1.
      ER39092   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 3--HD"              format=f1.
      ER39093   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 4--HD"              format=f1.
      ER39094   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 5--HD"              format=f1.
      ER39095   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 6--HD"              format=f1.
      ER39096   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 7--HD"              format=f1.
      ER39097   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 8--HD"              format=f1.
      ER39098   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 9--HD"              format=f1.
      ER39099   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 10--HD"             format=f1.
      ER39100   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 11--HD"             format=f1.
      ER39101   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 12--HD"             format=f1.
      ER39102   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 13--HD"             format=f1.
      ER39103   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 14--HD"             format=f1.
      ER39104   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 15--HD"             format=f1.
      ER39105   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 16--HD"             format=f1.
      ER39106   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 17+--HD"            format=f1.
      ER39107   LABEL="HEHC OTR RPT: AGE END SPCH IMPAIR--HD"            format=f3.
      ER39108   LABEL="HEHC OTR RPT: ALLERGY B4 AGE 1--HD"               format=f1.
      ER39109   LABEL="HEHC OTR RPT: ALLERGY AGE 1--HD"                  format=f1.
      ER39110   LABEL="HEHC OTR RPT: ALLERGY AGE 2--HD"                  format=f1.
      ER39111   LABEL="HEHC OTR RPT: ALLERGY AGE 3--HD"                  format=f1.
      ER39112   LABEL="HEHC OTR RPT: ALLERGY AGE 4--HD"                  format=f1.
      ER39113   LABEL="HEHC OTR RPT: ALLERGY AGE 5--HD"                  format=f1.
      ER39114   LABEL="HEHC OTR RPT: ALLERGY AGE 6--HD"                  format=f1.
      ER39115   LABEL="HEHC OTR RPT: ALLERGY AGE 7--HD"                  format=f1.
      ER39116   LABEL="HEHC OTR RPT: ALLERGY AGE 8--HD"                  format=f1.
      ER39117   LABEL="HEHC OTR RPT: ALLERGY AGE 9--HD"                  format=f1.
      ER39118   LABEL="HEHC OTR RPT: ALLERGY AGE 10--HD"                 format=f1.
      ER39119   LABEL="HEHC OTR RPT: ALLERGY AGE 11--HD"                 format=f1.
      ER39120   LABEL="HEHC OTR RPT: ALLERGY AGE 12--HD"                 format=f1.
      ER39121   LABEL="HEHC OTR RPT: ALLERGY AGE 13--HD"                 format=f1.
      ER39122   LABEL="HEHC OTR RPT: ALLERGY AGE 14--HD"                 format=f1.
      ER39123   LABEL="HEHC OTR RPT: ALLERGY AGE 15--HD"                 format=f1.
      ER39124   LABEL="HEHC OTR RPT: ALLERGY AGE 16--HD"                 format=f1.
      ER39125   LABEL="HEHC OTR RPT: ALLERGY AGE 17+--HD"                format=f1.
      ER39126   LABEL="HEHC OTR RPT: AGE END ALLERGY--HD"                format=f3.
      ER39127   LABEL="HEHC OTR RPT: HEART TRBL B4 AGE 1--HD"            format=f1.
      ER39128   LABEL="HEHC OTR RPT: HEART TRBL AGE 1--HD"               format=f1.
      ER39129   LABEL="HEHC OTR RPT: HEART TRBL AGE 2--HD"               format=f1.
      ER39130   LABEL="HEHC OTR RPT: HEART TRBL AGE 3--HD"               format=f1.
      ER39131   LABEL="HEHC OTR RPT: HEART TRBL AGE 4--HD"               format=f1.
      ER39132   LABEL="HEHC OTR RPT: HEART TRBL AGE 5--HD"               format=f1.
      ER39133   LABEL="HEHC OTR RPT: HEART TRBL AGE 6--HD"               format=f1.
      ER39134   LABEL="HEHC OTR RPT: HEART TRBL AGE 7--HD"               format=f1.
      ER39135   LABEL="HEHC OTR RPT: HEART TRBL AGE 8--HD"               format=f1.
      ER39136   LABEL="HEHC OTR RPT: HEART TRBL AGE 9--HD"               format=f1.
      ER39137   LABEL="HEHC OTR RPT: HEART TRBL AGE 10--HD"              format=f1.
      ER39138   LABEL="HEHC OTR RPT: HEART TRBL AGE 11--HD"              format=f1.
      ER39139   LABEL="HEHC OTR RPT: HEART TRBL AGE 12--HD"              format=f1.
      ER39140   LABEL="HEHC OTR RPT: HEART TRBL AGE 13--HD"              format=f1.
      ER39141   LABEL="HEHC OTR RPT: HEART TRBL AGE 14--HD"              format=f1.
      ER39142   LABEL="HEHC OTR RPT: HEART TRBL AGE 15--HD"              format=f1.
      ER39143   LABEL="HEHC OTR RPT: HEART TRBL AGE 16--HD"              format=f1.
      ER39144   LABEL="HEHC OTR RPT: HEART TRBL AGE 17+--HD"             format=f1.
      ER39145   LABEL="HEHC OTR RPT: AGE END HEART TRBL--HD"             format=f3.
      ER39146   LABEL="HEHC OTR RPT: EAR PROBS B4 AGE 1--HD"             format=f1.
      ER39147   LABEL="HEHC OTR RPT: EAR PROBS AGE 1--HD"                format=f1.
      ER39148   LABEL="HEHC OTR RPT: EAR PROBS AGE 2--HD"                format=f1.
      ER39149   LABEL="HEHC OTR RPT: EAR PROBS AGE 3--HD"                format=f1.
      ER39150   LABEL="HEHC OTR RPT: EAR PROBS AGE 4--HD"                format=f1.
      ER39151   LABEL="HEHC OTR RPT: EAR PROBS AGE 5--HD"                format=f1.
      ER39152   LABEL="HEHC OTR RPT: EAR PROBS AGE 6--HD"                format=f1.
      ER39153   LABEL="HEHC OTR RPT: EAR PROBS AGE 7--HD"                format=f1.
      ER39154   LABEL="HEHC OTR RPT: EAR PROBS AGE 8--HD"                format=f1.
      ER39155   LABEL="HEHC OTR RPT: EAR PROBS AGE 9--HD"                format=f1.
      ER39156   LABEL="HEHC OTR RPT: EAR PROBS AGE 10--HD"               format=f1.
      ER39157   LABEL="HEHC OTR RPT: EAR PROBS AGE 11--HD"               format=f1.
      ER39158   LABEL="HEHC OTR RPT: EAR PROBS AGE 12--HD"               format=f1.
      ER39159   LABEL="HEHC OTR RPT: EAR PROBS AGE 13--HD"               format=f1.
      ER39160   LABEL="HEHC OTR RPT: EAR PROBS AGE 14--HD"               format=f1.
      ER39161   LABEL="HEHC OTR RPT: EAR PROBS AGE 15--HD"               format=f1.
      ER39162   LABEL="HEHC OTR RPT: EAR PROBS AGE 16--HD"               format=f1.
      ER39163   LABEL="HEHC OTR RPT: EAR PROBS AGE 17+--HD"              format=f1.
      ER39164   LABEL="HEHC OTR RPT: AGE END EAR PROBS--HD"              format=f3.
      ER39165   LABEL="HEHC OTR RPT: EPILEPSY B4 AGE 1--HD"              format=f1.
      ER39166   LABEL="HEHC OTR RPT: EPILEPSY AGE 1--HD"                 format=f1.
      ER39167   LABEL="HEHC OTR RPT: EPILEPSY AGE 2--HD"                 format=f1.
      ER39168   LABEL="HEHC OTR RPT: EPILEPSY AGE 3--HD"                 format=f1.
      ER39169   LABEL="HEHC OTR RPT: EPILEPSY AGE 4--HD"                 format=f1.
      ER39170   LABEL="HEHC OTR RPT: EPILEPSY AGE 5--HD"                 format=f1.
      ER39171   LABEL="HEHC OTR RPT: EPILEPSY AGE 6--HD"                 format=f1.
      ER39172   LABEL="HEHC OTR RPT: EPILEPSY AGE 7--HD"                 format=f1.
      ER39173   LABEL="HEHC OTR RPT: EPILEPSY AGE 8--HD"                 format=f1.
      ER39174   LABEL="HEHC OTR RPT: EPILEPSY AGE 9--HD"                 format=f1.
      ER39175   LABEL="HEHC OTR RPT: EPILEPSY AGE 10--HD"                format=f1.
      ER39176   LABEL="HEHC OTR RPT: EPILEPSY AGE 11--HD"                format=f1.
      ER39177   LABEL="HEHC OTR RPT: EPILEPSY AGE 12--HD"                format=f1.
      ER39178   LABEL="HEHC OTR RPT: EPILEPSY AGE 13--HD"                format=f1.
      ER39179   LABEL="HEHC OTR RPT: EPILEPSY AGE 14--HD"                format=f1.
      ER39180   LABEL="HEHC OTR RPT: EPILEPSY AGE 15--HD"                format=f1.
      ER39181   LABEL="HEHC OTR RPT: EPILEPSY AGE 16--HD"                format=f1.
      ER39182   LABEL="HEHC OTR RPT: EPILEPSY AGE 17+--HD"               format=f1.
      ER39183   LABEL="HEHC OTR RPT: AGE END EPILEPSY--HD"               format=f3.
      ER39184   LABEL="HEHC OTR RPT: HEADACHE B4 AGE 1--HD"              format=f1.
      ER39185   LABEL="HEHC OTR RPT: HEADACHE AGE 1--HD"                 format=f1.
      ER39186   LABEL="HEHC OTR RPT: HEADACHE AGE 2--HD"                 format=f1.
      ER39187   LABEL="HEHC OTR RPT: HEADACHE AGE 3--HD"                 format=f1.
      ER39188   LABEL="HEHC OTR RPT: HEADACHE AGE 4--HD"                 format=f1.
      ER39189   LABEL="HEHC OTR RPT: HEADACHE AGE 5--HD"                 format=f1.
      ER39190   LABEL="HEHC OTR RPT: HEADACHE AGE 6--HD"                 format=f1.
      ER39191   LABEL="HEHC OTR RPT: HEADACHE AGE 7--HD"                 format=f1.
      ER39192   LABEL="HEHC OTR RPT: HEADACHE AGE 8--HD"                 format=f1.
      ER39193   LABEL="HEHC OTR RPT: HEADACHE AGE 9--HD"                 format=f1.
      ER39194   LABEL="HEHC OTR RPT: HEADACHE AGE 10--HD"                format=f1.
      ER39195   LABEL="HEHC OTR RPT: HEADACHE AGE 11--HD"                format=f1.
      ER39196   LABEL="HEHC OTR RPT: HEADACHE AGE 12--HD"                format=f1.
      ER39197   LABEL="HEHC OTR RPT: HEADACHE AGE 13--HD"                format=f1.
      ER39198   LABEL="HEHC OTR RPT: HEADACHE AGE 14--HD"                format=f1.
      ER39199   LABEL="HEHC OTR RPT: HEADACHE AGE 15--HD"                format=f1.
      ER39200   LABEL="HEHC OTR RPT: HEADACHE AGE 16--HD"                format=f1.
      ER39201   LABEL="HEHC OTR RPT: HEADACHE AGE 17+--HD"               format=f1.
      ER39202   LABEL="HEHC OTR RPT: AGE END HEADACHE--HD"               format=f3.
      ER39203   LABEL="HEHC OTR RPT: STOM PROB B4 AGE 1--HD"             format=f1.
      ER39204   LABEL="HEHC OTR RPT: STOM PROB AGE 1--HD"                format=f1.
      ER39205   LABEL="HEHC OTR RPT: STOM PROB AGE 2--HD"                format=f1.
      ER39206   LABEL="HEHC OTR RPT: STOM PROB AGE 3--HD"                format=f1.
      ER39207   LABEL="HEHC OTR RPT: STOM PROB AGE 4--HD"                format=f1.
      ER39208   LABEL="HEHC OTR RPT: STOM PROB AGE 5--HD"                format=f1.
      ER39209   LABEL="HEHC OTR RPT: STOM PROB AGE 6--HD"                format=f1.
      ER39210   LABEL="HEHC OTR RPT: STOM PROB AGE 7--HD"                format=f1.
      ER39211   LABEL="HEHC OTR RPT: STOM PROB AGE 8--HD"                format=f1.
      ER39212   LABEL="HEHC OTR RPT: STOM PROB AGE 9--HD"                format=f1.
      ER39213   LABEL="HEHC OTR RPT: STOM PROB AGE 10--HD"               format=f1.
      ER39214   LABEL="HEHC OTR RPT: STOM PROB AGE 11--HD"               format=f1.
      ER39215   LABEL="HEHC OTR RPT: STOM PROB AGE 12--HD"               format=f1.
      ER39216   LABEL="HEHC OTR RPT: STOM PROB AGE 13--HD"               format=f1.
      ER39217   LABEL="HEHC OTR RPT: STOM PROB AGE 14--HD"               format=f1.
      ER39218   LABEL="HEHC OTR RPT: STOM PROB AGE 15--HD"               format=f1.
      ER39219   LABEL="HEHC OTR RPT: STOM PROB AGE 16--HD"               format=f1.
      ER39220   LABEL="HEHC OTR RPT: STOM PROB AGE 17+--HD"              format=f1.
      ER39221   LABEL="HEHC OTR RPT: AGE END STOM PROB--HD"              format=f3.
      ER39222   LABEL="HEHC OTR RPT: HGH BLOOD PR B4 AGE 1--HD"          format=f1.
      ER39223   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 1--HD"             format=f1.
      ER39224   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 2--HD"             format=f1.
      ER39225   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 3--HD"             format=f1.
      ER39226   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 4--HD"             format=f1.
      ER39227   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 5--HD"             format=f1.
      ER39228   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 6--HD"             format=f1.
      ER39229   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 7--HD"             format=f1.
      ER39230   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 8--HD"             format=f1.
      ER39231   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 9--HD"             format=f1.
      ER39232   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 10--HD"            format=f1.
      ER39233   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 11--HD"            format=f1.
      ER39234   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 12--HD"            format=f1.
      ER39235   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 13--HD"            format=f1.
      ER39236   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 14--HD"            format=f1.
      ER39237   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 15--HD"            format=f1.
      ER39238   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 16--HD"            format=f1.
      ER39239   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 17+--HD"           format=f1.
      ER39240   LABEL="HEHC OTR RPT: AGE END HGH BLD PR--HD"             format=f3.
      ER39241   LABEL="HEHC OTR RPT: DEPRESSION B4 AGE 1--HD"            format=f1.
      ER39242   LABEL="HEHC OTR RPT: DEPRESSION AGE 1--HD"               format=f1.
      ER39243   LABEL="HEHC OTR RPT: DEPRESSION AGE 2--HD"               format=f1.
      ER39244   LABEL="HEHC OTR RPT: DEPRESSION AGE 3--HD"               format=f1.
      ER39245   LABEL="HEHC OTR RPT: DEPRESSION AGE 4--HD"               format=f1.
      ER39246   LABEL="HEHC OTR RPT: DEPRESSION AGE 5--HD"               format=f1.
      ER39247   LABEL="HEHC OTR RPT: DEPRESSION AGE 6--HD"               format=f1.
      ER39248   LABEL="HEHC OTR RPT: DEPRESSION AGE 7--HD"               format=f1.
      ER39249   LABEL="HEHC OTR RPT: DEPRESSION AGE 8--HD"               format=f1.
      ER39250   LABEL="HEHC OTR RPT: DEPRESSION AGE 9--HD"               format=f1.
      ER39251   LABEL="HEHC OTR RPT: DEPRESSION AGE 10--HD"              format=f1.
      ER39252   LABEL="HEHC OTR RPT: DEPRESSION AGE 11--HD"              format=f1.
      ER39253   LABEL="HEHC OTR RPT: DEPRESSION AGE 12--HD"              format=f1.
      ER39254   LABEL="HEHC OTR RPT: DEPRESSION AGE 13--HD"              format=f1.
      ER39255   LABEL="HEHC OTR RPT: DEPRESSION AGE 14--HD"              format=f1.
      ER39256   LABEL="HEHC OTR RPT: DEPRESSION AGE 15--HD"              format=f1.
      ER39257   LABEL="HEHC OTR RPT: DEPRESSION AGE 16--HD"              format=f1.
      ER39258   LABEL="HEHC OTR RPT: DEPRESSION AGE 17+--HD"             format=f1.
      ER39259   LABEL="HEHC OTR RPT: AGE END DEPRESSION--HD"             format=f3.
      ER39260   LABEL="HEHC OTR RPT: DRUG/AL PROB B4 AGE 1--HD"          format=f1.
      ER39261   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 1--HD"             format=f1.
      ER39262   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 2--HD"             format=f1.
      ER39263   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 3--HD"             format=f1.
      ER39264   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 4--HD"             format=f1.
      ER39265   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 5--HD"             format=f1.
      ER39266   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 6--HD"             format=f1.
      ER39267   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 7--HD"             format=f1.
      ER39268   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 8--HD"             format=f1.
      ER39269   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 9--HD"             format=f1.
      ER39270   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 10--HD"            format=f1.
      ER39271   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 11--HD"            format=f1.
      ER39272   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 12--HD"            format=f1.
      ER39273   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 13--HD"            format=f1.
      ER39274   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 14--HD"            format=f1.
      ER39275   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 15--HD"            format=f1.
      ER39276   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 16--HD"            format=f1.
      ER39277   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 17+--HD"           format=f1.
      ER39278   LABEL="HEHC OTR RPT: AGE END DRUG/AL PROB--HD"           format=f3.
      ER39279   LABEL="HEHC OTR RPT: OTR PSYCH PROB B4 AGE 1--H"         format=f1.
      ER39280   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 1--HD"           format=f1.
      ER39281   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 2--HD"           format=f1.
      ER39282   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 3--HD"           format=f1.
      ER39283   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 4--HD"           format=f1.
      ER39284   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 5--HD"           format=f1.
      ER39285   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 6--HD"           format=f1.
      ER39286   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 7--HD"           format=f1.
      ER39287   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 8--HD"           format=f1.
      ER39288   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 9--HD"           format=f1.
      ER39289   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 10--HD"          format=f1.
      ER39290   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 11--HD"          format=f1.
      ER39291   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 12--HD"          format=f1.
      ER39292   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 13--HD"          format=f1.
      ER39293   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 14--HD"          format=f1.
      ER39294   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 15--HD"          format=f1.
      ER39295   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 16--HD"          format=f1.
      ER39296   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 17+--HD"         format=f1.
      ER39297   LABEL="HEHC OTR RPT: AGE END OTR PSYCH PROB--HD"         format=f3.
      ER39298   LABEL="H24 WTR WIFE IN FU NOW"                           format=f1.
      ER39299   LABEL="H1 HEALTH STATUS-WIFE"                            format=f1.
      ER39300   LABEL="H1A WTR HLTH BETTER/WORSE-WIFE"                   format=f1.
      ER39301   LABEL="H1B WTR  HEALTH BETTER-WIFE"                      format=f1.
      ER39302   LABEL="H1C WTR HEALTH WORSE-WIFE"                        format=f1.
      ER39303   LABEL="H2 WTR TYPE/AMT WORK LIMITED-WIFE"                format=f1.
      ER39304   LABEL="H3 WTR UNABLE TO DO SOME TYPES WORK-WF"           format=f1.
      ER39305   LABEL="H4 WTR LIMIT AMT WORK CAN DO-WIFE"                format=f1.
      ER39306   LABEL="H5A WTR HAD STROKE-WIFE"                          format=f1.
      ER39307   LABEL="H6A1 AGE AT FIRST STROKE-WIFE"                    format=f3.
      ER39308   LABEL="H6A2 WTR SECOND STROKE-WIFE"                      format=f1.
      ER39309   LABEL="H7A WTR STROKE LIMIT DAILY ACTIVITY-WF"           format=f1.
      ER39310   LABEL="H5B WTR HEART ATTACK-WIFE"                        format=f1.
      ER39311   LABEL="H6B1 AGE AT FIRST HEART ATTACK-WF"                format=f3.
      ER39312   LABEL="H6B2 WTR SECOND HEART ATTACK-WF"                  format=f1.
      ER39313   LABEL="H7B WTR HRT ATTACK LIMIT ACTIVITY-WF"             format=f1.
      ER39314   LABEL="H5C WTR HEART DISEASE-WIFE"                       format=f1.
      ER39315   LABEL="H6C1 AGE FIRST HAD HEART DISEASE-WF"              format=f3.
      ER39316   LABEL="H6C2 WTR HRT DISEASE GOT WORSE-WF"                format=f1.
      ER39317   LABEL="H7C WTR HRT DISEASE LIMIT ACTIVITY-WF"            format=f1.
      ER39318   LABEL="H5D WTR HYPERTENSION-WIFE"                        format=f1.
      ER39319   LABEL="H6D1 AGE FIRST HAD HYPERTENSION-WF"               format=f3.
      ER39320   LABEL="H6D2 WTR HYPERTENSION GOT WORSE-WF"               format=f1.
      ER39321   LABEL="H7D WTR HYPERTENSION LIMIT ACTIVITY-WF"           format=f1.
      ER39322   LABEL="H5E WTR ASTHMA-WIFE"                              format=f1.
      ER39323   LABEL="H6E1 AGE FIRST HAD ASTHMA-WIFE"                   format=f3.
      ER39324   LABEL="H6E2 WTR ASTHMA GOT WORSE-WIFE"                   format=f1.
      ER39325   LABEL="H7E WTR ASTHMA LIMIT DAILY ACTIVITY-WF"           format=f1.
      ER39326   LABEL="H5F WTR LUNG DISEASE-WIFE"                        format=f1.
      ER39327   LABEL="H6F1 AGE FIRST HAD LUNG DISEASE-WF"               format=f3.
      ER39328   LABEL="H6F2 WTR LUNG DISEASE GOT WORSE-WF"               format=f1.
      ER39329   LABEL="H7F WTR LUNG DISEASE LIMIT ACTIVITY-WF"           format=f1.
      ER39330   LABEL="H5G WTR DIABETES-WIFE"                            format=f1.
      ER39331   LABEL="H6G1 AGE FIRST HAD DIABETES-WIFE"                 format=f3.
      ER39332   LABEL="H6G2 WTR DIABETES GOT WORSE-WIFE"                 format=f1.
      ER39333   LABEL="H7G WTR DIABETES LIMIT ACTIVITY-WF"               format=f1.
      ER39334   LABEL="H5H WTR ARTHRITIS-WIFE"                           format=f1.
      ER39335   LABEL="H6H1 AGE FIRST HAD ARTHRITIS-WIFE"                format=f3.
      ER39336   LABEL="H6H2 WTR ARTHRITIS GOT WORSE-WIFE"                format=f1.
      ER39337   LABEL="H7H WTR ARTHRITIS LIMIT ACTIVITY-WF"              format=f1.
      ER39338   LABEL="H5I WTR MENTAL LOSS-WIFE"                         format=f1.
      ER39339   LABEL="H6I1 AGE FIRST HAD MEMORY LOSS-WF"                format=f3.
      ER39340   LABEL="H6I2 WTR MEMORY LOSS GOT WORSE-WF"                format=f1.
      ER39341   LABEL="H7I WTR MEMORY LOSS LIMIT ACTIVITY-WF"            format=f1.
      ER39342   LABEL="H5J WTR LEARNING DISORDER-WIFE"                   format=f1.
      ER39343   LABEL="H6J1 AGE FIRST HAD LRNG DISORDER-WF"              format=f3.
      ER39344   LABEL="H6J2 WTR LRNG DISORDER GOT WORSE-WF"              format=f1.
      ER39345   LABEL="H7J WTR LRNG DISORDR LIMIT ACTIVITY-WF"           format=f1.
      ER39346   LABEL="H5K WTR CANCER-WIFE"                              format=f1.
      ER39347   LABEL="H6K1 AGE FIRST HAD CANCER-WIFE"                   format=f3.
      ER39348   LABEL="H6K2 WTR CANCER GOT WORSE-WIFE"                   format=f1.
      ER39349   LABEL="H6K3 WTR TREATING, RMSSN, OR CURED-WF"            format=f1.
      ER39350   LABEL="H6K4 TYPE OF CANCER MENTION 1-WIFE"               format=f2.
      ER39351   LABEL="H6K4 TYPE OF CANCER MENTION 2-WIFE"               format=f2.
      ER39352   LABEL="H7K WTR CANCER LIMIT ACTIVITY-WIFE"               format=f1.
      ER39353   LABEL="H5L WTR PSYCH PROBLEM-WIFE"                       format=f1.
      ER39354   LABEL="H6L1 AGE FIRST HAD PSYCH PROB-WIFE"               format=f3.
      ER39355   LABEL="H6L2 TYPE OF PSYCH PROB MENTION 1-WF"             format=f2.
      ER39356   LABEL="H6L2 TYPE OF PSYCH PROB MENTION 2-WF"             format=f2.
      ER39357   LABEL="H6L2 TYPE OF PSYCH PROB MENTION 3-WF"             format=f2.
      ER39358   LABEL="H6L3 WTR PSYCH PROB GOT WORSE-WF"                 format=f1.
      ER39359   LABEL="H7L WTR PSYCH PROB LIMIT ACTIVITY-WF"             format=f1.
      ER39360   LABEL="H5M WTR OTR CHRONIC CONDITION-WF"                 format=f1.
      ER39361   LABEL="H6M2 AGE FIRST HAD CHRON COND-WIFE"               format=f3.
      ER39362   LABEL="H6M3 WTR CHRON COND GOT WORSE-WF"                 format=f1.
      ER39363   LABEL="H7M WTR CHRON COND LIMIT ACTIVITY-WF"             format=f1.
      ER39364   LABEL="H8 WTR HOSPITALIZED IN 2004-WIFE"                 format=f1.
      ER39365   LABEL="H8A # NIGHTS HOSPITALIZED-WIFE"                   format=f3.
      ER39366   LABEL="H8A # WEEKS HOSPITALIZED-WIFE"                    format=f2.
      ER39367   LABEL="H9A WTR PROBLEM BATHING-WIFE"                     format=f1.
      ER39368   LABEL="H10A1 WTR SOMEONE HELPS BATHE-WF"                 format=f1.
      ER39369   LABEL="H10A2 WTR NEED EQUIP TO BATHE-WF"                 format=f1.
      ER39370   LABEL="H9B WTR PROBLEM DRESSING-WIFE"                    format=f1.
      ER39371   LABEL="H10B1 WTR SOMEONE HELPS DRESS-WF"                 format=f1.
      ER39372   LABEL="H10B2 WTR NEED EQUIP TO DRESS-WF"                 format=f1.
      ER39373   LABEL="H9C WTR PROBLEM EATING-WIFE"                      format=f1.
      ER39374   LABEL="H10C1 WTR SOMEONE HELPS EATNG-WF"                 format=f1.
      ER39375   LABEL="H10C2 WTR NEED EQUIP TO EAT-WF"                   format=f1.
      ER39376   LABEL="H9D WTR PROB GET IN/OUT BED/CHAIR-WF"             format=f1.
      ER39377   LABEL="H10D1 WTR SOMEONE HELPS BED/CHAIR-WF"             format=f1.
      ER39378   LABEL="H10D2 WTR NEED EQUIP FOR BED/CHAIR-WF"            format=f1.
      ER39379   LABEL="H9E WTR PROBLEM WALKING-WIFE"                     format=f1.
      ER39380   LABEL="H10E1 WTR SOMEONE HELPS WALK-WF"                  format=f1.
      ER39381   LABEL="H10E2 WTR NEED EQUIP TO WALK-WF"                  format=f1.
      ER39382   LABEL="H9F WTR PROBLEM GETTING OUTSIDE-WF"               format=f1.
      ER39383   LABEL="H10F1 WTR SOMEONE HELPS GET OUT-WF"               format=f1.
      ER39384   LABEL="H10F2 WTR NEED EQUIP TO GO OUTSIDE-WF"            format=f1.
      ER39385   LABEL="H9G WTR PROBLEM USE TOILET-WF"                    format=f1.
      ER39386   LABEL="H10G1 WTR SOMEONE HELPS TOILET-WF"                format=f1.
      ER39387   LABEL="H10G2 WTR NEED EQUIP TO USE TOILET-WF"            format=f1.
      ER39388   LABEL="H11A WTR DIFFICULT PREPARE MEALS-WF"              format=f1.
      ER39389   LABEL="H11B HEALTH/PHYSICAL PROBLEM?-WF"                 format=f1.
      ER39390   LABEL="H11C WTR DIFFICULT SHOPPING-WF"                   format=f1.
      ER39391   LABEL="H11D HEALTH/PHYSICAL PROBLEM?-WF"                 format=f1.
      ER39392   LABEL="H11E WTR DIFFICULT MANAGE MONEY-WF"               format=f1.
      ER39393   LABEL="H11F HEALTH/PHYSICAL PROBLEM?-WF"                 format=f1.
      ER39394   LABEL="H11G WTR TELEPHONE DIFFICULT-WF"                  format=f1.
      ER39395   LABEL="H11H HEALTH/PHYSICAL PROBLEM?-WF"                 format=f1.
      ER39396   LABEL="H11J WTR HEAVY HSWRK DIFFICULT-WF"                format=f1.
      ER39397   LABEL="H11K HEALTH/PHYSICAL PROBLEM?-WF"                 format=f1.
      ER39398   LABEL="H11L WTR LIGHT HSWRK DIFFICULT-WF"                format=f1.
      ER39399   LABEL="H11M HEALTH/PHYSICAL PROBLEM?-WF"                 format=f1.
      ER39400   LABEL="H12A FREQ OF HVY PHYSICAL ACTIVITY-WF"            format=f3.
      ER39401   LABEL="H12A TIME UNIT FOR HVY PHYS ACTIVITY-WF"          format=f1.
      ER39402   LABEL="H12B FREQ OF LITE PHYSICAL ACTIVITY-WF"           format=f3.
      ER39403   LABEL="H12B TIME UNIT FOR LITE PHYS ACTIVITY-WF"         format=f1.
      ER39404   LABEL="H12C FREQ OF STRENGTH PHYS ACTIVITY-WF"           format=f3.
      ER39405   LABEL="H12C TIME UNIT STRNGTH PHYS ACTVTY-WF"            format=f1.
      ER39406   LABEL="H13 WTR SMOKE CIGARETTES-WF"                      format=f1.
      ER39407   LABEL="H14 # CIGARETTES PER DAY-WF"                      format=f3.
      ER39408   LABEL="H15AGE WHEN FIRST SMOKED-WF"                      format=f2.
      ER39409   LABEL="H16 WTR EVER SMOKED CIGARETTES-WF"                format=f1.
      ER39410   LABEL="H17 # CIGARETTES PER DAY-WF"                      format=f3.
      ER39411   LABEL="H18 AGE LAST SMOKED REGULARLY-WF"                 format=f2.
      ER39412   LABEL="H19 AGE FIRST SMOKED REGULARLY-WF"                format=f2.
      ER39413   LABEL="H20 WTR DRINK ALCOHOL-WIFE"                       format=f1.
      ER39414   LABEL="H21A HOW OFTEN HAVE DRINKS-WF"                    format=f1.
      ER39415   LABEL="H21B # ALCOHOLIC DRINKS PER DAY-WF"               format=f2.
      ER39416   LABEL="H21C # DAYS HAD 4-5 DRINKS-WIFE"                  format=f3.
      ER39417   LABEL="H22 WEIGHT--WIFE"                                 format=f3.
      ER39418   LABEL="H23 HEIGHT-FEET--WIFE"                            format=f1.
      ER39419   LABEL="H23 HEIGHT-INCHES--WIFE"                          format=f2.
      ER39420   LABEL="H25W HEALTH STATUS B4 AGE 17--WF"                 format=f1.
      ER39421   LABEL="H26W WTR MISSED MO OR MORE SCHOOL--WF"            format=f1.
      ER39422   LABEL="H27W WTR MEASLES B4 AGE 17--WF"                   format=f1.
      ER39423   LABEL="H28W WTR MUMPS B4 AGE 17--WF"                     format=f1.
      ER39424   LABEL="H29W WTR CHICKEN POX B4 AGE 17--WF"               format=f1.
      ER39425   LABEL="H30W WTR DIFF SEEING B4 AGE 17--WF"               format=f1.
      ER39426   LABEL="H31W PARENTS SMOKED B4 WF AGE 17?--WF"            format=f1.
      ER39427   LABEL="H32W WTR ASTHMA B4 AGE 17--WF"                    format=f1.
      ER39428   LABEL="H33W WTR DIABETES B4 AGE 17--WF"                  format=f1.
      ER39429   LABEL="H34W WTR RESP DIS B4 AGE 17--WF"                  format=f1.
      ER39430   LABEL="H35W WTR SPCH IMPAIR B4 AGE 17--WF"               format=f1.
      ER39431   LABEL="H36W WTR ALLERGY B4 AGE 17--WF"                   format=f1.
      ER39432   LABEL="H37W WTR HEART TRBL B4 AGE 17--WF"                format=f1.
      ER39433   LABEL="H38W WTR EAR PROB B4 AGE 17--WF"                  format=f1.
      ER39434   LABEL="H39W WTR EPILEPSY B4 AGE 17--WF"                  format=f1.
      ER39435   LABEL="H40W WTR HEADACHE B4 AGE 17--WF"                  format=f1.
      ER39436   LABEL="H41W WTR STOM PROB B4 AGE 17--WF"                 format=f1.
      ER39437   LABEL="H42W WTR HGH BLOOD PR B4 AGE 17--WF"              format=f1.
      ER39438   LABEL="H43W WTR DEPRESSION B4 AGE 17--WF"                format=f1.
      ER39439   LABEL="H44W WTR DRUG/AL PROB B4 AGE 17--WF"              format=f1.
      ER39440   LABEL="H45W WTR OTR PSYCW PROB B4 AGE 17--WF"            format=f1.
      ER39441   LABEL="HEHC SLF RPT: YEAR 1ST REPORT--WF"                format=f4.
      ER39442   LABEL="HEHC SLF RPT: PAR SEP B4 AGE 1--WF"               format=f1.
      ER39443   LABEL="HEHC SLF RPT: PAR SEP AGE 1--WF"                  format=f1.
      ER39444   LABEL="HEHC SLF RPT: PAR SEP AGE 2--WF"                  format=f1.
      ER39445   LABEL="HEHC SLF RPT: PAR SEP AGE 3--WF"                  format=f1.
      ER39446   LABEL="HEHC SLF RPT: PAR SEP AGE 4--WF"                  format=f1.
      ER39447   LABEL="HEHC SLF RPT: PAR SEP AGE 5--WF"                  format=f1.
      ER39448   LABEL="HEHC SLF RPT: PAR SEP AGE 6--WF"                  format=f1.
      ER39449   LABEL="HEHC SLF RPT: PAR SEP AGE 7--WF"                  format=f1.
      ER39450   LABEL="HEHC SLF RPT: PAR SEP AGE 8--WF"                  format=f1.
      ER39451   LABEL="HEHC SLF RPT: PAR SEP AGE 9--WF"                  format=f1.
      ER39452   LABEL="HEHC SLF RPT: PAR SEP AGE 10--WF"                 format=f1.
      ER39453   LABEL="HEHC SLF RPT: PAR SEP AGE 11--WF"                 format=f1.
      ER39454   LABEL="HEHC SLF RPT: PAR SEP AGE 12--WF"                 format=f1.
      ER39455   LABEL="HEHC SLF RPT: PAR SEP AGE 13--WF"                 format=f1.
      ER39456   LABEL="HEHC SLF RPT: PAR SEP AGE 14--WF"                 format=f1.
      ER39457   LABEL="HEHC SLF RPT: PAR SEP AGE 15--WF"                 format=f1.
      ER39458   LABEL="HEHC SLF RPT: PAR SEP AGE 16--WF"                 format=f1.
      ER39459   LABEL="HEHC SLF RPT: MOVE B4 AGE 1--WF"                  format=f1.
      ER39460   LABEL="HEHC SLF RPT: MOVE AGE 1--WF"                     format=f1.
      ER39461   LABEL="HEHC SLF RPT: MOVE AGE 2--WF"                     format=f1.
      ER39462   LABEL="HEHC SLF RPT: MOVE AGE 3--WF"                     format=f1.
      ER39463   LABEL="HEHC SLF RPT: MOVE AGE 4--WF"                     format=f1.
      ER39464   LABEL="HEHC SLF RPT: MOVE AGE 5--WF"                     format=f1.
      ER39465   LABEL="HEHC SLF RPT: MOVE AGE 6--WF"                     format=f1.
      ER39466   LABEL="HEHC SLF RPT: MOVE AGE 7--WF"                     format=f1.
      ER39467   LABEL="HEHC SLF RPT: MOVE AGE 8--WF"                     format=f1.
      ER39468   LABEL="HEHC SLF RPT: MOVE AGE 9--WF"                     format=f1.
      ER39469   LABEL="HEHC SLF RPT: MOVE AGE 10--WF"                    format=f1.
      ER39470   LABEL="HEHC SLF RPT: MOVE AGE 11--WF"                    format=f1.
      ER39471   LABEL="HEHC SLF RPT: MOVE AGE 12--WF"                    format=f1.
      ER39472   LABEL="HEHC SLF RPT: MOVE AGE 13--WF"                    format=f1.
      ER39473   LABEL="HEHC SLF RPT: MOVE AGE 14--WF"                    format=f1.
      ER39474   LABEL="HEHC SLF RPT: MOVE AGE 15--WF"                    format=f1.
      ER39475   LABEL="HEHC SLF RPT: MOVE AGE 16--WF"                    format=f1.
      ER39476   LABEL="HEHC SLF RPT: SCHOOL B4 AGE 1--WF"                format=f1.
      ER39477   LABEL="HEHC SLF RPT: SCHOOL AGE 1--WF"                   format=f1.
      ER39478   LABEL="HEHC SLF RPT: SCHOOL AGE 2--WF"                   format=f1.
      ER39479   LABEL="HEHC SLF RPT: SCHOOL AGE 3--WF"                   format=f1.
      ER39480   LABEL="HEHC SLF RPT: SCHOOL AGE 4--WF"                   format=f1.
      ER39481   LABEL="HEHC SLF RPT: SCHOOL AGE 5--WF"                   format=f1.
      ER39482   LABEL="HEHC SLF RPT: SCHOOL AGE 6--WF"                   format=f1.
      ER39483   LABEL="HEHC SLF RPT: SCHOOL AGE 7--WF"                   format=f1.
      ER39484   LABEL="HEHC SLF RPT: SCHOOL AGE 8--WF"                   format=f1.
      ER39485   LABEL="HEHC SLF RPT: SCHOOL AGE 9--WF"                   format=f1.
      ER39486   LABEL="HEHC SLF RPT: SCHOOL AGE 10--WF"                  format=f1.
      ER39487   LABEL="HEHC SLF RPT: SCHOOL AGE 11--WF"                  format=f1.
      ER39488   LABEL="HEHC SLF RPT: SCHOOL AGE 12--WF"                  format=f1.
      ER39489   LABEL="HEHC SLF RPT: SCHOOL AGE 13--WF"                  format=f1.
      ER39490   LABEL="HEHC SLF RPT: SCHOOL AGE 14--WF"                  format=f1.
      ER39491   LABEL="HEHC SLF RPT: SCHOOL AGE 15--WF"                  format=f1.
      ER39492   LABEL="HEHC SLF RPT: SCHOOL AGE 16--WF"                  format=f1.
      ER39493   LABEL="HEHC SLF RPT: ASTHMA B4 AGE 1--WF"                format=f1.
      ER39494   LABEL="HEHC SLF RPT: ASTHMA AGE 1--WF"                   format=f1.
      ER39495   LABEL="HEHC SLF RPT: ASTHMA AGE 2--WF"                   format=f1.
      ER39496   LABEL="HEHC SLF RPT: ASTHMA AGE 3--WF"                   format=f1.
      ER39497   LABEL="HEHC SLF RPT: ASTHMA AGE 4--WF"                   format=f1.
      ER39498   LABEL="HEHC SLF RPT: ASTHMA AGE 5--WF"                   format=f1.
      ER39499   LABEL="HEHC SLF RPT: ASTHMA AGE 6--WF"                   format=f1.
      ER39500   LABEL="HEHC SLF RPT: ASTHMA AGE 7--WF"                   format=f1.
      ER39501   LABEL="HEHC SLF RPT: ASTHMA AGE 8--WF"                   format=f1.
      ER39502   LABEL="HEHC SLF RPT: ASTHMA AGE 9--WF"                   format=f1.
      ER39503   LABEL="HEHC SLF RPT: ASTHMA AGE 10--WF"                  format=f1.
      ER39504   LABEL="HEHC SLF RPT: ASTHMA AGE 11--WF"                  format=f1.
      ER39505   LABEL="HEHC SLF RPT: ASTHMA AGE 12--WF"                  format=f1.
      ER39506   LABEL="HEHC SLF RPT: ASTHMA AGE 13--WF"                  format=f1.
      ER39507   LABEL="HEHC SLF RPT: ASTHMA AGE 14--WF"                  format=f1.
      ER39508   LABEL="HEHC SLF RPT: ASTHMA AGE 15--WF"                  format=f1.
      ER39509   LABEL="HEHC SLF RPT: ASTHMA AGE 16--WF"                  format=f1.
      ER39510   LABEL="HEHC SLF RPT: ASTHMA AGE 17+--WF"                 format=f1.
      ER39511   LABEL="HEHC SLF RPT: AGE END ASTHMA--WF"                 format=f3.
      ER39512   LABEL="HEHC SLF RPT: DIABETES B4 AGE 1--WF"              format=f1.
      ER39513   LABEL="HEHC SLF RPT: DIABETES AGE 1--WF"                 format=f1.
      ER39514   LABEL="HEHC SLF RPT: DIABETES AGE 2--WF"                 format=f1.
      ER39515   LABEL="HEHC SLF RPT: DIABETES AGE 3--WF"                 format=f1.
      ER39516   LABEL="HEHC SLF RPT: DIABETES AGE 4--WF"                 format=f1.
      ER39517   LABEL="HEHC SLF RPT: DIABETES AGE 5--WF"                 format=f1.
      ER39518   LABEL="HEHC SLF RPT: DIABETES AGE 6--WF"                 format=f1.
      ER39519   LABEL="HEHC SLF RPT: DIABETES AGE 7--WF"                 format=f1.
      ER39520   LABEL="HEHC SLF RPT: DIABETES AGE 8--WF"                 format=f1.
      ER39521   LABEL="HEHC SLF RPT: DIABETES AGE 9--WF"                 format=f1.
      ER39522   LABEL="HEHC SLF RPT: DIABETES AGE 10--WF"                format=f1.
      ER39523   LABEL="HEHC SLF RPT: DIABETES AGE 11--WF"                format=f1.
      ER39524   LABEL="HEHC SLF RPT: DIABETES AGE 12--WF"                format=f1.
      ER39525   LABEL="HEHC SLF RPT: DIABETES AGE 13--WF"                format=f1.
      ER39526   LABEL="HEHC SLF RPT: DIABETES AGE 14--WF"                format=f1.
      ER39527   LABEL="HEHC SLF RPT: DIABETES AGE 15--WF"                format=f1.
      ER39528   LABEL="HEHC SLF RPT: DIABETES AGE 16--WF"                format=f1.
      ER39529   LABEL="HEHC SLF RPT: DIABETES AGE 17+--WF"               format=f1.
      ER39530   LABEL="HEHC SLF RPT: AGE END DIABETES--WF"               format=f3.
      ER39531   LABEL="HEHC SLF RPT: RESP DIS B4 AGE 1--WF"              format=f1.
      ER39532   LABEL="HEHC SLF RPT: RESP DIS AGE 1--WF"                 format=f1.
      ER39533   LABEL="HEHC SLF RPT: RESP DIS AGE 2--WF"                 format=f1.
      ER39534   LABEL="HEHC SLF RPT: RESP DIS AGE 3--WF"                 format=f1.
      ER39535   LABEL="HEHC SLF RPT: RESP DIS AGE 4--WF"                 format=f1.
      ER39536   LABEL="HEHC SLF RPT: RESP DIS AGE 5--WF"                 format=f1.
      ER39537   LABEL="HEHC SLF RPT: RESP DIS AGE 6--WF"                 format=f1.
      ER39538   LABEL="HEHC SLF RPT: RESP DIS AGE 7--WF"                 format=f1.
      ER39539   LABEL="HEHC SLF RPT: RESP DIS AGE 8--WF"                 format=f1.
      ER39540   LABEL="HEHC SLF RPT: RESP DIS AGE 9--WF"                 format=f1.
      ER39541   LABEL="HEHC SLF RPT: RESP DIS AGE 10--WF"                format=f1.
      ER39542   LABEL="HEHC SLF RPT: RESP DIS AGE 11--WF"                format=f1.
      ER39543   LABEL="HEHC SLF RPT: RESP DIS AGE 12--WF"                format=f1.
      ER39544   LABEL="HEHC SLF RPT: RESP DIS AGE 13--WF"                format=f1.
      ER39545   LABEL="HEHC SLF RPT: RESP DIS AGE 14--WF"                format=f1.
      ER39546   LABEL="HEHC SLF RPT: RESP DIS AGE 15--WF"                format=f1.
      ER39547   LABEL="HEHC SLF RPT: RESP DIS AGE 16--WF"                format=f1.
      ER39548   LABEL="HEHC SLF RPT: RESP DIS AGE 17+--WF"               format=f1.
      ER39549   LABEL="HEHC SLF RPT: AGE END RESP DIS--WF"               format=f3.
      ER39550   LABEL="HEHC SLF RPT: SPCH IMPAIR B4 AGE 1--WF"           format=f1.
      ER39551   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 1--WF"              format=f1.
      ER39552   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 2--WF"              format=f1.
      ER39553   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 3--WF"              format=f1.
      ER39554   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 4--WF"              format=f1.
      ER39555   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 5--WF"              format=f1.
      ER39556   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 6--WF"              format=f1.
      ER39557   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 7--WF"              format=f1.
      ER39558   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 8--WF"              format=f1.
      ER39559   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 9--WF"              format=f1.
      ER39560   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 10--WF"             format=f1.
      ER39561   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 11--WF"             format=f1.
      ER39562   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 12--WF"             format=f1.
      ER39563   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 13--WF"             format=f1.
      ER39564   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 14--WF"             format=f1.
      ER39565   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 15--WF"             format=f1.
      ER39566   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 16--WF"             format=f1.
      ER39567   LABEL="HEHC SLF RPT: SPCH IMPAIR AGE 17+--WF"            format=f1.
      ER39568   LABEL="HEHC SLF RPT: AGE END SPCH IMPAIR--WF"            format=f3.
      ER39569   LABEL="HEHC SLF RPT: ALLERGY B4 AGE 1--WF"               format=f1.
      ER39570   LABEL="HEHC SLF RPT: ALLERGY AGE 1--WF"                  format=f1.
      ER39571   LABEL="HEHC SLF RPT: ALLERGY AGE 2--WF"                  format=f1.
      ER39572   LABEL="HEHC SLF RPT: ALLERGY AGE 3--WF"                  format=f1.
      ER39573   LABEL="HEHC SLF RPT: ALLERGY AGE 4--WF"                  format=f1.
      ER39574   LABEL="HEHC SLF RPT: ALLERGY AGE 5--WF"                  format=f1.
      ER39575   LABEL="HEHC SLF RPT: ALLERGY AGE 6--WF"                  format=f1.
      ER39576   LABEL="HEHC SLF RPT: ALLERGY AGE 7--WF"                  format=f1.
      ER39577   LABEL="HEHC SLF RPT: ALLERGY AGE 8--WF"                  format=f1.
      ER39578   LABEL="HEHC SLF RPT: ALLERGY AGE 9--WF"                  format=f1.
      ER39579   LABEL="HEHC SLF RPT: ALLERGY AGE 10--WF"                 format=f1.
      ER39580   LABEL="HEHC SLF RPT: ALLERGY AGE 11--WF"                 format=f1.
      ER39581   LABEL="HEHC SLF RPT: ALLERGY AGE 12--WF"                 format=f1.
      ER39582   LABEL="HEHC SLF RPT: ALLERGY AGE 13--WF"                 format=f1.
      ER39583   LABEL="HEHC SLF RPT: ALLERGY AGE 14--WF"                 format=f1.
      ER39584   LABEL="HEHC SLF RPT: ALLERGY AGE 15--WF"                 format=f1.
      ER39585   LABEL="HEHC SLF RPT: ALLERGY AGE 16--WF"                 format=f1.
      ER39586   LABEL="HEHC SLF RPT: ALLERGY AGE 17+--WF"                format=f1.
      ER39587   LABEL="HEHC SLF RPT: AGE END ALLERGY--WF"                format=f3.
      ER39588   LABEL="HEHC SLF RPT: HEART TRBL B4 AGE 1--WF"            format=f1.
      ER39589   LABEL="HEHC SLF RPT: HEART TRBL AGE 1--WF"               format=f1.
      ER39590   LABEL="HEHC SLF RPT: HEART TRBL AGE 2--WF"               format=f1.
      ER39591   LABEL="HEHC SLF RPT: HEART TRBL AGE 3--WF"               format=f1.
      ER39592   LABEL="HEHC SLF RPT: HEART TRBL AGE 4--WF"               format=f1.
      ER39593   LABEL="HEHC SLF RPT: HEART TRBL AGE 5--WF"               format=f1.
      ER39594   LABEL="HEHC SLF RPT: HEART TRBL AGE 6--WF"               format=f1.
      ER39595   LABEL="HEHC SLF RPT: HEART TRBL AGE 7--WF"               format=f1.
      ER39596   LABEL="HEHC SLF RPT: HEART TRBL AGE 8--WF"               format=f1.
      ER39597   LABEL="HEHC SLF RPT: HEART TRBL AGE 9--WF"               format=f1.
      ER39598   LABEL="HEHC SLF RPT: HEART TRBL AGE 10--WF"              format=f1.
      ER39599   LABEL="HEHC SLF RPT: HEART TRBL AGE 11--WF"              format=f1.
      ER39600   LABEL="HEHC SLF RPT: HEART TRBL AGE 12--WF"              format=f1.
      ER39601   LABEL="HEHC SLF RPT: HEART TRBL AGE 13--WF"              format=f1.
      ER39602   LABEL="HEHC SLF RPT: HEART TRBL AGE 14--WF"              format=f1.
      ER39603   LABEL="HEHC SLF RPT: HEART TRBL AGE 15--WF"              format=f1.
      ER39604   LABEL="HEHC SLF RPT: HEART TRBL AGE 16--WF"              format=f1.
      ER39605   LABEL="HEHC SLF RPT: HEART TRBL AGE 17+--WF"             format=f1.
      ER39606   LABEL="HEHC SLF RPT: AGE END HEART TRBL--WF"             format=f3.
      ER39607   LABEL="HEHC SLF RPT: EAR PROBS B4 AGE 1--WF"             format=f1.
      ER39608   LABEL="HEHC SLF RPT: EAR PROBS AGE 1--WF"                format=f1.
      ER39609   LABEL="HEHC SLF RPT: EAR PROBS AGE 2--WF"                format=f1.
      ER39610   LABEL="HEHC SLF RPT: EAR PROBS AGE 3--WF"                format=f1.
      ER39611   LABEL="HEHC SLF RPT: EAR PROBS AGE 4--WF"                format=f1.
      ER39612   LABEL="HEHC SLF RPT: EAR PROBS AGE 5--WF"                format=f1.
      ER39613   LABEL="HEHC SLF RPT: EAR PROBS AGE 6--WF"                format=f1.
      ER39614   LABEL="HEHC SLF RPT: EAR PROBS AGE 7--WF"                format=f1.
      ER39615   LABEL="HEHC SLF RPT: EAR PROBS AGE 8--WF"                format=f1.
      ER39616   LABEL="HEHC SLF RPT: EAR PROBS AGE 9--WF"                format=f1.
      ER39617   LABEL="HEHC SLF RPT: EAR PROBS AGE 10--WF"               format=f1.
      ER39618   LABEL="HEHC SLF RPT: EAR PROBS AGE 11--WF"               format=f1.
      ER39619   LABEL="HEHC SLF RPT: EAR PROBS AGE 12--WF"               format=f1.
      ER39620   LABEL="HEHC SLF RPT: EAR PROBS AGE 13--WF"               format=f1.
      ER39621   LABEL="HEHC SLF RPT: EAR PROBS AGE 14--WF"               format=f1.
      ER39622   LABEL="HEHC SLF RPT: EAR PROBS AGE 15--WF"               format=f1.
      ER39623   LABEL="HEHC SLF RPT: EAR PROBS AGE 16--WF"               format=f1.
      ER39624   LABEL="HEHC SLF RPT: EAR PROBS AGE 17+--WF"              format=f1.
      ER39625   LABEL="HEHC SLF RPT: AGE END EAR PROBS--WF"              format=f3.
      ER39626   LABEL="HEHC SLF RPT: EPILEPSY B4 AGE 1--WF"              format=f1.
      ER39627   LABEL="HEHC SLF RPT: EPILEPSY AGE 1--WF"                 format=f1.
      ER39628   LABEL="HEHC SLF RPT: EPILEPSY AGE 2--WF"                 format=f1.
      ER39629   LABEL="HEHC SLF RPT: EPILEPSY AGE 3--WF"                 format=f1.
      ER39630   LABEL="HEHC SLF RPT: EPILEPSY AGE 4--WF"                 format=f1.
      ER39631   LABEL="HEHC SLF RPT: EPILEPSY AGE 5--WF"                 format=f1.
      ER39632   LABEL="HEHC SLF RPT: EPILEPSY AGE 6--WF"                 format=f1.
      ER39633   LABEL="HEHC SLF RPT: EPILEPSY AGE 7--WF"                 format=f1.
      ER39634   LABEL="HEHC SLF RPT: EPILEPSY AGE 8--WF"                 format=f1.
      ER39635   LABEL="HEHC SLF RPT: EPILEPSY AGE 9--WF"                 format=f1.
      ER39636   LABEL="HEHC SLF RPT: EPILEPSY AGE 10--WF"                format=f1.
      ER39637   LABEL="HEHC SLF RPT: EPILEPSY AGE 11--WF"                format=f1.
      ER39638   LABEL="HEHC SLF RPT: EPILEPSY AGE 12--WF"                format=f1.
      ER39639   LABEL="HEHC SLF RPT: EPILEPSY AGE 13--WF"                format=f1.
      ER39640   LABEL="HEHC SLF RPT: EPILEPSY AGE 14--WF"                format=f1.
      ER39641   LABEL="HEHC SLF RPT: EPILEPSY AGE 15--WF"                format=f1.
      ER39642   LABEL="HEHC SLF RPT: EPILEPSY AGE 16--WF"                format=f1.
      ER39643   LABEL="HEHC SLF RPT: EPILEPSY AGE 17+--WF"               format=f1.
      ER39644   LABEL="HEHC SLF RPT: AGE END EPILEPSY--WF"               format=f3.
      ER39645   LABEL="HEHC SLF RPT: HEADACHE B4 AGE 1--WF"              format=f1.
      ER39646   LABEL="HEHC SLF RPT: HEADACHE AGE 1--WF"                 format=f1.
      ER39647   LABEL="HEHC SLF RPT: HEADACHE AGE 2--WF"                 format=f1.
      ER39648   LABEL="HEHC SLF RPT: HEADACHE AGE 3--WF"                 format=f1.
      ER39649   LABEL="HEHC SLF RPT: HEADACHE AGE 4--WF"                 format=f1.
      ER39650   LABEL="HEHC SLF RPT: HEADACHE AGE 5--WF"                 format=f1.
      ER39651   LABEL="HEHC SLF RPT: HEADACHE AGE 6--WF"                 format=f1.
      ER39652   LABEL="HEHC SLF RPT: HEADACHE AGE 7--WF"                 format=f1.
      ER39653   LABEL="HEHC SLF RPT: HEADACHE AGE 8--WF"                 format=f1.
      ER39654   LABEL="HEHC SLF RPT: HEADACHE AGE 9--WF"                 format=f1.
      ER39655   LABEL="HEHC SLF RPT: HEADACHE AGE 10--WF"                format=f1.
      ER39656   LABEL="HEHC SLF RPT: HEADACHE AGE 11--WF"                format=f1.
      ER39657   LABEL="HEHC SLF RPT: HEADACHE AGE 12--WF"                format=f1.
      ER39658   LABEL="HEHC SLF RPT: HEADACHE AGE 13--WF"                format=f1.
      ER39659   LABEL="HEHC SLF RPT: HEADACHE AGE 14--WF"                format=f1.
      ER39660   LABEL="HEHC SLF RPT: HEADACHE AGE 15--WF"                format=f1.
      ER39661   LABEL="HEHC SLF RPT: HEADACHE AGE 16--WF"                format=f1.
      ER39662   LABEL="HEHC SLF RPT: HEADACHE AGE 17+--WF"               format=f1.
      ER39663   LABEL="HEHC SLF RPT: AGE END HEADACHE--WF"               format=f3.
      ER39664   LABEL="HEHC SLF RPT: STOM PROB B4 AGE 1--WF"             format=f1.
      ER39665   LABEL="HEHC SLF RPT: STOM PROB AGE 1--WF"                format=f1.
      ER39666   LABEL="HEHC SLF RPT: STOM PROB AGE 2--WF"                format=f1.
      ER39667   LABEL="HEHC SLF RPT: STOM PROB AGE 3--WF"                format=f1.
      ER39668   LABEL="HEHC SLF RPT: STOM PROB AGE 4--WF"                format=f1.
      ER39669   LABEL="HEHC SLF RPT: STOM PROB AGE 5--WF"                format=f1.
      ER39670   LABEL="HEHC SLF RPT: STOM PROB AGE 6--WF"                format=f1.
      ER39671   LABEL="HEHC SLF RPT: STOM PROB AGE 7--WF"                format=f1.
      ER39672   LABEL="HEHC SLF RPT: STOM PROB AGE 8--WF"                format=f1.
      ER39673   LABEL="HEHC SLF RPT: STOM PROB AGE 9--WF"                format=f1.
      ER39674   LABEL="HEHC SLF RPT: STOM PROB AGE 10--WF"               format=f1.
      ER39675   LABEL="HEHC SLF RPT: STOM PROB AGE 11--WF"               format=f1.
      ER39676   LABEL="HEHC SLF RPT: STOM PROB AGE 12--WF"               format=f1.
      ER39677   LABEL="HEHC SLF RPT: STOM PROB AGE 13--WF"               format=f1.
      ER39678   LABEL="HEHC SLF RPT: STOM PROB AGE 14--WF"               format=f1.
      ER39679   LABEL="HEHC SLF RPT: STOM PROB AGE 15--WF"               format=f1.
      ER39680   LABEL="HEHC SLF RPT: STOM PROB AGE 16--WF"               format=f1.
      ER39681   LABEL="HEHC SLF RPT: STOM PROB AGE 17+--WF"              format=f1.
      ER39682   LABEL="HEHC SLF RPT: AGE END STOM PROB--WF"              format=f3.
      ER39683   LABEL="HEHC SLF RPT: HGH BLOOD PR B4 AGE 1--WF"          format=f1.
      ER39684   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 1--WF"             format=f1.
      ER39685   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 2--WF"             format=f1.
      ER39686   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 3--WF"             format=f1.
      ER39687   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 4--WF"             format=f1.
      ER39688   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 5--WF"             format=f1.
      ER39689   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 6--WF"             format=f1.
      ER39690   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 7--WF"             format=f1.
      ER39691   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 8--WF"             format=f1.
      ER39692   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 9--WF"             format=f1.
      ER39693   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 10--WF"            format=f1.
      ER39694   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 11--WF"            format=f1.
      ER39695   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 12--WF"            format=f1.
      ER39696   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 13--WF"            format=f1.
      ER39697   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 14--WF"            format=f1.
      ER39698   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 15--WF"            format=f1.
      ER39699   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 16--WF"            format=f1.
      ER39700   LABEL="HEHC SLF RPT: HGH BLOOD PR AGE 17+--WF"           format=f1.
      ER39701   LABEL="HEHC SLF RPT: AGE END HGH BLOOD PR--WF"           format=f3.
      ER39702   LABEL="HEHC SLF RPT: DEPRESSION B4 AGE 1--WF"            format=f1.
      ER39703   LABEL="HEHC SLF RPT: DEPRESSION AGE 1--WF"               format=f1.
      ER39704   LABEL="HEHC SLF RPT: DEPRESSION AGE 2--WF"               format=f1.
      ER39705   LABEL="HEHC SLF RPT: DEPRESSION AGE 3--WF"               format=f1.
      ER39706   LABEL="HEHC SLF RPT: DEPRESSION AGE 4--WF"               format=f1.
      ER39707   LABEL="HEHC SLF RPT: DEPRESSION AGE 5--WF"               format=f1.
      ER39708   LABEL="HEHC SLF RPT: DEPRESSION AGE 6--WF"               format=f1.
      ER39709   LABEL="HEHC SLF RPT: DEPRESSION AGE 7--WF"               format=f1.
      ER39710   LABEL="HEHC SLF RPT: DEPRESSION AGE 8--WF"               format=f1.
      ER39711   LABEL="HEHC SLF RPT: DEPRESSION AGE 9--WF"               format=f1.
      ER39712   LABEL="HEHC SLF RPT: DEPRESSION AGE 10--WF"              format=f1.
      ER39713   LABEL="HEHC SLF RPT: DEPRESSION AGE 11--WF"              format=f1.
      ER39714   LABEL="HEHC SLF RPT: DEPRESSION AGE 12--WF"              format=f1.
      ER39715   LABEL="HEHC SLF RPT: DEPRESSION AGE 13--WF"              format=f1.
      ER39716   LABEL="HEHC SLF RPT: DEPRESSION AGE 14--WF"              format=f1.
      ER39717   LABEL="HEHC SLF RPT: DEPRESSION AGE 15--WF"              format=f1.
      ER39718   LABEL="HEHC SLF RPT: DEPRESSION AGE 16--WF"              format=f1.
      ER39719   LABEL="HEHC SLF RPT: DEPRESSION AGE 17+--WF"             format=f1.
      ER39720   LABEL="HEHC SLF RPT: AGE END DEPRESSION--WF"             format=f3.
      ER39721   LABEL="HEHC SLF RPT: DRUG/AL PROB B4 AGE 1--WF"          format=f1.
      ER39722   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 1--WF"             format=f1.
      ER39723   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 2--WF"             format=f1.
      ER39724   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 3--WF"             format=f1.
      ER39725   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 4--WF"             format=f1.
      ER39726   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 5--WF"             format=f1.
      ER39727   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 6--WF"             format=f1.
      ER39728   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 7--WF"             format=f1.
      ER39729   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 8--WF"             format=f1.
      ER39730   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 9--WF"             format=f1.
      ER39731   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 10--WF"            format=f1.
      ER39732   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 11--WF"            format=f1.
      ER39733   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 12--WF"            format=f1.
      ER39734   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 13--WF"            format=f1.
      ER39735   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 14--WF"            format=f1.
      ER39736   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 15--WF"            format=f1.
      ER39737   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 16--WF"            format=f1.
      ER39738   LABEL="HEHC SLF RPT: DRUG/AL PROB AGE 17+--WF"           format=f1.
      ER39739   LABEL="HEHC SLF RPT: AGE END DRUG/AL PROB--WF"           format=f3.
      ER39740   LABEL="HEHC SLF RPT: OTR PSYCH PROB B4 AGE 1--W"         format=f1.
      ER39741   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 1--WF"           format=f1.
      ER39742   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 2--WF"           format=f1.
      ER39743   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 3--WF"           format=f1.
      ER39744   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 4--WF"           format=f1.
      ER39745   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 5--WF"           format=f1.
      ER39746   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 6--WF"           format=f1.
      ER39747   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 7--WF"           format=f1.
      ER39748   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 8--WF"           format=f1.
      ER39749   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 9--WF"           format=f1.
      ER39750   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 10--WF"          format=f1.
      ER39751   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 11--WF"          format=f1.
      ER39752   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 12--WF"          format=f1.
      ER39753   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 13--WF"          format=f1.
      ER39754   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 14--WF"          format=f1.
      ER39755   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 15--WF"          format=f1.
      ER39756   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 16--WF"          format=f1.
      ER39757   LABEL="HEHC SLF RPT: OTR PSYCH PROB AGE 17+--WF"         format=f1.
      ER39758   LABEL="HEHC SLF RPT: AGE END OTR PSYCH PROB--WF"         format=f3.
      ER39759   LABEL="HEHC SP RPT: YEAR 1ST REPORT--WF"                 format=f4.
      ER39760   LABEL="HEHC SP RPT: PAR SEP B4 AGE 1--WF"                format=f1.
      ER39761   LABEL="HEHC SP RPT: PAR SEP AGE 1--WF"                   format=f1.
      ER39762   LABEL="HEHC SP RPT: PAR SEP AGE 2--WF"                   format=f1.
      ER39763   LABEL="HEHC SP RPT: PAR SEP AGE 3--WF"                   format=f1.
      ER39764   LABEL="HEHC SP RPT: PAR SEP AGE 4--WF"                   format=f1.
      ER39765   LABEL="HEHC SP RPT: PAR SEP AGE 5--WF"                   format=f1.
      ER39766   LABEL="HEHC SP RPT: PAR SEP AGE 6--WF"                   format=f1.
      ER39767   LABEL="HEHC SP RPT: PAR SEP AGE 7--WF"                   format=f1.
      ER39768   LABEL="HEHC SP RPT: PAR SEP AGE 8--WF"                   format=f1.
      ER39769   LABEL="HEHC SP RPT: PAR SEP AGE 9--WF"                   format=f1.
      ER39770   LABEL="HEHC SP RPT: PAR SEP AGE 10--WF"                  format=f1.
      ER39771   LABEL="HEHC SP RPT: PAR SEP AGE 11--WF"                  format=f1.
      ER39772   LABEL="HEHC SP RPT: PAR SEP AGE 12--WF"                  format=f1.
      ER39773   LABEL="HEHC SP RPT: PAR SEP AGE 13--WF"                  format=f1.
      ER39774   LABEL="HEHC SP RPT: PAR SEP AGE 14--WF"                  format=f1.
      ER39775   LABEL="HEHC SP RPT: PAR SEP AGE 15--WF"                  format=f1.
      ER39776   LABEL="HEHC SP RPT: PAR SEP AGE 16--WF"                  format=f1.
      ER39777   LABEL="HEHC SP RPT: MOVE B4 AGE 1--WF"                   format=f1.
      ER39778   LABEL="HEHC SP RPT: MOVE AGE 1--WF"                      format=f1.
      ER39779   LABEL="HEHC SP RPT: MOVE AGE 2--WF"                      format=f1.
      ER39780   LABEL="HEHC SP RPT: MOVE AGE 3--WF"                      format=f1.
      ER39781   LABEL="HEHC SP RPT: MOVE AGE 4--WF"                      format=f1.
      ER39782   LABEL="HEHC SP RPT: MOVE AGE 5--WF"                      format=f1.
      ER39783   LABEL="HEHC SP RPT: MOVE AGE 6--WF"                      format=f1.
      ER39784   LABEL="HEHC SP RPT: MOVE AGE 7--WF"                      format=f1.
      ER39785   LABEL="HEHC SP RPT: MOVE AGE 8--WF"                      format=f1.
      ER39786   LABEL="HEHC SP RPT: MOVE AGE 9--WF"                      format=f1.
      ER39787   LABEL="HEHC SP RPT: MOVE AGE 10--WF"                     format=f1.
      ER39788   LABEL="HEHC SP RPT: MOVE AGE 11--WF"                     format=f1.
      ER39789   LABEL="HEHC SP RPT: MOVE AGE 12--WF"                     format=f1.
      ER39790   LABEL="HEHC SP RPT: MOVE AGE 13--WF"                     format=f1.
      ER39791   LABEL="HEHC SP RPT: MOVE AGE 14--WF"                     format=f1.
      ER39792   LABEL="HEHC SP RPT: MOVE AGE 15--WF"                     format=f1.
      ER39793   LABEL="HEHC SP RPT: MOVE AGE 16--WF"                     format=f1.
      ER39794   LABEL="HEHC SP RPT: SCHOOL B4 AGE 1--WF"                 format=f1.
      ER39795   LABEL="HEHC SP RPT: SCHOOL AGE 1--WF"                    format=f1.
      ER39796   LABEL="HEHC SP RPT: SCHOOL AGE 2--WF"                    format=f1.
      ER39797   LABEL="HEHC SP RPT: SCHOOL AGE 3--WF"                    format=f1.
      ER39798   LABEL="HEHC SP RPT: SCHOOL AGE 4--WF"                    format=f1.
      ER39799   LABEL="HEHC SP RPT: SCHOOL AGE 5--WF"                    format=f1.
      ER39800   LABEL="HEHC SP RPT: SCHOOL AGE 6--WF"                    format=f1.
      ER39801   LABEL="HEHC SP RPT: SCHOOL AGE 7--WF"                    format=f1.
      ER39802   LABEL="HEHC SP RPT: SCHOOL AGE 8--WF"                    format=f1.
      ER39803   LABEL="HEHC SP RPT: SCHOOL AGE 9--WF"                    format=f1.
      ER39804   LABEL="HEHC SP RPT: SCHOOL AGE 10--WF"                   format=f1.
      ER39805   LABEL="HEHC SP RPT: SCHOOL AGE 11--WF"                   format=f1.
      ER39806   LABEL="HEHC SP RPT: SCHOOL AGE 12--WF"                   format=f1.
      ER39807   LABEL="HEHC SP RPT: SCHOOL AGE 13--WF"                   format=f1.
      ER39808   LABEL="HEHC SP RPT: SCHOOL AGE 14--WF"                   format=f1.
      ER39809   LABEL="HEHC SP RPT: SCHOOL AGE 15--WF"                   format=f1.
      ER39810   LABEL="HEHC SP RPT: SCHOOL AGE 16--WF"                   format=f1.
      ER39811   LABEL="HEHC SP RPT: ASTHMA B4 AGE 1--WF"                 format=f1.
      ER39812   LABEL="HEHC SP RPT: ASTHMA AGE 1--WF"                    format=f1.
      ER39813   LABEL="HEHC SP RPT: ASTHMA AGE 2--WF"                    format=f1.
      ER39814   LABEL="HEHC SP RPT: ASTHMA AGE 3--WF"                    format=f1.
      ER39815   LABEL="HEHC SP RPT: ASTHMA AGE 4--WF"                    format=f1.
      ER39816   LABEL="HEHC SP RPT: ASTHMA AGE 5--WF"                    format=f1.
      ER39817   LABEL="HEHC SP RPT: ASTHMA AGE 6--WF"                    format=f1.
      ER39818   LABEL="HEHC SP RPT: ASTHMA AGE 7--WF"                    format=f1.
      ER39819   LABEL="HEHC SP RPT: ASTHMA AGE 8--WF"                    format=f1.
      ER39820   LABEL="HEHC SP RPT: ASTHMA AGE 9--WF"                    format=f1.
      ER39821   LABEL="HEHC SP RPT: ASTHMA AGE 10--WF"                   format=f1.
      ER39822   LABEL="HEHC SP RPT: ASTHMA AGE 11--WF"                   format=f1.
      ER39823   LABEL="HEHC SP RPT: ASTHMA AGE 12--WF"                   format=f1.
      ER39824   LABEL="HEHC SP RPT: ASTHMA AGE 13--WF"                   format=f1.
      ER39825   LABEL="HEHC SP RPT: ASTHMA AGE 14--WF"                   format=f1.
      ER39826   LABEL="HEHC SP RPT: ASTHMA AGE 15--WF"                   format=f1.
      ER39827   LABEL="HEHC SP RPT: ASTHMA AGE 16--WF"                   format=f1.
      ER39828   LABEL="HEHC SP RPT: ASTHMA AGE 17+--WF"                  format=f1.
      ER39829   LABEL="HEHC SP RPT: AGE END ASTHMA--WF"                  format=f3.
      ER39830   LABEL="HEHC SP RPT: DIABETES B4 AGE 1--WF"               format=f1.
      ER39831   LABEL="HEHC SP RPT: DIABETES AGE 1--WF"                  format=f1.
      ER39832   LABEL="HEHC SP RPT: DIABETES AGE 2--WF"                  format=f1.
      ER39833   LABEL="HEHC SP RPT: DIABETES AGE 3--WF"                  format=f1.
      ER39834   LABEL="HEHC SP RPT: DIABETES AGE 4--WF"                  format=f1.
      ER39835   LABEL="HEHC SP RPT: DIABETES AGE 5--WF"                  format=f1.
      ER39836   LABEL="HEHC SP RPT: DIABETES AGE 6--WF"                  format=f1.
      ER39837   LABEL="HEHC SP RPT: DIABETES AGE 7--WF"                  format=f1.
      ER39838   LABEL="HEHC SP RPT: DIABETES AGE 8--WF"                  format=f1.
      ER39839   LABEL="HEHC SP RPT: DIABETES AGE 9--WF"                  format=f1.
      ER39840   LABEL="HEHC SP RPT: DIABETES AGE 10--WF"                 format=f1.
      ER39841   LABEL="HEHC SP RPT: DIABETES AGE 11--WF"                 format=f1.
      ER39842   LABEL="HEHC SP RPT: DIABETES AGE 12--WF"                 format=f1.
      ER39843   LABEL="HEHC SP RPT: DIABETES AGE 13--WF"                 format=f1.
      ER39844   LABEL="HEHC SP RPT: DIABETES AGE 14--WF"                 format=f1.
      ER39845   LABEL="HEHC SP RPT: DIABETES AGE 15--WF"                 format=f1.
      ER39846   LABEL="HEHC SP RPT: DIABETES AGE 16--WF"                 format=f1.
      ER39847   LABEL="HEHC SP RPT: DIABETES AGE 17+--WF"                format=f1.
      ER39848   LABEL="HEHC SP RPT: AGE END DIABETES--WF"                format=f3.
      ER39849   LABEL="HEHC SP RPT: RESP DIS B4 AGE 1--WF"               format=f1.
      ER39850   LABEL="HEHC SP RPT: RESP DIS AGE 1--WF"                  format=f1.
      ER39851   LABEL="HEHC SP RPT: RESP DIS AGE 2--WF"                  format=f1.
      ER39852   LABEL="HEHC SP RPT: RESP DIS AGE 3--WF"                  format=f1.
      ER39853   LABEL="HEHC SP RPT: RESP DIS AGE 4--WF"                  format=f1.
      ER39854   LABEL="HEHC SP RPT: RESP DIS AGE 5--WF"                  format=f1.
      ER39855   LABEL="HEHC SP RPT: RESP DIS AGE 6--WF"                  format=f1.
      ER39856   LABEL="HEHC SP RPT: RESP DIS AGE 7--WF"                  format=f1.
      ER39857   LABEL="HEHC SP RPT: RESP DIS AGE 8--WF"                  format=f1.
      ER39858   LABEL="HEHC SP RPT: RESP DIS AGE 9--WF"                  format=f1.
      ER39859   LABEL="HEHC SP RPT: RESP DIS AGE 10--WF"                 format=f1.
      ER39860   LABEL="HEHC SP RPT: RESP DIS AGE 11--WF"                 format=f1.
      ER39861   LABEL="HEHC SP RPT: RESP DIS AGE 12--WF"                 format=f1.
      ER39862   LABEL="HEHC SP RPT: RESP DIS AGE 13--WF"                 format=f1.
      ER39863   LABEL="HEHC SP RPT: RESP DIS AGE 14--WF"                 format=f1.
      ER39864   LABEL="HEHC SP RPT: RESP DIS AGE 15--WF"                 format=f1.
      ER39865   LABEL="HEHC SP RPT: RESP DIS AGE 16--WF"                 format=f1.
      ER39866   LABEL="HEHC SP RPT: RESP DIS AGE 17+--WF"                format=f1.
      ER39867   LABEL="HEHC SP RPT: AGE END RESP DIS--WF"                format=f3.
      ER39868   LABEL="HEHC SP RPT: SPCH IMPAIR B4 AGE 1--WF"            format=f1.
      ER39869   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 1--WF"               format=f1.
      ER39870   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 2--WF"               format=f1.
      ER39871   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 3--WF"               format=f1.
      ER39872   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 4--WF"               format=f1.
      ER39873   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 5--WF"               format=f1.
      ER39874   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 6--WF"               format=f1.
      ER39875   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 7--WF"               format=f1.
      ER39876   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 8--WF"               format=f1.
      ER39877   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 9--WF"               format=f1.
      ER39878   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 10--WF"              format=f1.
      ER39879   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 11--WF"              format=f1.
      ER39880   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 12--WF"              format=f1.
      ER39881   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 13--WF"              format=f1.
      ER39882   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 14--WF"              format=f1.
      ER39883   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 15--WF"              format=f1.
      ER39884   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 16--WF"              format=f1.
      ER39885   LABEL="HEHC SP RPT: SPCH IMPAIR AGE 17+--WF"             format=f1.
      ER39886   LABEL="HEHC SP RPT: AGE END SPCH IMPAIR--WF"             format=f3.
      ER39887   LABEL="HEHC SP RPT: ALLERGY B4 AGE 1--WF"                format=f1.
      ER39888   LABEL="HEHC SP RPT: ALLERGY AGE 1--WF"                   format=f1.
      ER39889   LABEL="HEHC SP RPT: ALLERGY AGE 2--WF"                   format=f1.
      ER39890   LABEL="HEHC SP RPT: ALLERGY AGE 3--WF"                   format=f1.
      ER39891   LABEL="HEHC SP RPT: ALLERGY AGE 4--WF"                   format=f1.
      ER39892   LABEL="HEHC SP RPT: ALLERGY AGE 5--WF"                   format=f1.
      ER39893   LABEL="HEHC SP RPT: ALLERGY AGE 6--WF"                   format=f1.
      ER39894   LABEL="HEHC SP RPT: ALLERGY AGE 7--WF"                   format=f1.
      ER39895   LABEL="HEHC SP RPT: ALLERGY AGE 8--WF"                   format=f1.
      ER39896   LABEL="HEHC SP RPT: ALLERGY AGE 9--WF"                   format=f1.
      ER39897   LABEL="HEHC SP RPT: ALLERGY AGE 10--WF"                  format=f1.
      ER39898   LABEL="HEHC SP RPT: ALLERGY AGE 11--WF"                  format=f1.
      ER39899   LABEL="HEHC SP RPT: ALLERGY AGE 12--WF"                  format=f1.
      ER39900   LABEL="HEHC SP RPT: ALLERGY AGE 13--WF"                  format=f1.
      ER39901   LABEL="HEHC SP RPT: ALLERGY AGE 14--WF"                  format=f1.
      ER39902   LABEL="HEHC SP RPT: ALLERGY AGE 15--WF"                  format=f1.
      ER39903   LABEL="HEHC SP RPT: ALLERGY AGE 16--WF"                  format=f1.
      ER39904   LABEL="HEHC SP RPT: ALLERGY AGE 17+--WF"                 format=f1.
      ER39905   LABEL="HEHC SP RPT: AGE END ALLERGY--WF"                 format=f3.
      ER39906   LABEL="HEHC SP RPT: HEART TRBL B4 AGE 1--WF"             format=f1.
      ER39907   LABEL="HEHC SP RPT: HEART TRBL AGE 1--WF"                format=f1.
      ER39908   LABEL="HEHC SP RPT: HEART TRBL AGE 2--WF"                format=f1.
      ER39909   LABEL="HEHC SP RPT: HEART TRBL AGE 3--WF"                format=f1.
      ER39910   LABEL="HEHC SP RPT: HEART TRBL AGE 4--WF"                format=f1.
      ER39911   LABEL="HEHC SP RPT: HEART TRBL AGE 5--WF"                format=f1.
      ER39912   LABEL="HEHC SP RPT: HEART TRBL AGE 6--WF"                format=f1.
      ER39913   LABEL="HEHC SP RPT: HEART TRBL AGE 7--WF"                format=f1.
      ER39914   LABEL="HEHC SP RPT: HEART TRBL AGE 8--WF"                format=f1.
      ER39915   LABEL="HEHC SP RPT: HEART TRBL AGE 9--WF"                format=f1.
      ER39916   LABEL="HEHC SP RPT: HEART TRBL AGE 10--WF"               format=f1.
      ER39917   LABEL="HEHC SP RPT: HEART TRBL AGE 11--WF"               format=f1.
      ER39918   LABEL="HEHC SP RPT: HEART TRBL AGE 12--WF"               format=f1.
      ER39919   LABEL="HEHC SP RPT: HEART TRBL AGE 13--WF"               format=f1.
      ER39920   LABEL="HEHC SP RPT: HEART TRBL AGE 14--WF"               format=f1.
      ER39921   LABEL="HEHC SP RPT: HEART TRBL AGE 15--WF"               format=f1.
      ER39922   LABEL="HEHC SP RPT: HEART TRBL AGE 16--WF"               format=f1.
      ER39923   LABEL="HEHC SP RPT: HEART TRBL AGE 17+--WF"              format=f1.
      ER39924   LABEL="HEHC SP RPT: AGE END HEART TRBL--WF"              format=f3.
      ER39925   LABEL="HEHC SP RPT: EAR PROBS B4 AGE 1--WF"              format=f1.
      ER39926   LABEL="HEHC SP RPT: EAR PROBS AGE 1--WF"                 format=f1.
      ER39927   LABEL="HEHC SP RPT: EAR PROBS AGE 2--WF"                 format=f1.
      ER39928   LABEL="HEHC SP RPT: EAR PROBS AGE 3--WF"                 format=f1.
      ER39929   LABEL="HEHC SP RPT: EAR PROBS AGE 4--WF"                 format=f1.
      ER39930   LABEL="HEHC SP RPT: EAR PROBS AGE 5--WF"                 format=f1.
      ER39931   LABEL="HEHC SP RPT: EAR PROBS AGE 6--WF"                 format=f1.
      ER39932   LABEL="HEHC SP RPT: EAR PROBS AGE 7--WF"                 format=f1.
      ER39933   LABEL="HEHC SP RPT: EAR PROBS AGE 8--WF"                 format=f1.
      ER39934   LABEL="HEHC SP RPT: EAR PROBS AGE 9--WF"                 format=f1.
      ER39935   LABEL="HEHC SP RPT: EAR PROBS AGE 10--WF"                format=f1.
      ER39936   LABEL="HEHC SP RPT: EAR PROBS AGE 11--WF"                format=f1.
      ER39937   LABEL="HEHC SP RPT: EAR PROBS AGE 12--WF"                format=f1.
      ER39938   LABEL="HEHC SP RPT: EAR PROBS AGE 13--WF"                format=f1.
      ER39939   LABEL="HEHC SP RPT: EAR PROBS AGE 14--WF"                format=f1.
      ER39940   LABEL="HEHC SP RPT: EAR PROBS AGE 15--WF"                format=f1.
      ER39941   LABEL="HEHC SP RPT: EAR PROBS AGE 16--WF"                format=f1.
      ER39942   LABEL="HEHC SP RPT: EAR PROBS AGE 17+--WF"               format=f1.
      ER39943   LABEL="HEHC SP RPT: AGE END EAR PROBS--WF"               format=f3.
      ER39944   LABEL="HEHC SP RPT: EPILEPSY B4 AGE 1--WF"               format=f1.
      ER39945   LABEL="HEHC SP RPT: EPILEPSY AGE 1--WF"                  format=f1.
      ER39946   LABEL="HEHC SP RPT: EPILEPSY AGE 2--WF"                  format=f1.
      ER39947   LABEL="HEHC SP RPT: EPILEPSY AGE 3--WF"                  format=f1.
      ER39948   LABEL="HEHC SP RPT: EPILEPSY AGE 4--WF"                  format=f1.
      ER39949   LABEL="HEHC SP RPT: EPILEPSY AGE 5--WF"                  format=f1.
      ER39950   LABEL="HEHC SP RPT: EPILEPSY AGE 6--WF"                  format=f1.
      ER39951   LABEL="HEHC SP RPT: EPILEPSY AGE 7--WF"                  format=f1.
      ER39952   LABEL="HEHC SP RPT: EPILEPSY AGE 8--WF"                  format=f1.
      ER39953   LABEL="HEHC SP RPT: EPILEPSY AGE 9--WF"                  format=f1.
      ER39954   LABEL="HEHC SP RPT: EPILEPSY AGE 10--WF"                 format=f1.
      ER39955   LABEL="HEHC SP RPT: EPILEPSY AGE 11--WF"                 format=f1.
      ER39956   LABEL="HEHC SP RPT: EPILEPSY AGE 12--WF"                 format=f1.
      ER39957   LABEL="HEHC SP RPT: EPILEPSY AGE 13--WF"                 format=f1.
      ER39958   LABEL="HEHC SP RPT: EPILEPSY AGE 14--WF"                 format=f1.
      ER39959   LABEL="HEHC SP RPT: EPILEPSY AGE 15--WF"                 format=f1.
      ER39960   LABEL="HEHC SP RPT: EPILEPSY AGE 16--WF"                 format=f1.
      ER39961   LABEL="HEHC SP RPT: EPILEPSY AGE 17+--WF"                format=f1.
      ER39962   LABEL="HEHC SP RPT: AGE END EPILEPSY--WF"                format=f3.
      ER39963   LABEL="HEHC SP RPT: HEADACHE B4 AGE 1--WF"               format=f1.
      ER39964   LABEL="HEHC SP RPT: HEADACHE AGE 1--WF"                  format=f1.
      ER39965   LABEL="HEHC SP RPT: HEADACHE AGE 2--WF"                  format=f1.
      ER39966   LABEL="HEHC SP RPT: HEADACHE AGE 3--WF"                  format=f1.
      ER39967   LABEL="HEHC SP RPT: HEADACHE AGE 4--WF"                  format=f1.
      ER39968   LABEL="HEHC SP RPT: HEADACHE AGE 5--WF"                  format=f1.
      ER39969   LABEL="HEHC SP RPT: HEADACHE AGE 6--WF"                  format=f1.
      ER39970   LABEL="HEHC SP RPT: HEADACHE AGE 7--WF"                  format=f1.
      ER39971   LABEL="HEHC SP RPT: HEADACHE AGE 8--WF"                  format=f1.
      ER39972   LABEL="HEHC SP RPT: HEADACHE AGE 9--WF"                  format=f1.
      ER39973   LABEL="HEHC SP RPT: HEADACHE AGE 10--WF"                 format=f1.
      ER39974   LABEL="HEHC SP RPT: HEADACHE AGE 11--WF"                 format=f1.
      ER39975   LABEL="HEHC SP RPT: HEADACHE AGE 12--WF"                 format=f1.
      ER39976   LABEL="HEHC SP RPT: HEADACHE AGE 13--WF"                 format=f1.
      ER39977   LABEL="HEHC SP RPT: HEADACHE AGE 14--WF"                 format=f1.
      ER39978   LABEL="HEHC SP RPT: HEADACHE AGE 15--WF"                 format=f1.
      ER39979   LABEL="HEHC SP RPT: HEADACHE AGE 16--WF"                 format=f1.
      ER39980   LABEL="HEHC SP RPT: HEADACHE AGE 17+--WF"                format=f1.
      ER39981   LABEL="HEHC SP RPT: AGE END HEADACHE--WF"                format=f3.
      ER39982   LABEL="HEHC SP RPT: STOM PROB B4 AGE 1--WF"              format=f1.
      ER39983   LABEL="HEHC SP RPT: STOM PROB AGE 1--WF"                 format=f1.
      ER39984   LABEL="HEHC SP RPT: STOM PROB AGE 2--WF"                 format=f1.
      ER39985   LABEL="HEHC SP RPT: STOM PROB AGE 3--WF"                 format=f1.
      ER39986   LABEL="HEHC SP RPT: STOM PROB AGE 4--WF"                 format=f1.
      ER39987   LABEL="HEHC SP RPT: STOM PROB AGE 5--WF"                 format=f1.
      ER39988   LABEL="HEHC SP RPT: STOM PROB AGE 6--WF"                 format=f1.
      ER39989   LABEL="HEHC SP RPT: STOM PROB AGE 7--WF"                 format=f1.
      ER39990   LABEL="HEHC SP RPT: STOM PROB AGE 8--WF"                 format=f1.
      ER39991   LABEL="HEHC SP RPT: STOM PROB AGE 9--WF"                 format=f1.
      ER39992   LABEL="HEHC SP RPT: STOM PROB AGE 10--WF"                format=f1.
      ER39993   LABEL="HEHC SP RPT: STOM PROB AGE 11--WF"                format=f1.
      ER39994   LABEL="HEHC SP RPT: STOM PROB AGE 12--WF"                format=f1.
      ER39995   LABEL="HEHC SP RPT: STOM PROB AGE 13--WF"                format=f1.
      ER39996   LABEL="HEHC SP RPT: STOM PROB AGE 14--WF"                format=f1.
      ER39997   LABEL="HEHC SP RPT: STOM PROB AGE 15--WF"                format=f1.
      ER39998   LABEL="HEHC SP RPT: STOM PROB AGE 16--WF"                format=f1.
      ER39999   LABEL="HEHC SP RPT: STOM PROB AGE 17+--WF"               format=f1.
      ER40000   LABEL="HEHC SP RPT: AGE END STOM PROB--WF"               format=f3.
      ER40001   LABEL="HEHC SP RPT: HGH BLOOD PR B4 AGE 1--WF"           format=f1.
      ER40002   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 1--WF"              format=f1.
      ER40003   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 2--WF"              format=f1.
      ER40004   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 3--WF"              format=f1.
      ER40005   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 4--WF"              format=f1.
      ER40006   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 5--WF"              format=f1.
      ER40007   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 6--WF"              format=f1.
      ER40008   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 7--WF"              format=f1.
      ER40009   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 8--WF"              format=f1.
      ER40010   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 9--WF"              format=f1.
      ER40011   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 10--WF"             format=f1.
      ER40012   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 11--WF"             format=f1.
      ER40013   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 12--WF"             format=f1.
      ER40014   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 13--WF"             format=f1.
      ER40015   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 14--WF"             format=f1.
      ER40016   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 15--WF"             format=f1.
      ER40017   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 16--WF"             format=f1.
      ER40018   LABEL="HEHC SP RPT: HGH BLOOD PR AGE 17+--WF"            format=f1.
      ER40019   LABEL="HEHC SP RPT: AGE END HGH BLOOD PR--WF"            format=f3.
      ER40020   LABEL="HEHC SP RPT: DEPRESSION B4 AGE 1--WF"             format=f1.
      ER40021   LABEL="HEHC SP RPT: DEPRESSION AGE 1--WF"                format=f1.
      ER40022   LABEL="HEHC SP RPT: DEPRESSION AGE 2--WF"                format=f1.
      ER40023   LABEL="HEHC SP RPT: DEPRESSION AGE 3--WF"                format=f1.
      ER40024   LABEL="HEHC SP RPT: DEPRESSION AGE 4--WF"                format=f1.
      ER40025   LABEL="HEHC SP RPT: DEPRESSION AGE 5--WF"                format=f1.
      ER40026   LABEL="HEHC SP RPT: DEPRESSION AGE 6--WF"                format=f1.
      ER40027   LABEL="HEHC SP RPT: DEPRESSION AGE 7--WF"                format=f1.
      ER40028   LABEL="HEHC SP RPT: DEPRESSION AGE 8--WF"                format=f1.
      ER40029   LABEL="HEHC SP RPT: DEPRESSION AGE 9--WF"                format=f1.
      ER40030   LABEL="HEHC SP RPT: DEPRESSION AGE 10--WF"               format=f1.
      ER40031   LABEL="HEHC SP RPT: DEPRESSION AGE 11--WF"               format=f1.
      ER40032   LABEL="HEHC SP RPT: DEPRESSION AGE 12--WF"               format=f1.
      ER40033   LABEL="HEHC SP RPT: DEPRESSION AGE 13--WF"               format=f1.
      ER40034   LABEL="HEHC SP RPT: DEPRESSION AGE 14--WF"               format=f1.
      ER40035   LABEL="HEHC SP RPT: DEPRESSION AGE 15--WF"               format=f1.
      ER40036   LABEL="HEHC SP RPT: DEPRESSION AGE 16--WF"               format=f1.
      ER40037   LABEL="HEHC SP RPT: DEPRESSION AGE 17+--WF"              format=f1.
      ER40038   LABEL="HEHC SP RPT: AGE END DEPRESSION--WF"              format=f3.
      ER40039   LABEL="HEHC SP RPT: DRUG/AL PROB B4 AGE 1--WF"           format=f1.
      ER40040   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 1--WF"              format=f1.
      ER40041   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 2--WF"              format=f1.
      ER40042   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 3--WF"              format=f1.
      ER40043   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 4--WF"              format=f1.
      ER40044   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 5--WF"              format=f1.
      ER40045   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 6--WF"              format=f1.
      ER40046   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 7--WF"              format=f1.
      ER40047   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 8--WF"              format=f1.
      ER40048   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 9--WF"              format=f1.
      ER40049   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 10--WF"             format=f1.
      ER40050   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 11--WF"             format=f1.
      ER40051   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 12--WF"             format=f1.
      ER40052   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 13--WF"             format=f1.
      ER40053   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 14--WF"             format=f1.
      ER40054   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 15--WF"             format=f1.
      ER40055   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 16--WF"             format=f1.
      ER40056   LABEL="HEHC SP RPT: DRUG/AL PROB AGE 17+--WF"            format=f1.
      ER40057   LABEL="HEHC SP RPT: AGE END DRUG/AL PROB--WF"            format=f3.
      ER40058   LABEL="HEHC SP RPT: OTR PSYCH PROB B4 AGE 1--WF"         format=f1.
      ER40059   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 1--WF"            format=f1.
      ER40060   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 2--WF"            format=f1.
      ER40061   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 3--WF"            format=f1.
      ER40062   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 4--WF"            format=f1.
      ER40063   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 5--WF"            format=f1.
      ER40064   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 6--WF"            format=f1.
      ER40065   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 7--WF"            format=f1.
      ER40066   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 8--WF"            format=f1.
      ER40067   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 9--WF"            format=f1.
      ER40068   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 10--WF"           format=f1.
      ER40069   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 11--WF"           format=f1.
      ER40070   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 12--WF"           format=f1.
      ER40071   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 13--WF"           format=f1.
      ER40072   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 14--WF"           format=f1.
      ER40073   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 15--WF"           format=f1.
      ER40074   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 16--WF"           format=f1.
      ER40075   LABEL="HEHC SP RPT: OTR PSYCH PROB AGE 17+--WF"          format=f1.
      ER40076   LABEL="HEHC SP RPT: AGE END OTR PSYCH PROB--WF"          format=f3.
      ER40077   LABEL="HEHC OTR RPT: YEAR 1ST REPORT--WF"                format=f4.
      ER40078   LABEL="HEHC OTR RPT: PAR SEP B4 AGE 1--WF"               format=f1.
      ER40079   LABEL="HEHC OTR RPT: PAR SEP AGE 1--WF"                  format=f1.
      ER40080   LABEL="HEHC OTR RPT: PAR SEP AGE 2--WF"                  format=f1.
      ER40081   LABEL="HEHC OTR RPT: PAR SEP AGE 3--WF"                  format=f1.
      ER40082   LABEL="HEHC OTR RPT: PAR SEP AGE 4--WF"                  format=f1.
      ER40083   LABEL="HEHC OTR RPT: PAR SEP AGE 5--WF"                  format=f1.
      ER40084   LABEL="HEHC OTR RPT: PAR SEP AGE 6--WF"                  format=f1.
      ER40085   LABEL="HEHC OTR RPT: PAR SEP AGE 7--WF"                  format=f1.
      ER40086   LABEL="HEHC OTR RPT: PAR SEP AGE 8--WF"                  format=f1.
      ER40087   LABEL="HEHC OTR RPT: PAR SEP AGE 9--WF"                  format=f1.
      ER40088   LABEL="HEHC OTR RPT: PAR SEP AGE 10--WF"                 format=f1.
      ER40089   LABEL="HEHC OTR RPT: PAR SEP AGE 11--WF"                 format=f1.
      ER40090   LABEL="HEHC OTR RPT: PAR SEP AGE 12--WF"                 format=f1.
      ER40091   LABEL="HEHC OTR RPT: PAR SEP AGE 13--WF"                 format=f1.
      ER40092   LABEL="HEHC OTR RPT: PAR SEP AGE 14--WF"                 format=f1.
      ER40093   LABEL="HEHC OTR RPT: PAR SEP AGE 15--WF"                 format=f1.
      ER40094   LABEL="HEHC OTR RPT: PAR SEP AGE 16--WF"                 format=f1.
      ER40095   LABEL="HEHC OTR RPT: MOVE B4 AGE 1--WF"                  format=f1.
      ER40096   LABEL="HEHC OTR RPT: MOVE AGE 1--WF"                     format=f1.
      ER40097   LABEL="HEHC OTR RPT: MOVE AGE 2--WF"                     format=f1.
      ER40098   LABEL="HEHC OTR RPT: MOVE AGE 3--WF"                     format=f1.
      ER40099   LABEL="HEHC OTR RPT: MOVE AGE 4--WF"                     format=f1.
      ER40100   LABEL="HEHC OTR RPT: MOVE AGE 5--WF"                     format=f1.
      ER40101   LABEL="HEHC OTR RPT: MOVE AGE 6--WF"                     format=f1.
      ER40102   LABEL="HEHC OTR RPT: MOVE AGE 7--WF"                     format=f1.
      ER40103   LABEL="HEHC OTR RPT: MOVE AGE 8--WF"                     format=f1.
      ER40104   LABEL="HEHC OTR RPT: MOVE AGE 9--WF"                     format=f1.
      ER40105   LABEL="HEHC OTR RPT: MOVE AGE 10--WF"                    format=f1.
      ER40106   LABEL="HEHC OTR RPT: MOVE AGE 11--WF"                    format=f1.
      ER40107   LABEL="HEHC OTR RPT: MOVE AGE 12--WF"                    format=f1.
      ER40108   LABEL="HEHC OTR RPT: MOVE AGE 13--WF"                    format=f1.
      ER40109   LABEL="HEHC OTR RPT: MOVE AGE 14--WF"                    format=f1.
      ER40110   LABEL="HEHC OTR RPT: MOVE AGE 15--WF"                    format=f1.
      ER40111   LABEL="HEHC OTR RPT: MOVE AGE 16--WF"                    format=f1.
      ER40112   LABEL="HEHC OTR RPT: SCHOOL B4 AGE 1--WF"                format=f1.
      ER40113   LABEL="HEHC OTR RPT: SCHOOL AGE 1--WF"                   format=f1.
      ER40114   LABEL="HEHC OTR RPT: SCHOOL AGE 2--WF"                   format=f1.
      ER40115   LABEL="HEHC OTR RPT: SCHOOL AGE 3--WF"                   format=f1.
      ER40116   LABEL="HEHC OTR RPT: SCHOOL AGE 4--WF"                   format=f1.
      ER40117   LABEL="HEHC OTR RPT: SCHOOL AGE 5--WF"                   format=f1.
      ER40118   LABEL="HEHC OTR RPT: SCHOOL AGE 6--WF"                   format=f1.
      ER40119   LABEL="HEHC OTR RPT: SCHOOL AGE 7--WF"                   format=f1.
      ER40120   LABEL="HEHC OTR RPT: SCHOOL AGE 8--WF"                   format=f1.
      ER40121   LABEL="HEHC OTR RPT: SCHOOL AGE 9--WF"                   format=f1.
      ER40122   LABEL="HEHC OTR RPT: SCHOOL AGE 10--WF"                  format=f1.
      ER40123   LABEL="HEHC OTR RPT: SCHOOL AGE 11--WF"                  format=f1.
      ER40124   LABEL="HEHC OTR RPT: SCHOOL AGE 12--WF"                  format=f1.
      ER40125   LABEL="HEHC OTR RPT: SCHOOL AGE 13--WF"                  format=f1.
      ER40126   LABEL="HEHC OTR RPT: SCHOOL AGE 14--WF"                  format=f1.
      ER40127   LABEL="HEHC OTR RPT: SCHOOL AGE 15--WF"                  format=f1.
      ER40128   LABEL="HEHC OTR RPT: SCHOOL AGE 16--WF"                  format=f1.
      ER40129   LABEL="HEHC OTR RPT: ASTHMA B4 AGE 1--WF"                format=f1.
      ER40130   LABEL="HEHC OTR RPT: ASTHMA AGE 1--WF"                   format=f1.
      ER40131   LABEL="HEHC OTR RPT: ASTHMA AGE 2--WF"                   format=f1.
      ER40132   LABEL="HEHC OTR RPT: ASTHMA AGE 3--WF"                   format=f1.
      ER40133   LABEL="HEHC OTR RPT: ASTHMA AGE 4--WF"                   format=f1.
      ER40134   LABEL="HEHC OTR RPT: ASTHMA AGE 5--WF"                   format=f1.
      ER40135   LABEL="HEHC OTR RPT: ASTHMA AGE 6--WF"                   format=f1.
      ER40136   LABEL="HEHC OTR RPT: ASTHMA AGE 7--WF"                   format=f1.
      ER40137   LABEL="HEHC OTR RPT: ASTHMA AGE 8--WF"                   format=f1.
      ER40138   LABEL="HEHC OTR RPT: ASTHMA AGE 9--WF"                   format=f1.
      ER40139   LABEL="HEHC OTR RPT: ASTHMA AGE 10--WF"                  format=f1.
      ER40140   LABEL="HEHC OTR RPT: ASTHMA AGE 11--WF"                  format=f1.
      ER40141   LABEL="HEHC OTR RPT: ASTHMA AGE 12--WF"                  format=f1.
      ER40142   LABEL="HEHC OTR RPT: ASTHMA AGE 13--WF"                  format=f1.
      ER40143   LABEL="HEHC OTR RPT: ASTHMA AGE 14--WF"                  format=f1.
      ER40144   LABEL="HEHC OTR RPT: ASTHMA AGE 15--WF"                  format=f1.
      ER40145   LABEL="HEHC OTR RPT: ASTHMA AGE 16--WF"                  format=f1.
      ER40146   LABEL="HEHC OTR RPT: ASTHMA AGE 17+--WF"                 format=f1.
      ER40147   LABEL="HEHC OTR RPT: AGE END ASTHMA--WF"                 format=f3.
      ER40148   LABEL="HEHC OTR RPT: DIABETES B4 AGE 1--WF"              format=f1.
      ER40149   LABEL="HEHC OTR RPT: DIABETES AGE 1--WF"                 format=f1.
      ER40150   LABEL="HEHC OTR RPT: DIABETES AGE 2--WF"                 format=f1.
      ER40151   LABEL="HEHC OTR RPT: DIABETES AGE 3--WF"                 format=f1.
      ER40152   LABEL="HEHC OTR RPT: DIABETES AGE 4--WF"                 format=f1.
      ER40153   LABEL="HEHC OTR RPT: DIABETES AGE 5--WF"                 format=f1.
      ER40154   LABEL="HEHC OTR RPT: DIABETES AGE 6--WF"                 format=f1.
      ER40155   LABEL="HEHC OTR RPT: DIABETES AGE 7--WF"                 format=f1.
      ER40156   LABEL="HEHC OTR RPT: DIABETES AGE 8--WF"                 format=f1.
      ER40157   LABEL="HEHC OTR RPT: DIABETES AGE 9--WF"                 format=f1.
      ER40158   LABEL="HEHC OTR RPT: DIABETES AGE 10--WF"                format=f1.
      ER40159   LABEL="HEHC OTR RPT: DIABETES AGE 11--WF"                format=f1.
      ER40160   LABEL="HEHC OTR RPT: DIABETES AGE 12--WF"                format=f1.
      ER40161   LABEL="HEHC OTR RPT: DIABETES AGE 13--WF"                format=f1.
      ER40162   LABEL="HEHC OTR RPT: DIABETES AGE 14--WF"                format=f1.
      ER40163   LABEL="HEHC OTR RPT: DIABETES AGE 15--WF"                format=f1.
      ER40164   LABEL="HEHC OTR RPT: DIABETES AGE 16--WF"                format=f1.
      ER40165   LABEL="HEHC OTR RPT: DIABETES AGE 17+--WF"               format=f1.
      ER40166   LABEL="HEHC OTR RPT: AGE END DIABETES--WF"               format=f3.
      ER40167   LABEL="HEHC OTR RPT: RESP DIS B4 AGE 1--WF"              format=f1.
      ER40168   LABEL="HEHC OTR RPT: RESP DIS AGE 1--WF"                 format=f1.
      ER40169   LABEL="HEHC OTR RPT: RESP DIS AGE 2--WF"                 format=f1.
      ER40170   LABEL="HEHC OTR RPT: RESP DIS AGE 3--WF"                 format=f1.
      ER40171   LABEL="HEHC OTR RPT: RESP DIS AGE 4--WF"                 format=f1.
      ER40172   LABEL="HEHC OTR RPT: RESP DIS AGE 5--WF"                 format=f1.
      ER40173   LABEL="HEHC OTR RPT: RESP DIS AGE 6--WF"                 format=f1.
      ER40174   LABEL="HEHC OTR RPT: RESP DIS AGE 7--WF"                 format=f1.
      ER40175   LABEL="HEHC OTR RPT: RESP DIS AGE 8--WF"                 format=f1.
      ER40176   LABEL="HEHC OTR RPT: RESP DIS AGE 9--WF"                 format=f1.
      ER40177   LABEL="HEHC OTR RPT: RESP DIS AGE 10--WF"                format=f1.
      ER40178   LABEL="HEHC OTR RPT: RESP DIS AGE 11--WF"                format=f1.
      ER40179   LABEL="HEHC OTR RPT: RESP DIS AGE 12--WF"                format=f1.
      ER40180   LABEL="HEHC OTR RPT: RESP DIS AGE 13--WF"                format=f1.
      ER40181   LABEL="HEHC OTR RPT: RESP DIS AGE 14--WF"                format=f1.
      ER40182   LABEL="HEHC OTR RPT: RESP DIS AGE 15--WF"                format=f1.
      ER40183   LABEL="HEHC OTR RPT: RESP DIS AGE 16--WF"                format=f1.
      ER40184   LABEL="HEHC OTR RPT: RESP DIS AGE 17+--WF"               format=f1.
      ER40185   LABEL="HEHC OTR RPT: AGE END RESP DIS--WF"               format=f3.
      ER40186   LABEL="HEHC OTR RPT: SPCH IMPAIR B4 AGE 1--WF"           format=f1.
      ER40187   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 1--WF"              format=f1.
      ER40188   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 2--WF"              format=f1.
      ER40189   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 3--WF"              format=f1.
      ER40190   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 4--WF"              format=f1.
      ER40191   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 5--WF"              format=f1.
      ER40192   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 6--WF"              format=f1.
      ER40193   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 7--WF"              format=f1.
      ER40194   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 8--WF"              format=f1.
      ER40195   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 9--WF"              format=f1.
      ER40196   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 10--WF"             format=f1.
      ER40197   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 11--WF"             format=f1.
      ER40198   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 12--WF"             format=f1.
      ER40199   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 13--WF"             format=f1.
      ER40200   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 14--WF"             format=f1.
      ER40201   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 15--WF"             format=f1.
      ER40202   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 16--WF"             format=f1.
      ER40203   LABEL="HEHC OTR RPT: SPCH IMPAIR AGE 17+--WF"            format=f1.
      ER40204   LABEL="HEHC OTR RPT: AGE END SPCH IMPAIR--WF"            format=f3.
      ER40205   LABEL="HEHC OTR RPT: ALLERGY B4 AGE 1--WF"               format=f1.
      ER40206   LABEL="HEHC OTR RPT: ALLERGY AGE 1--WF"                  format=f1.
      ER40207   LABEL="HEHC OTR RPT: ALLERGY AGE 2--WF"                  format=f1.
      ER40208   LABEL="HEHC OTR RPT: ALLERGY AGE 3--WF"                  format=f1.
      ER40209   LABEL="HEHC OTR RPT: ALLERGY AGE 4--WF"                  format=f1.
      ER40210   LABEL="HEHC OTR RPT: ALLERGY AGE 5--WF"                  format=f1.
      ER40211   LABEL="HEHC OTR RPT: ALLERGY AGE 6--WF"                  format=f1.
      ER40212   LABEL="HEHC OTR RPT: ALLERGY AGE 7--WF"                  format=f1.
      ER40213   LABEL="HEHC OTR RPT: ALLERGY AGE 8--WF"                  format=f1.
      ER40214   LABEL="HEHC OTR RPT: ALLERGY AGE 9--WF"                  format=f1.
      ER40215   LABEL="HEHC OTR RPT: ALLERGY AGE 10--WF"                 format=f1.
      ER40216   LABEL="HEHC OTR RPT: ALLERGY AGE 11--WF"                 format=f1.
      ER40217   LABEL="HEHC OTR RPT: ALLERGY AGE 12--WF"                 format=f1.
      ER40218   LABEL="HEHC OTR RPT: ALLERGY AGE 13--WF"                 format=f1.
      ER40219   LABEL="HEHC OTR RPT: ALLERGY AGE 14--WF"                 format=f1.
      ER40220   LABEL="HEHC OTR RPT: ALLERGY AGE 15--WF"                 format=f1.
      ER40221   LABEL="HEHC OTR RPT: ALLERGY AGE 16--WF"                 format=f1.
      ER40222   LABEL="HEHC OTR RPT: ALLERGY AGE 17+--WF"                format=f1.
      ER40223   LABEL="HEHC OTR RPT: AGE END ALLERGY--WF"                format=f3.
      ER40224   LABEL="HEHC OTR RPT: HEART TRBL B4 AGE 1--WF"            format=f1.
      ER40225   LABEL="HEHC OTR RPT: HEART TRBL AGE 1--WF"               format=f1.
      ER40226   LABEL="HEHC OTR RPT: HEART TRBL AGE 2--WF"               format=f1.
      ER40227   LABEL="HEHC OTR RPT: HEART TRBL AGE 3--WF"               format=f1.
      ER40228   LABEL="HEHC OTR RPT: HEART TRBL AGE 4--WF"               format=f1.
      ER40229   LABEL="HEHC OTR RPT: HEART TRBL AGE 5--WF"               format=f1.
      ER40230   LABEL="HEHC OTR RPT: HEART TRBL AGE 6--WF"               format=f1.
      ER40231   LABEL="HEHC OTR RPT: HEART TRBL AGE 7--WF"               format=f1.
      ER40232   LABEL="HEHC OTR RPT: HEART TRBL AGE 8--WF"               format=f1.
      ER40233   LABEL="HEHC OTR RPT: HEART TRBL AGE 9--WF"               format=f1.
      ER40234   LABEL="HEHC OTR RPT: HEART TRBL AGE 10--WF"              format=f1.
      ER40235   LABEL="HEHC OTR RPT: HEART TRBL AGE 11--WF"              format=f1.
      ER40236   LABEL="HEHC OTR RPT: HEART TRBL AGE 12--WF"              format=f1.
      ER40237   LABEL="HEHC OTR RPT: HEART TRBL AGE 13--WF"              format=f1.
      ER40238   LABEL="HEHC OTR RPT: HEART TRBL AGE 14--WF"              format=f1.
      ER40239   LABEL="HEHC OTR RPT: HEART TRBL AGE 15--WF"              format=f1.
      ER40240   LABEL="HEHC OTR RPT: HEART TRBL AGE 16--WF"              format=f1.
      ER40241   LABEL="HEHC OTR RPT: HEART TRBL AGE 17+--WF"             format=f1.
      ER40242   LABEL="HEHC OTR RPT: AGE END HEART TRBL--WF"             format=f3.
      ER40243   LABEL="HEHC OTR RPT: EAR PROBS B4 AGE 1--WF"             format=f1.
      ER40244   LABEL="HEHC OTR RPT: EAR PROBS AGE 1--WF"                format=f1.
      ER40245   LABEL="HEHC OTR RPT: EAR PROBS AGE 2--WF"                format=f1.
      ER40246   LABEL="HEHC OTR RPT: EAR PROBS AGE 3--WF"                format=f1.
      ER40247   LABEL="HEHC OTR RPT: EAR PROBS AGE 4--WF"                format=f1.
      ER40248   LABEL="HEHC OTR RPT: EAR PROBS AGE 5--WF"                format=f1.
      ER40249   LABEL="HEHC OTR RPT: EAR PROBS AGE 6--WF"                format=f1.
      ER40250   LABEL="HEHC OTR RPT: EAR PROBS AGE 7--WF"                format=f1.
      ER40251   LABEL="HEHC OTR RPT: EAR PROBS AGE 8--WF"                format=f1.
      ER40252   LABEL="HEHC OTR RPT: EAR PROBS AGE 9--WF"                format=f1.
      ER40253   LABEL="HEHC OTR RPT: EAR PROBS AGE 10--WF"               format=f1.
      ER40254   LABEL="HEHC OTR RPT: EAR PROBS AGE 11--WF"               format=f1.
      ER40255   LABEL="HEHC OTR RPT: EAR PROBS AGE 12--WF"               format=f1.
      ER40256   LABEL="HEHC OTR RPT: EAR PROBS AGE 13--WF"               format=f1.
      ER40257   LABEL="HEHC OTR RPT: EAR PROBS AGE 14--WF"               format=f1.
      ER40258   LABEL="HEHC OTR RPT: EAR PROBS AGE 15--WF"               format=f1.
      ER40259   LABEL="HEHC OTR RPT: EAR PROBS AGE 16--WF"               format=f1.
      ER40260   LABEL="HEHC OTR RPT: EAR PROBS AGE 17+--WF"              format=f1.
      ER40261   LABEL="HEHC OTR RPT: AGE END EAR PROBS--WF"              format=f3.
      ER40262   LABEL="HEHC OTR RPT: EPILEPSY B4 AGE 1--WF"              format=f1.
      ER40263   LABEL="HEHC OTR RPT: EPILEPSY AGE 1--WF"                 format=f1.
      ER40264   LABEL="HEHC OTR RPT: EPILEPSY AGE 2--WF"                 format=f1.
      ER40265   LABEL="HEHC OTR RPT: EPILEPSY AGE 3--WF"                 format=f1.
      ER40266   LABEL="HEHC OTR RPT: EPILEPSY AGE 4--WF"                 format=f1.
      ER40267   LABEL="HEHC OTR RPT: EPILEPSY AGE 5--WF"                 format=f1.
      ER40268   LABEL="HEHC OTR RPT: EPILEPSY AGE 6--WF"                 format=f1.
      ER40269   LABEL="HEHC OTR RPT: EPILEPSY AGE 7--WF"                 format=f1.
      ER40270   LABEL="HEHC OTR RPT: EPILEPSY AGE 8--WF"                 format=f1.
      ER40271   LABEL="HEHC OTR RPT: EPILEPSY AGE 9--WF"                 format=f1.
      ER40272   LABEL="HEHC OTR RPT: EPILEPSY AGE 10--WF"                format=f1.
      ER40273   LABEL="HEHC OTR RPT: EPILEPSY AGE 11--WF"                format=f1.
      ER40274   LABEL="HEHC OTR RPT: EPILEPSY AGE 12--WF"                format=f1.
      ER40275   LABEL="HEHC OTR RPT: EPILEPSY AGE 13--WF"                format=f1.
      ER40276   LABEL="HEHC OTR RPT: EPILEPSY AGE 14--WF"                format=f1.
      ER40277   LABEL="HEHC OTR RPT: EPILEPSY AGE 15--WF"                format=f1.
      ER40278   LABEL="HEHC OTR RPT: EPILEPSY AGE 16--WF"                format=f1.
      ER40279   LABEL="HEHC OTR RPT: EPILEPSY AGE 17+--WF"               format=f1.
      ER40280   LABEL="HEHC OTR RPT: AGE END EPILEPSY--WF"               format=f3.
      ER40281   LABEL="HEHC OTR RPT: HEADACHE B4 AGE 1--WF"              format=f1.
      ER40282   LABEL="HEHC OTR RPT: HEADACHE AGE 1--WF"                 format=f1.
      ER40283   LABEL="HEHC OTR RPT: HEADACHE AGE 2--WF"                 format=f1.
      ER40284   LABEL="HEHC OTR RPT: HEADACHE AGE 3--WF"                 format=f1.
      ER40285   LABEL="HEHC OTR RPT: HEADACHE AGE 4--WF"                 format=f1.
      ER40286   LABEL="HEHC OTR RPT: HEADACHE AGE 5--WF"                 format=f1.
      ER40287   LABEL="HEHC OTR RPT: HEADACHE AGE 6--WF"                 format=f1.
      ER40288   LABEL="HEHC OTR RPT: HEADACHE AGE 7--WF"                 format=f1.
      ER40289   LABEL="HEHC OTR RPT: HEADACHE AGE 8--WF"                 format=f1.
      ER40290   LABEL="HEHC OTR RPT: HEADACHE AGE 9--WF"                 format=f1.
      ER40291   LABEL="HEHC OTR RPT: HEADACHE AGE 10--WF"                format=f1.
      ER40292   LABEL="HEHC OTR RPT: HEADACHE AGE 11--WF"                format=f1.
      ER40293   LABEL="HEHC OTR RPT: HEADACHE AGE 12--WF"                format=f1.
      ER40294   LABEL="HEHC OTR RPT: HEADACHE AGE 13--WF"                format=f1.
      ER40295   LABEL="HEHC OTR RPT: HEADACHE AGE 14--WF"                format=f1.
      ER40296   LABEL="HEHC OTR RPT: HEADACHE AGE 15--WF"                format=f1.
      ER40297   LABEL="HEHC OTR RPT: HEADACHE AGE 16--WF"                format=f1.
      ER40298   LABEL="HEHC OTR RPT: HEADACHE AGE 17+--WF"               format=f1.
      ER40299   LABEL="HEHC OTR RPT: AGE END HEADACHE--WF"               format=f3.
      ER40300   LABEL="HEHC OTR RPT: STOM PROB B4 AGE 1--WF"             format=f1.
      ER40301   LABEL="HEHC OTR RPT: STOM PROB AGE 1--WF"                format=f1.
      ER40302   LABEL="HEHC OTR RPT: STOM PROB AGE 2--WF"                format=f1.
      ER40303   LABEL="HEHC OTR RPT: STOM PROB AGE 3--WF"                format=f1.
      ER40304   LABEL="HEHC OTR RPT: STOM PROB AGE 4--WF"                format=f1.
      ER40305   LABEL="HEHC OTR RPT: STOM PROB AGE 5--WF"                format=f1.
      ER40306   LABEL="HEHC OTR RPT: STOM PROB AGE 6--WF"                format=f1.
      ER40307   LABEL="HEHC OTR RPT: STOM PROB AGE 7--WF"                format=f1.
      ER40308   LABEL="HEHC OTR RPT: STOM PROB AGE 8--WF"                format=f1.
      ER40309   LABEL="HEHC OTR RPT: STOM PROB AGE 9--WF"                format=f1.
      ER40310   LABEL="HEHC OTR RPT: STOM PROB AGE 10--WF"               format=f1.
      ER40311   LABEL="HEHC OTR RPT: STOM PROB AGE 11--WF"               format=f1.
      ER40312   LABEL="HEHC OTR RPT: STOM PROB AGE 12--WF"               format=f1.
      ER40313   LABEL="HEHC OTR RPT: STOM PROB AGE 13--WF"               format=f1.
      ER40314   LABEL="HEHC OTR RPT: STOM PROB AGE 14--WF"               format=f1.
      ER40315   LABEL="HEHC OTR RPT: STOM PROB AGE 15--WF"               format=f1.
      ER40316   LABEL="HEHC OTR RPT: STOM PROB AGE 16--WF"               format=f1.
      ER40317   LABEL="HEHC OTR RPT: STOM PROB AGE 17+--WF"              format=f1.
      ER40318   LABEL="HEHC OTR RPT: AGE END STOM PROB--WF"              format=f3.
      ER40319   LABEL="HEHC OTR RPT: HGH BLOOD PR B4 AGE 1--WF"          format=f1.
      ER40320   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 1--WF"             format=f1.
      ER40321   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 2--WF"             format=f1.
      ER40322   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 3--WF"             format=f1.
      ER40323   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 4--WF"             format=f1.
      ER40324   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 5--WF"             format=f1.
      ER40325   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 6--WF"             format=f1.
      ER40326   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 7--WF"             format=f1.
      ER40327   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 8--WF"             format=f1.
      ER40328   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 9--WF"             format=f1.
      ER40329   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 10--WF"            format=f1.
      ER40330   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 11--WF"            format=f1.
      ER40331   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 12--WF"            format=f1.
      ER40332   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 13--WF"            format=f1.
      ER40333   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 14--WF"            format=f1.
      ER40334   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 15--WF"            format=f1.
      ER40335   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 16--WF"            format=f1.
      ER40336   LABEL="HEHC OTR RPT: HGH BLOOD PR AGE 17+--WF"           format=f1.
      ER40337   LABEL="HEHC OTR RPT: AGE END HGH BLOOD PR--WF"           format=f3.
      ER40338   LABEL="HEHC OTR RPT: DEPRESSION B4 AGE 1--WF"            format=f1.
      ER40339   LABEL="HEHC OTR RPT: DEPRESSION AGE 1--WF"               format=f1.
      ER40340   LABEL="HEHC OTR RPT: DEPRESSION AGE 2--WF"               format=f1.
      ER40341   LABEL="HEHC OTR RPT: DEPRESSION AGE 3--WF"               format=f1.
      ER40342   LABEL="HEHC OTR RPT: DEPRESSION AGE 4--WF"               format=f1.
      ER40343   LABEL="HEHC OTR RPT: DEPRESSION AGE 5--WF"               format=f1.
      ER40344   LABEL="HEHC OTR RPT: DEPRESSION AGE 6--WF"               format=f1.
      ER40345   LABEL="HEHC OTR RPT: DEPRESSION AGE 7--WF"               format=f1.
      ER40346   LABEL="HEHC OTR RPT: DEPRESSION AGE 8--WF"               format=f1.
      ER40347   LABEL="HEHC OTR RPT: DEPRESSION AGE 9--WF"               format=f1.
      ER40348   LABEL="HEHC OTR RPT: DEPRESSION AGE 10--WF"              format=f1.
      ER40349   LABEL="HEHC OTR RPT: DEPRESSION AGE 11--WF"              format=f1.
      ER40350   LABEL="HEHC OTR RPT: DEPRESSION AGE 12--WF"              format=f1.
      ER40351   LABEL="HEHC OTR RPT: DEPRESSION AGE 13--WF"              format=f1.
      ER40352   LABEL="HEHC OTR RPT: DEPRESSION AGE 14--WF"              format=f1.
      ER40353   LABEL="HEHC OTR RPT: DEPRESSION AGE 15--WF"              format=f1.
      ER40354   LABEL="HEHC OTR RPT: DEPRESSION AGE 16--WF"              format=f1.
      ER40355   LABEL="HEHC OTR RPT: DEPRESSION AGE 17+--WF"             format=f1.
      ER40356   LABEL="HEHC OTR RPT: AGE END DEPRESSION--WF"             format=f3.
      ER40357   LABEL="HEHC OTR RPT: DRUG/AL PROB B4 AGE 1--WF"          format=f1.
      ER40358   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 1--WF"             format=f1.
      ER40359   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 2--WF"             format=f1.
      ER40360   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 3--WF"             format=f1.
      ER40361   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 4--WF"             format=f1.
      ER40362   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 5--WF"             format=f1.
      ER40363   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 6--WF"             format=f1.
      ER40364   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 7--WF"             format=f1.
      ER40365   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 8--WF"             format=f1.
      ER40366   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 9--WF"             format=f1.
      ER40367   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 10--WF"            format=f1.
      ER40368   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 11--WF"            format=f1.
      ER40369   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 12--WF"            format=f1.
      ER40370   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 13--WF"            format=f1.
      ER40371   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 14--WF"            format=f1.
      ER40372   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 15--WF"            format=f1.
      ER40373   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 16--WF"            format=f1.
      ER40374   LABEL="HEHC OTR RPT: DRUG/AL PROB AGE 17+--WF"           format=f1.
      ER40375   LABEL="HEHC OTR RPT: AGE END DRUG/AL PROB--WF"           format=f3.
      ER40376   LABEL="HEHC OTR RPT: OTR PSYCH PROB B4 AGE 1--W"         format=f1.
      ER40377   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 1--WF"           format=f1.
      ER40378   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 2--WF"           format=f1.
      ER40379   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 3--WF"           format=f1.
      ER40380   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 4--WF"           format=f1.
      ER40381   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 5--WF"           format=f1.
      ER40382   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 6--WF"           format=f1.
      ER40383   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 7--WF"           format=f1.
      ER40384   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 8--WF"           format=f1.
      ER40385   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 9--WF"           format=f1.
      ER40386   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 10--WF"          format=f1.
      ER40387   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 11--WF"          format=f1.
      ER40388   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 12--WF"          format=f1.
      ER40389   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 13--WF"          format=f1.
      ER40390   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 14--WF"          format=f1.
      ER40391   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 15--WF"          format=f1.
      ER40392   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 16--WF"          format=f1.
      ER40393   LABEL="HEHC OTR RPT: OTR PSYCH PROB AGE 17+--WF"         format=f1.
      ER40394   LABEL="HEHC OTR RPT: AGE END OTR PSYCH PROB--WF"         format=f3.
      ER40395   LABEL="H49 WTR OTHERS IN FU IN POOR HEALTH"              format=f1.
      ER40396   LABEL="H59A SADNESS IN PAST 30 DAYS"                     format=f1.
      ER40397   LABEL="H59B NERVOUS IN PAST 30 DAYS"                     format=f1.
      ER40398   LABEL="H59C RESTLESS IN PAST 30 DAYS"                    format=f1.
      ER40399   LABEL="H59D HOPELESS IN PAST 30 DAYS"                    format=f1.
      ER40400   LABEL="H59E EVERYTHING EFFORT IN PAST 30 DAYS"           format=f1.
      ER40401   LABEL="H59F WORTHLESS IN PAST 30 DAYS"                   format=f1.
      ER40402   LABEL="K-6 NON-SPEC PSYCHOL DISTRESS SCALE"              format=f2.
      ER40403   LABEL="H59G MORE/LESS OFTEN THAN USUAL"                  format=f1.
      ER40404   LABEL="H59H LOT/SOMEWHAT/LITTLE MORE THAN USUAL"         format=f1.
      ER40405   LABEL="H59I LOT/SOMEWHAT/LITTLE LESS THAN USUAL"         format=f1.
      ER40406   LABEL="H59J HOW MUCH FEELINGS INTERFERE W/LIFE"          format=f1.
      ER40407   LABEL="H59K NUMBER OF DAYS UNABLE TO WORK"               format=f2.
      ER40408   LABEL="H59L NUMBER OF DAYS REDUCED WORK"                 format=f2.
      ER40409   LABEL="H60 WTR FU MEMBER W/HLTH INS LAST 2 YRS"          format=f1.
      ER40410   LABEL="H63 TOTAL PAID FOR HLTH INS LAST 2 YRS"           format=f6.
      ER40411   LABEL="H63A WTR AMT GE 2,400"                            format=f1.
      ER40412   LABEL="H63B WTR AMT GE 5,000"                            format=f1.
      ER40413   LABEL="H63C WTR AMT GE 1,000"                            format=f1.
      ER40414   LABEL="H64 TOTAL HOSPITAL/NURSNG HOME EXPENSES"          format=f6.
      ER40415   LABEL="H65 WTR TOTAL EXPENSE GE 10,000"                  format=f1.
      ER40416   LABEL="H66 WTR TOTAL EXPENSE GE 20,000"                  format=f1.
      ER40417   LABEL="H67 WTR TOTAL EXPENSE GE 50,000"                  format=f1.
      ER40418   LABEL="H68 WTR TOTAL EXPENSE GE 5,000"                   format=f1.
      ER40419   LABEL="H69 WTR TOTAL EXPENSE GE 500"                     format=f1.
      ER40420   LABEL="H70 TOT DR/OUTPT SURGRY/DENTAL EXPENSES"          format=f6.
      ER40421   LABEL="H71 WTR TOTAL EXPENSE GE 1,000"                   format=f1.
      ER40422   LABEL="H72 WTR TOTAL EXPENSE GE 5,000"                   format=f1.
      ER40423   LABEL="H73 WTR TOTAL EXPENSE GE 20,000"                  format=f1.
      ER40424   LABEL="H74 WTR TOTAL EXPENSE GE 500"                     format=f1.
      ER40425   LABEL="H75 WTR TOTAL EXPENSE GE 200"                     format=f1.
      ER40426   LABEL="H76 TOTAL PRESCRIPTN/OTR SVCS EXPENSES"           format=f6.
      ER40427   LABEL="H77 WTR TOTAL EXPENSE GE 5,000"                   format=f1.
      ER40428   LABEL="H78 WTR TOTAL EXPENSE GE 10,000"                  format=f1.
      ER40429   LABEL="H79 WTR TOTAL EXPENSE GE 20,000"                  format=f1.
      ER40430   LABEL="H80 WTR TOTAL EXPENSE GE 1,000"                   format=f1.
      ER40431   LABEL="H81 WTR TOTAL EXPENSE GE 500"                     format=f1.
      ER40432   LABEL="H82 TOTAL COST ALL MEDICAL CARE"                  format=f8.
      ER40433   LABEL="H83 WTR TOTAL COST GE 25,000"                     format=f1.
      ER40434   LABEL="H84 WTR TOTAL COST GE 100,000"                    format=f1.
      ER40435   LABEL="H85 WTR TOTAL COST GE 500,000"                    format=f1.
      ER40436   LABEL="H86 WTR TOTAL COST GE 5,000"                      format=f1.
      ER40437   LABEL="H87 WTR TOTAL COST GE 1,000"                      format=f1.
      ER40438   LABEL="K1 CKPT: WTR NEW WIFE IN FU"                      format=f1.
      ER40439   LABEL="K2 STATE WHERE FATHER BORN-WF"                    format=f2.
      ER40440   LABEL="K3 STATE FATHER GREW UP-WF"                       format=f2.
      ER40441   LABEL="K4 WTR FATHER EDUCATED IN US-WF"                  format=f1.
      ER40442   LABEL="K5 EDUCATION OF FATHER IN US-WF"                  format=f2.
      ER40443   LABEL="K6 WTR FATHER READ/WRITE-WF"                      format=f1.
      ER40444   LABEL="K7 CKPT:  WTR FATHER ED ALL IN US-WF"             format=f1.
      ER40445   LABEL="K8 YRS FOREIGN EDUCATION OF FATHR-WF"             format=f2.
      ER40446   LABEL="K9 FOREIGN DEGREES OF FATHER-WF"                  format=f1.
      ER40447   LABEL="K10-10A OCCUPATION OF FATHER-WF"                  format=f3.
      ER40448   LABEL="K11 INDUSTRY OF FATHER-WF"                        format=f3.
      ER40449   LABEL="K12 STATE WHERE MOTHER BORN-WF"                   format=f2.
      ER40450   LABEL="K13 STATE MOTHER GREW UP-WF"                      format=f2.
      ER40451   LABEL="K14 WTR MOTHER EDUCATED IN US-WF"                 format=f1.
      ER40452   LABEL="K15 EDUCATION OF MOTHER IN US-WF"                 format=f2.
      ER40453   LABEL="K16 WTR MOTHER READ/WRITE-WF"                     format=f1.
      ER40454   LABEL="K17 CKPT:  WTR MOTHER ED ALL IN US-WF"            format=f1.
      ER40455   LABEL="K18 YRS FOREIGN EDUCATION OF MOTHR-WF"            format=f2.
      ER40456   LABEL="K19 FOREIGN DEGREES OF MOTHER-WF"                 format=f1.
      ER40457   LABEL="K20-20A OCCUPATION OF MOTHER-WF"                  format=f3.
      ER40458   LABEL="K21 INDUSTRY OF MOTHER-WF"                        format=f3.
      ER40459   LABEL="K22 WHETHER BROTHERS-WF"                          format=f1.
      ER40460   LABEL="K23 # BROTHERS-WIFE"                              format=f2.
      ER40461   LABEL="K24 WTR ONLY BRO STILL ALIVE-WF"                  format=f1.
      ER40462   LABEL="K25 WTR ONLY BRO OLDER THAN WIFE"                 format=f1.
      ER40463   LABEL="K26 # BROTHERS STILL ALIVE-WF"                    format=f2.
      ER40464   LABEL="K27 WTR ANY BRO OLDER THAN WIFE"                  format=f1.
      ER40465   LABEL="K28 WHETHER SISTERS-WF"                           format=f1.
      ER40466   LABEL="K29 # SISTERS-WIFE"                               format=f2.
      ER40467   LABEL="K30 WTR ONLY SIS STILL ALIVE-WF"                  format=f1.
      ER40468   LABEL="K31 WTR ONLY SIS OLDER THAN WIFE"                 format=f1.
      ER40469   LABEL="K32 # SISTERS STILL ALIVE-WF"                     format=f2.
      ER40470   LABEL="K33 WTR ANY SIS OLDER THAN WIFE"                  format=f1.
      ER40471   LABEL="K39 SPANISH DESCENT-WIFE"                         format=f1.
      ER40472   LABEL="K40 RACE OF WIFE-MENTION 1"                       format=f1.
      ER40473   LABEL="K40 RACE OF WIFE-MENTION 2"                       format=f1.
      ER40474   LABEL="K40 RACE OF WIFE-MENTION 3"                       format=f1.
      ER40475   LABEL="K40 RACE OF WIFE-MENTION 4"                       format=f1.
      ER40476   LABEL="K41 ETHNIC GROUP-WF"                              format=f1.
      ER40477   LABEL="K41 NATIONALITY MENTION 1-WF"                     format=f2.
      ER40478   LABEL="K41 NATIONALITY MENTION 2-WF"                     format=f2.
      ER40479   LABEL="K42 WTR EVER IN MILITARY-WF"                      format=f1.
      ER40480   LABEL="K43 WTR WIFE EDUCATED IN US"                      format=f1.
      ER40481   LABEL="K44 WTR GRADUATED HS-WF"                          format=f1.
      ER40482   LABEL="K45 MO GRADUATED HS-WF"                           format=f2.
      ER40483   LABEL="K45 YR GRADUATED HS-WF"                           format=f4.
      ER40484   LABEL="K46 GRADE LEVEL IF GED-WF"                        format=f2.
      ER40485   LABEL="K47 MO LAST IN SCHOOL IF GED-WF"                  format=f2.
      ER40486   LABEL="K47 YR LAST IN SCHOOL IF GED-WF"                  format=f4.
      ER40487   LABEL="K48 MO RECEIVED GED-WF"                           format=f2.
      ER40488   LABEL="K48 YR RECEIVED GED-WF"                           format=f4.
      ER40489   LABEL="K49 GRADE OF SCHOOL FINISHED-W"                   format=f2.
      ER40490   LABEL="K50 MO LAST IN SCHOOL-WF"                         format=f2.
      ER40491   LABEL="K50 YR LAST IN SCHOOL-WF"                         format=f4.
      ER40492   LABEL="K51 WTR ATTENDED COLLEGE-WF"                      format=f1.
      ER40493   LABEL="K52 MO LAST ATTENDED COLLEGE-WF"                  format=f2.
      ER40494   LABEL="K52 YR LAST ATTENDED COLLEGE-WF"                  format=f4.
      ER40495   LABEL="K53 HGHST YR COLL COMPLETED-WF"                   format=f1.
      ER40496   LABEL="K54 WTR RECD COLLEGE DEGREE-WF"                   format=f1.
      ER40497   LABEL="K55 HGHST COLLEGE DEGREE RECD-WF"                 format=f2.
      ER40498   LABEL="K58 MO RECD COLLEGE DEGREE-WF"                    format=f2.
      ER40499   LABEL="K58 YR RECD COLLEGE DEGREE-WF"                    format=f4.
      ER40500   LABEL="K60 YRS FOREIGN EDUCATION-WF"                     format=f2.
      ER40501   LABEL="K61 FOREIGN DEGREES-WIFE"                         format=f1.
      ER40502   LABEL="K62 WTR RECD OTR DEG/CERT-WF"                     format=f1.
      ER40503   LABEL="K63 TYPE 1ST OTR DEG/CERT-WF"                     format=f1.
      ER40504   LABEL="K64 FIELD 1ST OTR DEG/CERT-WF"                    format=f2.
      ER40505   LABEL="K65 INST/ORG OF 1ST OTR DEG/CERT-WF"              format=f2.
      ER40506   LABEL="K66 MO RECD 1ST OTR DEG/CERT-WF"                  format=f2.
      ER40507   LABEL="K66 YR RECD 1ST OTR DEG/CERT-WF"                  format=f4.
      ER40508   LABEL="K67 WTR 2ND DEGREE/CERT-WF"                       format=f1.
      ER40509   LABEL="K63 TYPE 2ND OTR DEG/CERT-WF"                     format=f1.
      ER40510   LABEL="K64 FIELD 2ND OTR DEG/CERT-WF"                    format=f2.
      ER40511   LABEL="K65 INST/ORG OF 2ND OTR DEG/CERT-WF"              format=f2.
      ER40512   LABEL="K66 MO RECD 2ND OTR DEG/CERT-WF"                  format=f2.
      ER40513   LABEL="K66 YR RECD 2ND OTR DEG/CERT-WF"                  format=f4.
      ER40514   LABEL="K67 WTR 3RD DEGREE/CERT-WF"                       format=f1.
      ER40515   LABEL="K63 TYPE 3RD OTR DEG/CERT-WF"                     format=f1.
      ER40516   LABEL="K64 FIELD 3RD OTR DEG/CERT-WF"                    format=f2.
      ER40517   LABEL="K65 INST/ORG OF 3RD OTR DEG/CERT-WF"              format=f2.
      ER40518   LABEL="K66 MO RECD 3RD OTR DEG/CERT-WF"                  format=f2.
      ER40519   LABEL="K66 YR RECD 3RD OTR DEG/CERT-WF"                  format=f4.
      ER40520   LABEL="K67 WTR 4TH DEGREE/CERT-WF"                       format=f1.
      ER40521   LABEL="K68 RELIGIOUS PREFERENCE-WF"                      format=f2.
      ER40522   LABEL="K69 RELIG DENOMINATION-WF"                        format=f2.
      ER40523   LABEL="K70 #YRS WRKD SINCE 18-WF"                        format=f2.
      ER40524   LABEL="K71 #YR WRKED FULLTIME-WF"                        format=f2.
      ER40525   LABEL="K72 OCCUPATION 1ST FULL TIME JOB-WF"              format=f3.
      ER40526   LABEL="K73 INDUSTRY 1ST FULL-TIME JOB-WF"                format=f3.
      ER40527   LABEL="L1 CKPT: WTR NEW HEAD IN FU"                      format=f1.
      ER40528   LABEL="L2 STATE WHERE FATHER BORN-HD"                    format=f2.
      ER40529   LABEL="L3 STATE FATHER GREW UP-HD"                       format=f2.
      ER40530   LABEL="L4 WTR FATHER EDUCATED IN US-HD"                  format=f1.
      ER40531   LABEL="L5 EDUCATION OF FATHER IN US-HD"                  format=f2.
      ER40532   LABEL="L6 WTR FATHER READ/WRITE-HD"                      format=f1.
      ER40533   LABEL="L7 CKPT:  WTR FATHER ED ALL IN US-HD"             format=f1.
      ER40534   LABEL="L8 YRS FOREIGN EDUCATION OF FATHR-HD"             format=f2.
      ER40535   LABEL="L9 FOREIGN DEGREES OF FATHER-HD"                  format=f1.
      ER40536   LABEL="L10-10A OCCUPATION OF FATHER-HD"                  format=f3.
      ER40537   LABEL="L11 INDUSTRY OF FATHER-HD"                        format=f3.
      ER40538   LABEL="L12 STATE WHERE MOTHER BORN-HD"                   format=f2.
      ER40539   LABEL="L13 STATE MOTHER GREW UP-HD"                      format=f2.
      ER40540   LABEL="L14 WTR MOTHER EDUCATED IN US-H"                  format=f1.
      ER40541   LABEL="L15 EDUCATION OF MOTHER IN US-HD"                 format=f2.
      ER40542   LABEL="L16 WTR MOTHER READ/WRITE-HD"                     format=f1.
      ER40543   LABEL="L17 CKPT:  WTR MOTHER ED ALL IN US-HD"            format=f1.
      ER40544   LABEL="L18 YRS FOREIGN EDUCATION OF MOTHR-HD"            format=f2.
      ER40545   LABEL="L19 FOREIGN DEGREES OF MOTHER-HD"                 format=f1.
      ER40546   LABEL="L20-20A OCCUPATION OF MOTHER-HD"                  format=f3.
      ER40547   LABEL="L21 INDUSTRY OF MOTHER-HD"                        format=f3.
      ER40548   LABEL="L22 WHETHER BROTHERS-HD"                          format=f1.
      ER40549   LABEL="L23 # BROTHERS-HEAD"                              format=f2.
      ER40550   LABEL="L24 WTR ONLY BRO STILL ALIVE-HD"                  format=f1.
      ER40551   LABEL="L25 WTR ONLY BRO OLDER THAN HEAD"                 format=f1.
      ER40552   LABEL="L26 # BROTHERS STILL ALIVE-HD"                    format=f2.
      ER40553   LABEL="L27 WTR ANY BRO OLDER THAN HEAD"                  format=f1.
      ER40554   LABEL="L28 WHETHER SISTERS-HD"                           format=f1.
      ER40555   LABEL="L29 # SISTERS-HEAD"                               format=f2.
      ER40556   LABEL="L30 WTR ONLY SIS STILL ALIVE-HD"                  format=f1.
      ER40557   LABEL="L31 WTR ONLY SIS OLDER THAN HEAD"                 format=f1.
      ER40558   LABEL="L32 # SISTERS STILL ALIVE-HD"                     format=f2.
      ER40559   LABEL="L33 WTR ANY SIS OLDER THAN HEAD"                  format=f1.
      ER40560   LABEL="L34 GREW UP FARM OR?-HD"                          format=f1.
      ER40561   LABEL="L35 STATE WHERE HEAD GREW UP"                     format=f2.
      ER40562   LABEL="L36 WTR EVER LIVED IN OTR STATE-HD"               format=f1.
      ER40563   LABEL="L38 WTR LIVED W/BOTH PARENTS-HD"                  format=f1.
      ER40564   LABEL="L39 SPANISH DESCENT-HEAD"                         format=f1.
      ER40565   LABEL="L40 RACE OF HEAD-MENTION 1"                       format=f1.
      ER40566   LABEL="L40 RACE OF HEAD-MENTION 2"                       format=f1.
      ER40567   LABEL="L40 RACE OF HEAD-MENTION 3"                       format=f1.
      ER40568   LABEL="L40 RACE OF HEAD-MENTION 4"                       format=f1.
      ER40569   LABEL="L41 ETHNIC GROUP-HD"                              format=f1.
      ER40570   LABEL="L41 NATIONALITY MENTION 1-HD"                     format=f2.
      ER40571   LABEL="L41 NATIONALITY MENTION 2-HD"                     format=f2.
      ER40572   LABEL="L42 WTR EVER IN MILITARY-HD"                      format=f1.
      ER40573   LABEL="L43 WTR HEAD EDUCATED IN US"                      format=f1.
      ER40574   LABEL="L44 WTR GRADUATED HS-HD"                          format=f1.
      ER40575   LABEL="L45 MO GRADUATED HS-HD"                           format=f2.
      ER40576   LABEL="L45 YR GRADUATED HS-HD"                           format=f4.
      ER40577   LABEL="L46 GRADE LEVEL IF GED-HD"                        format=f2.
      ER40578   LABEL="L47 MO LAST IN SCHOOL IF GED-HD"                  format=f2.
      ER40579   LABEL="L47 YR LAST IN SCHOOL IF GED-HD"                  format=f4.
      ER40580   LABEL="L48 MO RECEIVED GED-HD"                           format=f2.
      ER40581   LABEL="L48 YR RECEIVED GED-HD"                           format=f4.
      ER40582   LABEL="L49 GRADE OF SCHOOL FINISHED-HD"                  format=f2.
      ER40583   LABEL="L50 MO LAST IN SCHOOL-HD"                         format=f2.
      ER40584   LABEL="L50 YR LAST IN SCHOOL-HD"                         format=f4.
      ER40585   LABEL="L51 WTR ATTENDED COLLEGE-HD"                      format=f1.
      ER40586   LABEL="L52 MO LAST ATTENDED COLLEGE-HD"                  format=f2.
      ER40587   LABEL="L52 YR LAST ATTENDED COLLEGE-HD"                  format=f4.
      ER40588   LABEL="L53 HGHST YR COLL COMPLETED-HD"                   format=f1.
      ER40589   LABEL="L54 WTR RECD COLLEGE DEGREE-HD"                   format=f1.
      ER40590   LABEL="L55 HGHST COLLEGE DEGREE RECD-HD"                 format=f2.
      ER40591   LABEL="L58 MO RECD COLLEGE DEGREE-HD"                    format=f2.
      ER40592   LABEL="L58 YR RECD COLLEGE DEGREE-HD"                    format=f4.
      ER40593   LABEL="L60 YRS FOREIGN EDUCATION-HD"                     format=f2.
      ER40594   LABEL="L61 FOREIGN DEGREES-HEAD"                         format=f1.
      ER40595   LABEL="L62 WTR REC OTR DEG/CERT-HD"                      format=f1.
      ER40596   LABEL="L63 TYPE 1ST OTR DEG/CERT-HD"                     format=f1.
      ER40597   LABEL="L64 FIELD 1ST OTR DEG/CERT-HD"                    format=f2.
      ER40598   LABEL="L65 INST/ORG OF 1ST OTR DEG/CERT-HD"              format=f2.
      ER40599   LABEL="L66 MO RECD 1ST OTR DEG/CERT-HD"                  format=f2.
      ER40600   LABEL="L66 YR RECD 1ST OTR DEG/CERT-HD"                  format=f4.
      ER40601   LABEL="L67 WTR 2ND DEGREE/CERT-HD"                       format=f1.
      ER40602   LABEL="L63 TYPE 2ND OTR DEG/CERT-HD"                     format=f1.
      ER40603   LABEL="L64 FIELD 2ND OTR DEG/CERT-HD"                    format=f2.
      ER40604   LABEL="L65 INST/ORG OF 2ND OTR DEG/CERT-HD"              format=f2.
      ER40605   LABEL="L66 MO RECD 2ND OTR DEG/CERT-HD"                  format=f2.
      ER40606   LABEL="L66 YR RECD 2ND OTR DEG/CERT-HD"                  format=f4.
      ER40607   LABEL="L67 WTR 3RD DEGREE/CERT-HD"                       format=f1.
      ER40608   LABEL="L63 TYPE 3RD OTR DEG/CERT-HD"                     format=f1.
      ER40609   LABEL="L64 FIELD 3RD OTR DEG/CERT-HD"                    format=f2.
      ER40610   LABEL="L65 INST/ORG OF 3RD OTR DEG/CERT-HD"              format=f2.
      ER40611   LABEL="L66 MO RECD 3RD OTR DEG/CERT-HD"                  format=f2.
      ER40612   LABEL="L66 YR RECD 3RD OTR DEG/CERT-HD"                  format=f4.
      ER40613   LABEL="L67 WTR 4TH DEGREE/CERT-HD"                       format=f1.
      ER40614   LABEL="L68 RELIGIOUS PREFERENCE-HD"                      format=f2.
      ER40615   LABEL="L69 RELIG DENOMINATION-HD"                        format=f2.
      ER40616   LABEL="L70 #YRS WRKD SINCE 18-HD"                        format=f2.
      ER40617   LABEL="L71 #YR WRKED FULLTIME-HD"                        format=f2.
      ER40618   LABEL="L72-72A OCCUPATION 1ST FULL TIME JOB-HD"          format=f3.
      ER40619   LABEL="L73 INDUSTRY 1ST FULL TIME JOB-HD"                format=f3.
      ER40620   LABEL="M1 WTR DONATION>25 TO CHARITY LAST YEAR"          format=f1.
      ER40621   LABEL="M2 WTR DONATED TO RELIGIOUS ORGANIZATION"         format=f1.
      ER40622   LABEL="M2A DOLLAR AMT OF RELIGIOUS DONATIONS"            format=f6.
      ER40623   LABEL="M2B WTR RELIGIOUS DONATIONS GE 300"               format=f1.
      ER40624   LABEL="M2C WTR RELIGIOUS DONATIONS GE 1,000"             format=f1.
      ER40625   LABEL="M2D WTR RELIGIOUS DONATIONS GE 2,500"             format=f1.
      ER40626   LABEL="M2E WTR RELIGIOUS DONATIONS GE 100"               format=f1.
      ER40627   LABEL="M3 WTR DONATD TO COMBO PURPOSE ORGANIZTN"         format=f1.
      ER40628   LABEL="M3A DOLLAR AMT OF COMBO DONATIONS"                format=f6.
      ER40629   LABEL="M3B WTR COMBO DONATIONS GE 200"                   format=f1.
      ER40630   LABEL="M3C WTR COMBO DONATIONS GE 500"                   format=f1.
      ER40631   LABEL="M3D WTR COMBO DONATIONS GE 1,000"                 format=f1.
      ER40632   LABEL="M3E WTR COMBO DONATIONS GE 100"                   format=f1.
      ER40633   LABEL="M4 WTR DONATED TO ORGANIZATION FOR NEEDY"         format=f1.
      ER40634   LABEL="M4A DOLLAR AMT OF NEEDY DONATIONS"                format=f5.
      ER40635   LABEL="M4B WTR NEEDY DONATIONS GE 200"                   format=f1.
      ER40636   LABEL="M4C WTR NEEDY DONATIONS GE 500"                   format=f1.
      ER40637   LABEL="M4D WTR NEEDY DONATIONS GE 1,000"                 format=f1.
      ER40638   LABEL="M4E WTR NEEDY DONATIONS GE 100"                   format=f1.
      ER40639   LABEL="M5 WTR DONATED TO ORGANIZATN FOR HEALTH"          format=f1.
      ER40640   LABEL="M5A DOLLAR AMT OF HEALTH DONATIONS"               format=f5.
      ER40641   LABEL="M5B WTR HEALTH DONATIONS GE 200"                  format=f1.
      ER40642   LABEL="M5C WTR HEALTH DONATIONS GE 500"                  format=f1.
      ER40643   LABEL="M5D WTR HEALTH DONATIONS GE 1,000"                format=f1.
      ER40644   LABEL="M5E WTR HEALTH DONATIONS GE 100"                  format=f1.
      ER40645   LABEL="M6 WTR DONATED TO ORGANZTION FOR EDUCATN"         format=f1.
      ER40646   LABEL="M6A DOLLAR AMT OF EDUCATION DONATIONS"            format=f5.
      ER40647   LABEL="M6B WTR EDUCATION DONATIONS GE 200"               format=f1.
      ER40648   LABEL="M6C WTR EDUCATION DONATIONS GE 500"               format=f1.
      ER40649   LABEL="M6D WTR EDUCATION DONATIONS GE 1,000"             format=f1.
      ER40650   LABEL="M6E WTR EDUCATION DONATIONS GE 100"               format=f1.
      ER40651   LABEL="M7 WTR DONATED TO YOUTH ORGANIZATIONS"            format=f1.
      ER40652   LABEL="M7A DOLLAR AMT OF YOUTH ORG DONATIONS"            format=f5.
      ER40653   LABEL="M7B WTR YOUTH ORG DONATIONS GE 200"               format=f1.
      ER40654   LABEL="M7C WTR YOUTH ORG DONATIONS GE 500"               format=f1.
      ER40655   LABEL="M7D WTR YOUTH ORG DONATIONS GE 1,000"             format=f1.
      ER40656   LABEL="M7E WTR YOUTH ORG DONATIONS GE 100"               format=f1.
      ER40657   LABEL="M8 WTR DONATED TO CULTURAL ORGS"                  format=f1.
      ER40658   LABEL="M8A DOLLAR AMT OF CULTURAL DONATIONS"             format=f5.
      ER40659   LABEL="M8B WTR CULTURAL DONATIONS GE 200"                format=f1.
      ER40660   LABEL="M8C WTR CULTURAL DONATIONS GE 500"                format=f1.
      ER40661   LABEL="M8D WTR CULTURAL DONATIONS GE 1,000"              format=f1.
      ER40662   LABEL="M8E WTR CULTURAL DONATIONS GE 100"                format=f1.
      ER40663   LABEL="M9 WTR DONATED TO COMMUNITY ORGS"                 format=f1.
      ER40664   LABEL="M9A DOLLAR AMT OF COMMUNITY DONATIONS"            format=f5.
      ER40665   LABEL="M9B WTR COMMUNITY DONATIONS GE 200"               format=f1.
      ER40666   LABEL="M9C WTR COMMUNITY DONATIONS GE 500"               format=f1.
      ER40667   LABEL="M9D WTR COMMUNITY DONATIONS GE 1,000"             format=f1.
      ER40668   LABEL="M9E WTR COMMUNITY DONATIONS GE 100"               format=f1.
      ER40669   LABEL="M10 WTR DONATED TO ENVIRONMENT ORGS"              format=f1.
      ER40670   LABEL="M10A DOLLAR AMT OF ENVIRONMENT DONATION"          format=f5.
      ER40671   LABEL="M10B WTR ENVIRONMENT DONATIONS GE 200"            format=f1.
      ER40672   LABEL="M10C WTR ENVIRONMENT DONATIONS GE 500"            format=f1.
      ER40673   LABEL="M10D WTR ENVIRONMENT DONATIONS GE 1,000"          format=f1.
      ER40674   LABEL="M10E WTR ENVIRONMENT DONATIONS GE 100"            format=f1.
      ER40675   LABEL="M11 WTR DONATED TO INTERNATL/PEACE ORG"           format=f1.
      ER40676   LABEL="M11A DOLLAR AMT OF INTERNATL/PEACE DNTN"          format=f5.
      ER40677   LABEL="M11B WTR INTERNATL/PEACE DNTNS GE 200"            format=f1.
      ER40678   LABEL="M11C WTR INTERNATL/PEACE DNTNS GE 500"            format=f1.
      ER40679   LABEL="M11D WTR INTERNATL/PEACE DNTNS GE 1,000"          format=f1.
      ER40680   LABEL="M11E WTR INTERNATL/PEACE DNTNS GE 100"            format=f1.
      ER40681   LABEL="M12 WTR DONATED TO OTHER ORGANIZATIONS"           format=f1.
      ER40682   LABEL="M12B DOLLAR AMT OF OTHER DONATIONS"               format=f5.
      ER40683   LABEL="M12C WTR OTHER DONATIONS GE 200"                  format=f1.
      ER40684   LABEL="M12D WTR OTHER DONATIONS GE 500"                  format=f1.
      ER40685   LABEL="M12E WTR OTHER DONATIONS GE 1,000"                format=f1.
      ER40686   LABEL="M12F WTR OTHER DONATIONS GE 100"                  format=f1.
      ER40687   LABEL="R16 WTR OFUMS REC ASSET Y YR BEFORE LAST"         format=f1.
      ER40688   LABEL="R18 OFUM ASSET Y AMOUNT YEAR BEFORE LAST"         format=f8.
      ER40689   LABEL="R18 OFUM ASSET Y PER YEAR BEFORE LAST"            format=f1.
      ER40690   LABEL="R19 WTR OFUMS REC ASSET Y JAN YR B4 LAST"         format=f1.
      ER40691   LABEL="R19 WTR OFUMS REC ASSET Y FEB YR B4 LAST"         format=f1.
      ER40692   LABEL="R19 WTR OFUMS REC ASSET Y MAR YR B4 LAST"         format=f1.
      ER40693   LABEL="R19 WTR OFUMS REC ASSET Y APR YR B4 LAST"         format=f1.
      ER40694   LABEL="R19 WTR OFUMS REC ASSET Y MAY YR B4 LAST"         format=f1.
      ER40695   LABEL="R19 WTR OFUMS REC ASSET Y JUN YR B4 LAST"         format=f1.
      ER40696   LABEL="R19 WTR OFUMS REC ASSET Y JUL YR B4 LAST"         format=f1.
      ER40697   LABEL="R19 WTR OFUMS REC ASSET Y AUG YR B4 LAST"         format=f1.
      ER40698   LABEL="R19 WTR OFUMS REC ASSET Y SEP YR B4 LAST"         format=f1.
      ER40699   LABEL="R19 WTR OFUMS REC ASSET Y OCT YR B4 LAST"         format=f1.
      ER40700   LABEL="R19 WTR OFUMS REC ASSET Y NOV YR B4 LAST"         format=f1.
      ER40701   LABEL="R19 WTR OFUMS REC ASSET Y DEC YR B4 LAST"         format=f1.
      ER40702   LABEL="R20 WTR RECD SOC SECURITY YR BEFORE LAST"         format=f1.
      ER40703   LABEL="R22 TYPE SOC SEC MEN 1 YR BEFORE LAST"            format=f1.
      ER40704   LABEL="R22 TYPE SOC SEC MEN 2 YR BEFORE LAST"            format=f1.
      ER40705   LABEL="R23 SOCIAL SECURITY AMOUNT YEAR B4 LAST"          format=f7.
      ER40706   LABEL="R23 SOCIAL SECURITY PER YEAR BEFORE LAST"         format=f1.
      ER40707   LABEL="R24 WTR RECD SOC SEC JAN YR BEFORE LAST"          format=f1.
      ER40708   LABEL="R24 WTR RECD SOC SEC FEB YR BEFORE LAST"          format=f1.
      ER40709   LABEL="R24 WTR RECD SOC SEC MAR YR BEFORE LAST"          format=f1.
      ER40710   LABEL="R24 WTR RECD SOC SEC APR YR BEFORE LAST"          format=f1.
      ER40711   LABEL="R24 WTR RECD SOC SEC MAY YR BEFORE LAST"          format=f1.
      ER40712   LABEL="R24 WTR RECD SOC SEC JUN YR BEFORE LAST"          format=f1.
      ER40713   LABEL="R24 WTR RECD SOC SEC JUL YR BEFORE LAST"          format=f1.
      ER40714   LABEL="R24 WTR RECD SOC SEC AUG YR BEFORE LAST"          format=f1.
      ER40715   LABEL="R24 WTR RECD SOC SEC SEP YR BEFORE LAST"          format=f1.
      ER40716   LABEL="R24 WTR RECD SOC SEC OCT YR BEFORE LAST"          format=f1.
      ER40717   LABEL="R24 WTR RECD SOC SEC NOV YR BEFORE LAST"          format=f1.
      ER40718   LABEL="R24 WTR RECD SOC SEC DEC YR BEFORE LAST"          format=f1.
      ER40719   LABEL="R25 WTR RECD RETIREMENT YR BEFORE LAST"           format=f1.
      ER40720   LABEL="R26 RETIREMENT AMOUNT YEAR BEFORE LAST"           format=f7.
      ER40721   LABEL="R26 RETIREMENT PER YEAR BEFORE LAST"              format=f1.
      ER40722   LABEL="R28 WTR RECD RETIREMENT JAN YR B4 LAST"           format=f1.
      ER40723   LABEL="R28 WTR RECD RETIREMENT FEB YR B4 LAST"           format=f1.
      ER40724   LABEL="R28 WTR RECD RETIREMENT MAR YR B4 LAST"           format=f1.
      ER40725   LABEL="R28 WTR RECD RETIREMENT APR YR B4 LAST"           format=f1.
      ER40726   LABEL="R28 WTR RECD RETIREMENT MAY YR B4 LAST"           format=f1.
      ER40727   LABEL="R28 WTR RECD RETIREMENT JUN YR B4 LAST"           format=f1.
      ER40728   LABEL="R28 WTR RECD RETIREMENT JUL YR B4 LAST"           format=f1.
      ER40729   LABEL="R28 WTR RECD RETIREMENT AUG YR B4 LAST"           format=f1.
      ER40730   LABEL="R28 WTR RECD RETIREMENT SEP YR B4 LAST"           format=f1.
      ER40731   LABEL="R28 WTR RECD RETIREMENT OCT YR B4 LAST"           format=f1.
      ER40732   LABEL="R28 WTR RECD RETIREMENT NOV YR B4 LAST"           format=f1.
      ER40733   LABEL="R28 WTR RECD RETIREMENT DEC YR B4 LAST"           format=f1.
      ER40734   LABEL="R29 WTR RECD VA PENSION YR BEFORE LAST"           format=f1.
      ER40735   LABEL="R31 VA PENSION AMOUNT YEAR BEFORE LAST"           format=f7.
      ER40736   LABEL="R31 VA PENSION PER YEAR BEFORE LAST"              format=f1.
      ER40737   LABEL="R32 WTR RECD VA PENSION JAN YR B4 LAST"           format=f1.
      ER40738   LABEL="R32 WTR RECD VA PENSION FEB YR B4 LAST"           format=f1.
      ER40739   LABEL="R32 WTR RECD VA PENSION MAR YR B4 LAST"           format=f1.
      ER40740   LABEL="R32 WTR RECD VA PENSION APR YR B4 LAST"           format=f1.
      ER40741   LABEL="R32 WTR RECD VA PENSION MAY YR B4 LAST"           format=f1.
      ER40742   LABEL="R32 WTR RECD VA PENSION JUN YR B4 LAST"           format=f1.
      ER40743   LABEL="R32 WTR RECD VA PENSION JUL YR B4 LAST"           format=f1.
      ER40744   LABEL="R32 WTR RECD VA PENSION AUG YR B4 LAST"           format=f1.
      ER40745   LABEL="R32 WTR RECD VA PENSION SEP YR B4 LAST"           format=f1.
      ER40746   LABEL="R32 WTR RECD VA PENSION OCT YR B4 LAST"           format=f1.
      ER40747   LABEL="R32 WTR RECD VA PENSION NOV YR B4 LAST"           format=f1.
      ER40748   LABEL="R32 WTR RECD VA PENSION DEC YR B4 LAST"           format=f1.
      ER40749   LABEL="R33 WTR RECD UNEMP COMP YR BEFORE LAST"           format=f1.
      ER40750   LABEL="R35 UNEMP COMP AMOUNT YEAR BEFORE LAST"           format=f7.
      ER40751   LABEL="R35 UNEMP COMP PER YEAR BEFORE LAST"              format=f1.
      ER40752   LABEL="R36 WTR RECD UNEMP COMP JAN YR B4 LAST"           format=f1.
      ER40753   LABEL="R36 WTR RECD UNEMP COMP FEB YR B4 LAST"           format=f1.
      ER40754   LABEL="R36 WTR RECD UNEMP COMP MAR YR B4 LAST"           format=f1.
      ER40755   LABEL="R36 WTR RECD UNEMP COMP APR YR B4 LAST"           format=f1.
      ER40756   LABEL="R36 WTR RECD UNEMP COMP MAY YR B4 LAST"           format=f1.
      ER40757   LABEL="R36 WTR RECD UNEMP COMP JUN YR B4 LAST"           format=f1.
      ER40758   LABEL="R36 WTR RECD UNEMP COMP JUL YR B4 LAST"           format=f1.
      ER40759   LABEL="R36 WTR RECD UNEMP COMP AUG YR B4 LAST"           format=f1.
      ER40760   LABEL="R36 WTR RECD UNEMP COMP SEP YR B4 LAST"           format=f1.
      ER40761   LABEL="R36 WTR RECD UNEMP COMP OCT YR B4 LAST"           format=f1.
      ER40762   LABEL="R36 WTR RECD UNEMP COMP NOV YR B4 LAST"           format=f1.
      ER40763   LABEL="R36 WTR RECD UNEMP COMP DEC YR B4 LAST"           format=f1.
      ER40764   LABEL="R37 WTR RECD WORKERS COMP YR BEFORE LAST"         format=f1.
      ER40765   LABEL="R39 WORKERS COMP AMOUNT YEAR BEFORE LAST"         format=f7.
      ER40766   LABEL="R39 WORKERS COMP PER YEAR BEFORE LAST"            format=f1.
      ER40767   LABEL="R40 WTR RECD WORKERS COMP JAN YR B4 LAST"         format=f1.
      ER40768   LABEL="R40 WTR RECD WORKERS COMP FEB YR B4 LAST"         format=f1.
      ER40769   LABEL="R40 WTR RECD WORKERS COMP MAR YR B4 LAST"         format=f1.
      ER40770   LABEL="R40 WTR RECD WORKERS COMP APR YR B4 LAST"         format=f1.
      ER40771   LABEL="R40 WTR RECD WORKERS COMP MAY YR B4 LAST"         format=f1.
      ER40772   LABEL="R40 WTR RECD WORKERS COMP JUN YR B4 LAST"         format=f1.
      ER40773   LABEL="R40 WTR RECD WORKERS COMP JUL YR B4 LAST"         format=f1.
      ER40774   LABEL="R40 WTR RECD WORKERS COMP AUG YR B4 LAST"         format=f1.
      ER40775   LABEL="R40 WTR RECD WORKERS COMP SEP YR B4 LAST"         format=f1.
      ER40776   LABEL="R40 WTR RECD WORKERS COMP OCT YR B4 LAST"         format=f1.
      ER40777   LABEL="R40 WTR RECD WORKERS COMP NOV YR B4 LAST"         format=f1.
      ER40778   LABEL="R40 WTR RECD WORKERS COMP DEC YR B4 LAST"         format=f1.
      ER40779   LABEL="R41 WTR RECD TANF (ADC) YR B4 LAST"               format=f1.
      ER40780   LABEL="R45 TANF (ADC) AMOUNT YEAR BEFORE LAST"           format=f7.
      ER40781   LABEL="R45 TANF (ADC) PER YEAR BEFORE LAST"              format=f1.
      ER40782   LABEL="R46 WTR RECD TANF (ADC) JAN YR B4 LAST"           format=f1.
      ER40783   LABEL="R46 WTR RECD TANF (ADC) FEB YR B4 LAST"           format=f1.
      ER40784   LABEL="R46 WTR RECD TANF (ADC) MAR YR B4 LAST"           format=f1.
      ER40785   LABEL="R46 WTR RECD TANF (ADC) APR YR B4 LAST"           format=f1.
      ER40786   LABEL="R46 WTR RECD TANF (ADC) MAY YR B4 LAST"           format=f1.
      ER40787   LABEL="R46 WTR RECD TANF (ADC) JUN YR B4 LAST"           format=f1.
      ER40788   LABEL="R46 WTR RECD TANF (ADC) JUL YR B4 LAST"           format=f1.
      ER40789   LABEL="R46 WTR RECD TANF (ADC) AUG YR B4 LAST"           format=f1.
      ER40790   LABEL="R46 WTR RECD TANF (ADC) SEP YR B4 LAST"           format=f1.
      ER40791   LABEL="R46 WTR RECD TANF (ADC) OCT YR B4 LAST"           format=f1.
      ER40792   LABEL="R46 WTR RECD TANF (ADC) NOV YR B4 LAST"           format=f1.
      ER40793   LABEL="R46 WTR RECD TANF (ADC) DEC YR B4 LAST"           format=f1.
      ER40794   LABEL="R47 WTR RECEIVED SSI YR BEFORE LAST"              format=f1.
      ER40795   LABEL="R49 SSI AMOUNT YEAR BEFORE LAST"                  format=f7.
      ER40796   LABEL="R49 SSI PER YEAR BEFORE LAST"                     format=f1.
      ER40797   LABEL="R50 WTR RECD SSI JAN YR BEFORE LAST"              format=f1.
      ER40798   LABEL="R50 WTR RECD SSI FEB YR BEFORE LAST"              format=f1.
      ER40799   LABEL="R50 WTR RECD SSI MAR YR BEFORE LAST"              format=f1.
      ER40800   LABEL="R50 WTR RECD SSI APR YR BEFORE LAST"              format=f1.
      ER40801   LABEL="R50 WTR RECD SSI MAY YR BEFORE LAST"              format=f1.
      ER40802   LABEL="R50 WTR RECD SSI JUN YR BEFORE LAST"              format=f1.
      ER40803   LABEL="R50 WTR RECD SSI JUL YR BEFORE LAST"              format=f1.
      ER40804   LABEL="R50 WTR RECD SSI AUG YR BEFORE LAST"              format=f1.
      ER40805   LABEL="R50 WTR RECD SSI SEP YR BEFORE LAST"              format=f1.
      ER40806   LABEL="R50 WTR RECD SSI OCT YR BEFORE LAST"              format=f1.
      ER40807   LABEL="R50 WTR RECD SSI NOV YR BEFORE LAST"              format=f1.
      ER40808   LABEL="R50 WTR RECD SSI DEC YR BEFORE LAST"              format=f1.
      ER40809   LABEL="R51 WTR RECEIVED OTR WELFARE YR B4 LAST"          format=f1.
      ER40810   LABEL="R53 OTR WELFARE AMOUNT YEAR BEFORE LAST"          format=f7.
      ER40811   LABEL="R53 OTR WELFARE PER YEAR BEFORE LAST"             format=f1.
      ER40812   LABEL="R54 WTR RECD OTR WELFARE JAN YR B4 LAST"          format=f1.
      ER40813   LABEL="R54 WTR RECD OTR WELFARE FEB YR B4 LAST"          format=f1.
      ER40814   LABEL="R54 WTR RECD OTR WELFARE MAR YR B4 LAST"          format=f1.
      ER40815   LABEL="R54 WTR RECD OTR WELFARE APR YR B4 LAST"          format=f1.
      ER40816   LABEL="R54 WTR RECD OTR WELFARE MAY YR B4 LAST"          format=f1.
      ER40817   LABEL="R54 WTR RECD OTR WELFARE JUN YR B4 LAST"          format=f1.
      ER40818   LABEL="R54 WTR RECD OTR WELFARE JUL YR B4 LAST"          format=f1.
      ER40819   LABEL="R54 WTR RECD OTR WELFARE AUG YR B4 LAST"          format=f1.
      ER40820   LABEL="R54 WTR RECD OTR WELFARE SEP YR B4 LAST"          format=f1.
      ER40821   LABEL="R54 WTR RECD OTR WELFARE OCT YR B4 LAST"          format=f1.
      ER40822   LABEL="R54 WTR RECD OTR WELFARE NOV YR B4 LAST"          format=f1.
      ER40823   LABEL="R54 WTR RECD OTR WELFARE DEC YR B4 LAST"          format=f1.
      ER40824   LABEL="R55 WTR REC CH SUPP/ALIMONY YR B4 LAST"           format=f1.
      ER40825   LABEL="R57 CH SUPP/ALIMONY AMT YR BEFORE LAST"           format=f7.
      ER40826   LABEL="R57 CH SUPP/ALIMONY PER YR BEFORE LAST"           format=f1.
      ER40827   LABEL="R58 WTR REC CH SUPP/ALMNY JAN YR B4 LAST"         format=f1.
      ER40828   LABEL="R58 WTR REC CH SUPP/ALMNY FEB YR B4 LAST"         format=f1.
      ER40829   LABEL="R58 WTR REC CH SUPP/ALMNY MAR YR B4 LAST"         format=f1.
      ER40830   LABEL="R58 WTR REC CH SUPP/ALMNY APR YR B4 LAST"         format=f1.
      ER40831   LABEL="R58 WTR REC CH SUPP/ALMNY MAY YR B4 LAST"         format=f1.
      ER40832   LABEL="R58 WTR REC CH SUPP/ALMNY JUN YR B4 LAST"         format=f1.
      ER40833   LABEL="R58 WTR REC CH SUPP/ALMNY JUL YR B4 LAST"         format=f1.
      ER40834   LABEL="R58 WTR REC CH SUPP/ALMNY AUG YR B4 LAST"         format=f1.
      ER40835   LABEL="R58 WTR REC CH SUPP/ALMNY SEP YR B4 LAST"         format=f1.
      ER40836   LABEL="R58 WTR REC CH SUPP/ALMNY OCT YR B4 LAST"         format=f1.
      ER40837   LABEL="R58 WTR REC CH SUPP/ALMNY NOV YR B4 LAST"         format=f1.
      ER40838   LABEL="R58 WTR REC CH SUPP/ALMNY DEC YR B4 LAST"         format=f1.
      ER40839   LABEL="R59 WTR REC HELP FROM RELS YR B4 LAST"            format=f1.
      ER40840   LABEL="R61 HELP FROM RELS AMT YEAR BEFORE LAST"          format=f7.
      ER40841   LABEL="R61 HELP FROM RELS PER YEAR BEFORE LAST"          format=f1.
      ER40842   LABEL="R62 WTR REC HELP FRM RELS JAN YR B4 LAST"         format=f1.
      ER40843   LABEL="R62 WTR REC HELP FRM RELS FEB YR B4 LAST"         format=f1.
      ER40844   LABEL="R62 WTR REC HELP FRM RELS MAR YR B4 LAST"         format=f1.
      ER40845   LABEL="R62 WTR REC HELP FRM RELS APR YR B4 LAST"         format=f1.
      ER40846   LABEL="R62 WTR REC HELP FRM RELS MAY YR B4 LAST"         format=f1.
      ER40847   LABEL="R62 WTR REC HELP FRM RELS JUN YR B4 LAST"         format=f1.
      ER40848   LABEL="R62 WTR REC HELP FRM RELS JUL YR B4 LAST"         format=f1.
      ER40849   LABEL="R62 WTR REC HELP FRM RELS AUG YR B4 LAST"         format=f1.
      ER40850   LABEL="R62 WTR REC HELP FRM RELS SEP YR B4 LAST"         format=f1.
      ER40851   LABEL="R62 WTR REC HELP FRM RELS OCT YR B4 LAST"         format=f1.
      ER40852   LABEL="R62 WTR REC HELP FRM RELS NOV YR B4 LAST"         format=f1.
      ER40853   LABEL="R62 WTR REC HELP FRM RELS DEC YR B4 LAST"         format=f1.
      ER40854   LABEL="R63 WTR ANY OTR INCOME 2 YRS AGO"                 format=f1.
      ER40855   LABEL="R66 AMT OF INCOME 2 YRS AGO"                      format=f7.
      ER40856   LABEL="R66 PER FOR AMT OF INCOME 2 YRS AGO"              format=f1.
      ER40857   LABEL="R67 WTR RECD INCOME JAN 2 YRS AGO"                format=f1.
      ER40858   LABEL="R67 WTR RECD INCOME FEB 2 YRS AGO"                format=f1.
      ER40859   LABEL="R67 WTR RECD INCOME MAR 2 YRS AGO"                format=f1.
      ER40860   LABEL="R67 WTR RECD INCOME APR 2 YRS AGO"                format=f1.
      ER40861   LABEL="R67 WTR RECD INCOME MAY 2 YRS AGO"                format=f1.
      ER40862   LABEL="R67 WTR RECD INCOME JUN 2 YRS AGO"                format=f1.
      ER40863   LABEL="R67 WTR RECD INCOME JUL 2 YRS AGO"                format=f1.
      ER40864   LABEL="R67 WTR RECD INCOME AUG 2 YRS AGO"                format=f1.
      ER40865   LABEL="R67 WTR RECD INCOME SEP 2 YRS AGO"                format=f1.
      ER40866   LABEL="R67 WTR RECD INCOME OCT 2 YRS AGO"                format=f1.
      ER40867   LABEL="R67 WTR RECD INCOME NOV 2 YRS AGO"                format=f1.
      ER40868   LABEL="R67 WTR RECD INCOME DEC 2 YRS AGO"                format=f1.
      ER40869   LABEL="WHO WAS RESPONDENT"                               format=f1.
      ER40870   LABEL="# CALLS FOR IW"                                   format=f3.
      ER40871   LABEL="LANGUAGE OF INTERVIEW"                            format=f1.
      ER40872   LABEL="# OF INDIVIDUAL RECORDS"                          format=f2.
      ER40873   LABEL="HEAD WORK WEEKS-2006"                             format=f4.1
      ER40874   LABEL="HEAD WEEKLY WORK HOURS-2006"                      format=f3.
      ER40875   LABEL="HD OVERTIME WORK HOURS-2006"                      format=f4.
      ER40876   LABEL="HEAD TOTAL HOURS OF WORK-2006"                    format=f4.
      ER40877   LABEL="HD WEEKS MISSED FOR ILLNESS OF OTRS-2006"         format=f4.1
      ER40878   LABEL="HD WEEKS MISSED FOR OWN ILLNESS-2006"             format=f4.1
      ER40879   LABEL="HEAD WEEKS OFF FOR VACATION-2006"                 format=f4.1
      ER40880   LABEL="HEAD STRIKE WEEKS-2006"                           format=f4.1
      ER40881   LABEL="HEAD WEEKS LAID OFF-2006"                         format=f4.1
      ER40882   LABEL="HEAD UNEMPLOYMENT WEEKS-2006"                     format=f4.1
      ER40883   LABEL="HEAD WEEKS OUT OF LABOR FORCE-2006"               format=f4.1
      ER40884   LABEL="WIFE WORK WEEKS-2006"                             format=f4.1
      ER40885   LABEL="WIFE WEEKLY WORK HOURS-2006"                      format=f3.
      ER40886   LABEL="WF OVERTIME WORK HOURS-2006"                      format=f4.
      ER40887   LABEL="WIFE TOTAL HOURS OF WORK-2006"                    format=f4.
      ER40888   LABEL="WF WEEKS MISSED FOR ILLNESS OF OTRS-2006"         format=f4.1
      ER40889   LABEL="WF WEEKS MISSED FOR OWN ILLNESS-2006"             format=f4.1
      ER40890   LABEL="WIFE WEEKS OFF FOR VACATION-2006"                 format=f4.1
      ER40891   LABEL="WIFE STRIKE WEEKS-2006"                           format=f4.1
      ER40892   LABEL="WIFE WEEKS LAID OFF-2006"                         format=f4.1
      ER40893   LABEL="WIFE UNEMPLOYMENT WEEKS-2006"                     format=f4.1
      ER40894   LABEL="WIFE WEEKS OUT OF LABOR FORCE-2006"               format=f4.1
      ER40895   LABEL="TOTAL BUSINESS INCOME-2006"                       format=f7.
      ER40896   LABEL="ACC BUSINESS INCOME-2006"                         format=f1.
      ER40897   LABEL="NUMBER OF BUSINESSES OWNED BY FU IN 2006"         format=f1.
      ER40898   LABEL="FARM INCOME OF HEAD-2006"                         format=f7.
      ER40899   LABEL="ACC FARM INCOME OF HEAD-2006"                     format=f1.
      ER40900   LABEL="HD LABOR INCOME FROM BUSINESS-2006"               format=f7.
      ER40901   LABEL="HD ASSET INCOME FROM BUSINESS-2006"               format=f7.
      ER40902   LABEL="NUMBER OF BUSINESSES OWNED BY HEAD"               format=f1.
      ER40903   LABEL="WAGES AND SALARIES OF HEAD-2006"                  format=f7.
      ER40904   LABEL="ACC WAGES AND SALARIES OF HEAD-2006"              format=f1.
      ER40905   LABEL="BONUS INCOME OF HEAD-2006"                        format=f6.
      ER40906   LABEL="ACC BONUS INCOME OF HEAD-2006"                    format=f1.
      ER40907   LABEL="OVERTIME INCOME OF HEAD-2006"                     format=f6.
      ER40908   LABEL="ACC OVERTIME INCOME OF HEAD-2006"                 format=f1.
      ER40909   LABEL="TIPS OF HEAD-2006"                                format=f6.
      ER40910   LABEL="ACC TIPS OF HEAD-2006"                            format=f1.
      ER40911   LABEL="COMMISSION INCOME OF HEAD-2006"                   format=f6.
      ER40912   LABEL="ACC COMMISSION INCOME OF HEAD-2006"               format=f1.
      ER40913   LABEL="PROFESSIONAL PRACTICE OF HEAD-2006"               format=f7.
      ER40914   LABEL="ACC PROFESSIONL PRACTICE OF HD-2006"              format=f1.
      ER40915   LABEL="MARKET GARDENING INCOME OF HD-2006"               format=f7.
      ER40916   LABEL="ACC MARKET GARDENING INCOME OF HEAD"              format=f1.
      ER40917   LABEL="HEAD ADDITIONAL JOB INCOME-2006"                  format=f7.
      ER40918   LABEL="ACC OF HEAD ADDITIONAL JOB INCOME"                format=f1.
      ER40919   LABEL="MISC LABOR INCOME OF HEAD-2006"                   format=f6.
      ER40920   LABEL="ACC MISC LABOR INCOME OF HEAD-2006"               format=f1.
      ER40921   LABEL="LABOR INCOME OF HEAD-2006"                        format=f7.
      ER40922   LABEL="HEAD RENT INCOME-2006"                            format=f6.
      ER40923   LABEL="ACCURACY OF HEAD RENT INCOME-2006"                format=f1.
      ER40924   LABEL="HEAD DIVIDENDS-2006"                              format=f6.
      ER40925   LABEL="ACCURACY OF HEAD DIVIDENDS-2006"                  format=f1.
      ER40926   LABEL="HEAD INTEREST INCOME-2006"                        format=f6.
      ER40927   LABEL="ACCURACY OF HEAD INTEREST INCOME-2006"            format=f1.
      ER40928   LABEL="HEAD INCOME FROM TRUSTS/ROYALTIES-2006"           format=f6.
      ER40929   LABEL="ACCURACY OF HD INCOME FROM TRUSTS-2006"           format=f1.
      ER40930   LABEL="WF LABOR INCOME FROM BUSINESS-2006"               format=f7.
      ER40931   LABEL="WF ASSET INCOME FROM BUSINESS-2006"               format=f7.
      ER40932   LABEL="NUMBER OF BUSINESSES OWNED BY WIFE"               format=f1.
      ER40933   LABEL="LABOR INCOME OF WIFE-2006"                        format=f7.
      ER40934   LABEL="ACC LABOR INCOME OF WIFE-2006"                    format=f1.
      ER40935   LABEL="WIFE RENT INCOME-2006"                            format=f6.
      ER40936   LABEL="ACCURACY OF WIFE RENT INCOME-2006"                format=f1.
      ER40937   LABEL="WIFE DIVIDENDS-2006"                              format=f6.
      ER40938   LABEL="ACCURACY OF WIFE DIVIDENDS-2006"                  format=f1.
      ER40939   LABEL="WIFE INTEREST INCOME-2006"                        format=f6.
      ER40940   LABEL="ACCURACY OF WIFE INTEREST INCOME-2006"            format=f1.
      ER40941   LABEL="WIFE INCOME FROM TRUSTS/ROYALTIES-2006"           format=f6.
      ER40942   LABEL="ACCURACY OF WF INCOME FROM TRUSTS-2006"           format=f1.
      ER40943   LABEL="HEAD AND WIFE TAXABLE INCOME-2006"                format=f7.
      ER40944   LABEL="HEAD INCOME FROM TANF, ETC.-2006"                 format=f6.
      ER40945   LABEL="ACCURACY OF HEAD INCOME FROM TANF-2006"           format=f1.
      ER40946   LABEL="HEAD SSI-2006"                                    format=f6.
      ER40947   LABEL="ACCURACY OF HEAD SSI-2006"                        format=f1.
      ER40948   LABEL="HEAD OTHER WELFARE-2006"                          format=f6.
      ER40949   LABEL="ACCURACY OF HEAD OTHER WELFARE-2006"              format=f1.
      ER40950   LABEL="HEAD VA PENSION-2006"                             format=f6.
      ER40951   LABEL="ACCURACY OF HEAD VA PENSION-2006"                 format=f1.
      ER40952   LABEL="HEAD RETIREMENT/PENSIONS-2006"                    format=f6.
      ER40953   LABEL="ACCURACY OF HEAD RETIREMENT-2006"                 format=f1.
      ER40954   LABEL="HEAD ANNUITIES-2006"                              format=f6.
      ER40955   LABEL="ACCURACY OF HEAD ANNUITIES-2006"                  format=f1.
      ER40956   LABEL="HEAD OTHER RETIREMENT-2006"                       format=f6.
      ER40957   LABEL="ACCURACY OF HEAD OTHER RETIREMENT-2006"           format=f1.
      ER40958   LABEL="HEAD UNEMPLOYMENT COMPENSATION-2006"              format=f6.
      ER40959   LABEL="ACCURACY OF HEAD UNEMPLOYMENT COMP-2006"          format=f1.
      ER40960   LABEL="HEAD WORKERS COMPENSATION-2006"                   format=f6.
      ER40961   LABEL="ACCURACY OF HEAD WORKERS COMP-2006"               format=f1.
      ER40962   LABEL="CHILD SUPPORT RECEIVED BY HEAD-2006"              format=f6.
      ER40963   LABEL="ACCURACY OF HEAD CHILD SUPPORT-2006"              format=f1.
      ER40964   LABEL="HEAD INCOME FROM ALIMONY-2006"                    format=f6.
      ER40965   LABEL="ACCURACY OF HEAD ALIMONY-2006"                    format=f1.
      ER40966   LABEL="HEAD HELP FROM RELATIVES-2006"                    format=f6.
      ER40967   LABEL="ACCURACY OF HEAD HELP FROM RELS-2006"             format=f1.
      ER40968   LABEL="HEAD HELP FROM OTHERS-2006"                       format=f6.
      ER40969   LABEL="ACCURACY OF HEAD HELP FROM OTHERS-2006"           format=f1.
      ER40970   LABEL="HEAD MISCELLANEOUS TRANSFERS-2006"                format=f6.
      ER40971   LABEL="ACCURACY OF HD MISC TRANSFERS-2006"               format=f1.
      ER40972   LABEL="WIFE INCOME FROM TANF, ETC.-2006"                 format=f6.
      ER40973   LABEL="ACCURACY OF WIFE INCOME FROM TANF-2006"           format=f1.
      ER40974   LABEL="WIFE SSI-2006"                                    format=f6.
      ER40975   LABEL="ACCURACY OF WIFE SSI-2006"                        format=f1.
      ER40976   LABEL="WIFE OTHER WELFARE-2006"                          format=f6.
      ER40977   LABEL="ACCURACY OF WIFE OTHER WELFARE-2006"              format=f1.
      ER40978   LABEL="WIFE RETIREMENT/ANNUITIES-2006"                   format=f6.
      ER40979   LABEL="ACCURACY OF WIFE RETIREMENT-2006"                 format=f1.
      ER40980   LABEL="WIFE UNEMPLOYMENT COMPENSATION-2006"              format=f6.
      ER40981   LABEL="ACCURACY OF WIFE UNEMPLOYMENT COMP-2006"          format=f1.
      ER40982   LABEL="WIFE WORKERS COMPENSATION-2006"                   format=f6.
      ER40983   LABEL="ACCURACY OF WIFE WORKERS COMP-2006"               format=f1.
      ER40984   LABEL="CHILD SUPPORT RECEIVED BY WIFE-2006"              format=f6.
      ER40985   LABEL="ACCURACY OF WIFE CHILD SUPPORT-2006"              format=f1.
      ER40986   LABEL="WIFE HELP FROM RELATIVES-2006"                    format=f6.
      ER40987   LABEL="ACCURACY OF WIFE HELP FROM RELS-2006"             format=f1.
      ER40988   LABEL="WIFE HELP FROM OTHERS-2006"                       format=f6.
      ER40989   LABEL="ACCURACY OF WIFE HELP FROM OTHERS-2006"           format=f1.
      ER40990   LABEL="WIFE MISCELLANEOUS TRANSFERS-2006"                format=f6.
      ER40991   LABEL="ACCURACY OF WF MISC TRANSFERS-2006"               format=f1.
      ER40992   LABEL="HEAD AND WIFE TRANSFER INCOME-2006"               format=f7.
      ER40993   LABEL="HEAD WAGE RATE-2006"                              format=f6.2
      ER40994   LABEL="WIFE WAGE RATE-2006"                              format=f6.2
      ER40995   LABEL="TOTAL LABOR INCOME OF OTR FU MEMBRS-2006"         format=f7.
      ER40996   LABEL="ACCURACY OF OTR FU MEMBR LABOR Y-2006"            format=f1.
      ER40997   LABEL="TOTAL ASSET INCOME OF OTR FU MEMBRS-2006"         format=f6.
      ER40998   LABEL="ACCURACY OF OTR FU MEMBR ASSET Y-2006"            format=f1.
      ER40999   LABEL="TAXABLE INCOME OF OTHER FU MEMBERS-2006"          format=f7.
      ER41000   LABEL="OTR FU MEMBR INCOME FROM TANF, ETC.-2006"         format=f6.
      ER41001   LABEL="ACCURACY OF OFUM INCOME FROM TANF-2006"           format=f1.
      ER41002   LABEL="OTR FU MEMBERS SSI-2006"                          format=f6.
      ER41003   LABEL="ACCURACY OF OTR FU MEMBERS SSI-2006"              format=f1.
      ER41004   LABEL="OTR FU MEMBERS OTHER WELFARE-2006"                format=f6.
      ER41005   LABEL="ACCURACY OF OFUM OTHER WELFARE-2006"              format=f1.
      ER41006   LABEL="OTHER FU MEMBERS VA PENSION-2006"                 format=f6.
      ER41007   LABEL="ACCURACY OF OTR FU MEMBR VA PENSION-2006"         format=f1.
      ER41008   LABEL="OTHER FU MEMBR RETIREMENT/ANNUITIES-2006"         format=f6.
      ER41009   LABEL="ACCURACY OF OFUM RETIREMENT-2006"                 format=f1.
      ER41010   LABEL="OFUM UNEMPLOYMENT COMPENSATION-2006"              format=f6.
      ER41011   LABEL="ACCURACY OF OFUM UNEMPLOYMENT COMP-2006"          format=f1.
      ER41012   LABEL="OTR FU MEMBERS WORKERS COMPENSATION-2006"         format=f6.
      ER41013   LABEL="ACCURACY OF OFUM WORKERS COMP-2006"               format=f1.
      ER41014   LABEL="OFUM INCOME FROM CHILD SUPPORT-2006"              format=f6.
      ER41015   LABEL="ACCURACY OF OFUM CHILD SUPPORT-2006"              format=f1.
      ER41016   LABEL="OTR FU MEMBERS HELP FROM RELATIVES-2006"          format=f6.
      ER41017   LABEL="ACCURACY OF OFUM HELP FROM RELS-2006"             format=f1.
      ER41018   LABEL="OFUM MISCELLANEOUS TRANSFERS-2006"                format=f6.
      ER41019   LABEL="ACCURACY OF OFUM MISC TRANSFERS-2006"             format=f1.
      ER41020   LABEL="TOTAL TRANSFER INCOME OF OFUMS-2006"              format=f6.
      ER41021   LABEL="HEAD SOCIAL SECURITY INCOME-2006"                 format=f6.
      ER41022   LABEL="ACCURACY OF HEAD SOCIAL SECURITY-2006"            format=f1.
      ER41023   LABEL="WIFE SOCIAL SECURITY INCOME-2006"                 format=f6.
      ER41024   LABEL="ACCURACY OF WIFE SOCIAL SECURITY-2006"            format=f1.
      ER41025   LABEL="OFUM SOCIAL SECURITY INCOME-2006"                 format=f6.
      ER41026   LABEL="ACCURACY OF OFUM SOCIAL SECURITY-2006"            format=f1.
      ER41027   LABEL="TOTAL FAMILY INCOME-2006"                         format=f7.
      ER41028   LABEL="USDA NEEDS STANDARD-2006"                         format=f5.
      ER41029   LABEL="CENSUS NEEDS STANDARD-2006"                       format=f5.
      ER41030   LABEL="USDA NEEDS STANDARD-2005"                         format=f5.
      ER41031   LABEL="CENSUS NEEDS STANDARD-2005"                       format=f5.
      ER41032   LABEL="CURRENT REGION"                                   format=f1.
      ER41033   LABEL="BEALE RURAL-URBAN CODE"                           format=f2.
      ER41034   LABEL="SIZE LARGEST CITY IN COUNTY"                      format=f1.
      ER41035   LABEL="REGION HD GREW UP"                                format=f1.
      ER41036   LABEL="HD GEOGRAPHIC MOBILITY"                           format=f1.
      ER41037   LABEL="COMPLETED ED-HD"                                  format=f2.
      ER41038   LABEL="COMPLETED ED-WF"                                  format=f2.
      ER41039   LABEL="MARITAL STATUS-GENERATED"                         format=f1.
      ER41040   LABEL="CHANGE IN MARITAL STATUS"                         format=f1.
      ER41041   LABEL="COUPLE STATUS OF HEAD"                            format=f1.
      ER41042   LABEL="YEAR NEW HEAD IN FU"                              format=f4.
      ER41043   LABEL="YEAR NEW WIFE IN FU"                              format=f4.
      ER41044   LABEL="HEAD-SPOUSE SAMPLE STATUS"                        format=f1.
      ER41045   LABEL="NUMBER OF SPLITOFFS FROM MAIN FAM"                format=f1.
      ER41046   LABEL="MAIN FAMILY ID FOR SPLITOFF"                      format=f5.
      ER41047   LABEL="CURRENT YR ID OF 1ST OTHER FU IN HU"              format=f5.
      ER41048   LABEL="REL OF 1ST OTHER FU"                              format=f1.
      ER41049   LABEL="SIZE OF 1ST OTHER FU"                             format=f2.
      ER41050   LABEL="CURRENT YR ID OF 2ND OTHER FU IN HU"              format=f5.
      ER41051   LABEL="REL OF 2ND OTHER FU"                              format=f1.
      ER41052   LABEL="SIZE OF 2ND OTHER FU"                             format=f2.
      ER41053   LABEL="CURRENT YR ID OF 3RD OTHER FU IN HU"              format=f5.
      ER41054   LABEL="REL OF 3RD OTHER FU"                              format=f1.
      ER41055   LABEL="SIZE OF 3RD OTHER FU"                             format=f2.
      ER41056   LABEL="CURRENT YR ID OF 4TH OTHER FU IN HU"              format=f5.
      ER41057   LABEL="REL OF 4TH OTHER FU"                              format=f1.
      ER41058   LABEL="SIZE OF 4TH OTHER FU"                             format=f2.
      ER41059   LABEL="HOUSEHOLD ID #"                                   format=f5.
      ER41060   LABEL="BIRTHS TO HEAD ONLY-2006"                         format=f1.
      ER41061   LABEL="BIRTHS TO WIFE ONLY-2006"                         format=f1.
      ER41062   LABEL="BIRTHS TO HEAD AND WIFE-2006"                     format=f1.
      ER41063   LABEL="BIRTHS TO OFUMS ONLY-2006"                        format=f1.
      ER41064   LABEL="BIRTHS TO HEAD ONLY-2005"                         format=f1.
      ER41065   LABEL="BIRTHS TO WIFE ONLY-2005"                         format=f1.
      ER41066   LABEL="BIRTHS TO HEAD AND WIFE-2005"                     format=f1.
      ER41067   LABEL="BIRTHS TO OFUMS ONLY-2005"                        format=f1.
      ER41068   LABEL="WTR RECORD IN KATRINA SUPPLEMENT-2007"            format=f1.
      ER41069   LABEL="2007 CORE/IMMIGRANT FAM WEIGHT NUMBER 1"          format=f7.3
   ;
   infile 'F:\PSID\FAM2007ER.txt'  lrecl=8185 missover;
   INPUT 
      ER36001         1 - 1         ER36002         2 - 6         ER36003         7 - 8    
      ER36004         9 - 10        ER36005        11 - 11        ER36006        12 - 12   
      ER36007        13 - 13        ER36008        14 - 14        ER36009        15 - 18   
      ER36010        19 - 19        ER36011        20 - 27        ER36012        28 - 29   
      ER36013        30 - 31        ER36014        32 - 35        ER36015        36 - 38   
      ER36016        39 - 40        ER36017        41 - 43        ER36018        44 - 44   
      ER36019        45 - 47        ER36020        48 - 49        ER36021        50 - 52   
      ER36022        53 - 54        ER36023        55 - 55        ER36024        56 - 56   
      ER36025        57 - 57        ER36026        58 - 58        ER36027        59 - 60   
      ER36028        61 - 61        ER36029        62 - 68        ER36030        69 - 69   
      ER36031        70 - 70        ER36032        71 - 71        ER36033        72 - 72   
      ER36034        73 - 73        ER36035        74 - 74        ER36036        75 - 79   
      ER36037        80 - 80        ER36038        81 - 84        ER36039        85 - 85   
      ER36040        86 - 86        ER36041        87 - 87        ER36042        88 - 94   
      ER36043        95 - 95        ER36044        96 - 100       ER36045       101 - 101  
      ER36046       102 - 103       ER36047       104 - 106       ER36048       107 - 107  
      ER36049       108 - 111       ER36050       112 - 113       ER36051       114 - 114  
      ER36052       115 - 115       ER36053       116 - 116       ER36054       117 - 123  
      ER36055       124 - 124       ER36056       125 - 129       ER36057       130 - 130  
      ER36058       131 - 132       ER36059       133 - 135       ER36060       136 - 136  
      ER36061       137 - 140       ER36062       141 - 142       ER36063       143 - 143  
      ER36064       144 - 144       ER36065       145 - 149       ER36066       150 - 150  
      ER36067       151 - 151       ER36068       152 - 152       ER36069       153 - 153  
      ER36070       154 - 154       ER36071       155 - 155       ER36072       156 - 159  
      ER36073       160 - 160       ER36074       161 - 161       ER36075       162 - 162  
      ER36076       163 - 163       ER36077       164 - 164       ER36078       165 - 165  
      ER36079       166 - 167       ER36080       168 - 169       ER36081       170 - 171  
      ER36082       172 - 172       ER36083       173 - 176       ER36084       177 - 177  
      ER36085       178 - 181       ER36086       182 - 182       ER36087       183 - 186  
      ER36088       187 - 187       ER36089       188 - 191       ER36090       192 - 192  
      ER36091       193 - 196       ER36092       197 - 197       ER36093       198 - 198  
      ER36094       199 - 199       ER36095       200 - 202       ER36096       203 - 203  
      ER36097       204 - 204       ER36098       205 - 208       ER36099       209 - 209  
      ER36100       210 - 210       ER36101       211 - 211       ER36102       212 - 212  
      ER36103       213 - 213       ER36104       214 - 215       ER36105       216 - 219  
      ER36106       220 - 221       ER36107       222 - 222       ER36108       223 - 223  
      ER36109       224 - 225       ER36110       226 - 227       ER36111       228 - 229  
      ER36112       230 - 233       ER36113       234 - 234       ER36114       235 - 235  
      ER36115       236 - 236       ER36116       237 - 238       ER36117       239 - 242  
      ER36118       243 - 244       ER36119       245 - 248       ER36120       249 - 249  
      ER36121       250 - 250       ER36122       251 - 251       ER36123       252 - 252  
      ER36124       253 - 253       ER36125       254 - 254       ER36126       255 - 255  
      ER36127       256 - 256       ER36128       257 - 257       ER36129       258 - 258  
      ER36130       259 - 259       ER36131       260 - 260       ER36132       261 - 263  
      ER36133       264 - 266       ER36134       267 - 267       ER36135       268 - 268  
      ER36136       269 - 269       ER36137       270 - 278       ER36138       279 - 279  
      ER36139       280 - 280       ER36140       281 - 281       ER36141       282 - 282  
      ER36142       283 - 283       ER36143       284 - 284       ER36144       285 - 285  
      ER36145       286 - 286       ER36146       287 - 287       ER36147       288 - 297  
      ER36148       298 - 298       ER36149       299 - 299       ER36150       300 - 300  
      ER36151       301 - 310       ER36152       311 - 311       ER36153       312 - 317  
      ER36154       318 - 318       ER36155       319 - 319       ER36156       320 - 320  
      ER36157       321 - 330       ER36158       331 - 331       ER36159       332 - 339  
      ER36160       340 - 340       ER36161       341 - 347       ER36162       348 - 348  
      ER36163       349 - 349       ER36164       350 - 358       ER36165       359 - 360  
      ER36166       361 - 362       ER36167       363 - 364       ER36168       365 - 368  
      ER36169       369 - 369       ER36170       370 - 372       ER36171       373 - 373  
      ER36172       374 - 374       ER36173       375 - 378       ER36174       379 - 379  
      ER36175       380 - 380       ER36176       381 - 390       ER36177       391 - 391  
      ER36178       392 - 392       ER36179       393 - 394       ER36180       395 - 398  
      ER36181       399 - 400       ER36182       401 - 404       ER36183       405 - 405  
      ER36184       406 - 406       ER36185       407 - 407       ER36186       408 - 408  
      ER36187       409 - 409       ER36188       410 - 410       ER36189       411 - 411  
      ER36190       412 - 412       ER36191       413 - 413       ER36192       414 - 414  
      ER36193       415 - 415       ER36194       416 - 416       ER36195       417 - 419  
      ER36196       420 - 422       ER36197       423 - 423       ER36198       424 - 424  
      ER36199       425 - 425       ER36200       426 - 429       ER36201       430 - 430  
      ER36202       431 - 433       ER36203       434 - 434       ER36204       435 - 435  
      ER36205       436 - 439       ER36206       440 - 440       ER36207       441 - 441  
      ER36208       442 - 451       ER36209       452 - 452       ER36210       453 - 453  
      ER36211       454 - 455       ER36212       456 - 459       ER36213       460 - 461  
      ER36214       462 - 465       ER36215       466 - 466       ER36216       467 - 467  
      ER36217       468 - 468       ER36218       469 - 469       ER36219       470 - 470  
      ER36220       471 - 471       ER36221       472 - 472       ER36222       473 - 473  
      ER36223       474 - 474       ER36224       475 - 475       ER36225       476 - 476  
      ER36226       477 - 477       ER36227       478 - 480       ER36228       481 - 483  
      ER36229       484 - 484       ER36230       485 - 485       ER36231       486 - 486  
      ER36232       487 - 490       ER36233       491 - 491       ER36234       492 - 494  
      ER36235       495 - 495       ER36236       496 - 496       ER36237       497 - 500  
      ER36238       501 - 501       ER36239       502 - 502       ER36240       503 - 512  
      ER36241       513 - 513       ER36242       514 - 514       ER36243       515 - 516  
      ER36244       517 - 520       ER36245       521 - 522       ER36246       523 - 526  
      ER36247       527 - 527       ER36248       528 - 528       ER36249       529 - 529  
      ER36250       530 - 530       ER36251       531 - 531       ER36252       532 - 532  
      ER36253       533 - 533       ER36254       534 - 534       ER36255       535 - 535  
      ER36256       536 - 536       ER36257       537 - 537       ER36258       538 - 538  
      ER36259       539 - 541       ER36260       542 - 544       ER36261       545 - 545  
      ER36262       546 - 546       ER36263       547 - 547       ER36264       548 - 551  
      ER36265       552 - 552       ER36266       553 - 555       ER36267       556 - 556  
      ER36268       557 - 557       ER36269       558 - 561       ER36270       562 - 562  
      ER36271       563 - 563       ER36272       564 - 573       ER36273       574 - 574  
      ER36274       575 - 575       ER36275       576 - 576       ER36276       577 - 577  
      ER36277       578 - 580       ER36278       581 - 581       ER36279       582 - 583  
      ER36280       584 - 584       ER36281       585 - 586       ER36282       587 - 587  
      ER36283       588 - 588       ER36284       589 - 591       ER36285       592 - 592  
      ER36286       593 - 594       ER36287       595 - 595       ER36288       596 - 597  
      ER36289       598 - 598       ER36290       599 - 599       ER36291       600 - 602  
      ER36292       603 - 603       ER36293       604 - 605       ER36294       606 - 606  
      ER36295       607 - 608       ER36296       609 - 609       ER36297       610 - 610  
      ER36298       611 - 613       ER36299       614 - 614       ER36300       615 - 616  
      ER36301       617 - 617       ER36302       618 - 619       ER36303       620 - 620  
      ER36304       621 - 621       ER36305       622 - 624       ER36306       625 - 625  
      ER36307       626 - 627       ER36308       628 - 628       ER36309       629 - 630  
      ER36310       631 - 631       ER36311       632 - 632       ER36312       633 - 635  
      ER36313       636 - 636       ER36314       637 - 638       ER36315       639 - 639  
      ER36316       640 - 641       ER36317       642 - 642       ER36318       643 - 643  
      ER36319       644 - 644       ER36320       645 - 645       ER36321       646 - 646  
      ER36322       647 - 647       ER36323       648 - 648       ER36324       649 - 649  
      ER36325       650 - 650       ER36326       651 - 651       ER36327       652 - 652  
      ER36328       653 - 653       ER36329       654 - 654       ER36330       655 - 655  
      ER36331       656 - 658       ER36332       659 - 659       ER36333       660 - 661  
      ER36334       662 - 662       ER36335       663 - 664       ER36336       665 - 665  
      ER36337       666 - 666       ER36338       667 - 667       ER36339       668 - 668  
      ER36340       669 - 669       ER36341       670 - 670       ER36342       671 - 671  
      ER36343       672 - 672       ER36344       673 - 673       ER36345       674 - 674  
      ER36346       675 - 675       ER36347       676 - 676       ER36348       677 - 677  
      ER36349       678 - 679       ER36350       680 - 682       ER36351       683 - 683  
      ER36352       684 - 685       ER36353       686 - 689       ER36354       690 - 690  
      ER36355       691 - 691       ER36356       692 - 692       ER36357       693 - 693  
      ER36358       694 - 694       ER36359       695 - 695       ER36360       696 - 696  
      ER36361       697 - 697       ER36362       698 - 698       ER36363       699 - 700  
      ER36364       701 - 702       ER36365       703 - 704       ER36366       705 - 705  
      ER36367       706 - 707       ER36368       708 - 709       ER36369       710 - 711  
      ER36370       712 - 715       ER36371       716 - 716       ER36372       717 - 717  
      ER36373       718 - 718       ER36374       719 - 720       ER36375       721 - 724  
      ER36376       725 - 726       ER36377       727 - 730       ER36378       731 - 731  
      ER36379       732 - 732       ER36380       733 - 733       ER36381       734 - 734  
      ER36382       735 - 735       ER36383       736 - 736       ER36384       737 - 737  
      ER36385       738 - 738       ER36386       739 - 739       ER36387       740 - 740  
      ER36388       741 - 741       ER36389       742 - 742       ER36390       743 - 745  
      ER36391       746 - 748       ER36392       749 - 749       ER36393       750 - 750  
      ER36394       751 - 751       ER36395       752 - 760       ER36396       761 - 761  
      ER36397       762 - 762       ER36398       763 - 763       ER36399       764 - 764  
      ER36400       765 - 765       ER36401       766 - 766       ER36402       767 - 767  
      ER36403       768 - 768       ER36404       769 - 769       ER36405       770 - 779  
      ER36406       780 - 780       ER36407       781 - 781       ER36408       782 - 782  
      ER36409       783 - 792       ER36410       793 - 793       ER36411       794 - 799  
      ER36412       800 - 800       ER36413       801 - 801       ER36414       802 - 802  
      ER36415       803 - 812       ER36416       813 - 813       ER36417       814 - 821  
      ER36418       822 - 822       ER36419       823 - 829       ER36420       830 - 830  
      ER36421       831 - 831       ER36422       832 - 840       ER36423       841 - 842  
      ER36424       843 - 844       ER36425       845 - 846       ER36426       847 - 850  
      ER36427       851 - 851       ER36428       852 - 854       ER36429       855 - 855  
      ER36430       856 - 856       ER36431       857 - 860       ER36432       861 - 861  
      ER36433       862 - 862       ER36434       863 - 872       ER36435       873 - 873  
      ER36436       874 - 874       ER36437       875 - 876       ER36438       877 - 880  
      ER36439       881 - 882       ER36440       883 - 886       ER36441       887 - 887  
      ER36442       888 - 888       ER36443       889 - 889       ER36444       890 - 890  
      ER36445       891 - 891       ER36446       892 - 892       ER36447       893 - 893  
      ER36448       894 - 894       ER36449       895 - 895       ER36450       896 - 896  
      ER36451       897 - 897       ER36452       898 - 898       ER36453       899 - 901  
      ER36454       902 - 904       ER36455       905 - 905       ER36456       906 - 906  
      ER36457       907 - 907       ER36458       908 - 911       ER36459       912 - 912  
      ER36460       913 - 915       ER36461       916 - 916       ER36462       917 - 917  
      ER36463       918 - 921       ER36464       922 - 922       ER36465       923 - 923  
      ER36466       924 - 933       ER36467       934 - 934       ER36468       935 - 935  
      ER36469       936 - 937       ER36470       938 - 941       ER36471       942 - 943  
      ER36472       944 - 947       ER36473       948 - 948       ER36474       949 - 949  
      ER36475       950 - 950       ER36476       951 - 951       ER36477       952 - 952  
      ER36478       953 - 953       ER36479       954 - 954       ER36480       955 - 955  
      ER36481       956 - 956       ER36482       957 - 957       ER36483       958 - 958  
      ER36484       959 - 959       ER36485       960 - 962       ER36486       963 - 965  
      ER36487       966 - 966       ER36488       967 - 967       ER36489       968 - 968  
      ER36490       969 - 972       ER36491       973 - 973       ER36492       974 - 976  
      ER36493       977 - 977       ER36494       978 - 978       ER36495       979 - 982  
      ER36496       983 - 983       ER36497       984 - 984       ER36498       985 - 994  
      ER36499       995 - 995       ER36500       996 - 996       ER36501       997 - 998  
      ER36502       999 - 1002      ER36503      1003 - 1004      ER36504      1005 - 1008 
      ER36505      1009 - 1009      ER36506      1010 - 1010      ER36507      1011 - 1011 
      ER36508      1012 - 1012      ER36509      1013 - 1013      ER36510      1014 - 1014 
      ER36511      1015 - 1015      ER36512      1016 - 1016      ER36513      1017 - 1017 
      ER36514      1018 - 1018      ER36515      1019 - 1019      ER36516      1020 - 1020 
      ER36517      1021 - 1023      ER36518      1024 - 1026      ER36519      1027 - 1027 
      ER36520      1028 - 1028      ER36521      1029 - 1029      ER36522      1030 - 1033 
      ER36523      1034 - 1034      ER36524      1035 - 1037      ER36525      1038 - 1038 
      ER36526      1039 - 1039      ER36527      1040 - 1043      ER36528      1044 - 1044 
      ER36529      1045 - 1045      ER36530      1046 - 1055      ER36531      1056 - 1056 
      ER36532      1057 - 1057      ER36533      1058 - 1058      ER36534      1059 - 1059 
      ER36535      1060 - 1062      ER36536      1063 - 1063      ER36537      1064 - 1065 
      ER36538      1066 - 1066      ER36539      1067 - 1068      ER36540      1069 - 1069 
      ER36541      1070 - 1070      ER36542      1071 - 1073      ER36543      1074 - 1074 
      ER36544      1075 - 1076      ER36545      1077 - 1077      ER36546      1078 - 1079 
      ER36547      1080 - 1080      ER36548      1081 - 1081      ER36549      1082 - 1084 
      ER36550      1085 - 1085      ER36551      1086 - 1087      ER36552      1088 - 1088 
      ER36553      1089 - 1090      ER36554      1091 - 1091      ER36555      1092 - 1092 
      ER36556      1093 - 1095      ER36557      1096 - 1096      ER36558      1097 - 1098 
      ER36559      1099 - 1099      ER36560      1100 - 1101      ER36561      1102 - 1102 
      ER36562      1103 - 1103      ER36563      1104 - 1106      ER36564      1107 - 1107 
      ER36565      1108 - 1109      ER36566      1110 - 1110      ER36567      1111 - 1112 
      ER36568      1113 - 1113      ER36569      1114 - 1114      ER36570      1115 - 1117 
      ER36571      1118 - 1118      ER36572      1119 - 1120      ER36573      1121 - 1121 
      ER36574      1122 - 1123      ER36575      1124 - 1124      ER36576      1125 - 1125 
      ER36577      1126 - 1126      ER36578      1127 - 1127      ER36579      1128 - 1128 
      ER36580      1129 - 1129      ER36581      1130 - 1130      ER36582      1131 - 1131 
      ER36583      1132 - 1132      ER36584      1133 - 1133      ER36585      1134 - 1134 
      ER36586      1135 - 1135      ER36587      1136 - 1136      ER36588      1137 - 1137 
      ER36589      1138 - 1140      ER36590      1141 - 1141      ER36591      1142 - 1143 
      ER36592      1144 - 1144      ER36593      1145 - 1146      ER36594      1147 - 1147 
      ER36595      1148 - 1148      ER36596      1149 - 1149      ER36597      1150 - 1150 
      ER36598      1151 - 1151      ER36599      1152 - 1152      ER36600      1153 - 1153 
      ER36601      1154 - 1154      ER36602      1155 - 1155      ER36603      1156 - 1156 
      ER36604      1157 - 1157      ER36605      1158 - 1158      ER36606      1159 - 1159 
      ER36607      1160 - 1161      ER36608      1162 - 1164      ER36609      1165 - 1165 
      ER36610      1166 - 1167      ER36611      1168 - 1171      ER36612      1172 - 1172 
      ER36613      1173 - 1173      ER36614      1174 - 1174      ER36615      1175 - 1175 
      ER36616      1176 - 1176      ER36617      1177 - 1177      ER36618      1178 - 1178 
      ER36619      1179 - 1179      ER36620      1180 - 1180      ER36621      1181 - 1182 
      ER36622      1183 - 1184      ER36623      1185 - 1186      ER36624      1187 - 1187 
      ER36625      1188 - 1190      ER36626      1191 - 1191      ER36627      1192 - 1194 
      ER36628      1195 - 1195      ER36629      1196 - 1196      ER36630      1197 - 1197 
      ER36631      1198 - 1198      ER36632      1199 - 1199      ER36633      1200 - 1205 
      ER36634      1206 - 1206      ER36635      1207 - 1207      ER36636      1208 - 1208 
      ER36637      1209 - 1209      ER36638      1210 - 1210      ER36639      1211 - 1211 
      ER36640      1212 - 1212      ER36641      1213 - 1213      ER36642      1214 - 1214 
      ER36643      1215 - 1215      ER36644      1216 - 1216      ER36645      1217 - 1217 
      ER36646      1218 - 1218      ER36647      1219 - 1219      ER36648      1220 - 1220 
      ER36649      1221 - 1221      ER36650      1222 - 1222      ER36651      1223 - 1223 
      ER36652      1224 - 1224      ER36653      1225 - 1230      ER36654      1231 - 1231 
      ER36655      1232 - 1232      ER36656      1233 - 1233      ER36657      1234 - 1239 
      ER36658      1240 - 1240      ER36659      1241 - 1241      ER36660      1242 - 1242 
      ER36661      1243 - 1243      ER36662      1244 - 1244      ER36663      1245 - 1245 
      ER36664      1246 - 1246      ER36665      1247 - 1247      ER36666      1248 - 1248 
      ER36667      1249 - 1249      ER36668      1250 - 1250      ER36669      1251 - 1251 
      ER36670      1252 - 1252      ER36671      1253 - 1253      ER36672      1254 - 1254 
      ER36673      1255 - 1260      ER36674      1261 - 1261      ER36675      1262 - 1262 
      ER36676      1263 - 1263      ER36677      1264 - 1264      ER36678      1265 - 1265 
      ER36679      1266 - 1266      ER36680      1267 - 1267      ER36681      1268 - 1268 
      ER36682      1269 - 1269      ER36683      1270 - 1270      ER36684      1271 - 1271 
      ER36685      1272 - 1272      ER36686      1273 - 1273      ER36687      1274 - 1274 
      ER36688      1275 - 1275      ER36689      1276 - 1276      ER36690      1277 - 1277 
      ER36691      1278 - 1278      ER36692      1279 - 1279      ER36693      1280 - 1280 
      ER36694      1281 - 1281      ER36695      1282 - 1282      ER36696      1283 - 1283 
      ER36697      1284 - 1284      ER36698      1285 - 1285      ER36699      1286 - 1286 
      ER36700      1287 - 1287      ER36701      1288 - 1288      ER36702      1289 - 1294 
      ER36703      1295 - 1295      ER36704      1296 - 1296      ER36705      1297 - 1297 
      ER36706      1298 - 1305      ER36707      1306 - 1306      ER36708      1307 - 1307 
      ER36709      1308 - 1308      ER36710      1309 - 1316      ER36711      1317 - 1317 
      ER36712      1318 - 1318      ER36713      1319 - 1326      ER36714      1327 - 1327 
      ER36715      1328 - 1328      ER36716      1329 - 1336      ER36717      1337 - 1337 
      ER36718      1338 - 1338      ER36719      1339 - 1339      ER36720      1340 - 1347 
      ER36721      1348 - 1348      ER36722      1349 - 1349      ER36723      1350 - 1357 
      ER36724      1358 - 1358      ER36725      1359 - 1359      ER36726      1360 - 1360 
      ER36727      1361 - 1362      ER36728      1363 - 1364      ER36729      1365 - 1366 
      ER36730      1367 - 1370      ER36731      1371 - 1371      ER36732      1372 - 1372 
      ER36733      1373 - 1374      ER36734      1375 - 1375      ER36735      1376 - 1376 
      ER36736      1377 - 1380      ER36737      1381 - 1382      ER36738      1383 - 1383 
      ER36739      1384 - 1384      ER36740      1385 - 1385      ER36741      1386 - 1391 
      ER36742      1392 - 1392      ER36743      1393 - 1398      ER36744      1399 - 1404 
      ER36745      1405 - 1405      ER36746      1406 - 1411      ER36747      1412 - 1417 
      ER36748      1418 - 1418      ER36749      1419 - 1421      ER36750      1422 - 1424 
      ER36751      1425 - 1430      ER36752      1431 - 1436      ER36753      1437 - 1437 
      ER36754      1438 - 1440      ER36755      1441 - 1443      ER36756      1444 - 1445 
      ER36757      1446 - 1447      ER36758      1448 - 1451      ER36759      1452 - 1452 
      ER36760      1453 - 1453      ER36761      1454 - 1455      ER36762      1456 - 1456 
      ER36763      1457 - 1457      ER36764      1458 - 1461      ER36765      1462 - 1463 
      ER36766      1464 - 1464      ER36767      1465 - 1465      ER36768      1466 - 1466 
      ER36769      1467 - 1472      ER36770      1473 - 1473      ER36771      1474 - 1479 
      ER36772      1480 - 1485      ER36773      1486 - 1486      ER36774      1487 - 1492 
      ER36775      1493 - 1498      ER36776      1499 - 1499      ER36777      1500 - 1502 
      ER36778      1503 - 1505      ER36779      1506 - 1511      ER36780      1512 - 1517 
      ER36781      1518 - 1518      ER36782      1519 - 1521      ER36783      1522 - 1524 
      ER36784      1525 - 1526      ER36785      1527 - 1528      ER36786      1529 - 1532 
      ER36787      1533 - 1533      ER36788      1534 - 1534      ER36789      1535 - 1536 
      ER36790      1537 - 1537      ER36791      1538 - 1538      ER36792      1539 - 1542 
      ER36793      1543 - 1544      ER36794      1545 - 1545      ER36795      1546 - 1546 
      ER36796      1547 - 1547      ER36797      1548 - 1553      ER36798      1554 - 1554 
      ER36799      1555 - 1560      ER36800      1561 - 1566      ER36801      1567 - 1567 
      ER36802      1568 - 1573      ER36803      1574 - 1579      ER36804      1580 - 1580 
      ER36805      1581 - 1583      ER36806      1584 - 1586      ER36807      1587 - 1592 
      ER36808      1593 - 1598      ER36809      1599 - 1599      ER36810      1600 - 1602 
      ER36811      1603 - 1605      ER36812      1606 - 1611      ER36813      1612 - 1612 
      ER36814      1613 - 1613      ER36815      1614 - 1619      ER36816      1620 - 1624 
      ER36817      1625 - 1629      ER36818      1630 - 1634      ER36819      1635 - 1639 
      ER36820      1640 - 1644      ER36821      1645 - 1649      ER36822      1650 - 1650 
      ER36823      1651 - 1656      ER36824      1657 - 1657      ER36825      1658 - 1663 
      ER36826      1664 - 1669      ER36827      1670 - 1670      ER36828      1671 - 1671 
      ER36829      1672 - 1672      ER36830      1673 - 1673      ER36831      1674 - 1679 
      ER36832      1680 - 1680      ER36833      1681 - 1681      ER36834      1682 - 1682 
      ER36835      1683 - 1683      ER36836      1684 - 1689      ER36837      1690 - 1690 
      ER36838      1691 - 1691      ER36839      1692 - 1692      ER36840      1693 - 1693 
      ER36841      1694 - 1699      ER36842      1700 - 1700      ER36843      1701 - 1701 
      ER36844      1702 - 1702      ER36845      1703 - 1703      ER36846      1704 - 1709 
      ER36847      1710 - 1710      ER36848      1711 - 1711      ER36849      1712 - 1712 
      ER36850      1713 - 1713      ER36851      1714 - 1714      ER36852      1715 - 1721 
      ER36853      1722 - 1728      ER36854      1729 - 1735      ER36855      1736 - 1736 
      ER36856      1737 - 1737      ER36857      1738 - 1739      ER36858      1740 - 1740 
      ER36859      1741 - 1741      ER36860      1742 - 1742      ER36861      1743 - 1743 
      ER36862      1744 - 1745      ER36863      1746 - 1747      ER36864      1748 - 1749 
      ER36865      1750 - 1751      ER36866      1752 - 1752      ER36867      1753 - 1759 
      ER36868      1760 - 1766      ER36869      1767 - 1773      ER36870      1774 - 1774 
      ER36871      1775 - 1776      ER36872      1777 - 1777      ER36873      1778 - 1778 
      ER36874      1779 - 1779      ER36875      1780 - 1780      ER36876      1781 - 1782 
      ER36877      1783 - 1784      ER36878      1785 - 1786      ER36879      1787 - 1788 
      ER36880      1789 - 1789      ER36881      1790 - 1796      ER36882      1797 - 1803 
      ER36883      1804 - 1810      ER36884      1811 - 1811      ER36885      1812 - 1813 
      ER36886      1814 - 1814      ER36887      1815 - 1815      ER36888      1816 - 1816 
      ER36889      1817 - 1817      ER36890      1818 - 1819      ER36891      1820 - 1821 
      ER36892      1822 - 1823      ER36893      1824 - 1825      ER36894      1826 - 1826 
      ER36895      1827 - 1833      ER36896      1834 - 1840      ER36897      1841 - 1847 
      ER36898      1848 - 1848      ER36899      1849 - 1850      ER36900      1851 - 1851 
      ER36901      1852 - 1852      ER36902      1853 - 1853      ER36903      1854 - 1854 
      ER36904      1855 - 1856      ER36905      1857 - 1858      ER36906      1859 - 1860 
      ER36907      1861 - 1862      ER36908      1863 - 1863      ER36909      1864 - 1870 
      ER36910      1871 - 1877      ER36911      1878 - 1884      ER36912      1885 - 1885 
      ER36913      1886 - 1887      ER36914      1888 - 1888      ER36915      1889 - 1889 
      ER36916      1890 - 1890      ER36917      1891 - 1891      ER36918      1892 - 1893 
      ER36919      1894 - 1895      ER36920      1896 - 1897      ER36921      1898 - 1899 
      ER36922      1900 - 1900      ER36923      1901 - 1907      ER36924      1908 - 1914 
      ER36925      1915 - 1921      ER36926      1922 - 1922      ER36927      1923 - 1923 
      ER36928      1924 - 1930      ER36929      1931 - 1931      ER36930      1932 - 1932 
      ER36931      1933 - 1933      ER36932      1934 - 1939      ER36933      1940 - 1940 
      ER36934      1941 - 1941      ER36935      1942 - 1947      ER36936      1948 - 1948 
      ER36937      1949 - 1949      ER36938      1950 - 1955      ER36939      1956 - 1956 
      ER36940      1957 - 1957      ER36941      1958 - 1963      ER36942      1964 - 1964 
      ER36943      1965 - 1965      ER36944      1966 - 1971      ER36945      1972 - 1972 
      ER36946      1973 - 1973      ER36947      1974 - 1974      ER36948      1975 - 1981 
      ER36949      1982 - 1982      ER36950      1983 - 1983      ER36951      1984 - 1984 
      ER36952      1985 - 1985      ER36953      1986 - 1986      ER36954      1987 - 1987 
      ER36955      1988 - 1988      ER36956      1989 - 1989      ER36957      1990 - 1990 
      ER36958      1991 - 1991      ER36959      1992 - 1992      ER36960      1993 - 1993 
      ER36961      1994 - 1994      ER36962      1995 - 1995      ER36963      1996 - 1996 
      ER36964      1997 - 1997      ER36965      1998 - 2004      ER36966      2005 - 2005 
      ER36967      2006 - 2006      ER36968      2007 - 2007      ER36969      2008 - 2008 
      ER36970      2009 - 2009      ER36971      2010 - 2010      ER36972      2011 - 2011 
      ER36973      2012 - 2012      ER36974      2013 - 2013      ER36975      2014 - 2014 
      ER36976      2015 - 2015      ER36977      2016 - 2016      ER36978      2017 - 2017 
      ER36979      2018 - 2018      ER36980      2019 - 2019      ER36981      2020 - 2020 
      ER36982      2021 - 2027      ER36983      2028 - 2028      ER36984      2029 - 2029 
      ER36985      2030 - 2030      ER36986      2031 - 2031      ER36987      2032 - 2032 
      ER36988      2033 - 2033      ER36989      2034 - 2034      ER36990      2035 - 2035 
      ER36991      2036 - 2036      ER36992      2037 - 2037      ER36993      2038 - 2038 
      ER36994      2039 - 2039      ER36995      2040 - 2040      ER36996      2041 - 2041 
      ER36997      2042 - 2042      ER36998      2043 - 2043      ER36999      2044 - 2050 
      ER37000      2051 - 2051      ER37001      2052 - 2052      ER37002      2053 - 2058 
      ER37003      2059 - 2059      ER37004      2060 - 2060      ER37005      2061 - 2061 
      ER37006      2062 - 2062      ER37007      2063 - 2063      ER37008      2064 - 2064 
      ER37009      2065 - 2065      ER37010      2066 - 2066      ER37011      2067 - 2067 
      ER37012      2068 - 2068      ER37013      2069 - 2069      ER37014      2070 - 2070 
      ER37015      2071 - 2071      ER37016      2072 - 2072      ER37017      2073 - 2073 
      ER37018      2074 - 2074      ER37019      2075 - 2080      ER37020      2081 - 2081 
      ER37021      2082 - 2082      ER37022      2083 - 2083      ER37023      2084 - 2084 
      ER37024      2085 - 2085      ER37025      2086 - 2086      ER37026      2087 - 2087 
      ER37027      2088 - 2088      ER37028      2089 - 2089      ER37029      2090 - 2090 
      ER37030      2091 - 2091      ER37031      2092 - 2092      ER37032      2093 - 2093 
      ER37033      2094 - 2094      ER37034      2095 - 2095      ER37035      2096 - 2096 
      ER37036      2097 - 2102      ER37037      2103 - 2103      ER37038      2104 - 2104 
      ER37039      2105 - 2105      ER37040      2106 - 2106      ER37041      2107 - 2107 
      ER37042      2108 - 2108      ER37043      2109 - 2109      ER37044      2110 - 2110 
      ER37045      2111 - 2111      ER37046      2112 - 2112      ER37047      2113 - 2113 
      ER37048      2114 - 2114      ER37049      2115 - 2115      ER37050      2116 - 2116 
      ER37051      2117 - 2117      ER37052      2118 - 2118      ER37053      2119 - 2124 
      ER37054      2125 - 2125      ER37055      2126 - 2126      ER37056      2127 - 2127 
      ER37057      2128 - 2128      ER37058      2129 - 2129      ER37059      2130 - 2130 
      ER37060      2131 - 2131      ER37061      2132 - 2132      ER37062      2133 - 2133 
      ER37063      2134 - 2134      ER37064      2135 - 2135      ER37065      2136 - 2136 
      ER37066      2137 - 2137      ER37067      2138 - 2138      ER37068      2139 - 2139 
      ER37069      2140 - 2145      ER37070      2146 - 2146      ER37071      2147 - 2147 
      ER37072      2148 - 2148      ER37073      2149 - 2149      ER37074      2150 - 2150 
      ER37075      2151 - 2151      ER37076      2152 - 2152      ER37077      2153 - 2153 
      ER37078      2154 - 2154      ER37079      2155 - 2155      ER37080      2156 - 2156 
      ER37081      2157 - 2157      ER37082      2158 - 2158      ER37083      2159 - 2159 
      ER37084      2160 - 2160      ER37085      2161 - 2161      ER37086      2162 - 2167 
      ER37087      2168 - 2168      ER37088      2169 - 2169      ER37089      2170 - 2170 
      ER37090      2171 - 2171      ER37091      2172 - 2172      ER37092      2173 - 2173 
      ER37093      2174 - 2174      ER37094      2175 - 2175      ER37095      2176 - 2176 
      ER37096      2177 - 2177      ER37097      2178 - 2178      ER37098      2179 - 2179 
      ER37099      2180 - 2180      ER37100      2181 - 2181      ER37101      2182 - 2182 
      ER37102      2183 - 2188      ER37103      2189 - 2189      ER37104      2190 - 2190 
      ER37105      2191 - 2191      ER37106      2192 - 2192      ER37107      2193 - 2193 
      ER37108      2194 - 2194      ER37109      2195 - 2195      ER37110      2196 - 2196 
      ER37111      2197 - 2197      ER37112      2198 - 2198      ER37113      2199 - 2199 
      ER37114      2200 - 2200      ER37115      2201 - 2201      ER37116      2202 - 2202 
      ER37117      2203 - 2203      ER37118      2204 - 2204      ER37119      2205 - 2210 
      ER37120      2211 - 2211      ER37121      2212 - 2212      ER37122      2213 - 2213 
      ER37123      2214 - 2214      ER37124      2215 - 2215      ER37125      2216 - 2216 
      ER37126      2217 - 2217      ER37127      2218 - 2218      ER37128      2219 - 2219 
      ER37129      2220 - 2220      ER37130      2221 - 2221      ER37131      2222 - 2222 
      ER37132      2223 - 2223      ER37133      2224 - 2224      ER37134      2225 - 2225 
      ER37135      2226 - 2231      ER37136      2232 - 2232      ER37137      2233 - 2233 
      ER37138      2234 - 2234      ER37139      2235 - 2235      ER37140      2236 - 2236 
      ER37141      2237 - 2237      ER37142      2238 - 2238      ER37143      2239 - 2239 
      ER37144      2240 - 2240      ER37145      2241 - 2241      ER37146      2242 - 2242 
      ER37147      2243 - 2243      ER37148      2244 - 2244      ER37149      2245 - 2245 
      ER37150      2246 - 2246      ER37151      2247 - 2252      ER37152      2253 - 2253 
      ER37153      2254 - 2254      ER37154      2255 - 2255      ER37155      2256 - 2256 
      ER37156      2257 - 2257      ER37157      2258 - 2258      ER37158      2259 - 2259 
      ER37159      2260 - 2260      ER37160      2261 - 2261      ER37161      2262 - 2262 
      ER37162      2263 - 2263      ER37163      2264 - 2264      ER37164      2265 - 2265 
      ER37165      2266 - 2266      ER37166      2267 - 2267      ER37167      2268 - 2273 
      ER37168      2274 - 2274      ER37169      2275 - 2275      ER37170      2276 - 2276 
      ER37171      2277 - 2277      ER37172      2278 - 2278      ER37173      2279 - 2279 
      ER37174      2280 - 2280      ER37175      2281 - 2281      ER37176      2282 - 2282 
      ER37177      2283 - 2283      ER37178      2284 - 2284      ER37179      2285 - 2285 
      ER37180      2286 - 2286      ER37181      2287 - 2287      ER37182      2288 - 2288 
      ER37183      2289 - 2289      ER37184      2290 - 2295      ER37185      2296 - 2296 
      ER37186      2297 - 2297      ER37187      2298 - 2298      ER37188      2299 - 2299 
      ER37189      2300 - 2300      ER37190      2301 - 2301      ER37191      2302 - 2302 
      ER37192      2303 - 2303      ER37193      2304 - 2304      ER37194      2305 - 2305 
      ER37195      2306 - 2306      ER37196      2307 - 2307      ER37197      2308 - 2308 
      ER37198      2309 - 2309      ER37199      2310 - 2310      ER37200      2311 - 2316 
      ER37201      2317 - 2317      ER37202      2318 - 2318      ER37203      2319 - 2319 
      ER37204      2320 - 2320      ER37205      2321 - 2321      ER37206      2322 - 2322 
      ER37207      2323 - 2323      ER37208      2324 - 2324      ER37209      2325 - 2325 
      ER37210      2326 - 2326      ER37211      2327 - 2327      ER37212      2328 - 2328 
      ER37213      2329 - 2329      ER37214      2330 - 2330      ER37215      2331 - 2331 
      ER37216      2332 - 2337      ER37217      2338 - 2338      ER37218      2339 - 2339 
      ER37219      2340 - 2340      ER37220      2341 - 2341      ER37221      2342 - 2342 
      ER37222      2343 - 2343      ER37223      2344 - 2344      ER37224      2345 - 2345 
      ER37225      2346 - 2346      ER37226      2347 - 2347      ER37227      2348 - 2348 
      ER37228      2349 - 2349      ER37229      2350 - 2350      ER37230      2351 - 2351 
      ER37231      2352 - 2352      ER37232      2353 - 2358      ER37233      2359 - 2359 
      ER37234      2360 - 2360      ER37235      2361 - 2361      ER37236      2362 - 2362 
      ER37237      2363 - 2363      ER37238      2364 - 2364      ER37239      2365 - 2365 
      ER37240      2366 - 2366      ER37241      2367 - 2367      ER37242      2368 - 2368 
      ER37243      2369 - 2369      ER37244      2370 - 2370      ER37245      2371 - 2371 
      ER37246      2372 - 2372      ER37247      2373 - 2373      ER37248      2374 - 2379 
      ER37249      2380 - 2380      ER37250      2381 - 2381      ER37251      2382 - 2382 
      ER37252      2383 - 2383      ER37253      2384 - 2384      ER37254      2385 - 2385 
      ER37255      2386 - 2386      ER37256      2387 - 2387      ER37257      2388 - 2388 
      ER37258      2389 - 2389      ER37259      2390 - 2390      ER37260      2391 - 2391 
      ER37261      2392 - 2392      ER37262      2393 - 2393      ER37263      2394 - 2394 
      ER37264      2395 - 2400      ER37265      2401 - 2401      ER37266      2402 - 2402 
      ER37267      2403 - 2403      ER37268      2404 - 2404      ER37269      2405 - 2405 
      ER37270      2406 - 2406      ER37271      2407 - 2407      ER37272      2408 - 2408 
      ER37273      2409 - 2409      ER37274      2410 - 2410      ER37275      2411 - 2411 
      ER37276      2412 - 2412      ER37277      2413 - 2413      ER37278      2414 - 2414 
      ER37279      2415 - 2415      ER37280      2416 - 2421      ER37281      2422 - 2422 
      ER37282      2423 - 2423      ER37283      2424 - 2424      ER37284      2425 - 2425 
      ER37285      2426 - 2426      ER37286      2427 - 2427      ER37287      2428 - 2428 
      ER37288      2429 - 2429      ER37289      2430 - 2430      ER37290      2431 - 2431 
      ER37291      2432 - 2432      ER37292      2433 - 2433      ER37293      2434 - 2434 
      ER37294      2435 - 2435      ER37295      2436 - 2436      ER37296      2437 - 2437 
      ER37297      2438 - 2438      ER37298      2439 - 2439      ER37299      2440 - 2446 
      ER37300      2447 - 2447      ER37301      2448 - 2448      ER37302      2449 - 2449 
      ER37303      2450 - 2455      ER37304      2456 - 2456      ER37305      2457 - 2457 
      ER37306      2458 - 2458      ER37307      2459 - 2459      ER37308      2460 - 2460 
      ER37309      2461 - 2461      ER37310      2462 - 2462      ER37311      2463 - 2463 
      ER37312      2464 - 2464      ER37313      2465 - 2465      ER37314      2466 - 2466 
      ER37315      2467 - 2467      ER37316      2468 - 2468      ER37317      2469 - 2469 
      ER37318      2470 - 2470      ER37319      2471 - 2476      ER37320      2477 - 2477 
      ER37321      2478 - 2478      ER37322      2479 - 2479      ER37323      2480 - 2480 
      ER37324      2481 - 2481      ER37325      2482 - 2482      ER37326      2483 - 2483 
      ER37327      2484 - 2484      ER37328      2485 - 2485      ER37329      2486 - 2486 
      ER37330      2487 - 2487      ER37331      2488 - 2488      ER37332      2489 - 2489 
      ER37333      2490 - 2490      ER37334      2491 - 2491      ER37335      2492 - 2497 
      ER37336      2498 - 2498      ER37337      2499 - 2499      ER37338      2500 - 2500 
      ER37339      2501 - 2501      ER37340      2502 - 2502      ER37341      2503 - 2503 
      ER37342      2504 - 2504      ER37343      2505 - 2505      ER37344      2506 - 2506 
      ER37345      2507 - 2507      ER37346      2508 - 2508      ER37347      2509 - 2509 
      ER37348      2510 - 2510      ER37349      2511 - 2511      ER37350      2512 - 2512 
      ER37351      2513 - 2513      ER37352      2514 - 2519      ER37353      2520 - 2520 
      ER37354      2521 - 2521      ER37355      2522 - 2522      ER37356      2523 - 2523 
      ER37357      2524 - 2524      ER37358      2525 - 2525      ER37359      2526 - 2526 
      ER37360      2527 - 2527      ER37361      2528 - 2528      ER37362      2529 - 2529 
      ER37363      2530 - 2530      ER37364      2531 - 2531      ER37365      2532 - 2532 
      ER37366      2533 - 2533      ER37367      2534 - 2534      ER37368      2535 - 2535 
      ER37369      2536 - 2541      ER37370      2542 - 2542      ER37371      2543 - 2543 
      ER37372      2544 - 2544      ER37373      2545 - 2545      ER37374      2546 - 2546 
      ER37375      2547 - 2547      ER37376      2548 - 2548      ER37377      2549 - 2549 
      ER37378      2550 - 2550      ER37379      2551 - 2551      ER37380      2552 - 2552 
      ER37381      2553 - 2553      ER37382      2554 - 2554      ER37383      2555 - 2555 
      ER37384      2556 - 2556      ER37385      2557 - 2557      ER37386      2558 - 2563 
      ER37387      2564 - 2564      ER37388      2565 - 2565      ER37389      2566 - 2566 
      ER37390      2567 - 2567      ER37391      2568 - 2568      ER37392      2569 - 2569 
      ER37393      2570 - 2570      ER37394      2571 - 2571      ER37395      2572 - 2572 
      ER37396      2573 - 2573      ER37397      2574 - 2574      ER37398      2575 - 2575 
      ER37399      2576 - 2576      ER37400      2577 - 2577      ER37401      2578 - 2578 
      ER37402      2579 - 2579      ER37403      2580 - 2585      ER37404      2586 - 2586 
      ER37405      2587 - 2587      ER37406      2588 - 2588      ER37407      2589 - 2589 
      ER37408      2590 - 2590      ER37409      2591 - 2591      ER37410      2592 - 2592 
      ER37411      2593 - 2593      ER37412      2594 - 2594      ER37413      2595 - 2595 
      ER37414      2596 - 2596      ER37415      2597 - 2597      ER37416      2598 - 2598 
      ER37417      2599 - 2599      ER37418      2600 - 2600      ER37419      2601 - 2606 
      ER37420      2607 - 2607      ER37421      2608 - 2608      ER37422      2609 - 2609 
      ER37423      2610 - 2610      ER37424      2611 - 2611      ER37425      2612 - 2612 
      ER37426      2613 - 2613      ER37427      2614 - 2614      ER37428      2615 - 2615 
      ER37429      2616 - 2616      ER37430      2617 - 2617      ER37431      2618 - 2618 
      ER37432      2619 - 2619      ER37433      2620 - 2620      ER37434      2621 - 2621 
      ER37435      2622 - 2627      ER37436      2628 - 2628      ER37437      2629 - 2629 
      ER37438      2630 - 2630      ER37439      2631 - 2631      ER37440      2632 - 2632 
      ER37441      2633 - 2633      ER37442      2634 - 2634      ER37443      2635 - 2635 
      ER37444      2636 - 2636      ER37445      2637 - 2637      ER37446      2638 - 2638 
      ER37447      2639 - 2639      ER37448      2640 - 2640      ER37449      2641 - 2641 
      ER37450      2642 - 2642      ER37451      2643 - 2648      ER37452      2649 - 2649 
      ER37453      2650 - 2650      ER37454      2651 - 2651      ER37455      2652 - 2652 
      ER37456      2653 - 2653      ER37457      2654 - 2654      ER37458      2655 - 2655 
      ER37459      2656 - 2656      ER37460      2657 - 2657      ER37461      2658 - 2658 
      ER37462      2659 - 2659      ER37463      2660 - 2660      ER37464      2661 - 2661 
      ER37465      2662 - 2662      ER37466      2663 - 2663      ER37467      2664 - 2669 
      ER37468      2670 - 2670      ER37469      2671 - 2671      ER37470      2672 - 2672 
      ER37471      2673 - 2673      ER37472      2674 - 2674      ER37473      2675 - 2675 
      ER37474      2676 - 2676      ER37475      2677 - 2677      ER37476      2678 - 2678 
      ER37477      2679 - 2679      ER37478      2680 - 2680      ER37479      2681 - 2681 
      ER37480      2682 - 2682      ER37481      2683 - 2683      ER37482      2684 - 2684 
      ER37483      2685 - 2690      ER37484      2691 - 2691      ER37485      2692 - 2692 
      ER37486      2693 - 2693      ER37487      2694 - 2694      ER37488      2695 - 2695 
      ER37489      2696 - 2696      ER37490      2697 - 2697      ER37491      2698 - 2698 
      ER37492      2699 - 2699      ER37493      2700 - 2700      ER37494      2701 - 2701 
      ER37495      2702 - 2702      ER37496      2703 - 2703      ER37497      2704 - 2704 
      ER37498      2705 - 2705      ER37499      2706 - 2711      ER37500      2712 - 2712 
      ER37501      2713 - 2713      ER37502      2714 - 2714      ER37503      2715 - 2715 
      ER37504      2716 - 2716      ER37505      2717 - 2717      ER37506      2718 - 2718 
      ER37507      2719 - 2719      ER37508      2720 - 2720      ER37509      2721 - 2721 
      ER37510      2722 - 2722      ER37511      2723 - 2723      ER37512      2724 - 2724 
      ER37513      2725 - 2725      ER37514      2726 - 2726      ER37515      2727 - 2732 
      ER37516      2733 - 2733      ER37517      2734 - 2734      ER37518      2735 - 2735 
      ER37519      2736 - 2736      ER37520      2737 - 2737      ER37521      2738 - 2738 
      ER37522      2739 - 2739      ER37523      2740 - 2740      ER37524      2741 - 2741 
      ER37525      2742 - 2742      ER37526      2743 - 2743      ER37527      2744 - 2744 
      ER37528      2745 - 2745      ER37529      2746 - 2746      ER37530      2747 - 2747 
      ER37531      2748 - 2754      ER37532      2755 - 2761      ER37533      2762 - 2762 
      ER37534      2763 - 2768      ER37535      2769 - 2774      ER37536      2775 - 2775 
      ER37537      2776 - 2777      ER37538      2778 - 2779      ER37539      2780 - 2781 
      ER37540      2782 - 2783      ER37541      2784 - 2785      ER37542      2786 - 2787 
      ER37543      2788 - 2794      ER37544      2795 - 2795      ER37545      2796 - 2802 
      ER37546      2803 - 2803      ER37547      2804 - 2810      ER37548      2811 - 2811 
      ER37549      2812 - 2813      ER37550      2814 - 2814      ER37551      2815 - 2815 
      ER37552      2816 - 2816      ER37553      2817 - 2825      ER37554      2826 - 2826 
      ER37555      2827 - 2827      ER37556      2828 - 2828      ER37557      2829 - 2837 
      ER37558      2838 - 2838      ER37559      2839 - 2839      ER37560      2840 - 2840 
      ER37561      2841 - 2841      ER37562      2842 - 2850      ER37563      2851 - 2851 
      ER37564      2852 - 2852      ER37565      2853 - 2853      ER37566      2854 - 2854 
      ER37567      2855 - 2863      ER37568      2864 - 2864      ER37569      2865 - 2865 
      ER37570      2866 - 2866      ER37571      2867 - 2867      ER37572      2868 - 2868 
      ER37573      2869 - 2874      ER37574      2875 - 2875      ER37575      2876 - 2876 
      ER37576      2877 - 2877      ER37577      2878 - 2878      ER37578      2879 - 2879 
      ER37579      2880 - 2880      ER37580      2881 - 2881      ER37581      2882 - 2882 
      ER37582      2883 - 2883      ER37583      2884 - 2884      ER37584      2885 - 2885 
      ER37585      2886 - 2886      ER37586      2887 - 2887      ER37587      2888 - 2888 
      ER37588      2889 - 2889      ER37589      2890 - 2898      ER37590      2899 - 2899 
      ER37591      2900 - 2900      ER37592      2901 - 2901      ER37593      2902 - 2902 
      ER37594      2903 - 2903      ER37595      2904 - 2912      ER37596      2913 - 2913 
      ER37597      2914 - 2914      ER37598      2915 - 2915      ER37599      2916 - 2916 
      ER37600      2917 - 2922      ER37601      2923 - 2923      ER37602      2924 - 2924 
      ER37603      2925 - 2925      ER37604      2926 - 2926      ER37605      2927 - 2927 
      ER37606      2928 - 2928      ER37607      2929 - 2929      ER37608      2930 - 2930 
      ER37609      2931 - 2931      ER37610      2932 - 2932      ER37611      2933 - 2933 
      ER37612      2934 - 2934      ER37613      2935 - 2935      ER37614      2936 - 2936 
      ER37615      2937 - 2937      ER37616      2938 - 2946      ER37617      2947 - 2947 
      ER37618      2948 - 2948      ER37619      2949 - 2949      ER37620      2950 - 2950 
      ER37621      2951 - 2959      ER37622      2960 - 2960      ER37623      2961 - 2961 
      ER37624      2962 - 2962      ER37625      2963 - 2963      ER37626      2964 - 2972 
      ER37627      2973 - 2973      ER37628      2974 - 2974      ER37629      2975 - 2975 
      ER37630      2976 - 2976      ER37631      2977 - 2985      ER37632      2986 - 2986 
      ER37633      2987 - 2987      ER37634      2988 - 2988      ER37635      2989 - 2989 
      ER37636      2990 - 2990      ER37637      2991 - 2999      ER37638      3000 - 3000 
      ER37639      3001 - 3001      ER37640      3002 - 3002      ER37641      3003 - 3003 
      ER37642      3004 - 3012      ER37643      3013 - 3013      ER37644      3014 - 3014 
      ER37645      3015 - 3015      ER37646      3016 - 3016      ER37647      3017 - 3025 
      ER37648      3026 - 3026      ER37649      3027 - 3027      ER37650      3028 - 3028 
      ER37651      3029 - 3029      ER37652      3030 - 3038      ER37653      3039 - 3039 
      ER37654      3040 - 3040      ER37655      3041 - 3041      ER37656      3042 - 3050 
      ER37657      3051 - 3051      ER37658      3052 - 3052      ER37659      3053 - 3053 
      ER37660      3054 - 3054      ER37661      3055 - 3063      ER37662      3064 - 3064 
      ER37663      3065 - 3065      ER37664      3066 - 3066      ER37665      3067 - 3067 
      ER37666      3068 - 3068      ER37667      3069 - 3069      ER37668      3070 - 3078 
      ER37669      3079 - 3079      ER37670      3080 - 3080      ER37671      3081 - 3081 
      ER37672      3082 - 3082      ER37673      3083 - 3091      ER37674      3092 - 3092 
      ER37675      3093 - 3093      ER37676      3094 - 3094      ER37677      3095 - 3095 
      ER37678      3096 - 3096      ER37679      3097 - 3105      ER37680      3106 - 3106 
      ER37681      3107 - 3107      ER37682      3108 - 3108      ER37683      3109 - 3109 
      ER37684      3110 - 3110      ER37685      3111 - 3119      ER37686      3120 - 3120 
      ER37687      3121 - 3121      ER37688      3122 - 3122      ER37689      3123 - 3123 
      ER37690      3124 - 3132      ER37691      3133 - 3133      ER37692      3134 - 3134 
      ER37693      3135 - 3135      ER37694      3136 - 3136      ER37695      3137 - 3137 
      ER37696      3138 - 3146      ER37697      3147 - 3147      ER37698      3148 - 3148 
      ER37699      3149 - 3149      ER37700      3150 - 3150      ER37701      3151 - 3159 
      ER37702      3160 - 3160      ER37703      3161 - 3161      ER37704      3162 - 3162 
      ER37705      3163 - 3163      ER37706      3164 - 3167      ER37707      3168 - 3176 
      ER37708      3177 - 3177      ER37709      3178 - 3178      ER37710      3179 - 3179 
      ER37711      3180 - 3183      ER37712      3184 - 3192      ER37713      3193 - 3193 
      ER37714      3194 - 3194      ER37715      3195 - 3195      ER37716      3196 - 3199 
      ER37717      3200 - 3208      ER37718      3209 - 3209      ER37719      3210 - 3210 
      ER37720      3211 - 3211      ER37721      3212 - 3212      ER37722      3213 - 3213 
      ER37723      3214 - 3214      ER37724      3215 - 3216      ER37725      3217 - 3217 
      ER37726      3218 - 3218      ER37727      3219 - 3219      ER37728      3220 - 3220 
      ER37729      3221 - 3221      ER37730      3222 - 3222      ER37731      3223 - 3223 
      ER37732      3224 - 3224      ER37733      3225 - 3225      ER37734      3226 - 3226 
      ER37735      3227 - 3227      ER37736      3228 - 3228      ER37737      3229 - 3229 
      ER37738      3230 - 3230      ER37739      3231 - 3231      ER37740      3232 - 3233 
      ER37741      3234 - 3237      ER37742      3238 - 3238      ER37743      3239 - 3241 
      ER37744      3242 - 3242      ER37745      3243 - 3245      ER37746      3246 - 3246 
      ER37747      3247 - 3247      ER37748      3248 - 3254      ER37749      3255 - 3255 
      ER37750      3256 - 3258      ER37751      3259 - 3259      ER37752      3260 - 3266 
      ER37753      3267 - 3267      ER37754      3268 - 3270      ER37755      3271 - 3271 
      ER37756      3272 - 3272      ER37757      3273 - 3279      ER37758      3280 - 3280 
      ER37759      3281 - 3283      ER37760      3284 - 3286      ER37761      3287 - 3295 
      ER37762      3296 - 3296      ER37763      3297 - 3297      ER37764      3298 - 3298 
      ER37765      3299 - 3299      ER37766      3300 - 3300      ER37767      3301 - 3309 
      ER37768      3310 - 3310      ER37769      3311 - 3313      ER37770      3314 - 3314 
      ER37771      3315 - 3315      ER37772      3316 - 3318      ER37773      3319 - 3321 
      ER37774      3322 - 3324      ER37775      3325 - 3327      ER37776      3328 - 3328 
      ER37777      3329 - 3329      ER37778      3330 - 3332      ER37779      3333 - 3335 
      ER37780      3336 - 3338      ER37781      3339 - 3341      ER37782      3342 - 3344 
      ER37783      3345 - 3345      ER37784      3346 - 3352      ER37785      3353 - 3353 
      ER37786      3354 - 3356      ER37787      3357 - 3365      ER37788      3366 - 3366 
      ER37789      3367 - 3367      ER37790      3368 - 3368      ER37791      3369 - 3369 
      ER37792      3370 - 3370      ER37793      3371 - 3371      ER37794      3372 - 3372 
      ER37795      3373 - 3373      ER37796      3374 - 3375      ER37797      3376 - 3377 
      ER37798      3378 - 3380      ER37799      3381 - 3384      ER37800      3385 - 3387 
      ER37801      3388 - 3391      ER37802      3392 - 3392      ER37803      3393 - 3393 
      ER37804      3394 - 3400      ER37805      3401 - 3401      ER37806      3402 - 3404 
      ER37807      3405 - 3405      ER37808      3406 - 3406      ER37809      3407 - 3414 
      ER37810      3415 - 3415      ER37811      3416 - 3416      ER37812      3417 - 3417 
      ER37813      3418 - 3418      ER37814      3419 - 3419      ER37815      3420 - 3427 
      ER37816      3428 - 3428      ER37817      3429 - 3429      ER37818      3430 - 3430 
      ER37819      3431 - 3431      ER37820      3432 - 3433      ER37821      3434 - 3440 
      ER37822      3441 - 3441      ER37823      3442 - 3442      ER37824      3443 - 3443 
      ER37825      3444 - 3444      ER37826      3445 - 3445      ER37827      3446 - 3446 
      ER37828      3447 - 3447      ER37829      3448 - 3448      ER37830      3449 - 3449 
      ER37831      3450 - 3450      ER37832      3451 - 3451      ER37833      3452 - 3453 
      ER37834      3454 - 3457      ER37835      3458 - 3464      ER37836      3465 - 3465 
      ER37837      3466 - 3466      ER37838      3467 - 3467      ER37839      3468 - 3468 
      ER37840      3469 - 3469      ER37841      3470 - 3470      ER37842      3471 - 3471 
      ER37843      3472 - 3478      ER37844      3479 - 3479      ER37845      3480 - 3480 
      ER37846      3481 - 3481      ER37847      3482 - 3482      ER37848      3483 - 3483 
      ER37849      3484 - 3484      ER37850      3485 - 3485      ER37851      3486 - 3486 
      ER37852      3487 - 3487      ER37853      3488 - 3488      ER37854      3489 - 3495 
      ER37855      3496 - 3496      ER37856      3497 - 3497      ER37857      3498 - 3498 
      ER37858      3499 - 3499      ER37859      3500 - 3501      ER37860      3502 - 3503 
      ER37861      3504 - 3509      ER37862      3510 - 3510      ER37863      3511 - 3513 
      ER37864      3514 - 3521      ER37865      3522 - 3522      ER37866      3523 - 3523 
      ER37867      3524 - 3524      ER37868      3525 - 3525      ER37869      3526 - 3532 
      ER37870      3533 - 3533      ER37871      3534 - 3534      ER37872      3535 - 3535 
      ER37873      3536 - 3536      ER37874      3537 - 3537      ER37875      3538 - 3545 
      ER37876      3546 - 3546      ER37877      3547 - 3547      ER37878      3548 - 3548 
      ER37879      3549 - 3549      ER37880      3550 - 3551      ER37881      3552 - 3558 
      ER37882      3559 - 3559      ER37883      3560 - 3560      ER37884      3561 - 3561 
      ER37885      3562 - 3562      ER37886      3563 - 3563      ER37887      3564 - 3565 
      ER37888      3566 - 3566      ER37889      3567 - 3567      ER37890      3568 - 3575 
      ER37891      3576 - 3576      ER37892      3577 - 3577      ER37893      3578 - 3578 
      ER37894      3579 - 3579      ER37895      3580 - 3580      ER37896      3581 - 3588 
      ER37897      3589 - 3589      ER37898      3590 - 3590      ER37899      3591 - 3591 
      ER37900      3592 - 3592      ER37901      3593 - 3594      ER37902      3595 - 3601 
      ER37903      3602 - 3602      ER37904      3603 - 3603      ER37905      3604 - 3604 
      ER37906      3605 - 3605      ER37907      3606 - 3606      ER37908      3607 - 3607 
      ER37909      3608 - 3608      ER37910      3609 - 3609      ER37911      3610 - 3610 
      ER37912      3611 - 3611      ER37913      3612 - 3612      ER37914      3613 - 3614 
      ER37915      3615 - 3618      ER37916      3619 - 3625      ER37917      3626 - 3626 
      ER37918      3627 - 3627      ER37919      3628 - 3628      ER37920      3629 - 3629 
      ER37921      3630 - 3630      ER37922      3631 - 3631      ER37923      3632 - 3632 
      ER37924      3633 - 3639      ER37925      3640 - 3640      ER37926      3641 - 3641 
      ER37927      3642 - 3642      ER37928      3643 - 3643      ER37929      3644 - 3644 
      ER37930      3645 - 3645      ER37931      3646 - 3646      ER37932      3647 - 3647 
      ER37933      3648 - 3648      ER37934      3649 - 3649      ER37935      3650 - 3656 
      ER37936      3657 - 3657      ER37937      3658 - 3658      ER37938      3659 - 3659 
      ER37939      3660 - 3660      ER37940      3661 - 3662      ER37941      3663 - 3664 
      ER37942      3665 - 3670      ER37943      3671 - 3671      ER37944      3672 - 3674 
      ER37945      3675 - 3682      ER37946      3683 - 3683      ER37947      3684 - 3684 
      ER37948      3685 - 3685      ER37949      3686 - 3686      ER37950      3687 - 3693 
      ER37951      3694 - 3694      ER37952      3695 - 3695      ER37953      3696 - 3696 
      ER37954      3697 - 3697      ER37955      3698 - 3698      ER37956      3699 - 3706 
      ER37957      3707 - 3707      ER37958      3708 - 3708      ER37959      3709 - 3709 
      ER37960      3710 - 3710      ER37961      3711 - 3712      ER37962      3713 - 3719 
      ER37963      3720 - 3720      ER37964      3721 - 3721      ER37965      3722 - 3722 
      ER37966      3723 - 3723      ER37967      3724 - 3724      ER37968      3725 - 3726 
      ER37969      3727 - 3727      ER37970      3728 - 3728      ER37971      3729 - 3729 
      ER37972      3730 - 3731      ER37973      3732 - 3735      ER37974      3736 - 3736 
      ER37975      3737 - 3739      ER37976      3740 - 3740      ER37977      3741 - 3743 
      ER37978      3744 - 3744      ER37979      3745 - 3745      ER37980      3746 - 3752 
      ER37981      3753 - 3753      ER37982      3754 - 3756      ER37983      3757 - 3757 
      ER37984      3758 - 3764      ER37985      3765 - 3765      ER37986      3766 - 3768 
      ER37987      3769 - 3769      ER37988      3770 - 3770      ER37989      3771 - 3777 
      ER37990      3778 - 3778      ER37991      3779 - 3781      ER37992      3782 - 3784 
      ER37993      3785 - 3793      ER37994      3794 - 3794      ER37995      3795 - 3795 
      ER37996      3796 - 3796      ER37997      3797 - 3797      ER37998      3798 - 3798 
      ER37999      3799 - 3807      ER38000      3808 - 3808      ER38001      3809 - 3811 
      ER38002      3812 - 3812      ER38003      3813 - 3813      ER38004      3814 - 3816 
      ER38005      3817 - 3819      ER38006      3820 - 3822      ER38007      3823 - 3825 
      ER38008      3826 - 3826      ER38009      3827 - 3827      ER38010      3828 - 3830 
      ER38011      3831 - 3833      ER38012      3834 - 3836      ER38013      3837 - 3839 
      ER38014      3840 - 3842      ER38015      3843 - 3843      ER38016      3844 - 3850 
      ER38017      3851 - 3851      ER38018      3852 - 3854      ER38019      3855 - 3863 
      ER38020      3864 - 3864      ER38021      3865 - 3865      ER38022      3866 - 3866 
      ER38023      3867 - 3867      ER38024      3868 - 3868      ER38025      3869 - 3869 
      ER38026      3870 - 3870      ER38027      3871 - 3871      ER38028      3872 - 3873 
      ER38029      3874 - 3875      ER38030      3876 - 3878      ER38031      3879 - 3882 
      ER38032      3883 - 3885      ER38033      3886 - 3889      ER38034      3890 - 3890 
      ER38035      3891 - 3891      ER38036      3892 - 3898      ER38037      3899 - 3899 
      ER38038      3900 - 3902      ER38039      3903 - 3903      ER38040      3904 - 3904 
      ER38041      3905 - 3912      ER38042      3913 - 3913      ER38043      3914 - 3914 
      ER38044      3915 - 3915      ER38045      3916 - 3916      ER38046      3917 - 3917 
      ER38047      3918 - 3925      ER38048      3926 - 3926      ER38049      3927 - 3927 
      ER38050      3928 - 3928      ER38051      3929 - 3929      ER38052      3930 - 3931 
      ER38053      3932 - 3938      ER38054      3939 - 3939      ER38055      3940 - 3940 
      ER38056      3941 - 3941      ER38057      3942 - 3942      ER38058      3943 - 3943 
      ER38059      3944 - 3944      ER38060      3945 - 3945      ER38061      3946 - 3946 
      ER38062      3947 - 3947      ER38063      3948 - 3948      ER38064      3949 - 3949 
      ER38065      3950 - 3951      ER38066      3952 - 3955      ER38067      3956 - 3962 
      ER38068      3963 - 3963      ER38069      3964 - 3964      ER38070      3965 - 3965 
      ER38071      3966 - 3966      ER38072      3967 - 3967      ER38073      3968 - 3968 
      ER38074      3969 - 3969      ER38075      3970 - 3976      ER38076      3977 - 3977 
      ER38077      3978 - 3978      ER38078      3979 - 3979      ER38079      3980 - 3980 
      ER38080      3981 - 3981      ER38081      3982 - 3982      ER38082      3983 - 3983 
      ER38083      3984 - 3984      ER38084      3985 - 3985      ER38085      3986 - 3986 
      ER38086      3987 - 3993      ER38087      3994 - 3994      ER38088      3995 - 3995 
      ER38089      3996 - 3996      ER38090      3997 - 3997      ER38091      3998 - 3999 
      ER38092      4000 - 4001      ER38093      4002 - 4007      ER38094      4008 - 4008 
      ER38095      4009 - 4011      ER38096      4012 - 4019      ER38097      4020 - 4020 
      ER38098      4021 - 4021      ER38099      4022 - 4022      ER38100      4023 - 4023 
      ER38101      4024 - 4030      ER38102      4031 - 4031      ER38103      4032 - 4032 
      ER38104      4033 - 4033      ER38105      4034 - 4034      ER38106      4035 - 4035 
      ER38107      4036 - 4043      ER38108      4044 - 4044      ER38109      4045 - 4045 
      ER38110      4046 - 4046      ER38111      4047 - 4047      ER38112      4048 - 4049 
      ER38113      4050 - 4056      ER38114      4057 - 4057      ER38115      4058 - 4058 
      ER38116      4059 - 4059      ER38117      4060 - 4060      ER38118      4061 - 4061 
      ER38119      4062 - 4063      ER38120      4064 - 4064      ER38121      4065 - 4065 
      ER38122      4066 - 4073      ER38123      4074 - 4074      ER38124      4075 - 4075 
      ER38125      4076 - 4076      ER38126      4077 - 4077      ER38127      4078 - 4078 
      ER38128      4079 - 4086      ER38129      4087 - 4087      ER38130      4088 - 4088 
      ER38131      4089 - 4089      ER38132      4090 - 4090      ER38133      4091 - 4092 
      ER38134      4093 - 4099      ER38135      4100 - 4100      ER38136      4101 - 4101 
      ER38137      4102 - 4102      ER38138      4103 - 4103      ER38139      4104 - 4104 
      ER38140      4105 - 4105      ER38141      4106 - 4106      ER38142      4107 - 4107 
      ER38143      4108 - 4108      ER38144      4109 - 4109      ER38145      4110 - 4110 
      ER38146      4111 - 4112      ER38147      4113 - 4116      ER38148      4117 - 4123 
      ER38149      4124 - 4124      ER38150      4125 - 4125      ER38151      4126 - 4126 
      ER38152      4127 - 4127      ER38153      4128 - 4128      ER38154      4129 - 4129 
      ER38155      4130 - 4130      ER38156      4131 - 4137      ER38157      4138 - 4138 
      ER38158      4139 - 4139      ER38159      4140 - 4140      ER38160      4141 - 4141 
      ER38161      4142 - 4142      ER38162      4143 - 4143      ER38163      4144 - 4144 
      ER38164      4145 - 4145      ER38165      4146 - 4146      ER38166      4147 - 4147 
      ER38167      4148 - 4154      ER38168      4155 - 4155      ER38169      4156 - 4156 
      ER38170      4157 - 4157      ER38171      4158 - 4158      ER38172      4159 - 4160 
      ER38173      4161 - 4162      ER38174      4163 - 4168      ER38175      4169 - 4169 
      ER38176      4170 - 4172      ER38177      4173 - 4180      ER38178      4181 - 4181 
      ER38179      4182 - 4182      ER38180      4183 - 4183      ER38181      4184 - 4184 
      ER38182      4185 - 4191      ER38183      4192 - 4192      ER38184      4193 - 4193 
      ER38185      4194 - 4194      ER38186      4195 - 4195      ER38187      4196 - 4196 
      ER38188      4197 - 4204      ER38189      4205 - 4205      ER38190      4206 - 4206 
      ER38191      4207 - 4207      ER38192      4208 - 4208      ER38193      4209 - 4210 
      ER38194      4211 - 4217      ER38195      4218 - 4218      ER38196      4219 - 4219 
      ER38197      4220 - 4220      ER38198      4221 - 4221      ER38199      4222 - 4222 
      ER38200      4223 - 4224      ER38201      4225 - 4225      ER38202      4226 - 4226 
      ER38203      4227 - 4227      ER38204      4228 - 4228      ER38205      4229 - 4229 
      ER38206      4230 - 4230      ER38207      4231 - 4231      ER38208      4232 - 4232 
      ER38209      4233 - 4233      ER38210      4234 - 4236      ER38211      4237 - 4237 
      ER38212      4238 - 4238      ER38213      4239 - 4239      ER38214      4240 - 4242 
      ER38215      4243 - 4243      ER38216      4244 - 4244      ER38217      4245 - 4245 
      ER38218      4246 - 4248      ER38219      4249 - 4249      ER38220      4250 - 4250 
      ER38221      4251 - 4251      ER38222      4252 - 4254      ER38223      4255 - 4255 
      ER38224      4256 - 4256      ER38225      4257 - 4257      ER38226      4258 - 4260 
      ER38227      4261 - 4261      ER38228      4262 - 4262      ER38229      4263 - 4263 
      ER38230      4264 - 4266      ER38231      4267 - 4267      ER38232      4268 - 4268 
      ER38233      4269 - 4269      ER38234      4270 - 4272      ER38235      4273 - 4273 
      ER38236      4274 - 4274      ER38237      4275 - 4275      ER38238      4276 - 4278 
      ER38239      4279 - 4279      ER38240      4280 - 4280      ER38241      4281 - 4281 
      ER38242      4282 - 4284      ER38243      4285 - 4285      ER38244      4286 - 4286 
      ER38245      4287 - 4287      ER38246      4288 - 4290      ER38247      4291 - 4291 
      ER38248      4292 - 4292      ER38249      4293 - 4293      ER38250      4294 - 4296 
      ER38251      4297 - 4297      ER38252      4298 - 4298      ER38253      4299 - 4300 
      ER38254      4301 - 4302      ER38255      4303 - 4303      ER38256      4304 - 4304 
      ER38257      4305 - 4307      ER38258      4308 - 4309      ER38259      4310 - 4311 
      ER38260      4312 - 4313      ER38261      4314 - 4314      ER38262      4315 - 4315 
      ER38263      4316 - 4316      ER38264      4317 - 4319      ER38265      4320 - 4320 
      ER38266      4321 - 4321      ER38267      4322 - 4322      ER38268      4323 - 4325 
      ER38269      4326 - 4327      ER38270      4328 - 4328      ER38271      4329 - 4329 
      ER38272      4330 - 4330      ER38273      4331 - 4331      ER38274      4332 - 4332 
      ER38275      4333 - 4333      ER38276      4334 - 4334      ER38277      4335 - 4335 
      ER38278      4336 - 4336      ER38279      4337 - 4337      ER38280      4338 - 4338 
      ER38281      4339 - 4339      ER38282      4340 - 4340      ER38283      4341 - 4341 
      ER38284      4342 - 4342      ER38285      4343 - 4343      ER38286      4344 - 4344 
      ER38287      4345 - 4345      ER38288      4346 - 4346      ER38289      4347 - 4347 
      ER38290      4348 - 4348      ER38291      4349 - 4349      ER38292      4350 - 4350 
      ER38293      4351 - 4351      ER38294      4352 - 4352      ER38295      4353 - 4353 
      ER38296      4354 - 4354      ER38297      4355 - 4355      ER38298      4356 - 4356 
      ER38299      4357 - 4357      ER38300      4358 - 4358      ER38301      4359 - 4359 
      ER38302      4360 - 4360      ER38303      4361 - 4363      ER38304      4364 - 4364 
      ER38305      4365 - 4367      ER38306      4368 - 4368      ER38307      4369 - 4371 
      ER38308      4372 - 4372      ER38309      4373 - 4373      ER38310      4374 - 4376 
      ER38311      4377 - 4378      ER38312      4379 - 4379      ER38313      4380 - 4382 
      ER38314      4383 - 4384      ER38315      4385 - 4386      ER38316      4387 - 4387 
      ER38317      4388 - 4388      ER38318      4389 - 4390      ER38319      4391 - 4393 
      ER38320      4394 - 4396      ER38321      4397 - 4397      ER38322      4398 - 4399 
      ER38323      4400 - 4400      ER38324      4401 - 4401      ER38325      4402 - 4402 
      ER38326      4403 - 4403      ER38327      4404 - 4404      ER38328      4405 - 4405 
      ER38329      4406 - 4406      ER38330      4407 - 4407      ER38331      4408 - 4408 
      ER38332      4409 - 4409      ER38333      4410 - 4410      ER38334      4411 - 4411 
      ER38335      4412 - 4412      ER38336      4413 - 4413      ER38337      4414 - 4414 
      ER38338      4415 - 4415      ER38339      4416 - 4416      ER38340      4417 - 4417 
      ER38341      4418 - 4418      ER38342      4419 - 4419      ER38343      4420 - 4420 
      ER38344      4421 - 4424      ER38345      4425 - 4425      ER38346      4426 - 4426 
      ER38347      4427 - 4427      ER38348      4428 - 4428      ER38349      4429 - 4429 
      ER38350      4430 - 4430      ER38351      4431 - 4431      ER38352      4432 - 4432 
      ER38353      4433 - 4433      ER38354      4434 - 4434      ER38355      4435 - 4435 
      ER38356      4436 - 4436      ER38357      4437 - 4437      ER38358      4438 - 4438 
      ER38359      4439 - 4439      ER38360      4440 - 4440      ER38361      4441 - 4441 
      ER38362      4442 - 4442      ER38363      4443 - 4443      ER38364      4444 - 4444 
      ER38365      4445 - 4445      ER38366      4446 - 4446      ER38367      4447 - 4447 
      ER38368      4448 - 4448      ER38369      4449 - 4449      ER38370      4450 - 4450 
      ER38371      4451 - 4451      ER38372      4452 - 4452      ER38373      4453 - 4453 
      ER38374      4454 - 4454      ER38375      4455 - 4455      ER38376      4456 - 4456 
      ER38377      4457 - 4457      ER38378      4458 - 4458      ER38379      4459 - 4459 
      ER38380      4460 - 4460      ER38381      4461 - 4461      ER38382      4462 - 4462 
      ER38383      4463 - 4463      ER38384      4464 - 4464      ER38385      4465 - 4465 
      ER38386      4466 - 4466      ER38387      4467 - 4467      ER38388      4468 - 4468 
      ER38389      4469 - 4469      ER38390      4470 - 4470      ER38391      4471 - 4471 
      ER38392      4472 - 4472      ER38393      4473 - 4473      ER38394      4474 - 4474 
      ER38395      4475 - 4475      ER38396      4476 - 4476      ER38397      4477 - 4477 
      ER38398      4478 - 4478      ER38399      4479 - 4479      ER38400      4480 - 4480 
      ER38401      4481 - 4481      ER38402      4482 - 4482      ER38403      4483 - 4483 
      ER38404      4484 - 4484      ER38405      4485 - 4485      ER38406      4486 - 4486 
      ER38407      4487 - 4487      ER38408      4488 - 4488      ER38409      4489 - 4489 
      ER38410      4490 - 4490      ER38411      4491 - 4491      ER38412      4492 - 4492 
      ER38413      4493 - 4493      ER38414      4494 - 4496      ER38415      4497 - 4497 
      ER38416      4498 - 4498      ER38417      4499 - 4499      ER38418      4500 - 4500 
      ER38419      4501 - 4501      ER38420      4502 - 4502      ER38421      4503 - 4503 
      ER38422      4504 - 4504      ER38423      4505 - 4505      ER38424      4506 - 4506 
      ER38425      4507 - 4507      ER38426      4508 - 4508      ER38427      4509 - 4509 
      ER38428      4510 - 4510      ER38429      4511 - 4511      ER38430      4512 - 4512 
      ER38431      4513 - 4513      ER38432      4514 - 4514      ER38433      4515 - 4517 
      ER38434      4518 - 4518      ER38435      4519 - 4519      ER38436      4520 - 4520 
      ER38437      4521 - 4521      ER38438      4522 - 4522      ER38439      4523 - 4523 
      ER38440      4524 - 4524      ER38441      4525 - 4525      ER38442      4526 - 4526 
      ER38443      4527 - 4527      ER38444      4528 - 4528      ER38445      4529 - 4529 
      ER38446      4530 - 4530      ER38447      4531 - 4531      ER38448      4532 - 4532 
      ER38449      4533 - 4533      ER38450      4534 - 4534      ER38451      4535 - 4535 
      ER38452      4536 - 4538      ER38453      4539 - 4539      ER38454      4540 - 4540 
      ER38455      4541 - 4541      ER38456      4542 - 4542      ER38457      4543 - 4543 
      ER38458      4544 - 4544      ER38459      4545 - 4545      ER38460      4546 - 4546 
      ER38461      4547 - 4547      ER38462      4548 - 4548      ER38463      4549 - 4549 
      ER38464      4550 - 4550      ER38465      4551 - 4551      ER38466      4552 - 4552 
      ER38467      4553 - 4553      ER38468      4554 - 4554      ER38469      4555 - 4555 
      ER38470      4556 - 4556      ER38471      4557 - 4559      ER38472      4560 - 4560 
      ER38473      4561 - 4561      ER38474      4562 - 4562      ER38475      4563 - 4563 
      ER38476      4564 - 4564      ER38477      4565 - 4565      ER38478      4566 - 4566 
      ER38479      4567 - 4567      ER38480      4568 - 4568      ER38481      4569 - 4569 
      ER38482      4570 - 4570      ER38483      4571 - 4571      ER38484      4572 - 4572 
      ER38485      4573 - 4573      ER38486      4574 - 4574      ER38487      4575 - 4575 
      ER38488      4576 - 4576      ER38489      4577 - 4577      ER38490      4578 - 4580 
      ER38491      4581 - 4581      ER38492      4582 - 4582      ER38493      4583 - 4583 
      ER38494      4584 - 4584      ER38495      4585 - 4585      ER38496      4586 - 4586 
      ER38497      4587 - 4587      ER38498      4588 - 4588      ER38499      4589 - 4589 
      ER38500      4590 - 4590      ER38501      4591 - 4591      ER38502      4592 - 4592 
      ER38503      4593 - 4593      ER38504      4594 - 4594      ER38505      4595 - 4595 
      ER38506      4596 - 4596      ER38507      4597 - 4597      ER38508      4598 - 4598 
      ER38509      4599 - 4601      ER38510      4602 - 4602      ER38511      4603 - 4603 
      ER38512      4604 - 4604      ER38513      4605 - 4605      ER38514      4606 - 4606 
      ER38515      4607 - 4607      ER38516      4608 - 4608      ER38517      4609 - 4609 
      ER38518      4610 - 4610      ER38519      4611 - 4611      ER38520      4612 - 4612 
      ER38521      4613 - 4613      ER38522      4614 - 4614      ER38523      4615 - 4615 
      ER38524      4616 - 4616      ER38525      4617 - 4617      ER38526      4618 - 4618 
      ER38527      4619 - 4619      ER38528      4620 - 4622      ER38529      4623 - 4623 
      ER38530      4624 - 4624      ER38531      4625 - 4625      ER38532      4626 - 4626 
      ER38533      4627 - 4627      ER38534      4628 - 4628      ER38535      4629 - 4629 
      ER38536      4630 - 4630      ER38537      4631 - 4631      ER38538      4632 - 4632 
      ER38539      4633 - 4633      ER38540      4634 - 4634      ER38541      4635 - 4635 
      ER38542      4636 - 4636      ER38543      4637 - 4637      ER38544      4638 - 4638 
      ER38545      4639 - 4639      ER38546      4640 - 4640      ER38547      4641 - 4643 
      ER38548      4644 - 4644      ER38549      4645 - 4645      ER38550      4646 - 4646 
      ER38551      4647 - 4647      ER38552      4648 - 4648      ER38553      4649 - 4649 
      ER38554      4650 - 4650      ER38555      4651 - 4651      ER38556      4652 - 4652 
      ER38557      4653 - 4653      ER38558      4654 - 4654      ER38559      4655 - 4655 
      ER38560      4656 - 4656      ER38561      4657 - 4657      ER38562      4658 - 4658 
      ER38563      4659 - 4659      ER38564      4660 - 4660      ER38565      4661 - 4661 
      ER38566      4662 - 4664      ER38567      4665 - 4665      ER38568      4666 - 4666 
      ER38569      4667 - 4667      ER38570      4668 - 4668      ER38571      4669 - 4669 
      ER38572      4670 - 4670      ER38573      4671 - 4671      ER38574      4672 - 4672 
      ER38575      4673 - 4673      ER38576      4674 - 4674      ER38577      4675 - 4675 
      ER38578      4676 - 4676      ER38579      4677 - 4677      ER38580      4678 - 4678 
      ER38581      4679 - 4679      ER38582      4680 - 4680      ER38583      4681 - 4681 
      ER38584      4682 - 4682      ER38585      4683 - 4685      ER38586      4686 - 4686 
      ER38587      4687 - 4687      ER38588      4688 - 4688      ER38589      4689 - 4689 
      ER38590      4690 - 4690      ER38591      4691 - 4691      ER38592      4692 - 4692 
      ER38593      4693 - 4693      ER38594      4694 - 4694      ER38595      4695 - 4695 
      ER38596      4696 - 4696      ER38597      4697 - 4697      ER38598      4698 - 4698 
      ER38599      4699 - 4699      ER38600      4700 - 4700      ER38601      4701 - 4701 
      ER38602      4702 - 4702      ER38603      4703 - 4703      ER38604      4704 - 4706 
      ER38605      4707 - 4707      ER38606      4708 - 4708      ER38607      4709 - 4709 
      ER38608      4710 - 4710      ER38609      4711 - 4711      ER38610      4712 - 4712 
      ER38611      4713 - 4713      ER38612      4714 - 4714      ER38613      4715 - 4715 
      ER38614      4716 - 4716      ER38615      4717 - 4717      ER38616      4718 - 4718 
      ER38617      4719 - 4719      ER38618      4720 - 4720      ER38619      4721 - 4721 
      ER38620      4722 - 4722      ER38621      4723 - 4723      ER38622      4724 - 4724 
      ER38623      4725 - 4727      ER38624      4728 - 4728      ER38625      4729 - 4729 
      ER38626      4730 - 4730      ER38627      4731 - 4731      ER38628      4732 - 4732 
      ER38629      4733 - 4733      ER38630      4734 - 4734      ER38631      4735 - 4735 
      ER38632      4736 - 4736      ER38633      4737 - 4737      ER38634      4738 - 4738 
      ER38635      4739 - 4739      ER38636      4740 - 4740      ER38637      4741 - 4741 
      ER38638      4742 - 4742      ER38639      4743 - 4743      ER38640      4744 - 4744 
      ER38641      4745 - 4745      ER38642      4746 - 4748      ER38643      4749 - 4749 
      ER38644      4750 - 4750      ER38645      4751 - 4751      ER38646      4752 - 4752 
      ER38647      4753 - 4753      ER38648      4754 - 4754      ER38649      4755 - 4755 
      ER38650      4756 - 4756      ER38651      4757 - 4757      ER38652      4758 - 4758 
      ER38653      4759 - 4759      ER38654      4760 - 4760      ER38655      4761 - 4761 
      ER38656      4762 - 4762      ER38657      4763 - 4763      ER38658      4764 - 4764 
      ER38659      4765 - 4765      ER38660      4766 - 4766      ER38661      4767 - 4769 
      ER38662      4770 - 4773      ER38663      4774 - 4774      ER38664      4775 - 4775 
      ER38665      4776 - 4776      ER38666      4777 - 4777      ER38667      4778 - 4778 
      ER38668      4779 - 4779      ER38669      4780 - 4780      ER38670      4781 - 4781 
      ER38671      4782 - 4782      ER38672      4783 - 4783      ER38673      4784 - 4784 
      ER38674      4785 - 4785      ER38675      4786 - 4786      ER38676      4787 - 4787 
      ER38677      4788 - 4788      ER38678      4789 - 4789      ER38679      4790 - 4790 
      ER38680      4791 - 4791      ER38681      4792 - 4792      ER38682      4793 - 4793 
      ER38683      4794 - 4794      ER38684      4795 - 4795      ER38685      4796 - 4796 
      ER38686      4797 - 4797      ER38687      4798 - 4798      ER38688      4799 - 4799 
      ER38689      4800 - 4800      ER38690      4801 - 4801      ER38691      4802 - 4802 
      ER38692      4803 - 4803      ER38693      4804 - 4804      ER38694      4805 - 4805 
      ER38695      4806 - 4806      ER38696      4807 - 4807      ER38697      4808 - 4808 
      ER38698      4809 - 4809      ER38699      4810 - 4810      ER38700      4811 - 4811 
      ER38701      4812 - 4812      ER38702      4813 - 4813      ER38703      4814 - 4814 
      ER38704      4815 - 4815      ER38705      4816 - 4816      ER38706      4817 - 4817 
      ER38707      4818 - 4818      ER38708      4819 - 4819      ER38709      4820 - 4820 
      ER38710      4821 - 4821      ER38711      4822 - 4822      ER38712      4823 - 4823 
      ER38713      4824 - 4824      ER38714      4825 - 4825      ER38715      4826 - 4826 
      ER38716      4827 - 4827      ER38717      4828 - 4828      ER38718      4829 - 4829 
      ER38719      4830 - 4830      ER38720      4831 - 4831      ER38721      4832 - 4832 
      ER38722      4833 - 4833      ER38723      4834 - 4834      ER38724      4835 - 4835 
      ER38725      4836 - 4836      ER38726      4837 - 4837      ER38727      4838 - 4838 
      ER38728      4839 - 4839      ER38729      4840 - 4840      ER38730      4841 - 4841 
      ER38731      4842 - 4842      ER38732      4843 - 4845      ER38733      4846 - 4846 
      ER38734      4847 - 4847      ER38735      4848 - 4848      ER38736      4849 - 4849 
      ER38737      4850 - 4850      ER38738      4851 - 4851      ER38739      4852 - 4852 
      ER38740      4853 - 4853      ER38741      4854 - 4854      ER38742      4855 - 4855 
      ER38743      4856 - 4856      ER38744      4857 - 4857      ER38745      4858 - 4858 
      ER38746      4859 - 4859      ER38747      4860 - 4860      ER38748      4861 - 4861 
      ER38749      4862 - 4862      ER38750      4863 - 4863      ER38751      4864 - 4866 
      ER38752      4867 - 4867      ER38753      4868 - 4868      ER38754      4869 - 4869 
      ER38755      4870 - 4870      ER38756      4871 - 4871      ER38757      4872 - 4872 
      ER38758      4873 - 4873      ER38759      4874 - 4874      ER38760      4875 - 4875 
      ER38761      4876 - 4876      ER38762      4877 - 4877      ER38763      4878 - 4878 
      ER38764      4879 - 4879      ER38765      4880 - 4880      ER38766      4881 - 4881 
      ER38767      4882 - 4882      ER38768      4883 - 4883      ER38769      4884 - 4884 
      ER38770      4885 - 4887      ER38771      4888 - 4888      ER38772      4889 - 4889 
      ER38773      4890 - 4890      ER38774      4891 - 4891      ER38775      4892 - 4892 
      ER38776      4893 - 4893      ER38777      4894 - 4894      ER38778      4895 - 4895 
      ER38779      4896 - 4896      ER38780      4897 - 4897      ER38781      4898 - 4898 
      ER38782      4899 - 4899      ER38783      4900 - 4900      ER38784      4901 - 4901 
      ER38785      4902 - 4902      ER38786      4903 - 4903      ER38787      4904 - 4904 
      ER38788      4905 - 4905      ER38789      4906 - 4908      ER38790      4909 - 4909 
      ER38791      4910 - 4910      ER38792      4911 - 4911      ER38793      4912 - 4912 
      ER38794      4913 - 4913      ER38795      4914 - 4914      ER38796      4915 - 4915 
      ER38797      4916 - 4916      ER38798      4917 - 4917      ER38799      4918 - 4918 
      ER38800      4919 - 4919      ER38801      4920 - 4920      ER38802      4921 - 4921 
      ER38803      4922 - 4922      ER38804      4923 - 4923      ER38805      4924 - 4924 
      ER38806      4925 - 4925      ER38807      4926 - 4926      ER38808      4927 - 4929 
      ER38809      4930 - 4930      ER38810      4931 - 4931      ER38811      4932 - 4932 
      ER38812      4933 - 4933      ER38813      4934 - 4934      ER38814      4935 - 4935 
      ER38815      4936 - 4936      ER38816      4937 - 4937      ER38817      4938 - 4938 
      ER38818      4939 - 4939      ER38819      4940 - 4940      ER38820      4941 - 4941 
      ER38821      4942 - 4942      ER38822      4943 - 4943      ER38823      4944 - 4944 
      ER38824      4945 - 4945      ER38825      4946 - 4946      ER38826      4947 - 4947 
      ER38827      4948 - 4950      ER38828      4951 - 4951      ER38829      4952 - 4952 
      ER38830      4953 - 4953      ER38831      4954 - 4954      ER38832      4955 - 4955 
      ER38833      4956 - 4956      ER38834      4957 - 4957      ER38835      4958 - 4958 
      ER38836      4959 - 4959      ER38837      4960 - 4960      ER38838      4961 - 4961 
      ER38839      4962 - 4962      ER38840      4963 - 4963      ER38841      4964 - 4964 
      ER38842      4965 - 4965      ER38843      4966 - 4966      ER38844      4967 - 4967 
      ER38845      4968 - 4968      ER38846      4969 - 4971      ER38847      4972 - 4972 
      ER38848      4973 - 4973      ER38849      4974 - 4974      ER38850      4975 - 4975 
      ER38851      4976 - 4976      ER38852      4977 - 4977      ER38853      4978 - 4978 
      ER38854      4979 - 4979      ER38855      4980 - 4980      ER38856      4981 - 4981 
      ER38857      4982 - 4982      ER38858      4983 - 4983      ER38859      4984 - 4984 
      ER38860      4985 - 4985      ER38861      4986 - 4986      ER38862      4987 - 4987 
      ER38863      4988 - 4988      ER38864      4989 - 4989      ER38865      4990 - 4992 
      ER38866      4993 - 4993      ER38867      4994 - 4994      ER38868      4995 - 4995 
      ER38869      4996 - 4996      ER38870      4997 - 4997      ER38871      4998 - 4998 
      ER38872      4999 - 4999      ER38873      5000 - 5000      ER38874      5001 - 5001 
      ER38875      5002 - 5002      ER38876      5003 - 5003      ER38877      5004 - 5004 
      ER38878      5005 - 5005      ER38879      5006 - 5006      ER38880      5007 - 5007 
      ER38881      5008 - 5008      ER38882      5009 - 5009      ER38883      5010 - 5010 
      ER38884      5011 - 5013      ER38885      5014 - 5014      ER38886      5015 - 5015 
      ER38887      5016 - 5016      ER38888      5017 - 5017      ER38889      5018 - 5018 
      ER38890      5019 - 5019      ER38891      5020 - 5020      ER38892      5021 - 5021 
      ER38893      5022 - 5022      ER38894      5023 - 5023      ER38895      5024 - 5024 
      ER38896      5025 - 5025      ER38897      5026 - 5026      ER38898      5027 - 5027 
      ER38899      5028 - 5028      ER38900      5029 - 5029      ER38901      5030 - 5030 
      ER38902      5031 - 5031      ER38903      5032 - 5034      ER38904      5035 - 5035 
      ER38905      5036 - 5036      ER38906      5037 - 5037      ER38907      5038 - 5038 
      ER38908      5039 - 5039      ER38909      5040 - 5040      ER38910      5041 - 5041 
      ER38911      5042 - 5042      ER38912      5043 - 5043      ER38913      5044 - 5044 
      ER38914      5045 - 5045      ER38915      5046 - 5046      ER38916      5047 - 5047 
      ER38917      5048 - 5048      ER38918      5049 - 5049      ER38919      5050 - 5050 
      ER38920      5051 - 5051      ER38921      5052 - 5052      ER38922      5053 - 5055 
      ER38923      5056 - 5056      ER38924      5057 - 5057      ER38925      5058 - 5058 
      ER38926      5059 - 5059      ER38927      5060 - 5060      ER38928      5061 - 5061 
      ER38929      5062 - 5062      ER38930      5063 - 5063      ER38931      5064 - 5064 
      ER38932      5065 - 5065      ER38933      5066 - 5066      ER38934      5067 - 5067 
      ER38935      5068 - 5068      ER38936      5069 - 5069      ER38937      5070 - 5070 
      ER38938      5071 - 5071      ER38939      5072 - 5072      ER38940      5073 - 5073 
      ER38941      5074 - 5076      ER38942      5077 - 5077      ER38943      5078 - 5078 
      ER38944      5079 - 5079      ER38945      5080 - 5080      ER38946      5081 - 5081 
      ER38947      5082 - 5082      ER38948      5083 - 5083      ER38949      5084 - 5084 
      ER38950      5085 - 5085      ER38951      5086 - 5086      ER38952      5087 - 5087 
      ER38953      5088 - 5088      ER38954      5089 - 5089      ER38955      5090 - 5090 
      ER38956      5091 - 5091      ER38957      5092 - 5092      ER38958      5093 - 5093 
      ER38959      5094 - 5094      ER38960      5095 - 5097      ER38961      5098 - 5098 
      ER38962      5099 - 5099      ER38963      5100 - 5100      ER38964      5101 - 5101 
      ER38965      5102 - 5102      ER38966      5103 - 5103      ER38967      5104 - 5104 
      ER38968      5105 - 5105      ER38969      5106 - 5106      ER38970      5107 - 5107 
      ER38971      5108 - 5108      ER38972      5109 - 5109      ER38973      5110 - 5110 
      ER38974      5111 - 5111      ER38975      5112 - 5112      ER38976      5113 - 5113 
      ER38977      5114 - 5114      ER38978      5115 - 5115      ER38979      5116 - 5118 
      ER38980      5119 - 5122      ER38981      5123 - 5123      ER38982      5124 - 5124 
      ER38983      5125 - 5125      ER38984      5126 - 5126      ER38985      5127 - 5127 
      ER38986      5128 - 5128      ER38987      5129 - 5129      ER38988      5130 - 5130 
      ER38989      5131 - 5131      ER38990      5132 - 5132      ER38991      5133 - 5133 
      ER38992      5134 - 5134      ER38993      5135 - 5135      ER38994      5136 - 5136 
      ER38995      5137 - 5137      ER38996      5138 - 5138      ER38997      5139 - 5139 
      ER38998      5140 - 5140      ER38999      5141 - 5141      ER39000      5142 - 5142 
      ER39001      5143 - 5143      ER39002      5144 - 5144      ER39003      5145 - 5145 
      ER39004      5146 - 5146      ER39005      5147 - 5147      ER39006      5148 - 5148 
      ER39007      5149 - 5149      ER39008      5150 - 5150      ER39009      5151 - 5151 
      ER39010      5152 - 5152      ER39011      5153 - 5153      ER39012      5154 - 5154 
      ER39013      5155 - 5155      ER39014      5156 - 5156      ER39015      5157 - 5157 
      ER39016      5158 - 5158      ER39017      5159 - 5159      ER39018      5160 - 5160 
      ER39019      5161 - 5161      ER39020      5162 - 5162      ER39021      5163 - 5163 
      ER39022      5164 - 5164      ER39023      5165 - 5165      ER39024      5166 - 5166 
      ER39025      5167 - 5167      ER39026      5168 - 5168      ER39027      5169 - 5169 
      ER39028      5170 - 5170      ER39029      5171 - 5171      ER39030      5172 - 5172 
      ER39031      5173 - 5173      ER39032      5174 - 5174      ER39033      5175 - 5175 
      ER39034      5176 - 5176      ER39035      5177 - 5177      ER39036      5178 - 5178 
      ER39037      5179 - 5179      ER39038      5180 - 5180      ER39039      5181 - 5181 
      ER39040      5182 - 5182      ER39041      5183 - 5183      ER39042      5184 - 5184 
      ER39043      5185 - 5185      ER39044      5186 - 5186      ER39045      5187 - 5187 
      ER39046      5188 - 5188      ER39047      5189 - 5189      ER39048      5190 - 5190 
      ER39049      5191 - 5191      ER39050      5192 - 5194      ER39051      5195 - 5195 
      ER39052      5196 - 5196      ER39053      5197 - 5197      ER39054      5198 - 5198 
      ER39055      5199 - 5199      ER39056      5200 - 5200      ER39057      5201 - 5201 
      ER39058      5202 - 5202      ER39059      5203 - 5203      ER39060      5204 - 5204 
      ER39061      5205 - 5205      ER39062      5206 - 5206      ER39063      5207 - 5207 
      ER39064      5208 - 5208      ER39065      5209 - 5209      ER39066      5210 - 5210 
      ER39067      5211 - 5211      ER39068      5212 - 5212      ER39069      5213 - 5215 
      ER39070      5216 - 5216      ER39071      5217 - 5217      ER39072      5218 - 5218 
      ER39073      5219 - 5219      ER39074      5220 - 5220      ER39075      5221 - 5221 
      ER39076      5222 - 5222      ER39077      5223 - 5223      ER39078      5224 - 5224 
      ER39079      5225 - 5225      ER39080      5226 - 5226      ER39081      5227 - 5227 
      ER39082      5228 - 5228      ER39083      5229 - 5229      ER39084      5230 - 5230 
      ER39085      5231 - 5231      ER39086      5232 - 5232      ER39087      5233 - 5233 
      ER39088      5234 - 5236      ER39089      5237 - 5237      ER39090      5238 - 5238 
      ER39091      5239 - 5239      ER39092      5240 - 5240      ER39093      5241 - 5241 
      ER39094      5242 - 5242      ER39095      5243 - 5243      ER39096      5244 - 5244 
      ER39097      5245 - 5245      ER39098      5246 - 5246      ER39099      5247 - 5247 
      ER39100      5248 - 5248      ER39101      5249 - 5249      ER39102      5250 - 5250 
      ER39103      5251 - 5251      ER39104      5252 - 5252      ER39105      5253 - 5253 
      ER39106      5254 - 5254      ER39107      5255 - 5257      ER39108      5258 - 5258 
      ER39109      5259 - 5259      ER39110      5260 - 5260      ER39111      5261 - 5261 
      ER39112      5262 - 5262      ER39113      5263 - 5263      ER39114      5264 - 5264 
      ER39115      5265 - 5265      ER39116      5266 - 5266      ER39117      5267 - 5267 
      ER39118      5268 - 5268      ER39119      5269 - 5269      ER39120      5270 - 5270 
      ER39121      5271 - 5271      ER39122      5272 - 5272      ER39123      5273 - 5273 
      ER39124      5274 - 5274      ER39125      5275 - 5275      ER39126      5276 - 5278 
      ER39127      5279 - 5279      ER39128      5280 - 5280      ER39129      5281 - 5281 
      ER39130      5282 - 5282      ER39131      5283 - 5283      ER39132      5284 - 5284 
      ER39133      5285 - 5285      ER39134      5286 - 5286      ER39135      5287 - 5287 
      ER39136      5288 - 5288      ER39137      5289 - 5289      ER39138      5290 - 5290 
      ER39139      5291 - 5291      ER39140      5292 - 5292      ER39141      5293 - 5293 
      ER39142      5294 - 5294      ER39143      5295 - 5295      ER39144      5296 - 5296 
      ER39145      5297 - 5299      ER39146      5300 - 5300      ER39147      5301 - 5301 
      ER39148      5302 - 5302      ER39149      5303 - 5303      ER39150      5304 - 5304 
      ER39151      5305 - 5305      ER39152      5306 - 5306      ER39153      5307 - 5307 
      ER39154      5308 - 5308      ER39155      5309 - 5309      ER39156      5310 - 5310 
      ER39157      5311 - 5311      ER39158      5312 - 5312      ER39159      5313 - 5313 
      ER39160      5314 - 5314      ER39161      5315 - 5315      ER39162      5316 - 5316 
      ER39163      5317 - 5317      ER39164      5318 - 5320      ER39165      5321 - 5321 
      ER39166      5322 - 5322      ER39167      5323 - 5323      ER39168      5324 - 5324 
      ER39169      5325 - 5325      ER39170      5326 - 5326      ER39171      5327 - 5327 
      ER39172      5328 - 5328      ER39173      5329 - 5329      ER39174      5330 - 5330 
      ER39175      5331 - 5331      ER39176      5332 - 5332      ER39177      5333 - 5333 
      ER39178      5334 - 5334      ER39179      5335 - 5335      ER39180      5336 - 5336 
      ER39181      5337 - 5337      ER39182      5338 - 5338      ER39183      5339 - 5341 
      ER39184      5342 - 5342      ER39185      5343 - 5343      ER39186      5344 - 5344 
      ER39187      5345 - 5345      ER39188      5346 - 5346      ER39189      5347 - 5347 
      ER39190      5348 - 5348      ER39191      5349 - 5349      ER39192      5350 - 5350 
      ER39193      5351 - 5351      ER39194      5352 - 5352      ER39195      5353 - 5353 
      ER39196      5354 - 5354      ER39197      5355 - 5355      ER39198      5356 - 5356 
      ER39199      5357 - 5357      ER39200      5358 - 5358      ER39201      5359 - 5359 
      ER39202      5360 - 5362      ER39203      5363 - 5363      ER39204      5364 - 5364 
      ER39205      5365 - 5365      ER39206      5366 - 5366      ER39207      5367 - 5367 
      ER39208      5368 - 5368      ER39209      5369 - 5369      ER39210      5370 - 5370 
      ER39211      5371 - 5371      ER39212      5372 - 5372      ER39213      5373 - 5373 
      ER39214      5374 - 5374      ER39215      5375 - 5375      ER39216      5376 - 5376 
      ER39217      5377 - 5377      ER39218      5378 - 5378      ER39219      5379 - 5379 
      ER39220      5380 - 5380      ER39221      5381 - 5383      ER39222      5384 - 5384 
      ER39223      5385 - 5385      ER39224      5386 - 5386      ER39225      5387 - 5387 
      ER39226      5388 - 5388      ER39227      5389 - 5389      ER39228      5390 - 5390 
      ER39229      5391 - 5391      ER39230      5392 - 5392      ER39231      5393 - 5393 
      ER39232      5394 - 5394      ER39233      5395 - 5395      ER39234      5396 - 5396 
      ER39235      5397 - 5397      ER39236      5398 - 5398      ER39237      5399 - 5399 
      ER39238      5400 - 5400      ER39239      5401 - 5401      ER39240      5402 - 5404 
      ER39241      5405 - 5405      ER39242      5406 - 5406      ER39243      5407 - 5407 
      ER39244      5408 - 5408      ER39245      5409 - 5409      ER39246      5410 - 5410 
      ER39247      5411 - 5411      ER39248      5412 - 5412      ER39249      5413 - 5413 
      ER39250      5414 - 5414      ER39251      5415 - 5415      ER39252      5416 - 5416 
      ER39253      5417 - 5417      ER39254      5418 - 5418      ER39255      5419 - 5419 
      ER39256      5420 - 5420      ER39257      5421 - 5421      ER39258      5422 - 5422 
      ER39259      5423 - 5425      ER39260      5426 - 5426      ER39261      5427 - 5427 
      ER39262      5428 - 5428      ER39263      5429 - 5429      ER39264      5430 - 5430 
      ER39265      5431 - 5431      ER39266      5432 - 5432      ER39267      5433 - 5433 
      ER39268      5434 - 5434      ER39269      5435 - 5435      ER39270      5436 - 5436 
      ER39271      5437 - 5437      ER39272      5438 - 5438      ER39273      5439 - 5439 
      ER39274      5440 - 5440      ER39275      5441 - 5441      ER39276      5442 - 5442 
      ER39277      5443 - 5443      ER39278      5444 - 5446      ER39279      5447 - 5447 
      ER39280      5448 - 5448      ER39281      5449 - 5449      ER39282      5450 - 5450 
      ER39283      5451 - 5451      ER39284      5452 - 5452      ER39285      5453 - 5453 
      ER39286      5454 - 5454      ER39287      5455 - 5455      ER39288      5456 - 5456 
      ER39289      5457 - 5457      ER39290      5458 - 5458      ER39291      5459 - 5459 
      ER39292      5460 - 5460      ER39293      5461 - 5461      ER39294      5462 - 5462 
      ER39295      5463 - 5463      ER39296      5464 - 5464      ER39297      5465 - 5467 
      ER39298      5468 - 5468      ER39299      5469 - 5469      ER39300      5470 - 5470 
      ER39301      5471 - 5471      ER39302      5472 - 5472      ER39303      5473 - 5473 
      ER39304      5474 - 5474      ER39305      5475 - 5475      ER39306      5476 - 5476 
      ER39307      5477 - 5479      ER39308      5480 - 5480      ER39309      5481 - 5481 
      ER39310      5482 - 5482      ER39311      5483 - 5485      ER39312      5486 - 5486 
      ER39313      5487 - 5487      ER39314      5488 - 5488      ER39315      5489 - 5491 
      ER39316      5492 - 5492      ER39317      5493 - 5493      ER39318      5494 - 5494 
      ER39319      5495 - 5497      ER39320      5498 - 5498      ER39321      5499 - 5499 
      ER39322      5500 - 5500      ER39323      5501 - 5503      ER39324      5504 - 5504 
      ER39325      5505 - 5505      ER39326      5506 - 5506      ER39327      5507 - 5509 
      ER39328      5510 - 5510      ER39329      5511 - 5511      ER39330      5512 - 5512 
      ER39331      5513 - 5515      ER39332      5516 - 5516      ER39333      5517 - 5517 
      ER39334      5518 - 5518      ER39335      5519 - 5521      ER39336      5522 - 5522 
      ER39337      5523 - 5523      ER39338      5524 - 5524      ER39339      5525 - 5527 
      ER39340      5528 - 5528      ER39341      5529 - 5529      ER39342      5530 - 5530 
      ER39343      5531 - 5533      ER39344      5534 - 5534      ER39345      5535 - 5535 
      ER39346      5536 - 5536      ER39347      5537 - 5539      ER39348      5540 - 5540 
      ER39349      5541 - 5541      ER39350      5542 - 5543      ER39351      5544 - 5545 
      ER39352      5546 - 5546      ER39353      5547 - 5547      ER39354      5548 - 5550 
      ER39355      5551 - 5552      ER39356      5553 - 5554      ER39357      5555 - 5556 
      ER39358      5557 - 5557      ER39359      5558 - 5558      ER39360      5559 - 5559 
      ER39361      5560 - 5562      ER39362      5563 - 5563      ER39363      5564 - 5564 
      ER39364      5565 - 5565      ER39365      5566 - 5568      ER39366      5569 - 5570 
      ER39367      5571 - 5571      ER39368      5572 - 5572      ER39369      5573 - 5573 
      ER39370      5574 - 5574      ER39371      5575 - 5575      ER39372      5576 - 5576 
      ER39373      5577 - 5577      ER39374      5578 - 5578      ER39375      5579 - 5579 
      ER39376      5580 - 5580      ER39377      5581 - 5581      ER39378      5582 - 5582 
      ER39379      5583 - 5583      ER39380      5584 - 5584      ER39381      5585 - 5585 
      ER39382      5586 - 5586      ER39383      5587 - 5587      ER39384      5588 - 5588 
      ER39385      5589 - 5589      ER39386      5590 - 5590      ER39387      5591 - 5591 
      ER39388      5592 - 5592      ER39389      5593 - 5593      ER39390      5594 - 5594 
      ER39391      5595 - 5595      ER39392      5596 - 5596      ER39393      5597 - 5597 
      ER39394      5598 - 5598      ER39395      5599 - 5599      ER39396      5600 - 5600 
      ER39397      5601 - 5601      ER39398      5602 - 5602      ER39399      5603 - 5603 
      ER39400      5604 - 5606      ER39401      5607 - 5607      ER39402      5608 - 5610 
      ER39403      5611 - 5611      ER39404      5612 - 5614      ER39405      5615 - 5615 
      ER39406      5616 - 5616      ER39407      5617 - 5619      ER39408      5620 - 5621 
      ER39409      5622 - 5622      ER39410      5623 - 5625      ER39411      5626 - 5627 
      ER39412      5628 - 5629      ER39413      5630 - 5630      ER39414      5631 - 5631 
      ER39415      5632 - 5633      ER39416      5634 - 5636      ER39417      5637 - 5639 
      ER39418      5640 - 5640      ER39419      5641 - 5642      ER39420      5643 - 5643 
      ER39421      5644 - 5644      ER39422      5645 - 5645      ER39423      5646 - 5646 
      ER39424      5647 - 5647      ER39425      5648 - 5648      ER39426      5649 - 5649 
      ER39427      5650 - 5650      ER39428      5651 - 5651      ER39429      5652 - 5652 
      ER39430      5653 - 5653      ER39431      5654 - 5654      ER39432      5655 - 5655 
      ER39433      5656 - 5656      ER39434      5657 - 5657      ER39435      5658 - 5658 
      ER39436      5659 - 5659      ER39437      5660 - 5660      ER39438      5661 - 5661 
      ER39439      5662 - 5662      ER39440      5663 - 5663      ER39441      5664 - 5667 
      ER39442      5668 - 5668      ER39443      5669 - 5669      ER39444      5670 - 5670 
      ER39445      5671 - 5671      ER39446      5672 - 5672      ER39447      5673 - 5673 
      ER39448      5674 - 5674      ER39449      5675 - 5675      ER39450      5676 - 5676 
      ER39451      5677 - 5677      ER39452      5678 - 5678      ER39453      5679 - 5679 
      ER39454      5680 - 5680      ER39455      5681 - 5681      ER39456      5682 - 5682 
      ER39457      5683 - 5683      ER39458      5684 - 5684      ER39459      5685 - 5685 
      ER39460      5686 - 5686      ER39461      5687 - 5687      ER39462      5688 - 5688 
      ER39463      5689 - 5689      ER39464      5690 - 5690      ER39465      5691 - 5691 
      ER39466      5692 - 5692      ER39467      5693 - 5693      ER39468      5694 - 5694 
      ER39469      5695 - 5695      ER39470      5696 - 5696      ER39471      5697 - 5697 
      ER39472      5698 - 5698      ER39473      5699 - 5699      ER39474      5700 - 5700 
      ER39475      5701 - 5701      ER39476      5702 - 5702      ER39477      5703 - 5703 
      ER39478      5704 - 5704      ER39479      5705 - 5705      ER39480      5706 - 5706 
      ER39481      5707 - 5707      ER39482      5708 - 5708      ER39483      5709 - 5709 
      ER39484      5710 - 5710      ER39485      5711 - 5711      ER39486      5712 - 5712 
      ER39487      5713 - 5713      ER39488      5714 - 5714      ER39489      5715 - 5715 
      ER39490      5716 - 5716      ER39491      5717 - 5717      ER39492      5718 - 5718 
      ER39493      5719 - 5719      ER39494      5720 - 5720      ER39495      5721 - 5721 
      ER39496      5722 - 5722      ER39497      5723 - 5723      ER39498      5724 - 5724 
      ER39499      5725 - 5725      ER39500      5726 - 5726      ER39501      5727 - 5727 
      ER39502      5728 - 5728      ER39503      5729 - 5729      ER39504      5730 - 5730 
      ER39505      5731 - 5731      ER39506      5732 - 5732      ER39507      5733 - 5733 
      ER39508      5734 - 5734      ER39509      5735 - 5735      ER39510      5736 - 5736 
      ER39511      5737 - 5739      ER39512      5740 - 5740      ER39513      5741 - 5741 
      ER39514      5742 - 5742      ER39515      5743 - 5743      ER39516      5744 - 5744 
      ER39517      5745 - 5745      ER39518      5746 - 5746      ER39519      5747 - 5747 
      ER39520      5748 - 5748      ER39521      5749 - 5749      ER39522      5750 - 5750 
      ER39523      5751 - 5751      ER39524      5752 - 5752      ER39525      5753 - 5753 
      ER39526      5754 - 5754      ER39527      5755 - 5755      ER39528      5756 - 5756 
      ER39529      5757 - 5757      ER39530      5758 - 5760      ER39531      5761 - 5761 
      ER39532      5762 - 5762      ER39533      5763 - 5763      ER39534      5764 - 5764 
      ER39535      5765 - 5765      ER39536      5766 - 5766      ER39537      5767 - 5767 
      ER39538      5768 - 5768      ER39539      5769 - 5769      ER39540      5770 - 5770 
      ER39541      5771 - 5771      ER39542      5772 - 5772      ER39543      5773 - 5773 
      ER39544      5774 - 5774      ER39545      5775 - 5775      ER39546      5776 - 5776 
      ER39547      5777 - 5777      ER39548      5778 - 5778      ER39549      5779 - 5781 
      ER39550      5782 - 5782      ER39551      5783 - 5783      ER39552      5784 - 5784 
      ER39553      5785 - 5785      ER39554      5786 - 5786      ER39555      5787 - 5787 
      ER39556      5788 - 5788      ER39557      5789 - 5789      ER39558      5790 - 5790 
      ER39559      5791 - 5791      ER39560      5792 - 5792      ER39561      5793 - 5793 
      ER39562      5794 - 5794      ER39563      5795 - 5795      ER39564      5796 - 5796 
      ER39565      5797 - 5797      ER39566      5798 - 5798      ER39567      5799 - 5799 
      ER39568      5800 - 5802      ER39569      5803 - 5803      ER39570      5804 - 5804 
      ER39571      5805 - 5805      ER39572      5806 - 5806      ER39573      5807 - 5807 
      ER39574      5808 - 5808      ER39575      5809 - 5809      ER39576      5810 - 5810 
      ER39577      5811 - 5811      ER39578      5812 - 5812      ER39579      5813 - 5813 
      ER39580      5814 - 5814      ER39581      5815 - 5815      ER39582      5816 - 5816 
      ER39583      5817 - 5817      ER39584      5818 - 5818      ER39585      5819 - 5819 
      ER39586      5820 - 5820      ER39587      5821 - 5823      ER39588      5824 - 5824 
      ER39589      5825 - 5825      ER39590      5826 - 5826      ER39591      5827 - 5827 
      ER39592      5828 - 5828      ER39593      5829 - 5829      ER39594      5830 - 5830 
      ER39595      5831 - 5831      ER39596      5832 - 5832      ER39597      5833 - 5833 
      ER39598      5834 - 5834      ER39599      5835 - 5835      ER39600      5836 - 5836 
      ER39601      5837 - 5837      ER39602      5838 - 5838      ER39603      5839 - 5839 
      ER39604      5840 - 5840      ER39605      5841 - 5841      ER39606      5842 - 5844 
      ER39607      5845 - 5845      ER39608      5846 - 5846      ER39609      5847 - 5847 
      ER39610      5848 - 5848      ER39611      5849 - 5849      ER39612      5850 - 5850 
      ER39613      5851 - 5851      ER39614      5852 - 5852      ER39615      5853 - 5853 
      ER39616      5854 - 5854      ER39617      5855 - 5855      ER39618      5856 - 5856 
      ER39619      5857 - 5857      ER39620      5858 - 5858      ER39621      5859 - 5859 
      ER39622      5860 - 5860      ER39623      5861 - 5861      ER39624      5862 - 5862 
      ER39625      5863 - 5865      ER39626      5866 - 5866      ER39627      5867 - 5867 
      ER39628      5868 - 5868      ER39629      5869 - 5869      ER39630      5870 - 5870 
      ER39631      5871 - 5871      ER39632      5872 - 5872      ER39633      5873 - 5873 
      ER39634      5874 - 5874      ER39635      5875 - 5875      ER39636      5876 - 5876 
      ER39637      5877 - 5877      ER39638      5878 - 5878      ER39639      5879 - 5879 
      ER39640      5880 - 5880      ER39641      5881 - 5881      ER39642      5882 - 5882 
      ER39643      5883 - 5883      ER39644      5884 - 5886      ER39645      5887 - 5887 
      ER39646      5888 - 5888      ER39647      5889 - 5889      ER39648      5890 - 5890 
      ER39649      5891 - 5891      ER39650      5892 - 5892      ER39651      5893 - 5893 
      ER39652      5894 - 5894      ER39653      5895 - 5895      ER39654      5896 - 5896 
      ER39655      5897 - 5897      ER39656      5898 - 5898      ER39657      5899 - 5899 
      ER39658      5900 - 5900      ER39659      5901 - 5901      ER39660      5902 - 5902 
      ER39661      5903 - 5903      ER39662      5904 - 5904      ER39663      5905 - 5907 
      ER39664      5908 - 5908      ER39665      5909 - 5909      ER39666      5910 - 5910 
      ER39667      5911 - 5911      ER39668      5912 - 5912      ER39669      5913 - 5913 
      ER39670      5914 - 5914      ER39671      5915 - 5915      ER39672      5916 - 5916 
      ER39673      5917 - 5917      ER39674      5918 - 5918      ER39675      5919 - 5919 
      ER39676      5920 - 5920      ER39677      5921 - 5921      ER39678      5922 - 5922 
      ER39679      5923 - 5923      ER39680      5924 - 5924      ER39681      5925 - 5925 
      ER39682      5926 - 5928      ER39683      5929 - 5929      ER39684      5930 - 5930 
      ER39685      5931 - 5931      ER39686      5932 - 5932      ER39687      5933 - 5933 
      ER39688      5934 - 5934      ER39689      5935 - 5935      ER39690      5936 - 5936 
      ER39691      5937 - 5937      ER39692      5938 - 5938      ER39693      5939 - 5939 
      ER39694      5940 - 5940      ER39695      5941 - 5941      ER39696      5942 - 5942 
      ER39697      5943 - 5943      ER39698      5944 - 5944      ER39699      5945 - 5945 
      ER39700      5946 - 5946      ER39701      5947 - 5949      ER39702      5950 - 5950 
      ER39703      5951 - 5951      ER39704      5952 - 5952      ER39705      5953 - 5953 
      ER39706      5954 - 5954      ER39707      5955 - 5955      ER39708      5956 - 5956 
      ER39709      5957 - 5957      ER39710      5958 - 5958      ER39711      5959 - 5959 
      ER39712      5960 - 5960      ER39713      5961 - 5961      ER39714      5962 - 5962 
      ER39715      5963 - 5963      ER39716      5964 - 5964      ER39717      5965 - 5965 
      ER39718      5966 - 5966      ER39719      5967 - 5967      ER39720      5968 - 5970 
      ER39721      5971 - 5971      ER39722      5972 - 5972      ER39723      5973 - 5973 
      ER39724      5974 - 5974      ER39725      5975 - 5975      ER39726      5976 - 5976 
      ER39727      5977 - 5977      ER39728      5978 - 5978      ER39729      5979 - 5979 
      ER39730      5980 - 5980      ER39731      5981 - 5981      ER39732      5982 - 5982 
      ER39733      5983 - 5983      ER39734      5984 - 5984      ER39735      5985 - 5985 
      ER39736      5986 - 5986      ER39737      5987 - 5987      ER39738      5988 - 5988 
      ER39739      5989 - 5991      ER39740      5992 - 5992      ER39741      5993 - 5993 
      ER39742      5994 - 5994      ER39743      5995 - 5995      ER39744      5996 - 5996 
      ER39745      5997 - 5997      ER39746      5998 - 5998      ER39747      5999 - 5999 
      ER39748      6000 - 6000      ER39749      6001 - 6001      ER39750      6002 - 6002 
      ER39751      6003 - 6003      ER39752      6004 - 6004      ER39753      6005 - 6005 
      ER39754      6006 - 6006      ER39755      6007 - 6007      ER39756      6008 - 6008 
      ER39757      6009 - 6009      ER39758      6010 - 6012      ER39759      6013 - 6016 
      ER39760      6017 - 6017      ER39761      6018 - 6018      ER39762      6019 - 6019 
      ER39763      6020 - 6020      ER39764      6021 - 6021      ER39765      6022 - 6022 
      ER39766      6023 - 6023      ER39767      6024 - 6024      ER39768      6025 - 6025 
      ER39769      6026 - 6026      ER39770      6027 - 6027      ER39771      6028 - 6028 
      ER39772      6029 - 6029      ER39773      6030 - 6030      ER39774      6031 - 6031 
      ER39775      6032 - 6032      ER39776      6033 - 6033      ER39777      6034 - 6034 
      ER39778      6035 - 6035      ER39779      6036 - 6036      ER39780      6037 - 6037 
      ER39781      6038 - 6038      ER39782      6039 - 6039      ER39783      6040 - 6040 
      ER39784      6041 - 6041      ER39785      6042 - 6042      ER39786      6043 - 6043 
      ER39787      6044 - 6044      ER39788      6045 - 6045      ER39789      6046 - 6046 
      ER39790      6047 - 6047      ER39791      6048 - 6048      ER39792      6049 - 6049 
      ER39793      6050 - 6050      ER39794      6051 - 6051      ER39795      6052 - 6052 
      ER39796      6053 - 6053      ER39797      6054 - 6054      ER39798      6055 - 6055 
      ER39799      6056 - 6056      ER39800      6057 - 6057      ER39801      6058 - 6058 
      ER39802      6059 - 6059      ER39803      6060 - 6060      ER39804      6061 - 6061 
      ER39805      6062 - 6062      ER39806      6063 - 6063      ER39807      6064 - 6064 
      ER39808      6065 - 6065      ER39809      6066 - 6066      ER39810      6067 - 6067 
      ER39811      6068 - 6068      ER39812      6069 - 6069      ER39813      6070 - 6070 
      ER39814      6071 - 6071      ER39815      6072 - 6072      ER39816      6073 - 6073 
      ER39817      6074 - 6074      ER39818      6075 - 6075      ER39819      6076 - 6076 
      ER39820      6077 - 6077      ER39821      6078 - 6078      ER39822      6079 - 6079 
      ER39823      6080 - 6080      ER39824      6081 - 6081      ER39825      6082 - 6082 
      ER39826      6083 - 6083      ER39827      6084 - 6084      ER39828      6085 - 6085 
      ER39829      6086 - 6088      ER39830      6089 - 6089      ER39831      6090 - 6090 
      ER39832      6091 - 6091      ER39833      6092 - 6092      ER39834      6093 - 6093 
      ER39835      6094 - 6094      ER39836      6095 - 6095      ER39837      6096 - 6096 
      ER39838      6097 - 6097      ER39839      6098 - 6098      ER39840      6099 - 6099 
      ER39841      6100 - 6100      ER39842      6101 - 6101      ER39843      6102 - 6102 
      ER39844      6103 - 6103      ER39845      6104 - 6104      ER39846      6105 - 6105 
      ER39847      6106 - 6106      ER39848      6107 - 6109      ER39849      6110 - 6110 
      ER39850      6111 - 6111      ER39851      6112 - 6112      ER39852      6113 - 6113 
      ER39853      6114 - 6114      ER39854      6115 - 6115      ER39855      6116 - 6116 
      ER39856      6117 - 6117      ER39857      6118 - 6118      ER39858      6119 - 6119 
      ER39859      6120 - 6120      ER39860      6121 - 6121      ER39861      6122 - 6122 
      ER39862      6123 - 6123      ER39863      6124 - 6124      ER39864      6125 - 6125 
      ER39865      6126 - 6126      ER39866      6127 - 6127      ER39867      6128 - 6130 
      ER39868      6131 - 6131      ER39869      6132 - 6132      ER39870      6133 - 6133 
      ER39871      6134 - 6134      ER39872      6135 - 6135      ER39873      6136 - 6136 
      ER39874      6137 - 6137      ER39875      6138 - 6138      ER39876      6139 - 6139 
      ER39877      6140 - 6140      ER39878      6141 - 6141      ER39879      6142 - 6142 
      ER39880      6143 - 6143      ER39881      6144 - 6144      ER39882      6145 - 6145 
      ER39883      6146 - 6146      ER39884      6147 - 6147      ER39885      6148 - 6148 
      ER39886      6149 - 6151      ER39887      6152 - 6152      ER39888      6153 - 6153 
      ER39889      6154 - 6154      ER39890      6155 - 6155      ER39891      6156 - 6156 
      ER39892      6157 - 6157      ER39893      6158 - 6158      ER39894      6159 - 6159 
      ER39895      6160 - 6160      ER39896      6161 - 6161      ER39897      6162 - 6162 
      ER39898      6163 - 6163      ER39899      6164 - 6164      ER39900      6165 - 6165 
      ER39901      6166 - 6166      ER39902      6167 - 6167      ER39903      6168 - 6168 
      ER39904      6169 - 6169      ER39905      6170 - 6172      ER39906      6173 - 6173 
      ER39907      6174 - 6174      ER39908      6175 - 6175      ER39909      6176 - 6176 
      ER39910      6177 - 6177      ER39911      6178 - 6178      ER39912      6179 - 6179 
      ER39913      6180 - 6180      ER39914      6181 - 6181      ER39915      6182 - 6182 
      ER39916      6183 - 6183      ER39917      6184 - 6184      ER39918      6185 - 6185 
      ER39919      6186 - 6186      ER39920      6187 - 6187      ER39921      6188 - 6188 
      ER39922      6189 - 6189      ER39923      6190 - 6190      ER39924      6191 - 6193 
      ER39925      6194 - 6194      ER39926      6195 - 6195      ER39927      6196 - 6196 
      ER39928      6197 - 6197      ER39929      6198 - 6198      ER39930      6199 - 6199 
      ER39931      6200 - 6200      ER39932      6201 - 6201      ER39933      6202 - 6202 
      ER39934      6203 - 6203      ER39935      6204 - 6204      ER39936      6205 - 6205 
      ER39937      6206 - 6206      ER39938      6207 - 6207      ER39939      6208 - 6208 
      ER39940      6209 - 6209      ER39941      6210 - 6210      ER39942      6211 - 6211 
      ER39943      6212 - 6214      ER39944      6215 - 6215      ER39945      6216 - 6216 
      ER39946      6217 - 6217      ER39947      6218 - 6218      ER39948      6219 - 6219 
      ER39949      6220 - 6220      ER39950      6221 - 6221      ER39951      6222 - 6222 
      ER39952      6223 - 6223      ER39953      6224 - 6224      ER39954      6225 - 6225 
      ER39955      6226 - 6226      ER39956      6227 - 6227      ER39957      6228 - 6228 
      ER39958      6229 - 6229      ER39959      6230 - 6230      ER39960      6231 - 6231 
      ER39961      6232 - 6232      ER39962      6233 - 6235      ER39963      6236 - 6236 
      ER39964      6237 - 6237      ER39965      6238 - 6238      ER39966      6239 - 6239 
      ER39967      6240 - 6240      ER39968      6241 - 6241      ER39969      6242 - 6242 
      ER39970      6243 - 6243      ER39971      6244 - 6244      ER39972      6245 - 6245 
      ER39973      6246 - 6246      ER39974      6247 - 6247      ER39975      6248 - 6248 
      ER39976      6249 - 6249      ER39977      6250 - 6250      ER39978      6251 - 6251 
      ER39979      6252 - 6252      ER39980      6253 - 6253      ER39981      6254 - 6256 
      ER39982      6257 - 6257      ER39983      6258 - 6258      ER39984      6259 - 6259 
      ER39985      6260 - 6260      ER39986      6261 - 6261      ER39987      6262 - 6262 
      ER39988      6263 - 6263      ER39989      6264 - 6264      ER39990      6265 - 6265 
      ER39991      6266 - 6266      ER39992      6267 - 6267      ER39993      6268 - 6268 
      ER39994      6269 - 6269      ER39995      6270 - 6270      ER39996      6271 - 6271 
      ER39997      6272 - 6272      ER39998      6273 - 6273      ER39999      6274 - 6274 
      ER40000      6275 - 6277      ER40001      6278 - 6278      ER40002      6279 - 6279 
      ER40003      6280 - 6280      ER40004      6281 - 6281      ER40005      6282 - 6282 
      ER40006      6283 - 6283      ER40007      6284 - 6284      ER40008      6285 - 6285 
      ER40009      6286 - 6286      ER40010      6287 - 6287      ER40011      6288 - 6288 
      ER40012      6289 - 6289      ER40013      6290 - 6290      ER40014      6291 - 6291 
      ER40015      6292 - 6292      ER40016      6293 - 6293      ER40017      6294 - 6294 
      ER40018      6295 - 6295      ER40019      6296 - 6298      ER40020      6299 - 6299 
      ER40021      6300 - 6300      ER40022      6301 - 6301      ER40023      6302 - 6302 
      ER40024      6303 - 6303      ER40025      6304 - 6304      ER40026      6305 - 6305 
      ER40027      6306 - 6306      ER40028      6307 - 6307      ER40029      6308 - 6308 
      ER40030      6309 - 6309      ER40031      6310 - 6310      ER40032      6311 - 6311 
      ER40033      6312 - 6312      ER40034      6313 - 6313      ER40035      6314 - 6314 
      ER40036      6315 - 6315      ER40037      6316 - 6316      ER40038      6317 - 6319 
      ER40039      6320 - 6320      ER40040      6321 - 6321      ER40041      6322 - 6322 
      ER40042      6323 - 6323      ER40043      6324 - 6324      ER40044      6325 - 6325 
      ER40045      6326 - 6326      ER40046      6327 - 6327      ER40047      6328 - 6328 
      ER40048      6329 - 6329      ER40049      6330 - 6330      ER40050      6331 - 6331 
      ER40051      6332 - 6332      ER40052      6333 - 6333      ER40053      6334 - 6334 
      ER40054      6335 - 6335      ER40055      6336 - 6336      ER40056      6337 - 6337 
      ER40057      6338 - 6340      ER40058      6341 - 6341      ER40059      6342 - 6342 
      ER40060      6343 - 6343      ER40061      6344 - 6344      ER40062      6345 - 6345 
      ER40063      6346 - 6346      ER40064      6347 - 6347      ER40065      6348 - 6348 
      ER40066      6349 - 6349      ER40067      6350 - 6350      ER40068      6351 - 6351 
      ER40069      6352 - 6352      ER40070      6353 - 6353      ER40071      6354 - 6354 
      ER40072      6355 - 6355      ER40073      6356 - 6356      ER40074      6357 - 6357 
      ER40075      6358 - 6358      ER40076      6359 - 6361      ER40077      6362 - 6365 
      ER40078      6366 - 6366      ER40079      6367 - 6367      ER40080      6368 - 6368 
      ER40081      6369 - 6369      ER40082      6370 - 6370      ER40083      6371 - 6371 
      ER40084      6372 - 6372      ER40085      6373 - 6373      ER40086      6374 - 6374 
      ER40087      6375 - 6375      ER40088      6376 - 6376      ER40089      6377 - 6377 
      ER40090      6378 - 6378      ER40091      6379 - 6379      ER40092      6380 - 6380 
      ER40093      6381 - 6381      ER40094      6382 - 6382      ER40095      6383 - 6383 
      ER40096      6384 - 6384      ER40097      6385 - 6385      ER40098      6386 - 6386 
      ER40099      6387 - 6387      ER40100      6388 - 6388      ER40101      6389 - 6389 
      ER40102      6390 - 6390      ER40103      6391 - 6391      ER40104      6392 - 6392 
      ER40105      6393 - 6393      ER40106      6394 - 6394      ER40107      6395 - 6395 
      ER40108      6396 - 6396      ER40109      6397 - 6397      ER40110      6398 - 6398 
      ER40111      6399 - 6399      ER40112      6400 - 6400      ER40113      6401 - 6401 
      ER40114      6402 - 6402      ER40115      6403 - 6403      ER40116      6404 - 6404 
      ER40117      6405 - 6405      ER40118      6406 - 6406      ER40119      6407 - 6407 
      ER40120      6408 - 6408      ER40121      6409 - 6409      ER40122      6410 - 6410 
      ER40123      6411 - 6411      ER40124      6412 - 6412      ER40125      6413 - 6413 
      ER40126      6414 - 6414      ER40127      6415 - 6415      ER40128      6416 - 6416 
      ER40129      6417 - 6417      ER40130      6418 - 6418      ER40131      6419 - 6419 
      ER40132      6420 - 6420      ER40133      6421 - 6421      ER40134      6422 - 6422 
      ER40135      6423 - 6423      ER40136      6424 - 6424      ER40137      6425 - 6425 
      ER40138      6426 - 6426      ER40139      6427 - 6427      ER40140      6428 - 6428 
      ER40141      6429 - 6429      ER40142      6430 - 6430      ER40143      6431 - 6431 
      ER40144      6432 - 6432      ER40145      6433 - 6433      ER40146      6434 - 6434 
      ER40147      6435 - 6437      ER40148      6438 - 6438      ER40149      6439 - 6439 
      ER40150      6440 - 6440      ER40151      6441 - 6441      ER40152      6442 - 6442 
      ER40153      6443 - 6443      ER40154      6444 - 6444      ER40155      6445 - 6445 
      ER40156      6446 - 6446      ER40157      6447 - 6447      ER40158      6448 - 6448 
      ER40159      6449 - 6449      ER40160      6450 - 6450      ER40161      6451 - 6451 
      ER40162      6452 - 6452      ER40163      6453 - 6453      ER40164      6454 - 6454 
      ER40165      6455 - 6455      ER40166      6456 - 6458      ER40167      6459 - 6459 
      ER40168      6460 - 6460      ER40169      6461 - 6461      ER40170      6462 - 6462 
      ER40171      6463 - 6463      ER40172      6464 - 6464      ER40173      6465 - 6465 
      ER40174      6466 - 6466      ER40175      6467 - 6467      ER40176      6468 - 6468 
      ER40177      6469 - 6469      ER40178      6470 - 6470      ER40179      6471 - 6471 
      ER40180      6472 - 6472      ER40181      6473 - 6473      ER40182      6474 - 6474 
      ER40183      6475 - 6475      ER40184      6476 - 6476      ER40185      6477 - 6479 
      ER40186      6480 - 6480      ER40187      6481 - 6481      ER40188      6482 - 6482 
      ER40189      6483 - 6483      ER40190      6484 - 6484      ER40191      6485 - 6485 
      ER40192      6486 - 6486      ER40193      6487 - 6487      ER40194      6488 - 6488 
      ER40195      6489 - 6489      ER40196      6490 - 6490      ER40197      6491 - 6491 
      ER40198      6492 - 6492      ER40199      6493 - 6493      ER40200      6494 - 6494 
      ER40201      6495 - 6495      ER40202      6496 - 6496      ER40203      6497 - 6497 
      ER40204      6498 - 6500      ER40205      6501 - 6501      ER40206      6502 - 6502 
      ER40207      6503 - 6503      ER40208      6504 - 6504      ER40209      6505 - 6505 
      ER40210      6506 - 6506      ER40211      6507 - 6507      ER40212      6508 - 6508 
      ER40213      6509 - 6509      ER40214      6510 - 6510      ER40215      6511 - 6511 
      ER40216      6512 - 6512      ER40217      6513 - 6513      ER40218      6514 - 6514 
      ER40219      6515 - 6515      ER40220      6516 - 6516      ER40221      6517 - 6517 
      ER40222      6518 - 6518      ER40223      6519 - 6521      ER40224      6522 - 6522 
      ER40225      6523 - 6523      ER40226      6524 - 6524      ER40227      6525 - 6525 
      ER40228      6526 - 6526      ER40229      6527 - 6527      ER40230      6528 - 6528 
      ER40231      6529 - 6529      ER40232      6530 - 6530      ER40233      6531 - 6531 
      ER40234      6532 - 6532      ER40235      6533 - 6533      ER40236      6534 - 6534 
      ER40237      6535 - 6535      ER40238      6536 - 6536      ER40239      6537 - 6537 
      ER40240      6538 - 6538      ER40241      6539 - 6539      ER40242      6540 - 6542 
      ER40243      6543 - 6543      ER40244      6544 - 6544      ER40245      6545 - 6545 
      ER40246      6546 - 6546      ER40247      6547 - 6547      ER40248      6548 - 6548 
      ER40249      6549 - 6549      ER40250      6550 - 6550      ER40251      6551 - 6551 
      ER40252      6552 - 6552      ER40253      6553 - 6553      ER40254      6554 - 6554 
      ER40255      6555 - 6555      ER40256      6556 - 6556      ER40257      6557 - 6557 
      ER40258      6558 - 6558      ER40259      6559 - 6559      ER40260      6560 - 6560 
      ER40261      6561 - 6563      ER40262      6564 - 6564      ER40263      6565 - 6565 
      ER40264      6566 - 6566      ER40265      6567 - 6567      ER40266      6568 - 6568 
      ER40267      6569 - 6569      ER40268      6570 - 6570      ER40269      6571 - 6571 
      ER40270      6572 - 6572      ER40271      6573 - 6573      ER40272      6574 - 6574 
      ER40273      6575 - 6575      ER40274      6576 - 6576      ER40275      6577 - 6577 
      ER40276      6578 - 6578      ER40277      6579 - 6579      ER40278      6580 - 6580 
      ER40279      6581 - 6581      ER40280      6582 - 6584      ER40281      6585 - 6585 
      ER40282      6586 - 6586      ER40283      6587 - 6587      ER40284      6588 - 6588 
      ER40285      6589 - 6589      ER40286      6590 - 6590      ER40287      6591 - 6591 
      ER40288      6592 - 6592      ER40289      6593 - 6593      ER40290      6594 - 6594 
      ER40291      6595 - 6595      ER40292      6596 - 6596      ER40293      6597 - 6597 
      ER40294      6598 - 6598      ER40295      6599 - 6599      ER40296      6600 - 6600 
      ER40297      6601 - 6601      ER40298      6602 - 6602      ER40299      6603 - 6605 
      ER40300      6606 - 6606      ER40301      6607 - 6607      ER40302      6608 - 6608 
      ER40303      6609 - 6609      ER40304      6610 - 6610      ER40305      6611 - 6611 
      ER40306      6612 - 6612      ER40307      6613 - 6613      ER40308      6614 - 6614 
      ER40309      6615 - 6615      ER40310      6616 - 6616      ER40311      6617 - 6617 
      ER40312      6618 - 6618      ER40313      6619 - 6619      ER40314      6620 - 6620 
      ER40315      6621 - 6621      ER40316      6622 - 6622      ER40317      6623 - 6623 
      ER40318      6624 - 6626      ER40319      6627 - 6627      ER40320      6628 - 6628 
      ER40321      6629 - 6629      ER40322      6630 - 6630      ER40323      6631 - 6631 
      ER40324      6632 - 6632      ER40325      6633 - 6633      ER40326      6634 - 6634 
      ER40327      6635 - 6635      ER40328      6636 - 6636      ER40329      6637 - 6637 
      ER40330      6638 - 6638      ER40331      6639 - 6639      ER40332      6640 - 6640 
      ER40333      6641 - 6641      ER40334      6642 - 6642      ER40335      6643 - 6643 
      ER40336      6644 - 6644      ER40337      6645 - 6647      ER40338      6648 - 6648 
      ER40339      6649 - 6649      ER40340      6650 - 6650      ER40341      6651 - 6651 
      ER40342      6652 - 6652      ER40343      6653 - 6653      ER40344      6654 - 6654 
      ER40345      6655 - 6655      ER40346      6656 - 6656      ER40347      6657 - 6657 
      ER40348      6658 - 6658      ER40349      6659 - 6659      ER40350      6660 - 6660 
      ER40351      6661 - 6661      ER40352      6662 - 6662      ER40353      6663 - 6663 
      ER40354      6664 - 6664      ER40355      6665 - 6665      ER40356      6666 - 6668 
      ER40357      6669 - 6669      ER40358      6670 - 6670      ER40359      6671 - 6671 
      ER40360      6672 - 6672      ER40361      6673 - 6673      ER40362      6674 - 6674 
      ER40363      6675 - 6675      ER40364      6676 - 6676      ER40365      6677 - 6677 
      ER40366      6678 - 6678      ER40367      6679 - 6679      ER40368      6680 - 6680 
      ER40369      6681 - 6681      ER40370      6682 - 6682      ER40371      6683 - 6683 
      ER40372      6684 - 6684      ER40373      6685 - 6685      ER40374      6686 - 6686 
      ER40375      6687 - 6689      ER40376      6690 - 6690      ER40377      6691 - 6691 
      ER40378      6692 - 6692      ER40379      6693 - 6693      ER40380      6694 - 6694 
      ER40381      6695 - 6695      ER40382      6696 - 6696      ER40383      6697 - 6697 
      ER40384      6698 - 6698      ER40385      6699 - 6699      ER40386      6700 - 6700 
      ER40387      6701 - 6701      ER40388      6702 - 6702      ER40389      6703 - 6703 
      ER40390      6704 - 6704      ER40391      6705 - 6705      ER40392      6706 - 6706 
      ER40393      6707 - 6707      ER40394      6708 - 6710      ER40395      6711 - 6711 
      ER40396      6712 - 6712      ER40397      6713 - 6713      ER40398      6714 - 6714 
      ER40399      6715 - 6715      ER40400      6716 - 6716      ER40401      6717 - 6717 
      ER40402      6718 - 6719      ER40403      6720 - 6720      ER40404      6721 - 6721 
      ER40405      6722 - 6722      ER40406      6723 - 6723      ER40407      6724 - 6725 
      ER40408      6726 - 6727      ER40409      6728 - 6728      ER40410      6729 - 6734 
      ER40411      6735 - 6735      ER40412      6736 - 6736      ER40413      6737 - 6737 
      ER40414      6738 - 6743      ER40415      6744 - 6744      ER40416      6745 - 6745 
      ER40417      6746 - 6746      ER40418      6747 - 6747      ER40419      6748 - 6748 
      ER40420      6749 - 6754      ER40421      6755 - 6755      ER40422      6756 - 6756 
      ER40423      6757 - 6757      ER40424      6758 - 6758      ER40425      6759 - 6759 
      ER40426      6760 - 6765      ER40427      6766 - 6766      ER40428      6767 - 6767 
      ER40429      6768 - 6768      ER40430      6769 - 6769      ER40431      6770 - 6770 
      ER40432      6771 - 6778      ER40433      6779 - 6779      ER40434      6780 - 6780 
      ER40435      6781 - 6781      ER40436      6782 - 6782      ER40437      6783 - 6783 
      ER40438      6784 - 6784      ER40439      6785 - 6786      ER40440      6787 - 6788 
      ER40441      6789 - 6789      ER40442      6790 - 6791      ER40443      6792 - 6792 
      ER40444      6793 - 6793      ER40445      6794 - 6795      ER40446      6796 - 6796 
      ER40447      6797 - 6799      ER40448      6800 - 6802      ER40449      6803 - 6804 
      ER40450      6805 - 6806      ER40451      6807 - 6807      ER40452      6808 - 6809 
      ER40453      6810 - 6810      ER40454      6811 - 6811      ER40455      6812 - 6813 
      ER40456      6814 - 6814      ER40457      6815 - 6817      ER40458      6818 - 6820 
      ER40459      6821 - 6821      ER40460      6822 - 6823      ER40461      6824 - 6824 
      ER40462      6825 - 6825      ER40463      6826 - 6827      ER40464      6828 - 6828 
      ER40465      6829 - 6829      ER40466      6830 - 6831      ER40467      6832 - 6832 
      ER40468      6833 - 6833      ER40469      6834 - 6835      ER40470      6836 - 6836 
      ER40471      6837 - 6837      ER40472      6838 - 6838      ER40473      6839 - 6839 
      ER40474      6840 - 6840      ER40475      6841 - 6841      ER40476      6842 - 6842 
      ER40477      6843 - 6844      ER40478      6845 - 6846      ER40479      6847 - 6847 
      ER40480      6848 - 6848      ER40481      6849 - 6849      ER40482      6850 - 6851 
      ER40483      6852 - 6855      ER40484      6856 - 6857      ER40485      6858 - 6859 
      ER40486      6860 - 6863      ER40487      6864 - 6865      ER40488      6866 - 6869 
      ER40489      6870 - 6871      ER40490      6872 - 6873      ER40491      6874 - 6877 
      ER40492      6878 - 6878      ER40493      6879 - 6880      ER40494      6881 - 6884 
      ER40495      6885 - 6885      ER40496      6886 - 6886      ER40497      6887 - 6888 
      ER40498      6889 - 6890      ER40499      6891 - 6894      ER40500      6895 - 6896 
      ER40501      6897 - 6897      ER40502      6898 - 6898      ER40503      6899 - 6899 
      ER40504      6900 - 6901      ER40505      6902 - 6903      ER40506      6904 - 6905 
      ER40507      6906 - 6909      ER40508      6910 - 6910      ER40509      6911 - 6911 
      ER40510      6912 - 6913      ER40511      6914 - 6915      ER40512      6916 - 6917 
      ER40513      6918 - 6921      ER40514      6922 - 6922      ER40515      6923 - 6923 
      ER40516      6924 - 6925      ER40517      6926 - 6927      ER40518      6928 - 6929 
      ER40519      6930 - 6933      ER40520      6934 - 6934      ER40521      6935 - 6936 
      ER40522      6937 - 6938      ER40523      6939 - 6940      ER40524      6941 - 6942 
      ER40525      6943 - 6945      ER40526      6946 - 6948      ER40527      6949 - 6949 
      ER40528      6950 - 6951      ER40529      6952 - 6953      ER40530      6954 - 6954 
      ER40531      6955 - 6956      ER40532      6957 - 6957      ER40533      6958 - 6958 
      ER40534      6959 - 6960      ER40535      6961 - 6961      ER40536      6962 - 6964 
      ER40537      6965 - 6967      ER40538      6968 - 6969      ER40539      6970 - 6971 
      ER40540      6972 - 6972      ER40541      6973 - 6974      ER40542      6975 - 6975 
      ER40543      6976 - 6976      ER40544      6977 - 6978      ER40545      6979 - 6979 
      ER40546      6980 - 6982      ER40547      6983 - 6985      ER40548      6986 - 6986 
      ER40549      6987 - 6988      ER40550      6989 - 6989      ER40551      6990 - 6990 
      ER40552      6991 - 6992      ER40553      6993 - 6993      ER40554      6994 - 6994 
      ER40555      6995 - 6996      ER40556      6997 - 6997      ER40557      6998 - 6998 
      ER40558      6999 - 7000      ER40559      7001 - 7001      ER40560      7002 - 7002 
      ER40561      7003 - 7004      ER40562      7005 - 7005      ER40563      7006 - 7006 
      ER40564      7007 - 7007      ER40565      7008 - 7008      ER40566      7009 - 7009 
      ER40567      7010 - 7010      ER40568      7011 - 7011      ER40569      7012 - 7012 
      ER40570      7013 - 7014      ER40571      7015 - 7016      ER40572      7017 - 7017 
      ER40573      7018 - 7018      ER40574      7019 - 7019      ER40575      7020 - 7021 
      ER40576      7022 - 7025      ER40577      7026 - 7027      ER40578      7028 - 7029 
      ER40579      7030 - 7033      ER40580      7034 - 7035      ER40581      7036 - 7039 
      ER40582      7040 - 7041      ER40583      7042 - 7043      ER40584      7044 - 7047 
      ER40585      7048 - 7048      ER40586      7049 - 7050      ER40587      7051 - 7054 
      ER40588      7055 - 7055      ER40589      7056 - 7056      ER40590      7057 - 7058 
      ER40591      7059 - 7060      ER40592      7061 - 7064      ER40593      7065 - 7066 
      ER40594      7067 - 7067      ER40595      7068 - 7068      ER40596      7069 - 7069 
      ER40597      7070 - 7071      ER40598      7072 - 7073      ER40599      7074 - 7075 
      ER40600      7076 - 7079      ER40601      7080 - 7080      ER40602      7081 - 7081 
      ER40603      7082 - 7083      ER40604      7084 - 7085      ER40605      7086 - 7087 
      ER40606      7088 - 7091      ER40607      7092 - 7092      ER40608      7093 - 7093 
      ER40609      7094 - 7095      ER40610      7096 - 7097      ER40611      7098 - 7099 
      ER40612      7100 - 7103      ER40613      7104 - 7104      ER40614      7105 - 7106 
      ER40615      7107 - 7108      ER40616      7109 - 7110      ER40617      7111 - 7112 
      ER40618      7113 - 7115      ER40619      7116 - 7118      ER40620      7119 - 7119 
      ER40621      7120 - 7120      ER40622      7121 - 7126      ER40623      7127 - 7127 
      ER40624      7128 - 7128      ER40625      7129 - 7129      ER40626      7130 - 7130 
      ER40627      7131 - 7131      ER40628      7132 - 7137      ER40629      7138 - 7138 
      ER40630      7139 - 7139      ER40631      7140 - 7140      ER40632      7141 - 7141 
      ER40633      7142 - 7142      ER40634      7143 - 7147      ER40635      7148 - 7148 
      ER40636      7149 - 7149      ER40637      7150 - 7150      ER40638      7151 - 7151 
      ER40639      7152 - 7152      ER40640      7153 - 7157      ER40641      7158 - 7158 
      ER40642      7159 - 7159      ER40643      7160 - 7160      ER40644      7161 - 7161 
      ER40645      7162 - 7162      ER40646      7163 - 7167      ER40647      7168 - 7168 
      ER40648      7169 - 7169      ER40649      7170 - 7170      ER40650      7171 - 7171 
      ER40651      7172 - 7172      ER40652      7173 - 7177      ER40653      7178 - 7178 
      ER40654      7179 - 7179      ER40655      7180 - 7180      ER40656      7181 - 7181 
      ER40657      7182 - 7182      ER40658      7183 - 7187      ER40659      7188 - 7188 
      ER40660      7189 - 7189      ER40661      7190 - 7190      ER40662      7191 - 7191 
      ER40663      7192 - 7192      ER40664      7193 - 7197      ER40665      7198 - 7198 
      ER40666      7199 - 7199      ER40667      7200 - 7200      ER40668      7201 - 7201 
      ER40669      7202 - 7202      ER40670      7203 - 7207      ER40671      7208 - 7208 
      ER40672      7209 - 7209      ER40673      7210 - 7210      ER40674      7211 - 7211 
      ER40675      7212 - 7212      ER40676      7213 - 7217      ER40677      7218 - 7218 
      ER40678      7219 - 7219      ER40679      7220 - 7220      ER40680      7221 - 7221 
      ER40681      7222 - 7222      ER40682      7223 - 7227      ER40683      7228 - 7228 
      ER40684      7229 - 7229      ER40685      7230 - 7230      ER40686      7231 - 7231 
      ER40687      7232 - 7232      ER40688      7233 - 7240      ER40689      7241 - 7241 
      ER40690      7242 - 7242      ER40691      7243 - 7243      ER40692      7244 - 7244 
      ER40693      7245 - 7245      ER40694      7246 - 7246      ER40695      7247 - 7247 
      ER40696      7248 - 7248      ER40697      7249 - 7249      ER40698      7250 - 7250 
      ER40699      7251 - 7251      ER40700      7252 - 7252      ER40701      7253 - 7253 
      ER40702      7254 - 7254      ER40703      7255 - 7255      ER40704      7256 - 7256 
      ER40705      7257 - 7263      ER40706      7264 - 7264      ER40707      7265 - 7265 
      ER40708      7266 - 7266      ER40709      7267 - 7267      ER40710      7268 - 7268 
      ER40711      7269 - 7269      ER40712      7270 - 7270      ER40713      7271 - 7271 
      ER40714      7272 - 7272      ER40715      7273 - 7273      ER40716      7274 - 7274 
      ER40717      7275 - 7275      ER40718      7276 - 7276      ER40719      7277 - 7277 
      ER40720      7278 - 7284      ER40721      7285 - 7285      ER40722      7286 - 7286 
      ER40723      7287 - 7287      ER40724      7288 - 7288      ER40725      7289 - 7289 
      ER40726      7290 - 7290      ER40727      7291 - 7291      ER40728      7292 - 7292 
      ER40729      7293 - 7293      ER40730      7294 - 7294      ER40731      7295 - 7295 
      ER40732      7296 - 7296      ER40733      7297 - 7297      ER40734      7298 - 7298 
      ER40735      7299 - 7305      ER40736      7306 - 7306      ER40737      7307 - 7307 
      ER40738      7308 - 7308      ER40739      7309 - 7309      ER40740      7310 - 7310 
      ER40741      7311 - 7311      ER40742      7312 - 7312      ER40743      7313 - 7313 
      ER40744      7314 - 7314      ER40745      7315 - 7315      ER40746      7316 - 7316 
      ER40747      7317 - 7317      ER40748      7318 - 7318      ER40749      7319 - 7319 
      ER40750      7320 - 7326      ER40751      7327 - 7327      ER40752      7328 - 7328 
      ER40753      7329 - 7329      ER40754      7330 - 7330      ER40755      7331 - 7331 
      ER40756      7332 - 7332      ER40757      7333 - 7333      ER40758      7334 - 7334 
      ER40759      7335 - 7335      ER40760      7336 - 7336      ER40761      7337 - 7337 
      ER40762      7338 - 7338      ER40763      7339 - 7339      ER40764      7340 - 7340 
      ER40765      7341 - 7347      ER40766      7348 - 7348      ER40767      7349 - 7349 
      ER40768      7350 - 7350      ER40769      7351 - 7351      ER40770      7352 - 7352 
      ER40771      7353 - 7353      ER40772      7354 - 7354      ER40773      7355 - 7355 
      ER40774      7356 - 7356      ER40775      7357 - 7357      ER40776      7358 - 7358 
      ER40777      7359 - 7359      ER40778      7360 - 7360      ER40779      7361 - 7361 
      ER40780      7362 - 7368      ER40781      7369 - 7369      ER40782      7370 - 7370 
      ER40783      7371 - 7371      ER40784      7372 - 7372      ER40785      7373 - 7373 
      ER40786      7374 - 7374      ER40787      7375 - 7375      ER40788      7376 - 7376 
      ER40789      7377 - 7377      ER40790      7378 - 7378      ER40791      7379 - 7379 
      ER40792      7380 - 7380      ER40793      7381 - 7381      ER40794      7382 - 7382 
      ER40795      7383 - 7389      ER40796      7390 - 7390      ER40797      7391 - 7391 
      ER40798      7392 - 7392      ER40799      7393 - 7393      ER40800      7394 - 7394 
      ER40801      7395 - 7395      ER40802      7396 - 7396      ER40803      7397 - 7397 
      ER40804      7398 - 7398      ER40805      7399 - 7399      ER40806      7400 - 7400 
      ER40807      7401 - 7401      ER40808      7402 - 7402      ER40809      7403 - 7403 
      ER40810      7404 - 7410      ER40811      7411 - 7411      ER40812      7412 - 7412 
      ER40813      7413 - 7413      ER40814      7414 - 7414      ER40815      7415 - 7415 
      ER40816      7416 - 7416      ER40817      7417 - 7417      ER40818      7418 - 7418 
      ER40819      7419 - 7419      ER40820      7420 - 7420      ER40821      7421 - 7421 
      ER40822      7422 - 7422      ER40823      7423 - 7423      ER40824      7424 - 7424 
      ER40825      7425 - 7431      ER40826      7432 - 7432      ER40827      7433 - 7433 
      ER40828      7434 - 7434      ER40829      7435 - 7435      ER40830      7436 - 7436 
      ER40831      7437 - 7437      ER40832      7438 - 7438      ER40833      7439 - 7439 
      ER40834      7440 - 7440      ER40835      7441 - 7441      ER40836      7442 - 7442 
      ER40837      7443 - 7443      ER40838      7444 - 7444      ER40839      7445 - 7445 
      ER40840      7446 - 7452      ER40841      7453 - 7453      ER40842      7454 - 7454 
      ER40843      7455 - 7455      ER40844      7456 - 7456      ER40845      7457 - 7457 
      ER40846      7458 - 7458      ER40847      7459 - 7459      ER40848      7460 - 7460 
      ER40849      7461 - 7461      ER40850      7462 - 7462      ER40851      7463 - 7463 
      ER40852      7464 - 7464      ER40853      7465 - 7465      ER40854      7466 - 7466 
      ER40855      7467 - 7473      ER40856      7474 - 7474      ER40857      7475 - 7475 
      ER40858      7476 - 7476      ER40859      7477 - 7477      ER40860      7478 - 7478 
      ER40861      7479 - 7479      ER40862      7480 - 7480      ER40863      7481 - 7481 
      ER40864      7482 - 7482      ER40865      7483 - 7483      ER40866      7484 - 7484 
      ER40867      7485 - 7485      ER40868      7486 - 7486      ER40869      7487 - 7487 
      ER40870      7488 - 7490      ER40871      7491 - 7491      ER40872      7492 - 7493 
      ER40873      7494 - 7497      ER40874      7498 - 7500      ER40875      7501 - 7504 
      ER40876      7505 - 7508      ER40877      7509 - 7512      ER40878      7513 - 7516 
      ER40879      7517 - 7520      ER40880      7521 - 7524      ER40881      7525 - 7528 
      ER40882      7529 - 7532      ER40883      7533 - 7536      ER40884      7537 - 7540 
      ER40885      7541 - 7543      ER40886      7544 - 7547      ER40887      7548 - 7551 
      ER40888      7552 - 7555      ER40889      7556 - 7559      ER40890      7560 - 7563 
      ER40891      7564 - 7567      ER40892      7568 - 7571      ER40893      7572 - 7575 
      ER40894      7576 - 7579      ER40895      7580 - 7586      ER40896      7587 - 7587 
      ER40897      7588 - 7588      ER40898      7589 - 7595      ER40899      7596 - 7596 
      ER40900      7597 - 7603      ER40901      7604 - 7610      ER40902      7611 - 7611 
      ER40903      7612 - 7618      ER40904      7619 - 7619      ER40905      7620 - 7625 
      ER40906      7626 - 7626      ER40907      7627 - 7632      ER40908      7633 - 7633 
      ER40909      7634 - 7639      ER40910      7640 - 7640      ER40911      7641 - 7646 
      ER40912      7647 - 7647      ER40913      7648 - 7654      ER40914      7655 - 7655 
      ER40915      7656 - 7662      ER40916      7663 - 7663      ER40917      7664 - 7670 
      ER40918      7671 - 7671      ER40919      7672 - 7677      ER40920      7678 - 7678 
      ER40921      7679 - 7685      ER40922      7686 - 7691      ER40923      7692 - 7692 
      ER40924      7693 - 7698      ER40925      7699 - 7699      ER40926      7700 - 7705 
      ER40927      7706 - 7706      ER40928      7707 - 7712      ER40929      7713 - 7713 
      ER40930      7714 - 7720      ER40931      7721 - 7727      ER40932      7728 - 7728 
      ER40933      7729 - 7735      ER40934      7736 - 7736      ER40935      7737 - 7742 
      ER40936      7743 - 7743      ER40937      7744 - 7749      ER40938      7750 - 7750 
      ER40939      7751 - 7756      ER40940      7757 - 7757      ER40941      7758 - 7763 
      ER40942      7764 - 7764      ER40943      7765 - 7771      ER40944      7772 - 7777 
      ER40945      7778 - 7778      ER40946      7779 - 7784      ER40947      7785 - 7785 
      ER40948      7786 - 7791      ER40949      7792 - 7792      ER40950      7793 - 7798 
      ER40951      7799 - 7799      ER40952      7800 - 7805      ER40953      7806 - 7806 
      ER40954      7807 - 7812      ER40955      7813 - 7813      ER40956      7814 - 7819 
      ER40957      7820 - 7820      ER40958      7821 - 7826      ER40959      7827 - 7827 
      ER40960      7828 - 7833      ER40961      7834 - 7834      ER40962      7835 - 7840 
      ER40963      7841 - 7841      ER40964      7842 - 7847      ER40965      7848 - 7848 
      ER40966      7849 - 7854      ER40967      7855 - 7855      ER40968      7856 - 7861 
      ER40969      7862 - 7862      ER40970      7863 - 7868      ER40971      7869 - 7869 
      ER40972      7870 - 7875      ER40973      7876 - 7876      ER40974      7877 - 7882 
      ER40975      7883 - 7883      ER40976      7884 - 7889      ER40977      7890 - 7890 
      ER40978      7891 - 7896      ER40979      7897 - 7897      ER40980      7898 - 7903 
      ER40981      7904 - 7904      ER40982      7905 - 7910      ER40983      7911 - 7911 
      ER40984      7912 - 7917      ER40985      7918 - 7918      ER40986      7919 - 7924 
      ER40987      7925 - 7925      ER40988      7926 - 7931      ER40989      7932 - 7932 
      ER40990      7933 - 7938      ER40991      7939 - 7939      ER40992      7940 - 7946 
      ER40993      7947 - 7952      ER40994      7953 - 7958      ER40995      7959 - 7965 
      ER40996      7966 - 7966      ER40997      7967 - 7972      ER40998      7973 - 7973 
      ER40999      7974 - 7980      ER41000      7981 - 7986      ER41001      7987 - 7987 
      ER41002      7988 - 7993      ER41003      7994 - 7994      ER41004      7995 - 8000 
      ER41005      8001 - 8001      ER41006      8002 - 8007      ER41007      8008 - 8008 
      ER41008      8009 - 8014      ER41009      8015 - 8015      ER41010      8016 - 8021 
      ER41011      8022 - 8022      ER41012      8023 - 8028      ER41013      8029 - 8029 
      ER41014      8030 - 8035      ER41015      8036 - 8036      ER41016      8037 - 8042 
      ER41017      8043 - 8043      ER41018      8044 - 8049      ER41019      8050 - 8050 
      ER41020      8051 - 8056      ER41021      8057 - 8062      ER41022      8063 - 8063 
      ER41023      8064 - 8069      ER41024      8070 - 8070      ER41025      8071 - 8076 
      ER41026      8077 - 8077      ER41027      8078 - 8084      ER41028      8085 - 8089 
      ER41029      8090 - 8094      ER41030      8095 - 8099      ER41031      8100 - 8104 
      ER41032      8105 - 8105      ER41033      8106 - 8107      ER41034      8108 - 8108 
      ER41035      8109 - 8109      ER41036      8110 - 8110      ER41037      8111 - 8112 
      ER41038      8113 - 8114      ER41039      8115 - 8115      ER41040      8116 - 8116 
      ER41041      8117 - 8117      ER41042      8118 - 8121      ER41043      8122 - 8125 
      ER41044      8126 - 8126      ER41045      8127 - 8127      ER41046      8128 - 8132 
      ER41047      8133 - 8137      ER41048      8138 - 8138      ER41049      8139 - 8140 
      ER41050      8141 - 8145      ER41051      8146 - 8146      ER41052      8147 - 8148 
      ER41053      8149 - 8153      ER41054      8154 - 8154      ER41055      8155 - 8156 
      ER41056      8157 - 8161      ER41057      8162 - 8162      ER41058      8163 - 8164 
      ER41059      8165 - 8169      ER41060      8170 - 8170      ER41061      8171 - 8171 
      ER41062      8172 - 8172      ER41063      8173 - 8173      ER41064      8174 - 8174 
      ER41065      8175 - 8175      ER41066      8176 - 8176      ER41067      8177 - 8177 
      ER41068      8178 - 8178      ER41069      8179 - 8185 
;

file rawdat lrecl=8185;

put    
ER36002
ER36003
ER36007
ER36009
ER36012
ER36013
ER36014
ER36016
ER36017
ER36018
ER36019
ER36023
ER36028
ER36029
ER36030
ER36036
ER36037
ER36038
ER36039
ER36040
ER36041
ER36042
ER36043
ER36044
ER36045
ER36046
ER36047
ER36048
ER36049
ER36050
ER36051
ER36052
ER36053
ER36054
ER36055
ER36056
ER36057
ER36058
ER36059
ER36060
ER36061
ER36062
ER36065
ER36066
ER36067
ER36103
ER36104
ER36105
ER36106
ER36109
ER36110
ER36111
ER36134
ER36165
ER36166
ER36167
ER36178
ER36363
ER36364
ER36365
ER36367
ER36368
ER36369
ER36392
ER36423
ER36424
ER36425
ER36436
ER36621
ER36622
ER36623
ER36673
ER36674
ER36704
ER36706
ER36707
ER36708
ER36710
ER36711
ER36712
ER36713
ER36714
ER36715
ER36716
ER36717
ER36718
ER36720
ER36721
ER36722
ER36723
ER36724
ER36725
ER36727
ER36728
ER36731
ER36734
ER36735
ER36736
ER36741
ER36744
ER36745
ER36746
ER36747
ER36748
ER36749
ER36750
ER36752
ER36753
ER36756
ER36759
ER36762
ER36763
ER36764
ER36769
ER36772
ER36773
ER36774
ER36775
ER36776
ER36777
ER36778
ER36780
ER36781
ER36784
ER36787
ER36790
ER36791
ER36792
ER36797
ER36800
ER36801
ER36802
ER36803
ER36804
ER36805
ER36806
ER36808
ER36809
ER36812
ER36813
ER36815
ER36816
ER36817
ER36818
ER36819
ER36820
ER36821
ER36823
ER36825
ER36826
ER36827
ER36831
ER36832
ER36836
ER36837
ER36841
ER36842
ER36846
ER36847
ER36852
ER36856
ER36929
ER36933
ER36935
ER36939
ER36942
ER36946
ER36950
ER36967
ER37000
ER37002
ER37003
ER37019
ER37020
ER37351
ER37352
ER37353
ER37531
ER37537
ER37553
ER37557
ER37562
ER37567
ER37587
ER37588
ER37589
ER37595
ER37616
ER37621
ER37652
ER37690
ER37701
ER38206
ER40481
ER40489
ER40492
ER40496
ER40527
ER40565
ER40574
ER40582
ER40585
ER40589
ER40873
ER40874
ER40875
ER40876
ER40877
ER40878
ER40884
ER40885
ER40886
ER40887
ER40888
ER40889
ER40900
ER40921
ER40930
ER40933
ER40934
ER40943
ER40992
ER40999
ER41000
ER41021
ER41023
ER41025
ER41027
ER41028
ER41032
ER41069
;

proc means;
run;

PROC PRINTTO PRINT=PRINT;
RUN; 

PROC PRINTTO LOG=LOG;
RUN; 
